/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.dao._RootDAO;

public class LogCleaner {
    private static Log sLog = LogFactory.getLog(LogCleaner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupQueryLog(int days) {
        if (days < 0) {
            return;
        }
        Transaction tx = null;
        try (Session hibSession = new _RootDAO().createNewSession();){
            tx = hibSession.beginTransaction();
            int rows = hibSession.createQuery("delete from QueryLog where timeStamp < " + HibernateUtil.addDate("current_date()", ":days")).setInteger("days", -days).executeUpdate();
            if (rows > 0) {
                sLog.info((Object)("All records older than " + days + " days deleted from the query log (" + rows + " records)."));
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupChangeLog(int days) {
        if (days < 0) {
            return;
        }
        Transaction tx = null;
        try (Session hibSession = new _RootDAO().createNewSession();){
            tx = hibSession.beginTransaction();
            int rows = hibSession.createQuery("delete from ChangeLog where timeStamp < " + HibernateUtil.addDate("current_date()", ":days")).setInteger("days", -days).executeUpdate();
            if (rows > 0) {
                sLog.info((Object)("All records older than " + days + " days deleted from the change log (" + rows + " records)."));
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupOnlineSectioningLog(int days) {
        if (days < 0) {
            return;
        }
        Transaction tx = null;
        try (Session hibSession = new _RootDAO().createNewSession();){
            tx = hibSession.beginTransaction();
            int rows = hibSession.createQuery("delete from OnlineSectioningLog where timeStamp < " + HibernateUtil.addDate("current_date()", ":days")).setInteger("days", -days).executeUpdate();
            if (rows > 0) {
                sLog.info((Object)("All records older than " + days + " days deleted from the online sectioning log (" + rows + " records)."));
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupMessageLog(int days) {
        if (days < 0) {
            return;
        }
        Transaction tx = null;
        try (Session hibSession = new _RootDAO().createNewSession();){
            tx = hibSession.beginTransaction();
            int rows = hibSession.createQuery("delete from MessageLog where timeStamp < " + HibernateUtil.addDate("current_date()", ":days")).setInteger("days", -days).executeUpdate();
            if (rows > 0) {
                sLog.info((Object)("All records older than " + days + " days deleted from the message log (" + rows + " records)."));
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupStudentSectioningQueue(int days) {
        if (days < 0) {
            return;
        }
        Transaction tx = null;
        try (Session hibSession = new _RootDAO().createNewSession();){
            tx = hibSession.beginTransaction();
            int rows = hibSession.createQuery("delete from StudentSectioningQueue where timeStamp < " + HibernateUtil.addDate("current_date()", ":days")).setInteger("days", -days).executeUpdate();
            if (rows > 0) {
                sLog.info((Object)("All records older than " + days + " days deleted from the student sectioning queue (" + rows + " records)."));
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupHashedQueries(int days) {
        if (days < 0) {
            return;
        }
        Transaction tx = null;
        try (Session hibSession = new _RootDAO().createNewSession();){
            tx = hibSession.beginTransaction();
            int rows = hibSession.createQuery("delete from HashedQuery where lastUsed < " + HibernateUtil.addDate("current_date()", ":days")).setInteger("days", -days).executeUpdate();
            if (rows > 0) {
                sLog.info((Object)("All records not used for more than " + days + " days deleted from the hashed queries (" + rows + " records)."));
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupSctSolutionLog(int days) {
        if (days < 0) {
            return;
        }
        Transaction tx = null;
        try (Session hibSession = new _RootDAO().createNewSession();){
            tx = hibSession.beginTransaction();
            int rows = hibSession.createQuery("delete from SectioningSolutionLog where timeStamp < " + HibernateUtil.addDate("current_date()", ":days")).setInteger("days", -days).executeUpdate();
            if (rows > 0) {
                sLog.info((Object)("All records older than " + days + " days deleted from the sectioning solutions log (" + rows + " records)."));
            }
            tx.commit();
        }
    }

    public static void cleanupLogs() {
        LogCleaner.cleanupChangeLog(ApplicationProperty.LogCleanupChangeLog.intValue());
        LogCleaner.cleanupQueryLog(ApplicationProperty.LogCleanupQueryLog.intValue());
        LogCleaner.cleanupOnlineSectioningLog(ApplicationProperty.LogCleanupOnlineSchedulingLog.intValue());
        LogCleaner.cleanupMessageLog(ApplicationProperty.LogCleanupMessageLog.intValue());
        LogCleaner.cleanupStudentSectioningQueue(ApplicationProperty.LogCleanupOnlineSchedulingQueue.intValue());
        LogCleaner.cleanupHashedQueries(ApplicationProperty.LogCleanupHashedQueries.intValue());
        LogCleaner.cleanupSctSolutionLog(ApplicationProperty.LogCleanupSectioningSolutionLog.intValue());
    }
}

