/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.FinalExamEvent;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.MidtermExamEvent;
import org.unitime.timetable.model.base.BaseRefTableEntry;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.util.Constants;

public class DefaultRoomAvailabilityService
implements RoomAvailabilityInterface {
    private Vector<CacheElement> iCache = new Vector();
    private boolean iInstructorAvailabilityEnabled = false;

    @Override
    public String getTimeStamp(Date startTime, Date endTime, String excludeType) {
        TimeFrame time = new TimeFrame(startTime, endTime);
        CacheElement cache = this.get(time, excludeType);
        return cache == null ? null : cache.getTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheElement get(TimeFrame time, String excludeType) {
        Vector<CacheElement> vector = this.iCache;
        synchronized (vector) {
            for (CacheElement cache : this.iCache) {
                if (!cache.cover(time) || !cache.exclude(excludeType)) continue;
                return cache;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RoomAvailabilityInterface.TimeBlock> getRoomAvailability(Long locationId, Date startTime, Date endTime, String excludeType) {
        Location location = (Location)LocationDAO.getInstance().get(locationId);
        if (location == null || location.getPermanentId() == null) {
            return null;
        }
        EventDateMapping.Class2EventDateMap class2eventDateMap = sClassType.equals(excludeType) ? EventDateMapping.getMapping(location.getSession().getUniqueId()) : null;
        TimeFrame time = new TimeFrame(startTime, endTime);
        Vector<CacheElement> vector = this.iCache;
        synchronized (vector) {
            MeetingTimeBlock block;
            CacheElement cache = this.get(time, excludeType);
            if (cache != null) {
                return cache.get(location.getPermanentId(), excludeType);
            }
            TreeSet<RoomAvailabilityInterface.TimeBlock> ret = new TreeSet<RoomAvailabilityInterface.TimeBlock>();
            Class exclude = null;
            BaseRefTableEntry examType = null;
            if (excludeType != null) {
                if (sFinalExamType.equals(excludeType)) {
                    exclude = FinalExamEvent.class;
                } else if (sMidtermExamType.equals(excludeType)) {
                    exclude = MidtermExamEvent.class;
                } else if (sClassType.equals(excludeType)) {
                    exclude = ClassEvent.class;
                } else {
                    exclude = ExamEvent.class;
                    examType = ExamType.findByReference(excludeType);
                }
            }
            for (Meeting m : LocationDAO.getInstance().getSession().createQuery("select m from Meeting m where m.locationPermanentId=:locPermId and m.approvalStatus = 1 and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (examType != null ? " and m.event.uniqueId not in (select x.uniqueId from ExamEvent x where x.exam.examType = " + examType.getUniqueId() + ")" : (exclude != null ? " and m.event.class!=" + exclude.getSimpleName() : ""))).setLong("locPermId", location.getPermanentId().longValue()).setDate("startDate", time.getStartDate()).setDate("endDate", time.getEndDate()).setInteger("startSlot", time.getStartSlot()).setInteger("endSlot", time.getEndSlot()).setCacheable(true).list()) {
                block = new MeetingTimeBlock(m, class2eventDateMap);
                if (block.getStartTime() == null) continue;
                ret.add(block);
            }
            if (ApplicationProperty.RoomAvailabilityIncludeOtherTerms.isTrue() && excludeType != null) {
                if (ClassEvent.class.isAssignableFrom(exclude)) {
                    for (Meeting m : LocationDAO.getInstance().getSession().createQuery("select m from ClassEvent e inner join e.meetings m where m.locationPermanentId=:locPermId and m.approvalStatus = 1 and e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId != :sessionId and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot").setLong("locPermId", location.getPermanentId().longValue()).setLong("sessionId", location.getSession().getUniqueId().longValue()).setDate("startDate", time.getStartDate()).setDate("endDate", time.getEndDate()).setInteger("startSlot", time.getStartSlot()).setInteger("endSlot", time.getEndSlot()).setCacheable(true).list()) {
                        block = new MeetingTimeBlock(m, class2eventDateMap);
                        if (block.getStartTime() == null) continue;
                        ret.add(block);
                    }
                } else if (ExamEvent.class.isAssignableFrom(exclude)) {
                    for (Meeting m : LocationDAO.getInstance().getSession().createQuery("select m from " + exclude.getSimpleName() + " e inner join e.meetings m where m.locationPermanentId=:locPermId and m.approvalStatus = 1 and e.exam.session.uniqueId != :sessionId and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (examType != null ? " and e.exam.examType = " + examType.getUniqueId() : "")).setLong("locPermId", location.getPermanentId().longValue()).setLong("sessionId", location.getSession().getUniqueId().longValue()).setDate("startDate", time.getStartDate()).setDate("endDate", time.getEndDate()).setInteger("startSlot", time.getStartSlot()).setInteger("endSlot", time.getEndSlot()).setCacheable(true).list()) {
                        block = new MeetingTimeBlock(m, class2eventDateMap);
                        if (block.getStartTime() == null) continue;
                        ret.add(block);
                    }
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(Long sessionId, Date startTime, Date endTime, String excludeType, boolean waitForSync) {
        this.iInstructorAvailabilityEnabled = ApplicationProperty.RoomAvailabilityIncludeInstructors.isTrue();
        TimeFrame time = new TimeFrame(startTime, endTime);
        EventDateMapping.Class2EventDateMap class2eventDateMap = sClassType.equals(excludeType) ? EventDateMapping.getMapping(sessionId) : null;
        Vector<CacheElement> vector = this.iCache;
        synchronized (vector) {
            CacheElement cache = this.get(time, excludeType);
            if (cache == null) {
                cache = new CacheElement(time, excludeType);
                this.iCache.insertElementAt(cache, 0);
            }
            cache.update(class2eventDateMap, sessionId, this.iInstructorAvailabilityEnabled);
        }
    }

    @Override
    public void startService() {
    }

    @Override
    public void stopService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RoomAvailabilityInterface.TimeBlock> getInstructorAvailability(Long instructorId, Date startTime, Date endTime, String excludeType) {
        DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(instructorId);
        if (!this.iInstructorAvailabilityEnabled || instructor == null || instructor.getExternalUniqueId() == null) {
            if (instructor != null) {
                return instructor.listUnavailableDays();
            }
            return null;
        }
        EventDateMapping.Class2EventDateMap class2eventDateMap = sClassType.equals(excludeType) ? EventDateMapping.getMapping(instructor.getDepartment().getSession().getUniqueId()) : null;
        TimeFrame time = new TimeFrame(startTime, endTime);
        Vector<CacheElement> vector = this.iCache;
        synchronized (vector) {
            MeetingTimeBlockWithRoom block;
            CacheElement cache = this.get(time, excludeType);
            if (cache != null) {
                TreeSet<RoomAvailabilityInterface.TimeBlock> cached = cache.get(instructor.getExternalUniqueId(), excludeType);
                if (instructor.hasUnavailabilities()) {
                    List<RoomAvailabilityInterface.TimeBlock> ret = instructor.listUnavailableDays();
                    if (cached != null) {
                        ret.addAll(cached);
                    }
                    return ret;
                }
                return cached;
            }
            TreeSet<RoomAvailabilityInterface.TimeBlock> ret = new TreeSet<RoomAvailabilityInterface.TimeBlock>();
            Class exclude = null;
            BaseRefTableEntry examType = null;
            if (excludeType != null) {
                if (sFinalExamType.equals(excludeType)) {
                    exclude = FinalExamEvent.class;
                } else if (sMidtermExamType.equals(excludeType)) {
                    exclude = MidtermExamEvent.class;
                } else if (sClassType.equals(excludeType)) {
                    exclude = ClassEvent.class;
                } else {
                    exclude = ExamEvent.class;
                    examType = ExamType.findByReference(excludeType);
                }
            }
            for (Meeting m : LocationDAO.getInstance().getSession().createQuery("select m from Meeting m left outer join m.event.additionalContacts c where (m.event.mainContact.externalUniqueId = :user or c.externalUniqueId = :user) and m.approvalStatus = 1 and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (examType != null ? " and m.event.uniqueId not in (select x.uniqueId from ExamEvent x where x.exam.examType = " + examType.getUniqueId() + ")" : (exclude != null ? " and m.event.class!=" + exclude.getSimpleName() : ""))).setString("user", instructor.getExternalUniqueId()).setDate("startDate", time.getStartDate()).setDate("endDate", time.getEndDate()).setInteger("startSlot", time.getStartSlot()).setInteger("endSlot", time.getEndSlot()).setCacheable(true).list()) {
                block = new MeetingTimeBlockWithRoom(m, class2eventDateMap);
                if (block.getStartTime() == null) continue;
                ret.add(block);
            }
            if (ApplicationProperty.RoomAvailabilityIncludeOtherTerms.isTrue() && excludeType != null) {
                if (ClassEvent.class.isAssignableFrom(exclude)) {
                    for (Meeting m : LocationDAO.getInstance().getSession().createQuery("select m from ClassEvent e inner join e.meetings m inner join e.clazz.classInstructors ci where ci.instructor.externalUniqueId = :user and ci.lead = true and m.approvalStatus = 1 and e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId != :sessionId and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot").setString("user", instructor.getExternalUniqueId()).setLong("sessionId", instructor.getDepartment().getSession().getUniqueId().longValue()).setDate("startDate", time.getStartDate()).setDate("endDate", time.getEndDate()).setInteger("startSlot", time.getStartSlot()).setInteger("endSlot", time.getEndSlot()).setCacheable(true).list()) {
                        block = new MeetingTimeBlockWithRoom(m, class2eventDateMap);
                        if (block.getStartTime() == null) continue;
                        ret.add(block);
                    }
                } else if (ExamEvent.class.isAssignableFrom(exclude)) {
                    for (Meeting m : LocationDAO.getInstance().getSession().createQuery("select m from " + exclude.getSimpleName() + " e inner join e.meetings m inner join e.exam.instructors di where  di.externalUniqueId = :user and m.approvalStatus = 1 and e.exam.session.uniqueId != :sessionId and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (examType != null ? " and e.exam.examType = " + examType.getUniqueId() : "")).setString("user", instructor.getExternalUniqueId()).setLong("sessionId", instructor.getDepartment().getSession().getUniqueId().longValue()).setDate("startDate", time.getStartDate()).setDate("endDate", time.getEndDate()).setInteger("startSlot", time.getStartSlot()).setInteger("endSlot", time.getEndSlot()).setCacheable(true).list()) {
                        block = new MeetingTimeBlockWithRoom(m, class2eventDateMap);
                        if (block.getStartTime() == null) continue;
                        ret.add(block);
                    }
                }
            }
            if (instructor.hasUnavailabilities()) {
                ret.addAll(instructor.listUnavailableDays());
            }
            return ret;
        }
    }

    public static class MeetingTimeBlockWithRoom
    extends MeetingTimeBlock
    implements RoomAvailabilityInterface.HasRoom {
        private static final long serialVersionUID = 917189228937342264L;
        Long iLocationId;
        String iLocationLabel;
        Double iCoordX;
        Double iCoordY;
        boolean iIgnoreTooFar;
        boolean iIgnoreRoomCheck;

        public MeetingTimeBlockWithRoom(Meeting m, EventDateMapping.Class2EventDateMap class2eventDateMap) {
            super(m, class2eventDateMap);
            Location location = m.getLocation();
            if (location != null) {
                this.iLocationId = location.getUniqueId();
                this.iLocationLabel = location.getLabel();
                this.iCoordX = location.getCoordinateX();
                this.iCoordY = location.getCoordinateY();
                this.iIgnoreTooFar = location.isIgnoreTooFar();
                this.iIgnoreRoomCheck = location.isIgnoreRoomCheck();
            }
        }

        @Override
        public Long getLocationId() {
            return this.iLocationId;
        }

        @Override
        public Long getPermanentId() {
            return this.getLocationPermanentId();
        }

        @Override
        public String getLabel() {
            return this.iLocationLabel;
        }

        @Override
        public Double getCoordinateX() {
            return this.iCoordX;
        }

        @Override
        public Double getCoordinateY() {
            return this.iCoordY;
        }

        @Override
        public boolean isIgnoreTooFar() {
            return this.iIgnoreTooFar;
        }

        @Override
        public boolean isIgnoreRoomCheck() {
            return this.iIgnoreRoomCheck;
        }
    }

    public static class MeetingTimeBlock
    implements RoomAvailabilityInterface.TimeBlock,
    Comparable<RoomAvailabilityInterface.TimeBlock> {
        private static final long serialVersionUID = -5557707709984628517L;
        Long iEventId;
        Long iMeetingId;
        Long iLocationPermanentId;
        String iEventName;
        String iEventType;
        Date iStart;
        Date iEnd;

        public MeetingTimeBlock(Meeting m, EventDateMapping.Class2EventDateMap class2eventDateMap) {
            this.iEventId = m.getEvent().getUniqueId();
            this.iMeetingId = m.getUniqueId();
            this.iLocationPermanentId = m.getLocationPermanentId();
            this.iEventName = m.getEvent().getEventName();
            this.iEventType = m.getEvent().getEventTypeAbbv();
            this.iStart = m.getTrueStartTime(class2eventDateMap);
            this.iEnd = m.getTrueStopTime(class2eventDateMap);
        }

        @Override
        public Long getEventId() {
            return this.iEventId;
        }

        public Long getMeetingId() {
            return this.iMeetingId;
        }

        public Long getLocationPermanentId() {
            return this.iLocationPermanentId;
        }

        @Override
        public String getEventName() {
            return this.iEventName;
        }

        @Override
        public String getEventType() {
            return this.iEventType;
        }

        @Override
        public Date getStartTime() {
            return this.iStart;
        }

        @Override
        public Date getEndTime() {
            return this.iEnd;
        }

        public String toString() {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy HH:mm");
            SimpleDateFormat df2 = new SimpleDateFormat("HH:mm");
            return this.getEventName() + " (" + this.getEventType() + ") " + df.format(this.getStartTime()) + " - " + df2.format(this.getEndTime());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof MeetingTimeBlock)) {
                return false;
            }
            MeetingTimeBlock m = (MeetingTimeBlock)o;
            return this.getMeetingId().equals(m.getMeetingId());
        }

        public int hashCode() {
            return this.getMeetingId().hashCode();
        }

        @Override
        public int compareTo(RoomAvailabilityInterface.TimeBlock block) {
            int cmp = this.getStartTime().compareTo(block.getStartTime());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getEndTime().compareTo(block.getEndTime());
            if (cmp != 0) {
                return cmp;
            }
            return this.getEventName().compareTo(block.getEventName());
        }
    }

    public static class CacheElement {
        private TimeFrame iTime;
        private Map<Long, TreeSet<RoomAvailabilityInterface.TimeBlock>> iAvailability = new HashMap<Long, TreeSet<RoomAvailabilityInterface.TimeBlock>>();
        private Map<String, TreeSet<RoomAvailabilityInterface.TimeBlock>> iInstructorAvailability = new HashMap<String, TreeSet<RoomAvailabilityInterface.TimeBlock>>();
        private String iTimestamp = null;
        private String iExcludeType = null;

        public CacheElement(TimeFrame time, String excludeType) {
            this.iTime = time;
            this.iExcludeType = excludeType;
        }

        public void update(EventDateMapping.Class2EventDateMap class2eventDateMap, Long sessionId, boolean includeInstructors) {
            this.iAvailability.clear();
            this.iInstructorAvailability.clear();
            Class exclude = null;
            BaseRefTableEntry examType = null;
            if (this.iExcludeType != null) {
                if (RoomAvailabilityInterface.sFinalExamType.equals(this.iExcludeType)) {
                    exclude = FinalExamEvent.class;
                } else if (RoomAvailabilityInterface.sMidtermExamType.equals(this.iExcludeType)) {
                    exclude = MidtermExamEvent.class;
                } else if (RoomAvailabilityInterface.sClassType.equals(this.iExcludeType)) {
                    exclude = ClassEvent.class;
                } else {
                    exclude = ExamEvent.class;
                    examType = ExamType.findByReference(this.iExcludeType);
                }
            }
            this.addAll(LocationDAO.getInstance().getSession().createQuery("select m from Meeting m where m.locationPermanentId!=null and m.approvalStatus = 1 and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (examType != null ? " and m.event.uniqueId not in (select x.uniqueId from ExamEvent x where x.exam.examType = " + examType.getUniqueId() + ")" : (exclude == null ? "" : " and m.event.class!=" + exclude.getSimpleName()))).setDate("startDate", this.iTime.getStartDate()).setDate("endDate", this.iTime.getEndDate()).setInteger("startSlot", this.iTime.getStartSlot()).setInteger("endSlot", this.iTime.getEndSlot()).setCacheable(true).list(), class2eventDateMap);
            if (sessionId != null && ApplicationProperty.RoomAvailabilityIncludeOtherTerms.isTrue() && exclude != null) {
                if (ClassEvent.class.isAssignableFrom(exclude)) {
                    this.addAll(LocationDAO.getInstance().getSession().createQuery("select m from ClassEvent e inner join e.meetings m where m.locationPermanentId in (select l.permanentId from Location l where l.session = :sessionId) and m.approvalStatus = 1 and e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId != :sessionId and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot").setLong("sessionId", sessionId.longValue()).setDate("startDate", this.iTime.getStartDate()).setDate("endDate", this.iTime.getEndDate()).setInteger("startSlot", this.iTime.getStartSlot()).setInteger("endSlot", this.iTime.getEndSlot()).setCacheable(true).list(), class2eventDateMap);
                } else if (ExamEvent.class.isAssignableFrom(exclude)) {
                    this.addAll(LocationDAO.getInstance().getSession().createQuery("select m from " + exclude.getSimpleName() + " e inner join e.meetings m where m.locationPermanentId in (select l.permanentId from Location l where l.session = :sessionId) and m.approvalStatus = 1 and e.exam.session.uniqueId != :sessionId and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (examType != null ? " and e.exam.examType = " + examType.getUniqueId() : "")).setLong("sessionId", sessionId.longValue()).setDate("startDate", this.iTime.getStartDate()).setDate("endDate", this.iTime.getEndDate()).setInteger("startSlot", this.iTime.getStartSlot()).setInteger("endSlot", this.iTime.getEndSlot()).setCacheable(true).list(), class2eventDateMap);
                }
            }
            if (sessionId != null && includeInstructors) {
                this.addAllInstructors(LocationDAO.getInstance().getSession().createQuery("select distinct m, i.externalUniqueId from Meeting m left outer join m.event.additionalContacts c, DepartmentalInstructor i where i.department.session.uniqueId = :sessionId and i.externalUniqueId is not null and (m.event.mainContact.externalUniqueId = i.externalUniqueId or c.externalUniqueId = i.externalUniqueId) and m.approvalStatus = 1 and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (examType != null ? " and m.event.uniqueId not in (select x.uniqueId from ExamEvent x where x.exam.examType = " + examType.getUniqueId() + ")" : (exclude != null ? " and m.event.class!=" + exclude.getSimpleName() : ""))).setDate("startDate", this.iTime.getStartDate()).setDate("endDate", this.iTime.getEndDate()).setLong("sessionId", sessionId.longValue()).setInteger("startSlot", this.iTime.getStartSlot()).setInteger("endSlot", this.iTime.getEndSlot()).setCacheable(true).list(), class2eventDateMap);
                if (ApplicationProperty.RoomAvailabilityIncludeOtherTerms.isTrue() && exclude != null) {
                    if (ClassEvent.class.isAssignableFrom(exclude)) {
                        this.addAllInstructors(LocationDAO.getInstance().getSession().createQuery("select m, ci.instructor.externalUniqueId from ClassEvent e inner join e.meetings m inner join e.clazz.classInstructors ci where ci.lead = true and m.approvalStatus = 1 and e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId != :sessionId and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot").setLong("sessionId", sessionId.longValue()).setDate("startDate", this.iTime.getStartDate()).setDate("endDate", this.iTime.getEndDate()).setInteger("startSlot", this.iTime.getStartSlot()).setInteger("endSlot", this.iTime.getEndSlot()).setCacheable(true).list(), class2eventDateMap);
                    } else if (ExamEvent.class.isAssignableFrom(exclude)) {
                        this.addAllInstructors(LocationDAO.getInstance().getSession().createQuery("select m, di.externalUniqueId from " + exclude.getSimpleName() + " e inner join e.meetings m inner join e.exam.instructors di where  m.approvalStatus = 1 and e.exam.session.uniqueId != :sessionId and m.meetingDate>=:startDate and m.meetingDate<=:endDate and m.startPeriod<:endSlot and m.stopPeriod>:startSlot" + (examType != null ? " and e.exam.examType = " + examType.getUniqueId() : "")).setLong("sessionId", sessionId.longValue()).setDate("startDate", this.iTime.getStartDate()).setDate("endDate", this.iTime.getEndDate()).setInteger("startSlot", this.iTime.getStartSlot()).setInteger("endSlot", this.iTime.getEndSlot()).setCacheable(true).list(), class2eventDateMap);
                    }
                }
            }
            this.iTimestamp = new Date().toString();
        }

        private void add(Meeting m, EventDateMapping.Class2EventDateMap class2eventDateMap) {
            MeetingTimeBlock block;
            TreeSet<RoomAvailabilityInterface.TimeBlock> blocks = this.iAvailability.get(m.getLocationPermanentId());
            if (blocks == null) {
                blocks = new TreeSet();
                this.iAvailability.put(m.getLocationPermanentId(), blocks);
            }
            if ((block = new MeetingTimeBlock(m, class2eventDateMap)).getStartTime() != null) {
                blocks.add(block);
            }
        }

        private void addAll(List<Meeting> meetings, EventDateMapping.Class2EventDateMap class2eventDateMap) {
            if (meetings != null) {
                for (Meeting m : meetings) {
                    this.add(m, class2eventDateMap);
                }
            }
        }

        private void add(Meeting m, String instructorExternalId, EventDateMapping.Class2EventDateMap class2eventDateMap) {
            MeetingTimeBlockWithRoom block;
            TreeSet<RoomAvailabilityInterface.TimeBlock> blocks = this.iInstructorAvailability.get(instructorExternalId);
            if (blocks == null) {
                blocks = new TreeSet();
                this.iInstructorAvailability.put(instructorExternalId, blocks);
            }
            if ((block = new MeetingTimeBlockWithRoom(m, class2eventDateMap)).getStartTime() != null) {
                blocks.add(block);
            }
        }

        private void addAllInstructors(List<Object[]> meetings, EventDateMapping.Class2EventDateMap class2eventDateMap) {
            if (meetings != null) {
                for (Object[] o : meetings) {
                    Meeting m = (Meeting)o[0];
                    String id = (String)o[1];
                    this.add(m, id, class2eventDateMap);
                }
            }
        }

        public TreeSet<RoomAvailabilityInterface.TimeBlock> get(Long roomPermId, String excludeType) {
            TreeSet<RoomAvailabilityInterface.TimeBlock> roomAvailability = this.iAvailability.get(roomPermId);
            if (roomAvailability == null || excludeType == null || excludeType.equals(this.iExcludeType)) {
                return roomAvailability;
            }
            TreeSet<RoomAvailabilityInterface.TimeBlock> ret = new TreeSet<RoomAvailabilityInterface.TimeBlock>();
            for (RoomAvailabilityInterface.TimeBlock block : roomAvailability) {
                if (excludeType.equals(block.getEventType())) continue;
                ret.add(block);
            }
            return ret;
        }

        public TreeSet<RoomAvailabilityInterface.TimeBlock> get(String instructorExternalId, String excludeType) {
            if (instructorExternalId == null) {
                return null;
            }
            TreeSet<RoomAvailabilityInterface.TimeBlock> instructorAvailability = this.iInstructorAvailability.get(instructorExternalId);
            if (instructorAvailability == null || excludeType == null || excludeType.equals(this.iExcludeType)) {
                return instructorAvailability;
            }
            TreeSet<RoomAvailabilityInterface.TimeBlock> ret = new TreeSet<RoomAvailabilityInterface.TimeBlock>();
            for (RoomAvailabilityInterface.TimeBlock block : instructorAvailability) {
                if (excludeType.equals(block.getEventType())) continue;
                ret.add(block);
            }
            return ret;
        }

        public TimeFrame getTimeFrame() {
            return this.iTime;
        }

        public String getExcludeType() {
            return this.iExcludeType;
        }

        public boolean exclude(String type) {
            return this.iExcludeType == null || this.iExcludeType.equals(type);
        }

        public boolean cover(TimeFrame time) {
            return this.iTime.getStartDate().compareTo(time.getStartDate()) <= 0 && time.getEndDate().compareTo(this.iTime.getEndDate()) <= 0 && this.iTime.getStartSlot() <= time.getStartSlot() && time.getEndSlot() <= this.iTime.getEndSlot();
        }

        public String getTimestamp() {
            return this.iTimestamp;
        }

        public String toString() {
            return this.iTime.toString();
        }
    }

    public static class TimeFrame {
        private Date iStart;
        private Date iEnd;
        private int iStartSlot;
        private int iEndSlot;

        public TimeFrame(Date startTime, Date endTime) {
            Calendar start = Calendar.getInstance(Locale.US);
            start.setTime(startTime);
            int startMin = 60 * start.get(11) + start.get(12);
            start.add(12, -startMin);
            Calendar end = Calendar.getInstance(Locale.US);
            end.setTime(endTime);
            int endMin = 60 * end.get(11) + start.get(12);
            end.add(12, -endMin);
            this.iStartSlot = (startMin - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            this.iEndSlot = (endMin - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            this.iStart = start.getTime();
            this.iEnd = end.getTime();
        }

        public Date getStartDate() {
            return this.iStart;
        }

        public Date getEndDate() {
            return this.iEnd;
        }

        public int getStartSlot() {
            return this.iStartSlot;
        }

        public int getEndSlot() {
            return this.iEndSlot;
        }

        public int hashCode() {
            return this.iStart.hashCode() ^ this.iEnd.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TimeFrame)) {
                return false;
            }
            TimeFrame t = (TimeFrame)o;
            return this.getStartDate().equals(t.getStartDate()) && this.getEndDate().equals(t.getEndDate()) && this.getStartSlot() == t.getStartSlot() && this.getEndSlot() == t.getEndSlot();
        }

        public String toString() {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy");
            int start = this.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            int end = this.getEndSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            return df.format(this.getStartDate()) + " - " + df.format(this.getEndDate()) + " " + Constants.toTime(start) + " - " + Constants.toTime(end);
        }
    }
}

