/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.TimetableXMLLoader;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.util.Constants;

public class MuniPdFKSCZVDatePatterns
extends Extension<Lecture, Placement> {
    private static Log sLog = LogFactory.getLog(MuniPdFKSCZVDatePatterns.class);
    private Hashtable<Integer, List<TimetableXMLLoader.DatePattern>> iDatePatternsExt = new Hashtable();
    private Hashtable<Integer, List<TimetableXMLLoader.DatePattern>> iDatePatternsAll = new Hashtable();
    static String[] sCombinations = new String[]{"1,0,0,0,0,0,0,0,0,0,0,0,0", "0,1,0,0,0,0,0,0,0,0,0,0,0", "0,0,1,0,0,0,0,0,0,0,0,0,0", "0,0,0,1,0,0,0,0,0,0,0,0,0", "0,0,0,0,1,0,0,0,0,0,0,0,0", "0,0,0,0,0,1,0,0,0,0,0,0,0", "0,0,0,0,0,0,1,0,0,0,0,0,0", "0,0,0,0,0,0,0,1,0,0,0,0,0", "0,0,0,0,0,0,0,0,1,0,0,0,0", "0,0,0,0,0,0,0,0,0,1,0,0,0", "0,0,0,0,0,0,0,0,0,0,1,0,0", "0,0,0,0,0,0,0,0,0,0,0,1,0", "0,0,0,0,0,0,0,0,0,0,0,0,1", "1,1,0,0,0,0,0,0,0,0,0,0,0", "0,1,1,0,0,0,0,0,0,0,0,0,0", "0,0,1,1,0,0,0,0,0,0,0,0,0", "0,0,0,1,1,0,0,0,0,0,0,0,0", "0,0,0,0,1,1,0,0,0,0,0,0,0", "0,0,0,0,0,1,1,0,0,0,0,0,0", "0,0,0,0,0,0,1,1,0,0,0,0,0", "0,0,0,0,0,0,0,1,1,0,0,0,0", "0,0,0,0,0,0,0,0,1,1,0,0,0", "0,0,0,0,0,0,0,0,0,1,1,0,0", "0,0,0,0,0,0,0,0,0,0,1,1,0", "0,0,0,0,0,0,0,0,0,0,0,1,1", "1,0,0,0,0,0,1,0,0,0,0,0,0", "0,1,0,0,0,0,0,1,0,0,0,0,0", "0,0,1,0,0,0,0,0,1,0,0,0,0", "0,0,0,1,0,0,0,0,0,1,0,0,0", "0,0,0,0,1,0,0,0,0,0,1,0,0", "0,0,0,0,0,1,0,0,0,0,0,1,0", "0,0,0,0,0,0,1,0,0,0,0,0,1", "1,1,1,0,0,0,0,0,0,0,0,0,0", "0,1,1,1,0,0,0,0,0,0,0,0,0", "0,0,1,1,1,0,0,0,0,0,0,0,0", "0,0,0,1,1,1,0,0,0,0,0,0,0", "0,0,0,0,1,1,1,0,0,0,0,0,0", "0,0,0,0,0,1,1,1,0,0,0,0,0", "0,0,0,0,0,0,1,1,1,0,0,0,0", "0,0,0,0,0,0,0,1,1,1,0,0,0", "0,0,0,0,0,0,0,0,1,1,1,0,0", "0,0,0,0,0,0,0,0,0,1,1,1,0", "0,0,0,0,0,0,0,0,0,0,1,1,1", "1,0,0,0,1,0,0,0,1,0,0,0,0", "0,1,0,0,0,1,0,0,0,1,0,0,0", "0,0,1,0,0,0,1,0,0,0,1,0,0", "0,0,0,1,0,0,0,1,0,0,0,1,0", "0,0,0,0,1,0,0,0,1,0,0,0,1", "1,1,1,1,0,0,0,0,0,0,0,0,0", "0,1,1,1,1,0,0,0,0,0,0,0,0", "0,0,1,1,1,1,0,0,0,0,0,0,0", "0,0,0,1,1,1,1,0,0,0,0,0,0", "0,0,0,0,1,1,1,1,0,0,0,0,0", "0,0,0,0,0,1,1,1,1,0,0,0,0", "0,0,0,0,0,0,1,1,1,1,0,0,0", "0,0,0,0,0,0,0,1,1,1,1,0,0", "0,0,0,0,0,0,0,0,1,1,1,1,0", "0,0,0,0,0,0,0,0,0,1,1,1,1", "1,0,0,1,0,0,1,0,0,1,0,0,0", "0,1,0,0,1,0,0,1,0,0,1,0,0", "0,0,1,0,0,1,0,0,1,0,0,1,0", "0,0,0,1,0,0,1,0,0,1,0,0,1", "1,1,1,1,1,0,0,0,0,0,0,0,0", "0,1,1,1,1,1,0,0,0,0,0,0,0", "0,0,1,1,1,1,1,0,0,0,0,0,0", "0,0,0,1,1,1,1,1,0,0,0,0,0", "0,0,0,0,1,1,1,1,1,0,0,0,0", "0,0,0,0,0,1,1,1,1,1,0,0,0", "0,0,0,0,0,0,1,1,1,1,1,0,0", "0,0,0,0,0,0,0,1,1,1,1,1,0", "0,0,0,0,0,0,0,0,1,1,1,1,1", "1,0,1,0,1,0,1,0,1,0,0,0,0", "0,1,0,1,0,1,0,1,0,1,0,0,0", "0,0,1,0,1,0,1,0,1,0,1,0,0", "0,0,0,1,0,1,0,1,0,1,0,1,0", "0,0,0,0,1,0,1,0,1,0,1,0,1", "1,1,1,1,1,1,0,0,0,0,0,0,0", "0,1,1,1,1,1,1,0,0,0,0,0,0", "0,0,1,1,1,1,1,1,0,0,0,0,0", "0,0,0,1,1,1,1,1,1,0,0,0,0", "0,0,0,0,1,1,1,1,1,1,0,0,0", "0,0,0,0,0,1,1,1,1,1,1,0,0", "0,0,0,0,0,0,1,1,1,1,1,1,0", "0,0,0,0,0,0,0,1,1,1,1,1,1", "1,0,1,0,1,0,1,0,1,0,1,0,0", "0,1,0,1,0,1,0,1,0,1,0,1,0", "0,0,1,0,1,0,1,0,1,0,1,0,1"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuniPdFKSCZVDatePatterns(Solver<Lecture, Placement> solver, DataProperties properties) {
        super(solver, properties);
        try (org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();){
            List<TimetableXMLLoader.DatePattern> patterns;
            int nrWeeks;
            BitSet weekCode;
            for (DatePattern dp : hibSession.createQuery("from DatePattern dp where dp.session.uniqueId = :sessionId and dp.type = :type and dp.name like :name order by dp.offset desc").setLong("sessionId", properties.getPropertyLong("General.SessionId", -1L)).setInteger("type", DatePattern.DatePatternType.Extended.ordinal()).setString("name", "T%den %").list()) {
                weekCode = dp.getPatternBitSet();
                nrWeeks = weekCode.cardinality() / 7;
                patterns = this.iDatePatternsExt.get(nrWeeks);
                if (patterns == null) {
                    patterns = new ArrayList<TimetableXMLLoader.DatePattern>();
                    this.iDatePatternsExt.put(nrWeeks, patterns);
                }
                patterns.add(new TimetableXMLLoader.DatePattern(dp.getUniqueId(), dp.getName(), weekCode));
            }
            for (DatePattern dp : hibSession.createQuery("from DatePattern dp where dp.session.uniqueId = :sessionId and dp.name like :name order by dp.offset desc").setLong("sessionId", properties.getPropertyLong("General.SessionId", -1L)).setString("name", "T%den %").list()) {
                weekCode = dp.getPatternBitSet();
                nrWeeks = weekCode.cardinality() / 7;
                patterns = this.iDatePatternsAll.get(nrWeeks);
                if (patterns == null) {
                    patterns = new ArrayList<TimetableXMLLoader.DatePattern>();
                    this.iDatePatternsAll.put(nrWeeks, patterns);
                }
                patterns.add(new TimetableXMLLoader.DatePattern(dp.getUniqueId(), dp.getName(), weekCode));
            }
        }
    }

    private Class_ parent(Class_ clazz) {
        Class_ parent;
        Class_ class_ = parent = clazz == null ? null : clazz.getParentClass();
        if (parent != null && parent.getSchedulingSubpart().getItype().equals(clazz.getSchedulingSubpart().getItype()) && clazz.effectiveDatePattern().equals(parent.effectiveDatePattern())) {
            return parent;
        }
        return null;
    }

    private Class_ child(Class_ clazz) {
        if (clazz == null) {
            return null;
        }
        for (Class_ child : clazz.getChildClasses()) {
            if (!child.getSchedulingSubpart().getItype().equals(clazz.getSchedulingSubpart().getItype()) || !child.effectiveDatePattern().equals(clazz.effectiveDatePattern())) continue;
            return child;
        }
        return null;
    }

    public void variableAdded(Lecture lecture) {
        if (lecture.timeLocations().isEmpty()) {
            return;
        }
        ArrayList times = new ArrayList(lecture.timeLocations());
        boolean sp = false;
        for (TimeLocation t : times) {
            if ((t.getDayCode() & Constants.DAY_CODES[3]) == 0) continue;
            sp = true;
            break;
        }
        if (((TimeLocation)times.get(0)).getDatePatternName().matches("[1-6]x")) {
            Class_ clazz = (Class_)Class_DAO.getInstance().get(lecture.getClassId());
            int parents = 0;
            Class_ parent = this.parent(clazz);
            while (parent != null) {
                ++parents;
                parent = this.parent(parent);
            }
            int children = 0;
            Class_ child = this.child(clazz);
            while (child != null) {
                ++children;
                child = this.child(child);
            }
            int n = Integer.parseInt(((TimeLocation)times.get(0)).getDatePatternName().substring(0, 1));
            lecture.timeLocations().clear();
            for (TimeLocation t : times) {
                List<TimetableXMLLoader.DatePattern> datePatterns = (sp ? this.iDatePatternsAll : this.iDatePatternsExt).get(n);
                for (int i = parents; i < datePatterns.size() - children; ++i) {
                    TimetableXMLLoader.DatePattern dp = datePatterns.get(i);
                    if (!dp.getName().endsWith("den 0") && (t.getDayCode() & Constants.DAY_CODES[3]) != 0) continue;
                    TimeLocation time = new TimeLocation(t.getDayCode(), t.getStartSlot(), t.getLength(), t.getPreference(), t.getNormalizedPreference(), dp.getId(), dp.getName(), dp.getPattern(), t.getBreakTime());
                    time.setTimePatternId(t.getTimePatternId());
                    lecture.timeLocations().add(time);
                }
            }
        }
        lecture.clearValueCache();
    }

    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            org.hibernate.Session hibSession = new _RootDAO().getSession();
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PdF"), ApplicationProperties.getProperty("year", "2011"), ApplicationProperties.getProperty("term", "Podzim"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + session));
            }
            ArrayList<BitSet> weeks = new ArrayList<BitSet>();
            BitSet fullTerm = session.getDefaultDatePattern().getPatternBitSet();
            int cnt = 0;
            for (int i = 0; i < fullTerm.length(); ++i) {
                if (!fullTerm.get(i)) continue;
                int w = cnt++ / 7;
                if (weeks.size() == w) {
                    weeks.add(new BitSet(fullTerm.length()));
                }
                ((BitSet)weeks.get(w)).set(i);
            }
            for (String c : sCombinations) {
                int j;
                String pattern;
                DatePattern p;
                BitSet weekCode = new BitSet(((BitSet)weeks.get(0)).length());
                String dp = "";
                int f = -1;
                int i = 0;
                for (String x : c.split(",")) {
                    if (x.equals("1")) {
                        if (f < 0) {
                            f = 1 + i;
                        }
                        weekCode.or((BitSet)weeks.get(i));
                    } else if (f > 0) {
                        if (!dp.isEmpty()) {
                            dp = dp + ",";
                        }
                        dp = f == i ? dp + "" + f : dp + f + "-" + i;
                        f = -1;
                    }
                    ++i;
                }
                if (f > 0) {
                    if (!dp.isEmpty()) {
                        dp = dp + ",";
                    }
                    dp = f == weeks.size() ? dp + "" + f : dp + f + "-" + weeks.size();
                }
                if ((p = DatePattern.findByName(session, "T\u00fdden " + dp)) == null) {
                    p = new DatePattern();
                    p.setSession(session);
                    p.setName("T\u00fdden " + dp);
                    p.setOffset(fullTerm.nextSetBit(0) - weekCode.nextSetBit(0));
                    p.setDatePatternType(DatePattern.DatePatternType.Extended);
                    p.setVisible(true);
                    pattern = "";
                    for (j = weekCode.nextSetBit(0); j < weekCode.length(); ++j) {
                        pattern = pattern + (weekCode.get(j) ? "1" : "0");
                    }
                    p.setPattern(pattern);
                    hibSession.saveOrUpdate((Object)p);
                    continue;
                }
                pattern = "";
                for (j = weekCode.nextSetBit(0); j < weekCode.length(); ++j) {
                    pattern = pattern + (weekCode.get(j) ? "1" : "0");
                }
                p.setOffset(fullTerm.nextSetBit(0) - weekCode.nextSetBit(0));
                p.setPattern(pattern);
                p.setDatePatternType(DatePattern.DatePatternType.Extended);
                p.setVisible(true);
                hibSession.saveOrUpdate((Object)p);
            }
            hibSession.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

