/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.security;

import org.hibernate.Session;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.unitime.timetable.model.User;
import org.unitime.timetable.model.dao.UserDAO;
import org.unitime.timetable.security.context.UniTimeUserContext;

@Service(value="unitimeUserDetailsService")
public class UniTimeUserDetailService
implements UserDetailsService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        try (Session hibSession = UserDAO.getInstance().createNewSession();){
            User user = (User)hibSession.createQuery("from User where username=:userName").setString("userName", username).setMaxResults(1).uniqueResult();
            if (user == null) {
                throw new UsernameNotFoundException("User " + username + " is not known.");
            }
            UniTimeUserContext uniTimeUserContext = new UniTimeUserContext(user.getExternalUniqueId(), user.getUsername(), null, user.getPassword());
            return uniTimeUserContext;
        }
    }
}

