/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.security;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalUidTranslation;
import org.unitime.timetable.security.context.UniTimeUserContext;

@Service(value="unitimeAuthenticationUserDetailsService")
public class UniTimeAuthenticationUserDetailsService
implements AuthenticationUserDetailsService<CasAssertionAuthenticationToken> {
    private ExternalUidTranslation iTranslation = null;

    public UniTimeAuthenticationUserDetailsService() {
        if (ApplicationProperty.ExternalUserIdTranslation.value() != null) {
            try {
                this.iTranslation = (ExternalUidTranslation)Class.forName(ApplicationProperty.ExternalUserIdTranslation.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Debug.error("Unable to instantiate external uid translation class, " + e.getMessage());
            }
        }
    }

    public UserDetails loadUserDetails(CasAssertionAuthenticationToken token) throws UsernameNotFoundException {
        Object value;
        Assertion assertion = token.getAssertion();
        Map attributes = assertion.getPrincipal().getAttributes();
        String userId = token.getName();
        if (ApplicationProperty.AuthenticationCasIdAttribute.value() != null) {
            String[] keys = ApplicationProperty.AuthenticationCasIdAttribute.value().split(",");
            String[] translate = ApplicationProperty.AuthenticationCasIdAlwaysTranslate.value().split(",");
            boolean found = false;
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String tr = translate[i < translate.length ? i : translate.length - 1];
                Object value2 = attributes.get(key);
                if (value2 == null) continue;
                if (value2 instanceof List) {
                    Iterator iterator = ((List)value2).iterator();
                    if (iterator.hasNext()) {
                        Object o = iterator.next();
                        userId = o.toString();
                    }
                } else {
                    userId = value2.toString();
                }
                if ("true".equalsIgnoreCase(tr) && this.iTranslation != null) {
                    userId = this.iTranslation.translate(userId, ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User);
                }
                found = true;
                break;
            }
            if (!found && this.iTranslation != null) {
                userId = this.iTranslation.translate(userId, ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User);
            }
        } else if (this.iTranslation != null) {
            userId = this.iTranslation.translate(userId, ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User);
        }
        String name = null;
        if (ApplicationProperty.AuthenticationCasNameAttribute.value() != null && (value = attributes.get(ApplicationProperty.AuthenticationCasNameAttribute.value())) != null) {
            if (value instanceof List) {
                Iterator iterator = ((List)value).iterator();
                if (iterator.hasNext()) {
                    Object o = iterator.next();
                    name = o.toString();
                }
            } else {
                name = value.toString();
            }
        }
        if (ApplicationProperty.AuthenticationCasIdTrimLeadingZerosFrom.isTrue()) {
            while (userId.startsWith("0")) {
                userId = userId.substring(1);
            }
        }
        return new UniTimeUserContext(userId, token.getName(), name, null);
    }
}

