/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.ldap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalUidTranslation;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

public class SpringLdapExternalUidTranslation
implements ExternalUidTranslation {
    private static Log sLog = LogFactory.getLog(SpringLdapExternalUidTranslation.class);

    @Override
    public String translate(String uid, ExternalUidTranslation.Source source, ExternalUidTranslation.Source target) {
        if (uid == null || source.equals((Object)target)) {
            return uid;
        }
        if (source.equals((Object)ExternalUidTranslation.Source.LDAP)) {
            return this.uid2ext(uid);
        }
        if (target.equals((Object)ExternalUidTranslation.Source.LDAP)) {
            return this.ext2uid(uid);
        }
        return uid;
    }

    public String uid2ext(String uid) {
        String externalIdAttribute = ApplicationProperty.AuthenticationLdapIdAttribute.value();
        if ("uid".equals(externalIdAttribute)) {
            return uid;
        }
        try {
            ContextSource source = (ContextSource)SpringApplicationContextHolder.getBean("unitimeLdapContextSource");
            String query = ApplicationProperty.AuthenticationLdapLogin2UserId.value();
            SpringSecurityLdapTemplate template = new SpringSecurityLdapTemplate(source);
            DirContextOperations user = template.retrieveEntry(query.replaceAll("\\{0\\}", uid), new String[]{externalIdAttribute});
            return user == null ? null : user.getStringAttribute(externalIdAttribute);
        }
        catch (Exception e) {
            sLog.warn((Object)("Unable to translate uid to " + externalIdAttribute + ": " + e.getMessage()));
            return null;
        }
    }

    public String ext2uid(String externalUserId) {
        String externalIdAttribute = ApplicationProperty.AuthenticationLdapIdAttribute.value();
        if ("uid".equals(externalIdAttribute)) {
            return externalUserId;
        }
        try {
            ContextSource source = (ContextSource)SpringApplicationContextHolder.getBean("unitimeLdapContextSource");
            String query = ApplicationProperty.AuthenticationLdapUserId2Login.value().replace("%", externalIdAttribute);
            SpringSecurityLdapTemplate template = new SpringSecurityLdapTemplate(source);
            DirContextOperations user = template.retrieveEntry(query.replaceAll("\\{0\\}", externalIdAttribute), new String[]{"uid"});
            return user == null ? null : user.getStringAttribute("uid");
        }
        catch (Exception e) {
            sLog.warn((Object)("Unable to translate " + externalIdAttribute + " to uid: " + e.getMessage()));
            return null;
        }
    }
}

