/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DistanceMetric;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;

public class PerturbationReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashSet iGroups = new HashSet();

    public PerturbationReport(Solver solver) {
        Assignment assignment = solver.currentSolution().getAssignment();
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        for (Lecture lecture : model.perturbVariables(assignment)) {
            Placement placement = (Placement)assignment.getValue((Variable)lecture);
            Placement initial = (Placement)lecture.getInitialAssignment();
            if (placement == null || initial == null || placement.equals((Object)initial)) continue;
            this.iGroups.add(new PerturbationGroup(solver, lecture));
        }
    }

    public Set getGroups() {
        return this.iGroups;
    }

    public class PerturbationGroup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ClassAssignmentDetails iDetail = null;
        public long affectedStudents = 0L;
        public int affectedInstructors = 0;
        public long affectedStudentsByTime = 0L;
        public int affectedInstructorsByTime = 0;
        public int differentRoom = 0;
        public int affectedInstructorsByRoom = 0;
        public long affectedStudentsByRoom = 0L;
        public int differentBuilding = 0;
        public int affectedInstructorsByBldg = 0;
        public long affectedStudentsByBldg = 0L;
        public int deltaRoomPreferences = 0;
        public int differentTime = 0;
        public int differentDay = 0;
        public int differentHour = 0;
        public int tooFarForInstructors = 0;
        public int tooFarForStudents = 0;
        public int deltaStudentConflicts = 0;
        public int newStudentConflicts = 0;
        public double deltaTimePreferences = 0.0;
        public int deltaInstructorDistancePreferences = 0;
        public double distance = 0.0;

        public PerturbationGroup(Solver solver, Lecture lecture) {
            Assignment assignment = solver.currentSolution().getAssignment();
            Placement assignedPlacement = (Placement)assignment.getValue((Variable)lecture);
            Placement initialPlacement = (Placement)lecture.getInitialAssignment();
            this.iDetail = new ClassAssignmentDetails(solver, lecture, initialPlacement, false);
            this.iDetail.setAssigned(new AssignmentPreferenceInfo(solver, assignedPlacement, false), assignedPlacement.getRoomIds(), assignedPlacement.getTimeLocation().getDayCode(), assignedPlacement.getTimeLocation().getStartSlot(), assignedPlacement.getTimeLocation().getTimePatternId(), assignedPlacement.getTimeLocation().getDatePatternId());
            this.affectedStudents = lecture.classLimit(assignment);
            this.affectedInstructors = lecture.getInstructorConstraints().size();
            this.affectedStudentsByTime = initialPlacement.getTimeLocation().equals((Object)assignedPlacement.getTimeLocation()) ? 0 : lecture.classLimit(assignment);
            this.affectedInstructorsByTime = initialPlacement.getTimeLocation().equals((Object)assignedPlacement.getTimeLocation()) ? 0 : lecture.getInstructorConstraints().size();
            this.differentRoom = initialPlacement.nrDifferentRooms(assignedPlacement);
            this.affectedInstructorsByRoom = this.differentRoom * lecture.getInstructorConstraints().size();
            this.affectedStudentsByRoom = this.differentRoom * lecture.classLimit(assignment);
            this.differentBuilding = initialPlacement.nrDifferentBuildings(assignedPlacement);
            this.affectedInstructorsByBldg = this.differentBuilding * lecture.getInstructorConstraints().size();
            this.affectedStudentsByBldg = this.differentBuilding * lecture.classLimit(assignment);
            this.deltaRoomPreferences = assignedPlacement.sumRoomPreference() - initialPlacement.sumRoomPreference();
            this.differentTime = initialPlacement.getTimeLocation().equals((Object)assignedPlacement.getTimeLocation()) ? 0 : 1;
            this.differentDay = initialPlacement.getTimeLocation().getDayCode() != assignedPlacement.getTimeLocation().getDayCode() ? 1 : 0;
            this.differentHour = initialPlacement.getTimeLocation().getStartSlot() != assignedPlacement.getTimeLocation().getStartSlot() ? 1 : 0;
            this.deltaStudentConflicts = lecture.countStudentConflicts(assignment, assignedPlacement) - lecture.countInitialStudentConflicts();
            this.deltaTimePreferences = assignedPlacement.getTimeLocation().getNormalizedPreference() - initialPlacement.getTimeLocation().getNormalizedPreference();
            DistanceMetric m = ((TimetableModel)lecture.getModel()).getDistanceMetric();
            this.distance = Placement.getDistanceInMeters((DistanceMetric)m, (Placement)initialPlacement, (Placement)assignedPlacement);
            if (!lecture.getInstructorConstraints().isEmpty()) {
                if (this.distance > m.getInstructorNoPreferenceLimit() && this.distance <= m.getInstructorDiscouragedLimit()) {
                    this.tooFarForInstructors += PreferenceLevel.sIntLevelDiscouraged;
                } else if (this.distance > m.getInstructorDiscouragedLimit() && this.distance <= m.getInstructorProhibitedLimit()) {
                    this.tooFarForInstructors += PreferenceLevel.sIntLevelStronglyDiscouraged;
                } else if (this.distance > m.getInstructorProhibitedLimit()) {
                    this.tooFarForInstructors += PreferenceLevel.sIntLevelProhibited;
                }
            }
            if (this.distance > m.minutes2meters(10)) {
                this.tooFarForStudents = lecture.classLimit(assignment);
            }
            Set newStudentConflictsVect = lecture.conflictStudents(assignment, assignedPlacement);
            Set initialStudentConflicts = lecture.initialStudentConflicts();
            Iterator e = newStudentConflictsVect.iterator();
            while (e.hasNext()) {
                if (initialStudentConflicts.contains(e.next())) continue;
                ++this.newStudentConflicts;
            }
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                for (Lecture lect : ic.variables()) {
                    if (lect.equals((Object)lecture)) continue;
                    int initialPreference = lect.getInitialAssignment() == null ? PreferenceLevel.sIntLevelNeutral : ic.getDistancePreference(initialPlacement, (Placement)lect.getInitialAssignment());
                    int assignedPreference = assignment.getValue((Variable)lect) == null ? PreferenceLevel.sIntLevelNeutral : ic.getDistancePreference(assignedPlacement, (Placement)assignment.getValue((Variable)lect));
                    this.deltaInstructorDistancePreferences += assignedPreference - initialPreference;
                }
            }
        }

        public ClassAssignmentDetails getClazz() {
            return this.iDetail;
        }
    }
}

