/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.criteria.additional.InstructorLunchBreak;
import org.cpsolver.coursett.criteria.additional.InstructorStudentConflict;
import org.cpsolver.coursett.criteria.additional.InstructorStudentHardConflict;
import org.cpsolver.coursett.criteria.additional.RoomSizePenalty;
import org.cpsolver.coursett.custom.DeterministicStudentSectioning;
import org.cpsolver.coursett.heuristics.FixCompleteSolutionNeighbourSelection;
import org.cpsolver.coursett.model.DefaultStudentSectioning;
import org.cpsolver.coursett.sectioning.SctSectioning;
import org.cpsolver.coursett.sectioning.StudentSwapSectioning;
import org.cpsolver.ifs.algorithms.SimpleSearch;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.SearchIntensification;
import org.cpsolver.ifs.extension.ViolatedInitials;
import org.cpsolver.ifs.util.DataProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseSolverParameterDef;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.jgroups.RemoteSolver;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.service.ProxyHolder;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;

@Service(value="courseTimetablingSolverService")
public class CourseTimetablingSolverService
implements SolverService<SolverProxy> {
    protected static Log sLog = LogFactory.getLog(CourseTimetablingSolverService.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverServerService solverServerService;

    public SolverProxy getSolver(String puid, Long sessionId) {
        try {
            SolverProxy proxy = this.solverServerService.getCourseSolverContainer().getSolver(puid);
            if (proxy == null) {
                return null;
            }
            if (sessionId != null && !sessionId.equals(proxy.getProperties().getPropertyLong("General.SessionId", null))) {
                return null;
            }
            return proxy;
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to retrieve solver, reason:" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public SolverProxy getSolver() {
        SolverProxy solver;
        ProxyHolder h = (ProxyHolder)this.sessionContext.getAttribute(SessionAttribute.CourseTimetablingSolver);
        SolverProxy solverProxy = solver = h != null && h.isValid() ? (SolverProxy)h.getProxy() : null;
        if (solver != null) {
            try {
                if (solver instanceof RemoteSolver && ((RemoteSolver)((Object)solver)).exists()) {
                    return solver;
                }
                this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingSolver);
            }
            catch (Exception e) {
                this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingSolver);
            }
        }
        if (!this.sessionContext.isAuthenticated()) {
            return null;
        }
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        if (sessionId == null) {
            return null;
        }
        String puid = (String)this.sessionContext.getAttribute(SessionAttribute.CourseTimetablingUser);
        if (puid != null && (solver = this.getSolver(puid, sessionId)) != null) {
            this.sessionContext.setAttribute(SessionAttribute.CourseTimetablingSolver, new ProxyHolder<String, SolverProxy>(puid, solver));
            return solver;
        }
        solver = this.getSolver(this.sessionContext.getUser().getExternalUserId(), sessionId);
        if (solver != null) {
            this.sessionContext.setAttribute(SessionAttribute.CourseTimetablingSolver, new ProxyHolder<String, SolverProxy>(this.sessionContext.getUser().getExternalUserId(), solver));
        }
        return solver;
    }

    @Override
    public SolverProxy getSolverNoSessionCheck() {
        SolverProxy solver;
        if (!this.sessionContext.isAuthenticated()) {
            return null;
        }
        String puid = (String)this.sessionContext.getAttribute(SessionAttribute.CourseTimetablingUser);
        if (puid != null && (solver = this.getSolver(puid, null)) != null) {
            return solver;
        }
        return this.getSolver(this.sessionContext.getUser().getExternalUserId(), null);
    }

    @Override
    public void removeSolver() {
        try {
            this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingSolver);
            this.sessionContext.removeAttribute("Suggestions.model");
            SolverProxy solver = this.getSolverNoSessionCheck();
            if (solver != null) {
                solver.interrupt();
                solver.dispose();
            }
            this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingUser);
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to remove a solver: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public DataProperties createConfig(Long settingsId, Map<Long, String> options) {
        String mode;
        DataProperties properties = new DataProperties();
        for (Object def : SolverPredefinedSettingDAO.getInstance().getSession().createQuery("from SolverParameterDef where group.type = :type").setInteger("type", SolverParameterGroup.SolverType.COURSE.ordinal()).list()) {
            if (((SolverParameterDef)def).getDefault() != null) {
                properties.put((Object)((BaseSolverParameterDef)def).getName(), (Object)((SolverParameterDef)def).getDefault());
            }
            if (options == null || !options.containsKey(((BaseSolverParameterDef)def).getUniqueId())) continue;
            properties.put((Object)((BaseSolverParameterDef)def).getName(), (Object)options.get(((BaseSolverParameterDef)def).getUniqueId()));
        }
        SolverPredefinedSetting settings = (SolverPredefinedSetting)SolverPredefinedSettingDAO.getInstance().get(settingsId);
        for (SolverParameter param : settings.getParameters()) {
            if (!param.getDefinition().isVisible().booleanValue() || param.getDefinition().getGroup().getSolverType() != SolverParameterGroup.SolverType.COURSE) continue;
            properties.put((Object)param.getDefinition().getName(), (Object)param.getValue());
            if (options == null || !options.containsKey(param.getDefinition().getUniqueId())) continue;
            properties.put((Object)param.getDefinition().getName(), (Object)options.get(param.getDefinition().getUniqueId()));
        }
        properties.setProperty("General.SettingsId", settings.getUniqueId().toString());
        String algorithm = properties.getProperty("General.SearchAlgorithm", "Default");
        if ("Experimental".equalsIgnoreCase(algorithm) || "Deluge".equalsIgnoreCase(algorithm) || "GD".equalsIgnoreCase(algorithm) || "SA".equalsIgnoreCase(algorithm) || "Annealing".equalsIgnoreCase(algorithm)) {
            properties.setProperty("Neighbour.Class", SimpleSearch.class.getName());
            properties.setProperty("General.SearchIntensification", "false");
            properties.setProperty("General.CompleteSolutionFixInterval", "-1");
            properties.setProperty("General.IncompleteSolutionFixInterval", "-1");
            if ("Deluge".equalsIgnoreCase(algorithm) || "GD".equalsIgnoreCase(algorithm)) {
                properties.setProperty("Search.GreatDeluge", "true");
            } else if ("SA".equalsIgnoreCase(algorithm) || "Annealing".equalsIgnoreCase(algorithm)) {
                properties.setProperty("Search.GreatDeluge", "false");
            }
        } else if ("Default".equals(algorithm) || "Legacy".equals(algorithm) || "IFS".equals(algorithm)) {
            properties.setProperty("Neighbour.Class", FixCompleteSolutionNeighbourSelection.class.getName());
        }
        String ext = properties.getProperty("Extensions.Classes", "");
        if (properties.getPropertyBoolean("General.SearchIntensification", true)) {
            if (!ext.isEmpty()) {
                ext = ext + ";";
            }
            ext = ext + SearchIntensification.class.getName();
        }
        if (properties.getPropertyBoolean("General.CBS", true)) {
            if (!ext.isEmpty()) {
                ext = ext + ";";
            }
            ext = ext + ConflictStatistics.class.getName();
        }
        if ("MPP".equals(mode = properties.getProperty("Basic.Mode", "Initial"))) {
            properties.setProperty("General.MPP", "true");
            if (!ext.isEmpty()) {
                ext = ext + ";";
            }
            ext = ext + ViolatedInitials.class.getName();
        }
        properties.setProperty("Extensions.Classes", ext);
        if (properties.getPropertyBoolean("Basic.DisobeyHard", false)) {
            properties.setProperty("General.InteractiveMode", "true");
        }
        if ("No Action".equals(properties.getProperty("Basic.WhenFinished"))) {
            properties.setProperty("General.Save", "false");
            properties.setProperty("General.CreateNewSolution", "false");
            properties.setProperty("General.Unload", "false");
        } else if ("Save".equals(properties.getProperty("Basic.WhenFinished"))) {
            properties.setProperty("General.Save", "true");
            properties.setProperty("General.CreateNewSolution", "false");
            properties.setProperty("General.Unload", "false");
        } else if ("Save as New".equals(properties.getProperty("Basic.WhenFinished"))) {
            properties.setProperty("General.Save", "true");
            properties.setProperty("General.CreateNewSolution", "true");
            properties.setProperty("General.Unload", "false");
        } else if ("Save and Unload".equals(properties.getProperty("Basic.WhenFinished"))) {
            properties.setProperty("General.Save", "true");
            properties.setProperty("General.CreateNewSolution", "false");
            properties.setProperty("General.Unload", "true");
        } else if ("Save as New and Unload".equals(properties.getProperty("Basic.WhenFinished"))) {
            properties.setProperty("General.Save", "true");
            properties.setProperty("General.CreateNewSolution", "true");
            properties.setProperty("General.Unload", "true");
        }
        properties.setProperty("Xml.ShowNames", "true");
        properties.setProperty("Xml.ExportStudentSectioning", "true");
        if (properties.getProperty("Distances.Ellipsoid") == null || properties.getProperty("Distances.Ellipsoid").equals("DEFAULT")) {
            properties.setProperty("Distances.Ellipsoid", ApplicationProperties.getProperty(ApplicationProperty.DistanceEllipsoid));
        }
        if (properties.getPropertyBoolean("Global.LoadStudentInstructorConflicts", false)) {
            properties.setProperty("General.AdditionalCriteria", properties.getProperty("General.AdditionalCriteria") + ";" + InstructorStudentConflict.class.getName() + ";" + InstructorStudentHardConflict.class.getName());
        }
        if (properties.getPropertyBoolean("InstructorLunch.Enabled", false)) {
            properties.setProperty("General.AdditionalCriteria", properties.getProperty("General.AdditionalCriteria") + ";" + InstructorLunchBreak.class.getName());
        }
        if (properties.getPropertyDouble("Comparator.RoomSizeWeight", 0.0) != 0.0) {
            properties.setProperty("General.AdditionalCriteria", properties.getProperty("General.AdditionalCriteria") + ";" + RoomSizePenalty.class.getName());
        }
        if (properties.getPropertyBoolean("General.DeterministicStudentSectioning", false)) {
            properties.setProperty("StudentSectioning.Class", DeterministicStudentSectioning.class.getName());
        } else if ("Deterministic".equalsIgnoreCase(properties.getProperty("General.StudentSectioning"))) {
            properties.setProperty("StudentSectioning.Class", DeterministicStudentSectioning.class.getName());
        } else if ("Branch & Bound".equalsIgnoreCase(properties.getProperty("General.StudentSectioning"))) {
            properties.setProperty("StudentSectioning.Class", SctSectioning.class.getName());
            properties.setProperty("SctSectioning.GroupFirst", "false");
        } else if ("Local-Search".equalsIgnoreCase(properties.getProperty("General.StudentSectioning")) || "Local Search".equalsIgnoreCase(properties.getProperty("General.StudentSectioning"))) {
            properties.setProperty("StudentSectioning.Class", StudentSwapSectioning.class.getName());
        } else if ("B&B Groups".equalsIgnoreCase(properties.getProperty("General.StudentSectioning"))) {
            properties.setProperty("StudentSectioning.Class", SctSectioning.class.getName());
            properties.setProperty("SctSectioning.GroupFirst", "true");
        } else if ("Legacy".equalsIgnoreCase(properties.getProperty("General.StudentSectioning")) || "Default".equalsIgnoreCase(properties.getProperty("General.StudentSectioning"))) {
            properties.setProperty("StudentSectioning.Class", DefaultStudentSectioning.class.getName());
        }
        if (properties.getProperty("Parallel.NrSolvers") == null) {
            properties.setProperty("Parallel.NrSolvers", String.valueOf(Math.max(1, Runtime.getRuntime().availableProcessors() / 2)));
        }
        if (properties.getPropertyBoolean("OnFlySectioning.Enabled", false)) {
            properties.setProperty("Parallel.NrSolvers", "1");
        }
        properties.setProperty("General.UseAmPm", CONSTANTS.useAmPm() ? "true" : "false");
        properties.expand();
        return properties;
    }

    private String getSolverWarning(DataProperties config) {
        String warn = "";
        int maxDistPriority = Integer.MIN_VALUE;
        int nrWarns = 0;
        Long sessionId = config.getPropertyLong("General.SessionId", null);
        Long[] solverGroupIds = config.getPropertyLongArry("General.SolverGroupId", null);
        HashSet<SolverGroup> solverGroups = new HashSet<SolverGroup>();
        for (Long solverGroupId : solverGroupIds) {
            SolverGroup sg = (SolverGroup)SolverGroupDAO.getInstance().get(solverGroupId);
            if (!sg.getSession().getUniqueId().equals(sessionId)) continue;
            maxDistPriority = Math.max(maxDistPriority, sg.getMaxDistributionPriority());
            solverGroups.add(sg);
        }
        for (SolverGroup sg : SolverGroup.findBySessionId(sessionId)) {
            if (solverGroups.contains(sg)) continue;
            if (sg.getMinDistributionPriority() < maxDistPriority && sg.getCommittedSolution() == null) {
                if (nrWarns > 0) {
                    warn = warn + "<BR>";
                }
                ArrayList<String> subjects = new ArrayList<String>();
                boolean dept = false;
                for (Department d : sg.getDepartments()) {
                    if (d.isExternalManager().booleanValue()) {
                        subjects.add(d.getExternalMgrAbbv());
                        continue;
                    }
                    dept = true;
                    for (SubjectArea sa : d.getSubjectAreas()) {
                        subjects.add(sa.getSubjectAreaAbbreviation());
                    }
                }
                warn = dept ? warn + MESSAGES.warnSolverNoCommittedSolutionDepartmental(sg.getAbbv(), SolverPageBackend.toString(subjects)) : warn + MESSAGES.warnSolverNoCommittedSolutionExternal(sg.getAbbv(), SolverPageBackend.toString(subjects));
                ++nrWarns;
            }
            if (nrWarns < 3) continue;
            warn = warn + "<BR>...";
            break;
        }
        return warn.isEmpty() ? null : warn;
    }

    @Override
    public SolverProxy createSolver(DataProperties properties) {
        try {
            if (!this.sessionContext.isAuthenticated() || this.sessionContext.getUser().getCurrentAcademicSessionId() == null) {
                return null;
            }
            this.removeSolver();
            properties.setProperty("General.SessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().toString());
            properties.setProperty("General.OwnerPuid", this.sessionContext.getUser().getExternalUserId());
            properties.setProperty("General.StartTime", String.valueOf(new Date().getTime()));
            String host = properties.getProperty("General.Host");
            String warn = this.getSolverWarning(properties);
            if (warn != null) {
                properties.setProperty("General.SolverWarnings", warn);
            } else {
                properties.remove((Object)"General.SolverWarnings");
            }
            String instructorFormat = this.sessionContext.getUser().getProperty(UserProperty.NameFormat);
            if (instructorFormat != null) {
                properties.setProperty("General.InstructorFormat", instructorFormat);
            }
            SolverProxy solver = this.solverServerService.createCourseSolver(host, this.sessionContext.getUser().getExternalUserId(), properties);
            solver.load(properties);
            return solver;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to start the solver: " + e.getMessage()), (Throwable)e);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    @Override
    public SolverProxy reload(DataProperties properties) {
        try {
            SolverProxy solver = this.getSolver();
            if (solver == null) {
                return this.createSolver(properties);
            }
            DataProperties oldProperties = solver.getProperties();
            properties.setProperty("General.SessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().toString());
            properties.setProperty("General.SolverGroupId", oldProperties.getProperty("General.SolverGroupId"));
            properties.setProperty("General.OwnerPuid", oldProperties.getProperty("General.OwnerPuid"));
            properties.setProperty("General.StartTime", String.valueOf(new Date().getTime()));
            String warn = this.getSolverWarning(properties);
            if (warn != null) {
                properties.setProperty("General.SolverWarnings", warn);
            } else {
                properties.remove((Object)"General.SolverWarnings");
            }
            String instructorFormat = this.sessionContext.getUser().getProperty(UserProperty.NameFormat);
            if (instructorFormat != null) {
                properties.setProperty("General.InstructorFormat", instructorFormat);
            }
            solver.reload(properties);
            return solver;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to reload the solver: " + e.getMessage()), (Throwable)e);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    @Override
    public Map<String, SolverProxy> getSolvers() {
        HashMap<String, SolverProxy> solvers = new HashMap<String, SolverProxy>();
        SolverContainer<SolverProxy> container = this.solverServerService.getCourseSolverContainer();
        for (String user : container.getSolvers()) {
            solvers.put(user, container.getSolver(user));
        }
        return solvers;
    }

    @Override
    public Map<String, SolverProxy> getLocalSolvers() {
        HashMap<String, SolverProxy> solvers = new HashMap<String, SolverProxy>();
        SolverContainer<SolverProxy> container = this.solverServerService.getLocalServer().getCourseSolverContainer();
        for (String user : container.getSolvers()) {
            solvers.put(user, container.getSolver(user));
        }
        return solvers;
    }
}

