/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.solver.SolverDisposeListener;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.remote.BackupFileFilter;
import org.unitime.timetable.solver.studentsct.StudentSolver;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.MemoryCounter;

public class StudentSolverContainer
implements SolverContainer<StudentSolverProxy> {
    private static Log sLog = LogFactory.getLog(StudentSolverContainer.class);
    protected Map<String, StudentSolver> iStudentSolvers = new Hashtable<String, StudentSolver>();
    private PassivationThread iPassivation = null;

    @Override
    public Set<String> getSolvers() {
        return new HashSet<String>(this.iStudentSolvers.keySet());
    }

    @Override
    public StudentSolverProxy getSolver(String user) {
        return this.iStudentSolvers.get(user);
    }

    @Override
    public long getMemUsage(String user) {
        StudentSolverProxy solver = this.getSolver(user);
        return solver == null ? 0L : new MemoryCounter().estimate(solver);
    }

    @Override
    public StudentSolverProxy createSolver(String user, DataProperties config) {
        StudentSolver solver = new StudentSolver(config, new SolverOnDispose(user));
        this.iStudentSolvers.put(user, solver);
        return solver;
    }

    @Override
    public void unloadSolver(String user) {
        StudentSolver solver = this.iStudentSolvers.get(user);
        if (solver != null) {
            solver.dispose();
        }
    }

    @Override
    public boolean hasSolver(String user) {
        return this.iStudentSolvers.containsKey(user);
    }

    @Override
    public int getUsage() {
        int ret = 0;
        for (StudentSolverProxy studentSolverProxy : this.iStudentSolvers.values()) {
            ++ret;
            if (!studentSolverProxy.isPassivated()) {
                ++ret;
            }
            try {
                if (!studentSolverProxy.isWorking()) continue;
                ++ret;
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    @Override
    public void start() {
        this.iPassivation = new PassivationThread(ApplicationProperties.getPassivationFolder());
        this.iPassivation.start();
        File folder = ApplicationProperties.getRestoreFolder();
        if (!folder.exists() || !folder.isDirectory()) {
            return;
        }
        BackupFileFilter filter = new BackupFileFilter(SolverParameterGroup.SolverType.STUDENT);
        File[] files = folder.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String user = filter.getUser(file);
            StudentSolver solver = new StudentSolver(new DataProperties(), new SolverOnDispose(user));
            if (!solver.restore(folder, user)) continue;
            if (ApplicationProperties.getPassivationFolder() != null) {
                solver.passivate(ApplicationProperties.getPassivationFolder(), user);
            }
            this.iStudentSolvers.put(user, solver);
        }
    }

    @Override
    public void stop() {
        File folder = ApplicationProperties.getRestoreFolder();
        if (folder.exists() && !folder.isDirectory()) {
            return;
        }
        folder.mkdirs();
        File[] old = folder.listFiles(new BackupFileFilter(SolverParameterGroup.SolverType.STUDENT));
        for (int i = 0; i < old.length; ++i) {
            old[i].delete();
        }
        for (Map.Entry<String, StudentSolver> entry : this.iStudentSolvers.entrySet()) {
            entry.getValue().backup(folder, entry.getKey());
        }
        this.iPassivation.destroy();
    }

    private class PassivationThread
    extends Thread {
        private File iFolder = null;
        public long iDelay = 30000L;
        public boolean iContinue = true;

        public PassivationThread(File folder) {
            this.iFolder = folder;
            this.setName("Passivation[StudentSectioning]");
            this.setDaemon(true);
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                sLog.info((Object)"Solver passivation thread started.");
                while (this.iContinue) {
                    for (Map.Entry<String, StudentSolver> entry : StudentSolverContainer.this.iStudentSolvers.entrySet()) {
                        entry.getValue().passivateIfNeeded(this.iFolder, entry.getKey());
                    }
                    try {
                        PassivationThread.sleep(this.iDelay);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                sLog.info((Object)"Solver passivation thread finished.");
            }
            catch (Exception e) {
                sLog.warn((Object)("Solver passivation thread failed, reason: " + e.getMessage()), (Throwable)e);
            }
        }

        public void destroy() {
            this.iContinue = false;
            if (this.isAlive()) {
                this.interrupt();
            }
        }
    }

    protected class SolverOnDispose
    implements SolverDisposeListener {
        String iUser = null;

        public SolverOnDispose(String user) {
            this.iUser = user;
        }

        @Override
        public void onDispose() {
            StudentSolverContainer.this.iStudentSolvers.remove(this.iUser);
        }
    }
}

