/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.instructor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.ProblemSaver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.instructor.model.InstructorSchedulingModel;
import org.cpsolver.instructor.model.Section;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;
import org.hibernate.CacheMode;
import org.hibernate.Transaction;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalCourseOfferingEditAction;
import org.unitime.timetable.interfaces.ExternalInstrOfferingConfigAssignInstructorsAction;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.util.NameFormat;

public class InstructorSchedulingDatabaseSaver
extends ProblemSaver<TeachingRequest.Variable, TeachingAssignment, InstructorSchedulingModel> {
    private String iInstructorFormat;
    private Long iSessionId = null;
    private Set<Long> iSolverGroupId = new HashSet<Long>();
    private Set<InstrOfferingConfig> iUpdatedConfigs = new HashSet<InstrOfferingConfig>();
    private Set<InstructionalOffering> iUpdatedOfferings = new HashSet<InstructionalOffering>();
    private Progress iProgress = Progress.getInstance((Object)this.getModel());
    private boolean iTentative = true;
    private boolean iShowClassSuffix = false;
    private boolean iShowConfigName = false;

    public InstructorSchedulingDatabaseSaver(Solver solver) {
        super(solver);
        this.iSessionId = ((InstructorSchedulingModel)this.getModel()).getProperties().getPropertyLong("General.SessionId", (Long)null);
        for (Long id : ((InstructorSchedulingModel)this.getModel()).getProperties().getPropertyLongArry("General.SolverGroupId", null)) {
            this.iSolverGroupId.add(id);
        }
        this.iTentative = !((InstructorSchedulingModel)this.getModel()).getProperties().getPropertyBoolean("Save.Commit", false);
        this.iInstructorFormat = ((InstructorSchedulingModel)this.getModel()).getProperties().getProperty("General.InstructorFormat", NameFormat.LAST_FIRST.reference());
        this.iShowClassSuffix = ApplicationProperty.SolverShowClassSufix.isTrue();
        this.iShowConfigName = ApplicationProperty.SolverShowConfiguratioName.isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws Exception {
        ApplicationProperties.setSessionId(this.iSessionId);
        this.iProgress.setStatus("Saving solution ...");
        org.hibernate.Session hibSession = new _RootDAO().getSession();
        hibSession.setCacheMode(CacheMode.IGNORE);
        Transaction tx = null;
        try {
            Session session;
            String className;
            tx = hibSession.beginTransaction();
            this.saveSolution(hibSession);
            tx.commit();
            if (!this.iUpdatedConfigs.isEmpty() && (className = ApplicationProperty.ExternalActionInstrOfferingConfigAssignInstructors.value()) != null && className.trim().length() > 0) {
                ExternalInstrOfferingConfigAssignInstructorsAction assignAction = (ExternalInstrOfferingConfigAssignInstructorsAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.iProgress.setPhase("Performing external actions ...", (long)this.iUpdatedConfigs.size());
                for (InstrOfferingConfig ioc : this.iUpdatedConfigs) {
                    this.iProgress.incProgress();
                    assignAction.performExternalInstrOfferingConfigAssignInstructorsAction(ioc, hibSession);
                }
            }
            if (!this.iUpdatedOfferings.isEmpty() && (className = ApplicationProperty.ExternalActionCourseOfferingEdit.value()) != null && className.trim().length() > 0) {
                ExternalCourseOfferingEditAction editAction = (ExternalCourseOfferingEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.iProgress.setPhase("Performing external actions ...", (long)this.iUpdatedOfferings.size());
                for (InstructionalOffering io : this.iUpdatedOfferings) {
                    this.iProgress.incProgress();
                    editAction.performExternalCourseOfferingEditAction(io, hibSession);
                }
            }
            this.iProgress.setPhase("Refreshing solution ...", 1L);
            try {
                if (SolverServerImplementation.getInstance() != null) {
                    SolverServerImplementation.getInstance().refreshInstructorSolution(this.iSolverGroupId);
                }
                this.iProgress.incProgress();
            }
            catch (Exception e) {
                this.iProgress.warn("Unable to refresh solution, reason:" + e.getMessage(), (Throwable)e);
            }
            if (!(this.iUpdatedOfferings.isEmpty() && this.iUpdatedConfigs.isEmpty() || (session = (Session)SessionDAO.getInstance().get(this.iSessionId, hibSession)).getStatusType().isTestSession() || !session.getStatusType().canOnlineSectionStudents() && !session.getStatusType().canSectionAssistStudents())) {
                HashSet<Long> offeringIds = new HashSet<Long>();
                for (InstructionalOffering io : this.iUpdatedOfferings) {
                    offeringIds.add(io.getUniqueId());
                }
                for (InstrOfferingConfig config : this.iUpdatedConfigs) {
                    offeringIds.add(config.getInstructionalOffering().getUniqueId());
                }
                StudentSectioningQueue.offeringChanged(hibSession, null, this.iSessionId, offeringIds);
                hibSession.flush();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            this.iProgress.fatal("Unable to save a solution, reason: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (hibSession != null && hibSession.isOpen()) {
                hibSession.close();
            }
        }
    }

    protected String toHtml(Class_ clazz) {
        return "<A href='classDetail.action?cid=" + clazz.getUniqueId() + "'>" + clazz.getClassLabel(this.iShowClassSuffix, this.iShowConfigName) + "</A>";
    }

    protected String toHtml(DepartmentalInstructor instructor) {
        return "<a href='instructorDetail.action?instructorId=" + instructor.getUniqueId() + "&deptId=" + instructor.getDepartment().getUniqueId() + "'>" + instructor.getName(this.iInstructorFormat) + "</a>";
    }

    protected String toHtml(TeachingAssignment assignment) {
        return "<a href='instructorDetail.action?instructorId=" + assignment.getInstructor().getInstructorId() + "'>" + assignment.getInstructor().getName() + "</a>";
    }

    protected String toHtml(org.cpsolver.instructor.model.TeachingRequest request) {
        return "<a href='classDetail.action?cid=" + ((Section)request.getSections().get(0)).getSectionId() + "'>" + request.getCourse().getCourseName() + " " + request.getSections() + "</a>";
    }

    protected void saveSolution(org.hibernate.Session hibSession) {
        this.iProgress.setPhase("Loading instructors ...", 1L);
        HashMap<Long, DepartmentalInstructor> instructors = new HashMap<Long, DepartmentalInstructor>();
        HashSet<DepartmentalInstructor> changedInstructors = new HashSet<DepartmentalInstructor>();
        HashSet<InstructionalOffering> changedOfferings = new HashSet<InstructionalOffering>();
        for (DepartmentalInstructor instructor : hibSession.createQuery("select i from DepartmentalInstructor i, SolverGroup g inner join g.departments d where g.uniqueId in :solverGroupId and i.department = d").setParameterList("solverGroupId", this.iSolverGroupId).list()) {
            instructors.put(instructor.getUniqueId(), instructor);
            Iterator<ClassInstructor> i = instructor.getClasses().iterator();
            while (i.hasNext()) {
                ClassInstructor ci = i.next();
                if (ci.getTeachingRequest() == null) continue;
                this.iUpdatedConfigs.add(ci.getClassInstructing().getSchedulingSubpart().getInstrOfferingConfig());
                changedInstructors.add(ci.getInstructor());
                ci.getClassInstructing().getClassInstructors().remove(ci);
                i.remove();
                hibSession.delete((Object)ci);
            }
        }
        this.iProgress.incProgress();
        for (OfferingCoordinator coordinator : hibSession.createQuery("select c from OfferingCoordinator c inner join c.instructor i, SolverGroup g inner join g.departments d where g.uniqueId in :solverGroupId and i.department = d").setParameterList("solverGroupId", this.iSolverGroupId).list()) {
            if (coordinator.getTeachingRequest() == null) continue;
            this.iUpdatedOfferings.add(coordinator.getOffering());
            changedOfferings.add(coordinator.getOffering());
            coordinator.getOffering().getOfferingCoordinators().remove(coordinator);
            hibSession.delete((Object)coordinator);
        }
        this.iProgress.setPhase("Loading requests ...", 1L);
        HashMap<Long, TeachingRequest> requests = new HashMap<Long, TeachingRequest>();
        for (TeachingRequest request : hibSession.createQuery("select r from TeachingRequest r inner join r.offering.courseOfferings co where co.isControl = true and co.subjectArea.department.solverGroup.uniqueId in :solverGroupId").setParameterList("solverGroupId", this.iSolverGroupId).list()) {
            request.getAssignedInstructors().clear();
            requests.put(request.getUniqueId(), request);
        }
        this.iProgress.incProgress();
        this.iProgress.setPhase("Saving instructor assignments ...", (long)((InstructorSchedulingModel)this.getModel()).variables().size());
        for (TeachingRequest request : ((InstructorSchedulingModel)this.getModel()).variables()) {
            TeachingRequest r;
            DepartmentalInstructor instructor;
            this.iProgress.incProgress();
            TeachingAssignment assignment = (TeachingAssignment)this.getAssignment().getValue((Variable)request);
            if (assignment == null || (instructor = (DepartmentalInstructor)instructors.get(assignment.getInstructor().getInstructorId())) == null || (r = (TeachingRequest)requests.get(request.getRequest().getRequestId())) == null) continue;
            r.getAssignedInstructors().add(instructor);
            if (this.iTentative) continue;
            if (r.isAssignCoordinator().booleanValue()) {
                OfferingCoordinator oc = new OfferingCoordinator();
                oc.setInstructor(instructor);
                oc.setOffering(r.getOffering());
                oc.setResponsibility(r.getResponsibility());
                oc.setPercentShare(r.getPercentShare());
                oc.setTeachingRequest(r);
                r.getOffering().getOfferingCoordinators().add(oc);
                changedOfferings.add(r.getOffering());
                hibSession.save((Object)oc);
                this.iUpdatedOfferings.add(r.getOffering());
            }
            for (TeachingClassRequest cr : r.getClassRequests()) {
                if (!cr.isAssignInstructor().booleanValue()) continue;
                ClassInstructor ci = new ClassInstructor();
                ci.setClassInstructing(cr.getTeachingClass());
                ci.setInstructor(instructor);
                ci.setLead(cr.isLead());
                ci.setPercentShare(cr.getPercentShare());
                ci.setResponsibility(r.getResponsibility());
                ci.setTeachingRequest(r);
                cr.getTeachingClass().getClassInstructors().add(ci);
                instructor.getClasses().add(ci);
                changedInstructors.add(ci.getInstructor());
                hibSession.saveOrUpdate((Object)ci);
                this.iUpdatedConfigs.add(cr.getTeachingClass().getSchedulingSubpart().getInstrOfferingConfig());
            }
        }
        for (TeachingRequest request : requests.values()) {
            hibSession.saveOrUpdate((Object)request);
        }
        for (DepartmentalInstructor instructor : changedInstructors) {
            hibSession.saveOrUpdate((Object)instructor);
        }
        for (InstructionalOffering offering : changedOfferings) {
            hibSession.saveOrUpdate((Object)offering);
        }
    }
}

