/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula.students;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ModelWithContext;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.unitime.timetable.solver.curricula.students.CurCourse;
import org.unitime.timetable.solver.curricula.students.CurHillClimber;
import org.unitime.timetable.solver.curricula.students.CurSimpleMove;
import org.unitime.timetable.solver.curricula.students.CurStudent;
import org.unitime.timetable.solver.curricula.students.CurStudentLimit;
import org.unitime.timetable.solver.curricula.students.CurStudentSwap;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurValueSelection;
import org.unitime.timetable.solver.curricula.students.CurVariable;
import org.unitime.timetable.solver.curricula.students.CurVariableSelection;

public class CurModel
extends ModelWithContext<CurVariable, CurValue, CurModelContext> {
    private static Log sLog = LogFactory.getLog(CurModel.class);
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private List<CurStudent> iStudents = new ArrayList<CurStudent>();
    private Map<Long, CurCourse> iCourses = new Hashtable<Long, CurCourse>();
    private List<CurCourse> iSwapableCourses = new ArrayList<CurCourse>();
    private CurStudentLimit iStudentLimit = null;
    private double iMinStudentWeight = 3.4028234663852886E38;
    private double iMaxStudentWeight = 0.0;
    private double iTotalStudentWeight = 0.0;
    private double iBestAssignedWeight = 0.0;
    private double iMaxAssignedWeight = 0.0;

    public CurModel(Collection<CurStudent> students) {
        for (CurStudent student : students) {
            student.setModel(this);
        }
        this.iStudents.addAll(students);
        this.iStudentLimit = new CurStudentLimit(0, Integer.MAX_VALUE);
        for (CurStudent student : this.getStudents()) {
            this.iMinStudentWeight = Math.min(this.iMinStudentWeight, student.getWeight());
            this.iMaxStudentWeight = Math.max(this.iMaxStudentWeight, student.getWeight());
            this.iTotalStudentWeight += student.getWeight();
        }
    }

    public double getMinStudentWidth() {
        return this.iMinStudentWeight;
    }

    public double getMaxStudentWidth() {
        return this.iMaxStudentWeight;
    }

    public void addCourse(Long courseId, String courseName, double size, Double priority) {
        CurCourse course = new CurCourse(this, courseId, courseName, Math.min(this.iStudents.size(), (int)Math.round(size / this.getMinStudentWidth())), size, priority);
        this.iCourses.put(courseId, course);
        if (course.getNrStudents() < this.iStudents.size()) {
            this.iSwapableCourses.add(course);
        }
        this.iMaxAssignedWeight += course.getOriginalMaxSize();
    }

    public void setTargetShare(Long c1, Long c2, double share, boolean round) {
        CurCourse course1 = this.iCourses.get(c1);
        CurCourse course2 = this.iCourses.get(c2);
        double ub = Math.min(course1.getOriginalMaxSize(), course2.getOriginalMaxSize());
        double lb = Math.max(0.0, course1.getOriginalMaxSize() + course2.getOriginalMaxSize() - this.iTotalStudentWeight);
        double ts = Math.max(lb, Math.min(ub, share));
        if (ts != share) {
            sLog.debug((Object)("Target share between " + course1.getCourseName() + " and " + course2.getCourseName() + " changed to " + ts + " (was: " + share + ", lb:" + lb + ", ub:" + ub + ")"));
        }
        course1.setTargetShare(c2, round ? (double)Math.round(ts) : ts);
        course2.setTargetShare(c1, round ? (double)Math.round(ts) : ts);
    }

    protected void setTargetShareNoAdjustments(Long c1, Long c2, double share) {
        CurCourse course1 = this.iCourses.get(c1);
        CurCourse course2 = this.iCourses.get(c2);
        course1.setTargetShare(c2, share);
        course2.setTargetShare(c1, share);
    }

    public void setStudentLimits() {
        double nrStudentCourses = 0.0;
        for (CurCourse course : this.getCourses()) {
            nrStudentCourses += course.getOriginalMaxSize();
        }
        double studentWeight = 0.0;
        for (CurStudent student : this.getStudents()) {
            studentWeight += student.getWeight();
        }
        double avg = nrStudentCourses / studentWeight;
        int maxLimit = 1 + (int)Math.ceil(avg);
        int minLimit = (int)Math.floor(avg) - 1;
        sLog.debug((Object)("Student course limit <" + minLimit + "," + maxLimit + ">"));
        this.iStudentLimit = new CurStudentLimit(minLimit, maxLimit);
        this.addGlobalConstraint(this.iStudentLimit);
    }

    public CurStudentLimit getStudentLimit() {
        return this.iStudentLimit;
    }

    public Collection<CurCourse> getCourses() {
        return this.iCourses.values();
    }

    public CurCourse getCourse(Long courseId) {
        return this.iCourses.get(courseId);
    }

    public List<CurStudent> getStudents() {
        return this.iStudents;
    }

    public List<CurCourse> getSwapCourses() {
        return this.iSwapableCourses;
    }

    public Map<String, String> getInfo(Assignment<CurVariable, CurValue> assignment) {
        Map ret = super.getInfo(assignment);
        ret.put("Students", String.valueOf(this.getStudents().size()));
        ret.put("Courses", String.valueOf(this.getCourses().size()));
        double avgEnrollment = (double)this.variables().size() / (double)this.getCourses().size();
        double rmsEnrollment = 0.0;
        for (CurCourse curCourse : this.getCourses()) {
            rmsEnrollment += ((double)curCourse.getNrStudents() - avgEnrollment) * ((double)curCourse.getNrStudents() - avgEnrollment);
        }
        ret.put("Course size", sDF.format(avgEnrollment) + " \u00b1 " + sDF.format(Math.sqrt(rmsEnrollment / (double)this.getCourses().size())));
        int totalCourses = 0;
        for (CurStudent student : this.getStudents()) {
            totalCourses += student.getCourses(assignment).size();
        }
        double d = (double)totalCourses / (double)this.getStudents().size();
        double rmsCourses = 0.0;
        for (CurStudent student : this.getStudents()) {
            rmsCourses += ((double)student.getCourses(assignment).size() - d) * ((double)student.getCourses(assignment).size() - d);
        }
        ret.put("Courses per student", sDF.format(d) + " \u00b1 " + sDF.format(Math.sqrt(rmsCourses / (double)this.getStudents().size())) + " (limit: " + this.getStudentLimit().getMinLimit() + " .. " + this.getStudentLimit().getMaxLimit() + ")");
        int totalShare = 0;
        double totalError = 0.0;
        double rmsError = 0.0;
        int pairs = 0;
        for (CurCourse c1 : this.getCourses()) {
            for (CurCourse c2 : this.getCourses()) {
                if (c1.getCourseId() >= c2.getCourseId()) continue;
                double share = c1.share(assignment, c2);
                double target = c1.getTargetShare(c2.getCourseId());
                totalError += Math.abs(share - target);
                rmsError += (share - target) * (share - target);
                ++pairs;
                totalShare = (int)((double)totalShare + share);
            }
        }
        ret.put("Errors", sDF.format(totalError) + " (" + sDF.format(100.0 * totalError / (double)totalShare) + "% of total share, avg: " + sDF.format(totalError / (double)pairs) + ", rms: " + sDF.format(Math.sqrt(rmsError / (double)pairs)) + ")");
        ret.put("Assigned Student Weight", sDF.format(((CurModelContext)this.getContext(assignment)).getAssignedWeight()) + "/" + sDF.format(this.getMaxWeight()));
        double totalStudentWeight = 0.0;
        for (CurStudent student : this.getStudents()) {
            totalStudentWeight += student.getWeight();
        }
        double avgStudentWeight = totalStudentWeight / (double)this.getStudents().size();
        double rmsStudentWeight = 0.0;
        for (CurStudent student : this.getStudents()) {
            rmsStudentWeight += (student.getWeight() - avgStudentWeight) * (student.getWeight() - avgStudentWeight);
        }
        ret.put("Student Weight", sDF.format(this.getMinStudentWidth()) + " .. " + sDF.format(this.getMaxStudentWidth()) + " (avg: " + sDF.format(avgStudentWeight) + ", rms: " + sDF.format(Math.sqrt(rmsStudentWeight / (double)this.getStudents().size())) + ")");
        return ret;
    }

    public double getTotalValue(Assignment<CurVariable, CurValue> assignment) {
        double value = 0.0;
        for (CurCourse c1 : this.iCourses.values()) {
            for (CurCourse c2 : this.iCourses.values()) {
                if (c1.getCourseId() >= c2.getCourseId()) continue;
                value += c1.penalty(assignment, c2);
            }
        }
        return value;
    }

    public double getMaxWeight() {
        return this.iMaxAssignedWeight;
    }

    public double getBestWeight() {
        return this.iBestAssignedWeight;
    }

    public void saveBest(Assignment<CurVariable, CurValue> assignment) {
        super.saveBest(assignment);
        this.iBestAssignedWeight = ((CurModelContext)this.getContext(assignment)).getAssignedWeight();
    }

    public void clearBest() {
        super.clearBest();
        this.iBestAssignedWeight = 0.0;
    }

    public String toString(Assignment<CurVariable, CurValue> assignment) {
        return this.assignedVariables(assignment).size() + "/" + this.variables().size() + " V:" + sDF.format(this.getTotalValue(assignment)) + " A:" + sDF.format(((CurModelContext)this.getContext(assignment)).getAssignedWeight()) + "/" + sDF.format(this.getMaxWeight());
    }

    public void ifs(Assignment<CurVariable, CurValue> assignment) {
        DataProperties cfg = new DataProperties();
        cfg.setProperty("Termination.Class", "org.unitime.timetable.solver.curricula.students.CurTermination");
        cfg.setProperty("Termination.StopWhenComplete", "false");
        cfg.setProperty("Termination.TimeOut", "60");
        cfg.setProperty("Termination.MaxIdle", "1000");
        cfg.setProperty("Comparator.Class", "org.unitime.timetable.solver.curricula.students.CurComparator");
        cfg.setProperty("Variable.Class", "org.unitime.timetable.solver.curricula.students.CurVariableSelection");
        cfg.setProperty("Value.Class", "org.unitime.timetable.solver.curricula.students.CurValueSelection");
        cfg.setProperty("General.SaveBestUnassigned", "-1");
        Solver solver = new Solver(cfg);
        solver.setInitalSolution(new Solution((Model)this, assignment));
        solver.currentSolution().addSolutionListener((SolutionListener)new SolutionListener<CurVariable, CurValue>(){

            public void solutionUpdated(Solution<CurVariable, CurValue> solution) {
            }

            public void getInfo(Solution<CurVariable, CurValue> solution, Map<String, String> info, Collection<CurVariable> variables) {
            }

            public void getInfo(Solution<CurVariable, CurValue> solution, Map<String, String> info) {
            }

            public void bestSaved(Solution<CurVariable, CurValue> solution) {
                sLog.debug((Object)(((CurModel)solution.getModel()).toString((Assignment<CurVariable, CurValue>)solution.getAssignment()) + ", i:" + solution.getIteration()));
            }

            public void bestRestored(Solution<CurVariable, CurValue> solution) {
            }

            public void bestCleared(Solution<CurVariable, CurValue> solution) {
            }
        });
        solver.start();
        try {
            solver.getSolverThread().join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Solution solution = solver.lastSolution();
        solution.restoreBest();
        sLog.debug((Object)("Best solution found after " + solution.getBestTime() + " seconds (" + solution.getBestIteration() + " iterations)."));
        sLog.debug((Object)("Number of assigned variables is " + solution.getAssignment().nrAssignedVariables()));
        sLog.debug((Object)("Total value of the solution is " + solution.getModel().getTotalValue(solution.getAssignment())));
    }

    public void saveAsXml(Element root, Assignment<CurVariable, CurValue> assignment) {
        ArrayList<Long> courses = new ArrayList<Long>();
        DecimalFormat df = new DecimalFormat("0.##########", new DecimalFormatSymbols(Locale.US));
        for (CurCourse course : this.getCourses()) {
            Element courseElement = root.addElement("course");
            courseElement.addAttribute("id", course.getCourseId().toString());
            courseElement.addAttribute("name", course.getCourseName());
            courseElement.addAttribute("limit", df.format(course.getOriginalMaxSize()));
            if (course.getPriority() != null) {
                courseElement.addAttribute("priority", course.getPriority().toString());
            }
            if (!courses.isEmpty()) {
                String share = "";
                for (Long other : courses) {
                    share = share + (share.isEmpty() ? "" : ",") + df.format(course.getTargetShare(other));
                }
                courseElement.addAttribute("share", share);
            }
            courses.add(course.getCourseId());
        }
        for (CurStudent student : this.getStudents()) {
            Element studentElement = root.addElement("student");
            studentElement.addAttribute("id", student.getStudentId().toString());
            if (student.getWeight() != 1.0) {
                studentElement.addAttribute("weight", df.format(student.getWeight()));
            }
            String courseIds = "";
            for (CurCourse course : student.getCourses(assignment)) {
                courseIds = courseIds + (courseIds.isEmpty() ? "" : ",") + course.getCourseId();
            }
            studentElement.setText(courseIds);
        }
    }

    public static Solution<CurVariable, CurValue> loadFromXml(Element root) {
        List studentElements = root.elements("student");
        ArrayList<CurStudent> students = new ArrayList<CurStudent>();
        for (Element studentElement : studentElements) {
            students.add(new CurStudent(Long.valueOf(studentElement.attributeValue("id")), Float.parseFloat(studentElement.attributeValue("weight", "1.0"))));
        }
        CurModel m = new CurModel(students);
        DefaultSingleAssignment a = new DefaultSingleAssignment();
        ArrayList<Long> courses = new ArrayList<Long>();
        Iterator i = root.elementIterator("course");
        while (i.hasNext()) {
            Element courseElement = (Element)i.next();
            Long courseId = Long.valueOf(courseElement.attributeValue("id"));
            String courseName = courseElement.attributeValue("name");
            double size = Float.parseFloat(courseElement.attributeValue("limit"));
            String priority = courseElement.attributeValue("priority");
            m.addCourse(courseId, courseName, size, priority == null ? null : Double.valueOf(priority));
            if (!courses.isEmpty()) {
                String[] share = courseElement.attributeValue("share").split(",");
                for (int j = 0; j < courses.size(); ++j) {
                    m.setTargetShareNoAdjustments(courseId, (Long)courses.get(j), Float.parseFloat(share[j]));
                }
            }
            courses.add(courseId);
        }
        int idx = 0;
        for (Element studentElement : studentElements) {
            CurStudent student = (CurStudent)((Object)students.get(idx++));
            String courseIds = studentElement.getText();
            if (courseIds == null || courseIds.isEmpty()) continue;
            for (String courseId : courseIds.split(",")) {
                CurCourse course = m.getCourse(Long.valueOf(courseId));
                CurVariable var = null;
                for (CurVariable v : course.variables()) {
                    if (a.getValue((Variable)v) != null) continue;
                    var = v;
                    break;
                }
                a.assign(0L, (Value)new CurValue(var, student));
            }
        }
        return new Solution((Model)m, (Assignment)a);
    }

    protected boolean canContinue() {
        return !Thread.currentThread().isInterrupted();
    }

    public void naive(DataProperties cfg, Assignment<CurVariable, CurValue> assignment) {
        Neighbour<CurVariable, CurValue> n;
        int maxIdle = cfg.getPropertyInt("Curriculum.Naive.MaxIdle", 1000);
        sLog.debug((Object)"  -- running naive");
        int it = 0;
        double best = this.getTotalValue(assignment);
        CurStudentSwap sw = new CurStudentSwap(cfg);
        Solution solution = new Solution((Model)this, assignment);
        for (int idle = 0; !this.getSwapCourses().isEmpty() && idle < maxIdle && this.canContinue() && (n = sw.selectNeighbour((Solution<CurVariable, CurValue>)solution)) != null; ++idle) {
            double value = n.value(assignment);
            if (value < -1.0E-5) {
                idle = 0;
                n.assign(assignment, (long)it);
            } else if (value <= 0.0) {
                n.assign(assignment, (long)it);
            }
            if (this.getTotalValue(assignment) < best) {
                best = this.getTotalValue(assignment);
                sLog.debug((Object)("  -- best value: " + this.toString(assignment)));
            }
            ++it;
        }
        sLog.debug((Object)("  -- final value: " + this.toString(assignment)));
    }

    public void hc(DataProperties cfg, Assignment<CurVariable, CurValue> assignment) {
        Neighbour<CurVariable, CurValue> n;
        double total;
        int maxIdle = cfg.getPropertyInt("Curriculum.HC.MaxIdle", 1000);
        sLog.debug((Object)"  -- running hill climber");
        int it = 0;
        double best = total = this.getTotalValue(assignment);
        CurHillClimber hc = new CurHillClimber(cfg);
        Solution solution = new Solution((Model)this, assignment);
        for (int idle = 0; idle < maxIdle && total > 1.0E-4 && this.canContinue() && (n = hc.selectNeighbour((Solution<CurVariable, CurValue>)solution)) != null; ++idle) {
            double value = n.value(assignment);
            if (value <= 0.0) {
                n.assign(assignment, (long)it);
                total += value;
                if (best - total > 1.0E-5) {
                    best = total;
                    idle = 0;
                    this.saveBest(assignment);
                    sLog.debug((Object)("  -- best value: " + this.toString(assignment)));
                }
            }
            ++it;
        }
        sLog.debug((Object)("  -- final value: " + this.toString(assignment)));
    }

    public void deluge(DataProperties cfg, Assignment<CurVariable, CurValue> assignment) {
        double f = cfg.getPropertyDouble("Curriculum.Deluge.Factor", 0.999999);
        double ub = cfg.getPropertyDouble("Curriculum.Deluge.UpperBound", 1.25);
        double lb = cfg.getPropertyDouble("Curriculum.Deluge.LowerBound", 0.75);
        sLog.debug((Object)"  -- running great deluge");
        int it = 0;
        double total = this.getTotalValue(assignment);
        double bound = ub * total;
        double best = this.getTotalValue(assignment);
        CurStudentSwap sw = new CurStudentSwap(cfg);
        Solution solution = new Solution((Model)this, assignment);
        this.saveBest(assignment);
        while (!this.getSwapCourses().isEmpty() && bound > lb * total && total > 1.0E-4 && this.canContinue()) {
            double value;
            Neighbour<CurVariable, CurValue> n = sw.selectNeighbour((Solution<CurVariable, CurValue>)solution);
            if (n != null && ((value = n.value(assignment)) <= 0.0 || total + value < bound)) {
                n.assign(assignment, (long)it);
                if (total + value < best) {
                    best = total + value;
                    this.saveBest(assignment);
                    sLog.debug((Object)("  -- best value: " + this.toString(assignment) + ", bound: " + bound));
                }
                total += value;
            }
            bound *= f;
            ++it;
        }
        this.restoreBest(assignment);
        sLog.debug((Object)("  -- final value: " + this.toString(assignment)));
    }

    public void fast(DataProperties cfg, Assignment<CurVariable, CurValue> assignment) {
        double total;
        int maxIdle = cfg.getPropertyInt("Curriculum.Fast.MaxIdle", 1000);
        sLog.debug((Object)"  -- running fast");
        int it = 0;
        double best = total = this.getTotalValue(assignment);
        CurSimpleMove m = new CurSimpleMove(cfg);
        Solution solution = new Solution((Model)this, assignment);
        for (int idle = 0; idle < maxIdle && this.canContinue(); ++idle) {
            Neighbour<CurVariable, CurValue> n = m.selectNeighbour((Solution<CurVariable, CurValue>)solution);
            if (n != null) {
                double value = n.value(assignment);
                if (value < -1.0E-5) {
                    idle = 0;
                    n.assign(assignment, (long)it);
                    total += value;
                } else if (value <= 0.0) {
                    n.assign(assignment, (long)it);
                }
            }
            if (total < best) {
                best = total;
                sLog.debug((Object)("  -- best value: " + this.toString(assignment)));
            }
            ++it;
        }
        sLog.debug((Object)("  -- final value: " + this.toString(assignment)));
    }

    public DataProperties solve(Assignment<CurVariable, CurValue> assignment) {
        return this.solve(new DataProperties(), assignment);
    }

    public DataProperties solve(DataProperties cfg, Assignment<CurVariable, CurValue> assignment) {
        if (cfg == null) {
            cfg = new DataProperties();
        }
        sLog.debug((Object)"  -- setting up the solver");
        CurVariableSelection var = new CurVariableSelection(cfg);
        CurValueSelection vs = new CurValueSelection(cfg);
        Solution solution = new Solution((Model)this, assignment);
        sLog.debug((Object)"  -- creating initial assignment");
        boolean precise = cfg.getPropertyBoolean("Curriculum.Initial.PreciseSelection", true);
        while (this.nrUnassignedVariables(assignment) > 0 && this.canContinue()) {
            CurValue student;
            Variable course = var.selectVariable(solution);
            if (course.getCourse().isComplete(assignment)) {
                sLog.debug((Object)"    -- all complete");
                break;
            }
            CurValue curValue = student = precise ? vs.selectValueSlow((Solution<CurVariable, CurValue>)solution, (CurVariable)course) : vs.selectValueFast((Solution<CurVariable, CurValue>)solution, (CurVariable)course);
            if (student == null) {
                sLog.debug((Object)("    -- no student for " + course.getCourse().getCourseName()));
                break;
            }
            assignment.assign(solution.getIteration(), (Value)student);
        }
        for (CurCourse course : this.getCourses()) {
            if (course.isComplete(assignment)) continue;
            sLog.debug((Object)("    -- incomplete " + course.getCourseName() + ": " + this.getCourse(course.getCourseId()).getStudents(assignment) + " (" + course.getSize(assignment) + "/" + course.getOriginalMaxSize() + ")"));
        }
        sLog.debug((Object)("  -- initial value: " + this.toString(assignment)));
        for (String phase : cfg.getProperty("Curriculum.Phases", "HC,Deluge").split(",")) {
            if ("hc".equalsIgnoreCase(phase)) {
                this.hc(cfg, assignment);
                continue;
            }
            if ("fast".equalsIgnoreCase(phase)) {
                this.fast(cfg, assignment);
                continue;
            }
            if ("deluge".equalsIgnoreCase(phase)) {
                this.deluge(cfg, assignment);
                continue;
            }
            if ("naive".equalsIgnoreCase(phase)) {
                this.naive(cfg, assignment);
                continue;
            }
            sLog.warn((Object)("Phase " + phase + " is not known"));
        }
        return cfg;
    }

    public boolean isSameModel(Object o) {
        if (o == null || !(o instanceof CurModel)) {
            return false;
        }
        CurModel m = (CurModel)((Object)o);
        if (this.getStudents().size() != m.getStudents().size()) {
            return false;
        }
        if (this.getStudentLimit().getMaxLimit() != m.getStudentLimit().getMaxLimit()) {
            return false;
        }
        if (this.getStudentLimit().getMinLimit() != m.getStudentLimit().getMinLimit()) {
            return false;
        }
        if (this.getMinStudentWidth() != m.getMinStudentWidth()) {
            return false;
        }
        if (this.getCourses().size() != m.getCourses().size()) {
            return false;
        }
        block0: for (CurStudent s : this.getStudents()) {
            if (s.getStudentId() == null || s.getStudentId() < 0L) continue;
            for (CurStudent z : m.getStudents()) {
                if (!z.getStudentId().equals(s.getStudentId()) || z.getWeight() != s.getWeight()) continue;
                continue block0;
            }
            return false;
        }
        block2: for (CurStudent s : m.getStudents()) {
            if (s.getStudentId() == null || s.getStudentId() < 0L) continue;
            for (CurStudent z : this.getStudents()) {
                if (!z.getStudentId().equals(s.getStudentId()) || z.getWeight() != s.getWeight()) continue;
                continue block2;
            }
            return false;
        }
        for (int idx = 0; idx < this.getStudents().size(); ++idx) {
            CurStudent s;
            s = this.getStudents().get(idx);
            if (s.getStudentId() != null && s.getStudentId() >= 0L || s.getWeight() == m.getStudents().get(idx).getWeight()) continue;
            return false;
        }
        for (CurCourse c1 : this.getCourses()) {
            CurCourse x1 = m.getCourse(c1.getCourseId());
            if (x1 == null || x1.getNrStudents() != c1.getNrStudents() || !CurModel.equals(x1.getPriority(), c1.getPriority())) {
                return false;
            }
            for (CurCourse c2 : this.getCourses()) {
                if (c1.getCourseId() >= c2.getCourseId() || !(Math.abs(c1.getTargetShare(c2.getCourseId()) - x1.getTargetShare(c2.getCourseId())) > 0.001)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static void main(String[] args) {
        try {
            int i;
            Configurator.setRootLevel((Level)Level.DEBUG);
            ArrayList<CurStudent> students = new ArrayList<CurStudent>();
            for (int i2 = 0; i2 < 20; ++i2) {
                students.add(new CurStudent(Long.valueOf(1 + i2), i2 < 10 ? 0.5f : 2.0f));
            }
            CurModel m = new CurModel(students);
            for (i = 1; i <= 10; ++i) {
                m.addCourse(Long.valueOf(i), "C" + i, 2 * i, null);
            }
            for (i = 1; i < 10; ++i) {
                for (int j = i + 1; j <= 10; ++j) {
                    m.setTargetShare(Long.valueOf(i), Long.valueOf(j), i, false);
                }
            }
            m.setStudentLimits();
            Document d0 = DocumentHelper.createDocument();
            DefaultSingleAssignment a = new DefaultSingleAssignment();
            m.saveAsXml(d0.addElement("curriculum"), (Assignment<CurVariable, CurValue>)a);
            sLog.info((Object)d0.asXML());
            sLog.info((Object)("Loaded: " + ToolBox.dict2string(m.getInfo((Assignment<CurVariable, CurValue>)a), (int)2)));
            m.solve((Assignment<CurVariable, CurValue>)a);
            sLog.info((Object)("Solution: " + ToolBox.dict2string(m.getInfo((Assignment<CurVariable, CurValue>)a), (int)2)));
            Document d1 = DocumentHelper.createDocument();
            m.saveAsXml(d1.addElement("curriculum"), (Assignment<CurVariable, CurValue>)a);
            sLog.info((Object)d1.asXML());
            Solution<CurVariable, CurValue> x = CurModel.loadFromXml(d1.getRootElement());
            sLog.info((Object)("Reloaded: " + ToolBox.dict2string((Map)x.getInfo(), (int)2)));
            TreeSet<CurCourse> courses = new TreeSet<CurCourse>(new Comparator<CurCourse>(){

                @Override
                public int compare(CurCourse c1, CurCourse c2) {
                    int cmp = c1.getCourseName().compareTo(c2.getCourseName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return c1.getCourseId().compareTo(c2.getCourseId());
                }
            });
            courses.addAll(m.getCourses());
            int penalty = 0;
            for (CurCourse course : courses) {
                sLog.info((Object)(course.getCourseName() + ": " + m.getCourse(course.getCourseId()).getStudents((Assignment<CurVariable, CurValue>)a) + " (" + course.getSize((Assignment<CurVariable, CurValue>)a) + "/" + course.getOriginalMaxSize() + ")"));
                for (CurCourse other : courses) {
                    if (other.getCourseId() <= course.getCourseId()) continue;
                    double share = course.share((Assignment<CurVariable, CurValue>)a, other);
                    double target = course.getTargetShare(other.getCourseId());
                    sLog.info((Object)("  " + other.getCourseName() + ": share=" + share + ", target=" + target + ", penalty=" + Math.abs(target - share)));
                    penalty = (int)((double)penalty + Math.abs(target - share));
                }
            }
            sLog.info((Object)("Total penalty: " + penalty));
            Document doc = DocumentHelper.createDocument();
            m.saveAsXml(doc.addElement("curriculum"), (Assignment<CurVariable, CurValue>)a);
            FileOutputStream fos = new FileOutputStream("/Users/muller/solution.xml");
            new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(doc);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CurModelContext createAssignmentContext(Assignment<CurVariable, CurValue> assignment) {
        return new CurModelContext(assignment);
    }

    public class CurModelContext
    implements AssignmentConstraintContext<CurVariable, CurValue> {
        private double iAssignedWeight = 0.0;

        public CurModelContext(Assignment<CurVariable, CurValue> assignment) {
            for (CurVariable var : CurModel.this.variables()) {
                CurValue val = (CurValue)assignment.getValue((Variable)var);
                if (val == null) continue;
                this.assigned(assignment, val);
            }
        }

        public void assigned(Assignment<CurVariable, CurValue> assignment, CurValue value) {
            this.iAssignedWeight += value.getStudent().getWeight();
        }

        public void unassigned(Assignment<CurVariable, CurValue> assignment, CurValue value) {
            this.iAssignedWeight -= value.getStudent().getWeight();
        }

        public double getAssignedWeight() {
            return this.iAssignedWeight;
        }
    }
}

