/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.IdGenerator;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.dao.CourseOfferingDAO;

public interface StudentCourseDemands {
    public void init(org.hibernate.Session var1, Progress var2, Session var3, Collection<InstructionalOffering> var4);

    public Set<WeightedStudentId> getDemands(CourseOffering var1);

    public Double getEnrollmentPriority(Long var1, Long var2);

    public boolean isMakingUpStudents();

    public boolean canUseStudentClassEnrollmentsAsSolution();

    public boolean isWeightStudentsToFillUpOffering();

    public Set<WeightedCourseOffering> getCourses(Long var1);

    public static interface ProjectionsProvider {
        public float getProjection(String var1, String var2, String var3);
    }

    public static class WeightedCourseOffering {
        private transient CourseOffering iCourseOffering = null;
        private long iCourseOfferingId;
        private Long iPrimaryOfferingId;
        private float iWeight = 1.0f;

        public WeightedCourseOffering(CourseOffering courseOffering) {
            this.iCourseOffering = courseOffering;
            this.iCourseOfferingId = courseOffering.getUniqueId();
        }

        public WeightedCourseOffering(Long courseOfferingId) {
            this.iCourseOfferingId = courseOfferingId;
        }

        public WeightedCourseOffering(CourseOffering courseOffering, float weight) {
            this(courseOffering);
            this.iWeight = weight;
        }

        public WeightedCourseOffering(Long courseOfferingId, float weight) {
            this(courseOfferingId);
            this.iWeight = weight;
        }

        public Long getCourseOfferingId() {
            return this.iCourseOfferingId;
        }

        public CourseOffering getCourseOffering() {
            if (this.iCourseOffering == null) {
                this.iCourseOffering = (CourseOffering)CourseOfferingDAO.getInstance().get(this.iCourseOfferingId);
            }
            return this.iCourseOffering;
        }

        public float getWeight() {
            return this.iWeight;
        }

        public void setPrimaryOfferingId(Long offeringId) {
            this.iPrimaryOfferingId = offeringId;
        }

        public Long getPrimaryOfferingId() {
            return this.iPrimaryOfferingId;
        }

        public int hashCode() {
            return (int)(this.iCourseOfferingId ^ this.iCourseOfferingId >>> 32);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof WeightedCourseOffering)) {
                return false;
            }
            return this.getCourseOfferingId() == ((WeightedCourseOffering)o).getCourseOfferingId();
        }

        public String toString() {
            return this.getCourseOffering().getCourseName() + (this.getWeight() != 1.0f ? "@" + this.getWeight() : "");
        }
    }

    public static class WeightedStudentId {
        private long iStudentId;
        private float iWeight;
        private TreeSet<AreaClasfMajor> iMajors = new TreeSet();
        private Set<AreaClasfMajor> iMinors = new TreeSet<AreaClasfMajor>();
        private Set<String> iCurricula = new TreeSet<String>();
        private Set<Group> iGroups = new HashSet<Group>();
        private Long iPrimaryOfferingId = null;
        private Student iStudent = null;

        public WeightedStudentId(WeightedStudentId student, float weight) {
            this.iStudentId = student.iStudentId;
            this.iWeight = weight;
            this.iMajors.addAll(student.iMajors);
            this.iMinors.addAll(student.iMinors);
            this.iCurricula.addAll(student.iCurricula);
            this.iGroups.addAll(student.iGroups);
            this.iStudent = student.iStudent;
        }

        public WeightedStudentId(Student student, ProjectionsProvider projections, float weight) {
            this.iStudent = student;
            this.iStudentId = student.getUniqueId();
            this.iWeight = weight;
            float rule = 0.0f;
            float total = 0.0f;
            for (StudentAreaClassificationMajor studentAreaClassificationMajor : student.getAreaClasfMajors()) {
                if (studentAreaClassificationMajor.getWeight() != null && studentAreaClassificationMajor.getWeight() <= 1.0E-4) continue;
                this.iMajors.add(new AreaClasfMajor(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getMajor().getCode(), studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getCode(), studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getReference(), studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getReference(), studentAreaClassificationMajor.getWeight()));
                if (projections == null) continue;
                rule = (float)((double)rule + (studentAreaClassificationMajor.getWeight() == null ? 1.0 : studentAreaClassificationMajor.getWeight()) * (double)projections.getProjection(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getMajor().getCode()));
                total = (float)((double)total + (studentAreaClassificationMajor.getWeight() == null ? 1.0 : studentAreaClassificationMajor.getWeight()));
            }
            for (StudentAreaClassificationMinor studentAreaClassificationMinor : student.getAreaClasfMinors()) {
                this.iMinors.add(new AreaClasfMajor(studentAreaClassificationMinor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMinor.getAcademicClassification().getCode(), studentAreaClassificationMinor.getMinor().getCode()));
            }
            if ((double)total > 0.0) {
                this.iWeight = rule / total;
            }
            for (StudentGroup studentGroup : student.getGroups()) {
                this.iGroups.add(new Group(studentGroup.getUniqueId(), studentGroup.getGroupAbbreviation(), studentGroup.getType() == null || studentGroup.getType().isKeepTogether() != false));
            }
        }

        public WeightedStudentId(Long studentId, CurriculumClassification cc, ProjectionsProvider projections) {
            this.iStudentId = studentId;
            Curriculum curriculum = cc.getCurriculum();
            this.iWeight = 1.0f;
            if (projections != null) {
                if (curriculum.getMajors().isEmpty()) {
                    this.iWeight = projections.getProjection(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode(), "");
                } else if (curriculum.getMajors().size() == 1) {
                    for (PosMajor m : curriculum.getMajors()) {
                        this.iWeight = projections.getProjection(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode(), m.getCode());
                    }
                } else {
                    double rule = 1.0;
                    for (PosMajor m : curriculum.getMajors()) {
                        rule *= (double)projections.getProjection(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode(), m.getCode());
                    }
                    this.iWeight = (float)Math.pow(rule, 1.0 / (double)curriculum.getMajors().size());
                }
            }
            if (curriculum.getMajors().isEmpty()) {
                if (!curriculum.isMultipleMajors().booleanValue()) {
                    if (curriculum.getAcademicArea().getPosMajors().isEmpty()) {
                        this.iMajors.add(new AreaClasfMajor(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode(), ""));
                    } else {
                        for (PosMajor major : curriculum.getAcademicArea().getPosMajors()) {
                            this.iMajors.add(new AreaClasfMajor(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode(), major.getCode()));
                        }
                    }
                } else {
                    this.iMajors.add(new AreaClasfMajor(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode(), ""));
                }
            } else {
                for (PosMajor major : curriculum.getMajors()) {
                    this.iMajors.add(new AreaClasfMajor(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode(), major.getCode()));
                }
            }
            this.iCurricula.add(curriculum.getAbbv() + " " + cc.getAcademicClassification().getCode());
        }

        public WeightedStudentId(Long studentId) {
            this.iStudentId = studentId;
            this.iWeight = 1.0f;
        }

        public WeightedStudentId(Student student, ProjectionsProvider projections) {
            this(student, projections, 1.0f);
        }

        public WeightedStudentId(Student student, float weight) {
            this(student, null, weight);
        }

        public WeightedStudentId(Student student) {
            this(student, null, 1.0f);
        }

        public WeightedStudentId(Long studentId, CurriculumClassification cc) {
            this(studentId, cc, null);
        }

        public long getStudentId() {
            return this.iStudentId;
        }

        public Student getStudent() {
            return this.iStudent;
        }

        public float getWeight() {
            return this.iWeight;
        }

        public void setWeight(float weight) {
            this.iWeight = weight;
        }

        public void setCurriculum(String curriculum) {
            this.iCurricula.clear();
            this.iCurricula.add(curriculum);
        }

        public void setPrimaryOfferingId(Long offeringId) {
            this.iPrimaryOfferingId = offeringId;
        }

        public Long getPrimaryOfferingId() {
            return this.iPrimaryOfferingId;
        }

        public Set<AreaClasfMajor> getMajors() {
            return this.iMajors;
        }

        public Set<AreaClasfMajor> getMinors() {
            return this.iMinors;
        }

        public AreaClasfMajor getPrimaryMajor() {
            if (this.iMajors == null || this.iMajors.isEmpty()) {
                return null;
            }
            return this.iMajors.first();
        }

        public Set<Group> getGroups() {
            return this.iGroups;
        }

        public Group getGroup(String name) {
            for (Group g : this.iGroups) {
                if (!name.equals(g.getName())) continue;
                return g;
            }
            return null;
        }

        public String getArea() {
            return WeightedStudentId.toString(this.iMajors, 0, ",");
        }

        public String getClasf() {
            return WeightedStudentId.toString(this.iMajors, 1, ",");
        }

        public String getMajor() {
            return WeightedStudentId.toString(this.iMajors, 2, ",");
        }

        public String getCurriculum() {
            StringBuffer ret = new StringBuffer();
            if (this.iCurricula.isEmpty()) {
                for (AreaClasfMajor a : this.iMajors) {
                    if (ret.length() > 0) {
                        ret.append("|");
                    }
                    ret.append(a.toString());
                }
            } else {
                for (String curriculum : this.iCurricula) {
                    if (ret.length() > 0) {
                        ret.append("|");
                    }
                    ret.append(curriculum);
                }
            }
            return ret.toString();
        }

        private static String toString(Set<AreaClasfMajor> set, int idx, String delim) {
            if (set == null || set.isEmpty()) {
                return null;
            }
            StringBuffer ret = new StringBuffer();
            for (AreaClasfMajor s : set) {
                if (ret.length() > 0) {
                    ret.append(delim);
                }
                switch (idx) {
                    case 0: {
                        ret.append(s.getArea());
                        break;
                    }
                    case 1: {
                        ret.append(s.getClasf());
                        break;
                    }
                    case 2: {
                        ret.append(s.getMajor());
                    }
                }
            }
            return ret.toString();
        }

        public boolean match(String areaAbbv, Set<String> majors) {
            for (AreaClasfMajor a : this.iMajors) {
                if (!a.getArea().equals(areaAbbv) || !majors.contains(a.getMajor())) continue;
                return true;
            }
            return false;
        }

        public boolean match(CurriculumClassification clasf) {
            if (clasf.getCurriculum().isMultipleMajors().booleanValue() && clasf.getCurriculum().getMajors().isEmpty()) {
                return false;
            }
            for (AreaClasfMajor a : this.iMajors) {
                if (!a.getArea().equals(clasf.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation()) || !a.getClasf().equals(clasf.getAcademicClassification().getCode())) continue;
                if (clasf.getCurriculum().isMultipleMajors().booleanValue()) {
                    for (PosMajor major : clasf.getCurriculum().getMajors()) {
                        boolean found = false;
                        for (AreaClasfMajor m : this.iMajors) {
                            if (!m.getArea().equals(a.getArea()) || !m.getClasf().equals(clasf.getAcademicClassification().getCode()) || !m.getMajor().equals(major.getCode())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        return true;
                    }
                    continue;
                }
                if (clasf.getCurriculum().getMajors().isEmpty()) {
                    return true;
                }
                for (PosMajor major : clasf.getCurriculum().getMajors()) {
                    if (!a.getMajor().equals(major.getCode())) continue;
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return Long.valueOf(this.getStudentId()).hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof WeightedStudentId)) {
                return false;
            }
            return this.getStudentId() == ((WeightedStudentId)o).getStudentId();
        }

        public String toString() {
            return String.valueOf(this.getStudentId());
        }
    }

    public static class Group
    implements Comparable<Group> {
        Long iId;
        String iName;
        double iWeight;
        boolean iKeepTogether = true;

        public Group(Long id, String name, double weight, boolean keepTogether) {
            this.iId = id;
            this.iName = name;
            this.iWeight = weight;
            this.iKeepTogether = keepTogether;
        }

        public Group(Long id, String name) {
            this(id, name, 1.0, true);
        }

        public Group(Long id, String name, boolean keepTogether) {
            this(id, name, 1.0, keepTogether);
        }

        public Long getId() {
            return this.iId;
        }

        public String getName() {
            return this.iName;
        }

        public double getWeight() {
            return this.iWeight;
        }

        public String toString() {
            return this.getName();
        }

        public boolean isKeepTogether() {
            return this.iKeepTogether;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Group)) {
                return false;
            }
            return this.getId().equals(((Group)o).getId());
        }

        @Override
        public int compareTo(Group g) {
            int cmp = this.getName().compareTo(g.getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId().compareTo(g.getId());
        }
    }

    public static class AreaClasfMajor
    implements Comparable<AreaClasfMajor> {
        Double iWeight = 0.0;
        String iArea;
        String iClasf;
        String iMajor;
        String iConcentration;
        String iDegree;
        String iProgram;

        public AreaClasfMajor(String area, String clasf, String major) {
            this.iArea = area;
            this.iClasf = clasf;
            this.iMajor = major;
        }

        public AreaClasfMajor(String area, String clasf, String major, String concentration) {
            this.iArea = area;
            this.iClasf = clasf;
            this.iMajor = major;
            this.iConcentration = concentration;
        }

        public AreaClasfMajor(String area, String clasf, String major, String concentration, String degree, String program, Double weight) {
            this.iArea = area;
            this.iClasf = clasf;
            this.iMajor = major;
            this.iConcentration = concentration;
            this.iDegree = degree;
            this.iProgram = program;
            this.iWeight = weight;
        }

        public String getArea() {
            return this.iArea;
        }

        public String getClasf() {
            return this.iClasf;
        }

        public String getMajor() {
            return this.iMajor;
        }

        public String getConcentration() {
            return this.iConcentration;
        }

        public String getDegree() {
            return this.iDegree;
        }

        public String getProgram() {
            return this.iProgram;
        }

        public double getWeight() {
            return this.iWeight == null ? 0.0 : this.iWeight;
        }

        public String toString() {
            return this.getArea() + (this.getMajor().isEmpty() ? "" : "/" + this.getMajor() + (this.getConcentration() == null ? "" : "-" + this.getConcentration())) + (this.getClasf().isEmpty() ? "" : " " + this.getClasf());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AreaClasfMajor)) {
                return false;
            }
            return this.toString().equals(o.toString());
        }

        @Override
        public int compareTo(AreaClasfMajor ac) {
            if (this.getWeight() != ac.getWeight()) {
                return this.getWeight() > ac.getWeight() ? -1 : 1;
            }
            return this.toString().compareTo(ac.toString());
        }
    }

    public static interface NeedsStudentIdGenerator {
        public void setStudentIdGenerator(IdGenerator var1);
    }
}

