/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.course.ui.ClassAssignment;
import org.unitime.timetable.solver.course.ui.ClassAssignmentInfo;
import org.unitime.timetable.solver.course.ui.ClassInfo;

public class ClassProposedChange
implements Serializable,
Comparable<ClassProposedChange> {
    private static final long serialVersionUID = 1510362646798301408L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private Vector<ClassAssignmentInfo> iAssignments = new Vector();
    private Vector<ClassAssignment> iConflicts = new Vector();
    private Hashtable<Long, ClassAssignment> iInitials = new Hashtable();
    private Long iSelectedClassId = null;

    public void addChange(ClassAssignmentInfo change, ClassAssignment initial) {
        for (ClassAssignment classAssignment : this.iAssignments) {
            if (!classAssignment.getClassId().equals(change.getClassId())) continue;
            this.iAssignments.remove(classAssignment);
            this.iInitials.remove(classAssignment.getClassId());
            break;
        }
        for (ClassAssignment classAssignment : this.iAssignments) {
            if (!classAssignment.getClassId().equals(change.getClassId())) continue;
            this.iConflicts.remove(classAssignment);
            break;
        }
        if (change.getDateId() != null) {
            this.iAssignments.add(change);
            if (initial != null && initial.getTimeId() != null) {
                this.iInitials.put(initial.getClassId(), initial);
            }
        } else {
            this.iConflicts.add(initial);
        }
    }

    public boolean isEmpty() {
        return this.iConflicts.isEmpty() && this.iAssignments.isEmpty();
    }

    public Collection<ClassAssignment> getConflicts() {
        return this.iConflicts;
    }

    public Collection<ClassAssignmentInfo> getAssignments() {
        return this.iAssignments;
    }

    public Hashtable<Long, ClassAssignment> getAssignmentTable() {
        Hashtable<Long, ClassAssignment> table = new Hashtable<Long, ClassAssignment>();
        try {
            for (ClassAssignment classAssignment : this.iConflicts) {
                table.put(classAssignment.getClassId(), new ClassAssignment(classAssignment.getClazz(), null, null, null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ClassAssignment classAssignment : this.iAssignments) {
            table.put(classAssignment.getClassId(), classAssignment);
        }
        return table;
    }

    public ClassAssignment getInitial(ClassAssignment current) {
        return this.iInitials.get(current.getClassId());
    }

    public ClassAssignmentInfo getCurrent(ClassInfo clazz) {
        return this.getCurrent(clazz.getClassId());
    }

    public ClassAssignmentInfo getCurrent(Long classId) {
        for (ClassAssignmentInfo assignment : this.iAssignments) {
            if (!assignment.getClassId().equals(classId)) continue;
            return assignment;
        }
        return null;
    }

    public ClassAssignment getConflict(ClassInfo clazz) {
        return this.getConflict(clazz.getClassId());
    }

    public ClassAssignment getConflict(Long classId) {
        for (ClassAssignment conflict : this.iConflicts) {
            if (!conflict.getClassId().equals(classId)) continue;
            return conflict;
        }
        return null;
    }

    public ClassAssignment getInitial(Long currentId) {
        return this.iInitials.get(currentId);
    }

    public int getNrAssigned() {
        return this.iAssignments.size();
    }

    public int getNrUnassigned() {
        return this.iConflicts.size();
    }

    public double getValue() {
        double value = 0.0;
        for (ClassAssignment classAssignment : this.iConflicts) {
            value -= (double)classAssignment.getValue();
        }
        for (ClassAssignment classAssignment : this.iAssignments) {
            value += (double)classAssignment.getValue();
        }
        for (ClassAssignment classAssignment : this.iInitials.values()) {
            value -= (double)classAssignment.getValue();
        }
        return value;
    }

    @Override
    public int compareTo(ClassProposedChange change) {
        int cmp = Double.compare(this.getNrUnassigned(), change.getNrUnassigned());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.getValue(), change.getValue());
    }

    public void setSelected(Long classId) {
        this.iSelectedClassId = classId;
    }

    public String getHtmlTable(SessionContext context) {
        String ret = "<table border='0' cellspacing='0' cellpadding='3' width='100%'>";
        ret = ret + "<tr>";
        ret = ret + "<td><i>" + MSG.columnClass() + "</i></td>";
        ret = ret + "<td><i>" + MSG.columnInstructor() + "</i></td>";
        ret = ret + "<td><i>" + MSG.columnDateChange() + "</i></td>";
        ret = ret + "<td><i>" + MSG.columnTimeChange() + "</i></td>";
        ret = ret + "<td><i>" + MSG.columnRoomChange() + "</i></td>";
        ret = ret + "</tr>";
        for (ClassAssignment classAssignment : this.iAssignments) {
            ClassAssignment initial = this.iInitials.get(classAssignment.getClassId());
            String bgColor = classAssignment.getClassId().equals(this.iSelectedClassId) ? "rgb(168,187,225)" : null;
            boolean canAssign = context.hasPermission(classAssignment.getClazz(), Right.ClassAssignment);
            ret = ret + "<tr " + (bgColor == null ? "" : "style=\"background-color:" + bgColor + ";\" ") + (canAssign ? "onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';this.style.cursor='hand';this.style.cursor='pointer';\" onmouseout=\"this.style.backgroundColor='" + (bgColor == null ? "transparent" : bgColor) + "';\" onclick=\"document.location='classInfo.action?classId=" + classAssignment.getClassId() + "&op=Select&noCacheTS=" + new Date().getTime() + "';\"" : "") + ">";
            ret = ret + "<td nowrap>";
            ret = ret + "<img src='images/action_delete.png' border='0' onclick=\"document.location='classInfo.action?delete=" + classAssignment.getClassId() + "&op=Select&noCacheTS=" + new Date().getTime() + "';event.cancelBubble=true;\">&nbsp;";
            if (!canAssign && context.hasPermission(classAssignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering(), Right.OfferingCanLock)) {
                ret = ret + "<img src='images/error.png' border='0' onclick='if (confirm(\"Course " + classAssignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseName() + " is not locked. Do you want to lock it?\")) document.location=\"classInfo.action?offering=" + classAssignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId() + "&op=Lock&noCacheTS=" + new Date().getTime() + "\";event.cancelBubble=true;' title=\"Course " + classAssignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseName() + " is not locked. Click the warning icon to lock it.\" style='cursor: pointer;'>&nbsp;";
            }
            ret = ret + classAssignment.getClassNameHtml();
            ret = ret + "</td><td nowrap>";
            ret = ret + classAssignment.getLeadingInstructorNames(", ");
            ret = ret + "</td><td nowrap>";
            if (initial != null && !initial.getDateId().equals(classAssignment.getDateId())) {
                ret = ret + initial.getDateNameHtml() + " &rarr; ";
            }
            if (initial == null) {
                ret = ret + "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>" + MSG.notAssigned() + "</i></font> &rarr; ";
            }
            ret = ret + classAssignment.getDateNameHtml();
            ret = ret + "</td><td nowrap>";
            if (initial != null && !initial.getTimeId().equals(classAssignment.getTimeId())) {
                ret = ret + initial.getTimeNameHtml() + " &rarr; ";
            }
            if (initial == null) {
                ret = ret + "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>" + MSG.notAssigned() + "</i></font> &rarr; ";
            }
            ret = ret + classAssignment.getTimeNameHtml();
            ret = ret + "</td><td nowrap>";
            if (initial != null && !initial.getRoomIds().equals(classAssignment.getRoomIds())) {
                ret = ret + initial.getRoomNamesHtml(", ") + " &rarr; ";
            }
            if (initial == null) {
                ret = ret + "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>" + MSG.notAssigned() + "</i></font> &rarr; ";
            }
            ret = ret + classAssignment.getRoomNamesHtml(", ");
            if (classAssignment.getNrRooms() != classAssignment.getNumberOfRooms()) {
                ret = classAssignment.getClassId().equals(this.iSelectedClassId) ? ret + "<i>" + MSG.assignmentRoomSelectBelow() + "</i>" : ret + "<i><font color='red'>" + MSG.assignmentRoomNotSelected() + "</font></i>";
            }
            ret = ret + "</td></tr>";
        }
        for (ClassAssignment classAssignment : this.iConflicts) {
            String bgColor = classAssignment.getClassId().equals(this.iSelectedClassId) ? "rgb(168,187,225)" : null;
            boolean canAssign = context.hasPermission(classAssignment.getClazz(), Right.ClassAssignment);
            ret = ret + "<tr " + (bgColor == null ? "" : "style=\"background-color:" + bgColor + ";\" ") + (canAssign ? "onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';this.style.cursor='hand';this.style.cursor='pointer';\" onmouseout=\"this.style.backgroundColor='" + (bgColor == null ? "transparent" : bgColor) + "';\" onclick=\"document.location='classInfo.action?classId=" + classAssignment.getClassId() + "&op=Select&noCacheTS=" + new Date().getTime() + "';\"" : "") + ">";
            ret = ret + "<td nowrap>";
            if (!canAssign && context.hasPermission(classAssignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering(), Right.OfferingCanLock)) {
                ret = ret + "<img src='images/error.png' border='0' onclick='if (confirm(\"" + MSG.messageCourseNotLocked(classAssignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseName()) + "\")) document.location=\"classInfo.action?offering=" + classAssignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId() + "&op=Lock&noCacheTS=" + new Date().getTime() + "\";event.cancelBubble=true;' title=\"" + MSG.titleCourseNotLocked(classAssignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseName()) + "\" style='cursor: pointer;'>&nbsp;";
            }
            ret = ret + classAssignment.getClassNameHtml();
            ret = ret + "</td><td nowrap>";
            ret = ret + classAssignment.getLeadingInstructorNames(", ");
            ret = ret + "</td><td nowrap>";
            ret = ret + classAssignment.getDateNameHtml() + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>" + MSG.notAssigned() + "</i></font></td>";
            ret = ret + "</td><td nowrap>";
            ret = ret + classAssignment.getTimeNameHtml() + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>" + MSG.notAssigned() + "</i></font></td>";
            ret = ret + "</td><td nowrap>";
            ret = ret + classAssignment.getRoomNamesHtml(", ") + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>" + MSG.notAssigned() + "</i></font>";
            ret = ret + "</td></tr>";
        }
        ret = ret + "</table>";
        return ret;
    }

    public String toString(String delim) {
        String ret = "";
        for (ClassAssignment classAssignment : this.iConflicts) {
            if (ret.length() > 0) {
                ret = ret + delim;
            }
            ret = ret + classAssignment.getClassName() + " " + classAssignment.getDate() + " " + classAssignment.getTime().getName() + " " + classAssignment.getRoomNames(", ") + " -> " + MSG.assignmentNotAssigned();
        }
        for (ClassAssignment classAssignment : this.iAssignments) {
            if (ret.length() > 0) {
                ret = ret + delim;
            }
            ClassAssignment initial = this.iInitials.get(classAssignment.getClassId());
            ret = ret + classAssignment.getClassName() + " " + (initial == null ? MSG.assignmentNotAssigned() : initial.getDate() + " " + initial.getTime().getName() + " " + initial.getRoomNames(", ")) + " -> " + classAssignment.getDate() + " " + classAssignment.getTime().getName() + " " + classAssignment.getRoomNames(", ");
        }
        return ret;
    }

    public String toString() {
        return this.toString("\n");
    }

    public boolean isUnassigned(Long classId) {
        for (ClassAssignment conflict : this.getConflicts()) {
            if (!classId.equals(conflict.getClassId())) continue;
            return true;
        }
        return false;
    }
}

