/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.Formats;

public class WebSolver {
    public static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);

    private static SolverService<SolverProxy> getCourseTimetablingSolverService(HttpSession session) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)session.getServletContext());
        return (SolverService)applicationContext.getBean("courseTimetablingSolverService");
    }

    public static SolverProxy getSolver(HttpSession session) {
        return WebSolver.getCourseTimetablingSolverService(session).getSolver();
    }

    private static SolverService<ExamSolverProxy> getExaminationSolverService(HttpSession session) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)session.getServletContext());
        return (SolverService)applicationContext.getBean("examinationSolverService");
    }

    public static ExamSolverProxy getExamSolver(HttpSession session) {
        return WebSolver.getExaminationSolverService(session).getSolver();
    }

    private static SolverService<StudentSolverProxy> getStudentSectioningSolverService(HttpSession session) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)session.getServletContext());
        return (SolverService)applicationContext.getBean("studentSectioningSolverService");
    }

    public static StudentSolverProxy getStudentSolver(HttpSession session) {
        return WebSolver.getStudentSectioningSolverService(session).getSolver();
    }

    private static AssignmentService<ClassAssignmentProxy> getClassAssignmentService(HttpSession session) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)session.getServletContext());
        return (AssignmentService)applicationContext.getBean("classAssignmentService");
    }

    public static ClassAssignmentProxy getClassAssignmentProxy(HttpSession session) {
        return WebSolver.getClassAssignmentService(session).getAssignment();
    }
}

