/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.hibernate.ObjectNotFoundException;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.base.BaseLocation;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.CommitedClassAssignmentProxy;
import org.unitime.timetable.solver.course.ui.ClassTimeInfo;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.RoomAvailability;

public class SolutionClassAssignmentProxy
extends CommitedClassAssignmentProxy {
    private Set<Long> iSolutionIds = new HashSet<Long>();
    private Hashtable<Long, Long> iDepartmentIds = new Hashtable();

    public SolutionClassAssignmentProxy(Collection solutionIds) {
        Iterator i = solutionIds.iterator();
        while (i.hasNext()) {
            Solution solution = (Solution)new SolutionDAO().get((Long)i.next());
            if (solution == null) continue;
            this.iSolutionIds.add(solution.getUniqueId());
            Iterator<Department> j = solution.getOwner().getDepartments().iterator();
            while (j.hasNext()) {
                this.iDepartmentIds.put(j.next().getUniqueId(), solution.getUniqueId());
            }
        }
    }

    public SolutionClassAssignmentProxy(Solution solution) {
        this.iSolutionIds.add(solution.getUniqueId());
        Iterator<Department> j = solution.getOwner().getDepartments().iterator();
        while (j.hasNext()) {
            this.iDepartmentIds.put(j.next().getUniqueId(), solution.getUniqueId());
        }
    }

    public Long getSolutionId(Class_ clazz) {
        Department department = clazz.getManagingDept();
        if (department == null) {
            return null;
        }
        return this.iDepartmentIds.get(department.getUniqueId());
    }

    @Override
    public Assignment getAssignment(Class_ clazz) {
        Long solutionId = this.getSolutionId(clazz);
        if (solutionId == null) {
            return super.getAssignment(clazz);
        }
        Iterator<Assignment> i = null;
        try {
            i = clazz.getAssignments().iterator();
        }
        catch (ObjectNotFoundException e) {
            new _RootDAO().getSession().refresh((Object)clazz);
            i = clazz.getAssignments().iterator();
        }
        while (i.hasNext()) {
            Assignment a = i.next();
            if (!solutionId.equals(a.getSolution().getUniqueId())) continue;
            return a;
        }
        return null;
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Class_ clazz) {
        Long solutionId = this.getSolutionId(clazz);
        if (solutionId == null) {
            return super.getAssignmentInfo(clazz);
        }
        Assignment a = this.getAssignment(clazz);
        return a == null ? null : (AssignmentPreferenceInfo)a.getAssignmentInfo("AssignmentInfo");
    }

    public Set<Long> getSolutionIds() {
        return this.iSolutionIds;
    }

    public boolean equals(Collection<Long> solutionIds) {
        if (solutionIds.size() != this.iSolutionIds.size()) {
            return false;
        }
        for (Long solutionId : solutionIds) {
            if (this.iSolutionIds.contains(solutionId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasConflicts(Long offeringId) {
        InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId);
        if (offering == null || offering.isNotOffered().booleanValue()) {
            return false;
        }
        for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    Assignment assignment;
                    if (clazz.isCancelled().booleanValue() || (assignment = this.getAssignment(clazz)) == null) continue;
                    if (assignment.getRooms() != null) {
                        for (Location room : assignment.getRooms()) {
                            if (!room.isIgnoreRoomCheck().booleanValue()) {
                                for (Assignment assignment2 : room.getAssignments(this.iSolutionIds)) {
                                    if (assignment.equals(assignment2) || assignment2.getClazz().isCancelled().booleanValue() || !assignment.overlaps(assignment2) || clazz.canShareRoom(assignment2.getClazz())) continue;
                                    return true;
                                }
                            }
                            if (!(room instanceof Room)) continue;
                            Room r = (Room)room;
                            if (r.getParentRoom() != null && !r.getParentRoom().isIgnoreRoomCheck().booleanValue()) {
                                for (Assignment a : r.getParentRoom().getAssignments(this.iSolutionIds)) {
                                    if (assignment.equals(a) || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a) || clazz.canShareRoom(a.getClazz())) continue;
                                    return true;
                                }
                            }
                            for (Object p : r.getPartitions()) {
                                if (((BaseLocation)p).isIgnoreRoomCheck().booleanValue()) continue;
                                for (Assignment a4 : ((Location)p).getAssignments(this.iSolutionIds)) {
                                    if (assignment.equals(a4) || a4.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a4) || clazz.canShareRoom(a4.getClazz())) continue;
                                    return true;
                                }
                            }
                        }
                    }
                    if (clazz.getClassInstructors() != null) {
                        for (ClassInstructor instructor : clazz.getClassInstructors()) {
                            if (!instructor.isLead().booleanValue()) continue;
                            for (DepartmentalInstructor departmentalInstructor : DepartmentalInstructor.getAllForInstructor(instructor.getInstructor())) {
                                Object p;
                                p = departmentalInstructor.getClasses().iterator();
                                while (p.hasNext()) {
                                    Assignment a;
                                    ClassInstructor ci = (ClassInstructor)p.next();
                                    if (ci.equals(instructor) || ci.getClassInstructing().equals(clazz) || !ci.isLead().booleanValue() || (a = this.getAssignment(ci.getClassInstructing())) == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a) || clazz.canShareInstructor(a.getClazz())) continue;
                                    return true;
                                }
                            }
                            if (instructor.getInstructor().getExternalUniqueId() == null) continue;
                            for (Class_ class_ : Class_DAO.getInstance().getSession().createQuery("select e.clazz from StudentClassEnrollment e where e.student.externalUniqueId = :externalId and e.student.session.uniqueId = :sessionId").setLong("sessionId", instructor.getInstructor().getDepartment().getSessionId().longValue()).setString("externalId", instructor.getInstructor().getExternalUniqueId()).setCacheable(true).list()) {
                                Assignment a;
                                a = this.getAssignment(class_);
                                if (a == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a)) continue;
                                return true;
                            }
                        }
                    }
                    for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
                        Assignment a5 = this.getAssignment(parent);
                        if (a5 == null || a5.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a5)) continue;
                        return true;
                    }
                    for (SchedulingSubpart ss : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
                        Assignment a3;
                        Class_ class_;
                        if (ss.getClasses().size() != 1 || clazz.equals(class_ = ss.getClasses().iterator().next()) || (a3 = this.getAssignment(class_)) == null || a3.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a3)) continue;
                        return true;
                    }
                }
            }
        }
        if (RoomAvailability.getInstance() != null) {
            boolean changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
            boolean ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
            Date[] bounds = DatePattern.getBounds(offering.getSessionId());
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.setTime(new Date());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date today = cal.getTime();
            for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    for (Class_ class_ : subpart.getClasses()) {
                        Assignment assignment = this.getAssignment(class_);
                        if (assignment == null || assignment.getRooms() == null || assignment.getRooms().isEmpty()) continue;
                        ClassTimeInfo period = new ClassTimeInfo(assignment);
                        for (Location room : assignment.getRooms()) {
                            Collection<RoomAvailabilityInterface.TimeBlock> times;
                            if (room.isIgnoreRoomCheck().booleanValue() || (times = RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) == null || times.isEmpty()) continue;
                            Collection<RoomAvailabilityInterface.TimeBlock> timesToCheck = null;
                            if (!changePast || ignorePast) {
                                timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                                for (RoomAvailabilityInterface.TimeBlock time : times) {
                                    if (time.getEndTime().before(today)) continue;
                                    timesToCheck.add(time);
                                }
                            } else {
                                timesToCheck = times;
                            }
                            if (period.overlaps(timesToCheck) == null) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public Set<Assignment> getConflicts(Long classId) {
        if (classId == null) {
            return null;
        }
        Class_ clazz = (Class_)Class_DAO.getInstance().get(classId);
        if (clazz == null || clazz.isCancelled().booleanValue()) {
            return null;
        }
        Assignment assignment = this.getAssignment(clazz);
        if (assignment == null) {
            return null;
        }
        HashSet<Assignment> conflicts = new HashSet<Assignment>();
        if (assignment.getRooms() != null) {
            for (Location room : assignment.getRooms()) {
                if (!room.isIgnoreRoomCheck().booleanValue()) {
                    for (Assignment assignment2 : room.getAssignments(this.iSolutionIds)) {
                        if (assignment.equals(assignment2) || assignment2.getClazz().isCancelled().booleanValue() || !assignment.overlaps(assignment2) || clazz.canShareRoom(assignment2.getClazz())) continue;
                        conflicts.add(assignment2);
                    }
                }
                if (!(room instanceof Room)) continue;
                Room r = (Room)room;
                if (r.getParentRoom() != null && !r.getParentRoom().isIgnoreRoomCheck().booleanValue()) {
                    for (Assignment a3 : r.getParentRoom().getAssignments(this.iSolutionIds)) {
                        if (assignment.equals(a3) || a3.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a3) || clazz.canShareRoom(a3.getClazz())) continue;
                        conflicts.add(a3);
                    }
                }
                for (Object p : r.getPartitions()) {
                    if (r.isIgnoreRoomCheck().booleanValue()) continue;
                    for (Assignment a4 : ((Location)p).getAssignments(this.iSolutionIds)) {
                        if (assignment.equals(a4) || a4.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a4) || clazz.canShareRoom(a4.getClazz())) continue;
                        conflicts.add(a4);
                    }
                }
            }
        }
        if (clazz.getClassInstructors() != null) {
            for (ClassInstructor instructor : clazz.getClassInstructors()) {
                if (!instructor.isLead().booleanValue()) continue;
                for (DepartmentalInstructor departmentalInstructor : DepartmentalInstructor.getAllForInstructor(instructor.getInstructor())) {
                    for (ClassInstructor ci : departmentalInstructor.getClasses()) {
                        Assignment a;
                        if (ci.equals(instructor) || ci.getClassInstructing().equals(clazz) || !ci.isLead().booleanValue() || (a = this.getAssignment(ci.getClassInstructing())) == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a) || clazz.canShareInstructor(a.getClazz())) continue;
                        conflicts.add(a);
                    }
                }
                if (instructor.getInstructor().getExternalUniqueId() == null) continue;
                for (Class_ class_ : Class_DAO.getInstance().getSession().createQuery("select e.clazz from StudentClassEnrollment e where e.student.externalUniqueId = :externalId and e.student.session.uniqueId = :sessionId").setLong("sessionId", instructor.getInstructor().getDepartment().getSessionId().longValue()).setString("externalId", instructor.getInstructor().getExternalUniqueId()).setCacheable(true).list()) {
                    Assignment a = this.getAssignment(class_);
                    if (a == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a)) continue;
                    conflicts.add(a);
                }
            }
        }
        for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
            Assignment a5 = this.getAssignment(parent);
            if (a5 == null || a5.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a5)) continue;
            conflicts.add(a5);
        }
        LinkedList<Class_> children = new LinkedList<Class_>(clazz.getChildClasses());
        Class_ child = null;
        while ((child = (Class_)children.poll()) != null) {
            Assignment assignment3 = this.getAssignment(child);
            if (assignment3 != null && !assignment3.getClazz().isCancelled().booleanValue() && assignment.overlaps(assignment3)) {
                conflicts.add(assignment3);
            }
            if (child.getChildClasses().isEmpty()) continue;
            children.addAll(child.getChildClasses());
        }
        for (SchedulingSubpart ss : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
            Assignment a6;
            if (ss.getClasses().size() != 1 || clazz.equals(child = ss.getClasses().iterator().next()) || (a6 = this.getAssignment(child)) == null || a6.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a6)) continue;
            conflicts.add(a6);
        }
        return conflicts;
    }

    @Override
    public Set<RoomAvailabilityInterface.TimeBlock> getConflictingTimeBlocks(Long classId) {
        if (classId == null) {
            return null;
        }
        Class_ clazz = (Class_)Class_DAO.getInstance().get(classId);
        if (clazz == null || clazz.isCancelled().booleanValue()) {
            return null;
        }
        Long solutionId = this.getSolutionId(clazz);
        if (solutionId == null) {
            return super.getConflictingTimeBlocks(classId);
        }
        TreeSet<RoomAvailabilityInterface.TimeBlock> conflicts = new TreeSet<RoomAvailabilityInterface.TimeBlock>(new RoomAvailabilityInterface.TimeBlockComparator());
        Assignment assignment = this.getAssignment(clazz);
        if (assignment != null && assignment.getRooms() != null && !assignment.getRooms().isEmpty() && RoomAvailability.getInstance() != null) {
            Date[] bounds = DatePattern.getBounds(clazz.getSessionId());
            boolean changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
            boolean ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.setTime(new Date());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date today = cal.getTime();
            ClassTimeInfo period = new ClassTimeInfo(assignment);
            for (Location room : assignment.getRooms()) {
                List<RoomAvailabilityInterface.TimeBlock> overlaps;
                Collection<RoomAvailabilityInterface.TimeBlock> times;
                if (room.isIgnoreRoomCheck().booleanValue() || (times = RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) == null || times.isEmpty()) continue;
                Collection<RoomAvailabilityInterface.TimeBlock> timesToCheck = null;
                if (!changePast || ignorePast) {
                    timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                    for (RoomAvailabilityInterface.TimeBlock time : times) {
                        if (time.getEndTime().before(today)) continue;
                        timesToCheck.add(time);
                    }
                } else {
                    timesToCheck = times;
                }
                if ((overlaps = period.allOverlaps(timesToCheck)) == null) continue;
                conflicts.addAll(overlaps);
            }
        }
        return conflicts;
    }
}

