/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.util.List;
import java.util.StringTokenizer;
import org.cpsolver.ifs.util.Progress;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CommonSolverInterface;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.solver.ui.LogInfo;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=SolverInterface.SolverLogPageRequest.class)
public class SolverLogPageBackend
implements GwtRpcImplementation<SolverInterface.SolverLogPageRequest, SolverInterface.SolverLogPageResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public SolverInterface.SolverLogPageResponse execute(SolverInterface.SolverLogPageRequest request, SessionContext context) {
        switch (request.getType()) {
            case COURSE: {
                context.checkPermission(Right.SolverLog);
                break;
            }
            case EXAM: {
                context.checkPermission(Right.ExaminationSolverLog);
                break;
            }
            case STUDENT: {
                context.checkPermission(Right.StudentSectioningSolverLog);
                break;
            }
            case INSTRUCTOR: {
                context.checkPermission(Right.InstructorSchedulingSolverLog);
            }
        }
        SolverInterface.ProgressLogLevel level = request.getLevel();
        if (level == null) {
            level = SolverInterface.ProgressLogLevel.INFO;
        }
        SolverService<? extends CommonSolverInterface> service = this.getSolverService(request.getType());
        CommonSolverInterface solver = service.getSolver();
        SolverInterface.SolverLogPageResponse response = new SolverInterface.SolverLogPageResponse(level);
        if (solver == null) {
            if (request.getType() == SolverInterface.SolverType.COURSE) {
                String solutionIdsStr = (String)context.getAttribute(SessionAttribute.SelectedSolution);
                if (solutionIdsStr != null && !solutionIdsStr.isEmpty()) {
                    StringTokenizer s = new StringTokenizer(solutionIdsStr, ",");
                    while (s.hasMoreTokens()) {
                        LogInfo log;
                        Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(s.nextToken()));
                        if (solution == null || (log = (LogInfo)solution.getInfo("LogInfo")) == null) continue;
                        SolverInterface.SolutionLog sl = new SolverInterface.SolutionLog(solution.getOwner().getName());
                        for (Progress.Message m : log.getLog()) {
                            if (m.getLevel() < level.ordinal()) continue;
                            sl.addMessage(m.getLevel(), m.getDate(), m.getMessage(), m.getTrace());
                        }
                        response.addSolutionLog(sl);
                    }
                    return response;
                }
                throw new GwtRpcException(MESSAGES.warnSolverNotStartedSolutionNotSelected());
            }
            throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
        }
        List<Progress.Message> log = solver.getProgressLog(level.ordinal(), null, request.getLastDate());
        if (log != null) {
            for (Progress.Message m : log) {
                response.addMessage(m.getLevel(), m.getDate(), m.getMessage(), m.getTrace());
            }
        }
        switch (request.getType()) {
            case COURSE: {
                BackTracker.markForBack(context, "gwt.jsp?page=solverlog&type=course", MESSAGES.pageCourseTimetablingSolverLog(), true, true);
                break;
            }
            case EXAM: {
                BackTracker.markForBack(context, "gwt.jsp?page=solverlog&type=exam", MESSAGES.pageExaminationTimetablingSolverLog(), true, true);
                break;
            }
            case INSTRUCTOR: {
                BackTracker.markForBack(context, "gwt.jsp?page=solverlog&type=instructor", MESSAGES.pageInstructorSchedulingSolverLog(), true, true);
                break;
            }
            case STUDENT: {
                BackTracker.markForBack(context, "gwt.jsp?page=solverlog&type=student", MESSAGES.pageStudentSchedulingSolverLog(), true, true);
            }
        }
        return response;
    }

    protected SolverService<? extends CommonSolverInterface> getSolverService(SolverInterface.SolverType type) {
        switch (type) {
            case COURSE: {
                return this.courseTimetablingSolverService;
            }
            case EXAM: {
                return this.examinationSolverService;
            }
            case STUDENT: {
                return this.studentSectioningSolverService;
            }
            case INSTRUCTOR: {
                return this.instructorSchedulingSolverService;
            }
        }
        throw new IllegalArgumentException(MESSAGES.errorSolverInvalidType(type.name()));
    }
}

