/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SuggestionsContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverService;

@GwtRpcImplements(value=SuggestionsInterface.MakeAssignmentRequest.class)
public class MakeAssignmentBackend
implements GwtRpcImplementation<SuggestionsInterface.MakeAssignmentRequest, GwtRpcResponseNull> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public GwtRpcResponseNull execute(SuggestionsInterface.MakeAssignmentRequest request, SessionContext context) {
        SolverProxy solver;
        context.checkPermission(Right.Suggestions);
        SuggestionsContext cx = new SuggestionsContext();
        String instructorFormat = context.getUser().getProperty(UserProperty.NameFormat);
        if (instructorFormat != null) {
            cx.setInstructorNameFormat(instructorFormat);
        }
        if ((solver = this.courseTimetablingSolverService.getSolver()) == null) {
            throw new GwtRpcException(MESSAGES.warnSolverNotLoaded());
        }
        if (solver.isWorking()) {
            throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
        }
        solver.assignSelectedAssignments(request.getAssignments());
        return null;
    }
}

