/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.Iterator;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=RoomInterface.UpdateBuildingRequest.class)
public class UpdateBuildingBackend
implements GwtRpcImplementation<RoomInterface.UpdateBuildingRequest, RoomInterface.BuildingInterface> {
    @Override
    public RoomInterface.BuildingInterface execute(RoomInterface.UpdateBuildingRequest request, SessionContext context) {
        switch (request.getAction()) {
            case CREATE: {
                context.checkPermission(Right.BuildingAdd);
                this.saveOrUpdate(request.getBuilding(), false, context);
                break;
            }
            case UPDATE: {
                context.checkPermission(request.getBuilding().getId(), "Building", Right.BuildingEdit);
                this.saveOrUpdate(request.getBuilding(), request.getUpdateRoomCoordinates(), context);
                break;
            }
            case DELETE: {
                context.checkPermission(request.getBuilding().getId(), "Building", Right.BuildingDelete);
                this.delete(request.getBuilding(), context);
                break;
            }
            case UPDATE_DATA: {
                context.checkPermission(Right.BuildingUpdateData);
                this.updateRooms(context);
            }
        }
        return request.getBuilding();
    }

    protected void saveOrUpdate(RoomInterface.BuildingInterface buildingInterface, boolean updateRoomCoordinates, SessionContext context) throws GwtRpcException {
        Transaction tx = null;
        try {
            org.hibernate.Session hibSession = BuildingDAO.getInstance().getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            Building building = null;
            if (buildingInterface.getId() != null) {
                building = (Building)BuildingDAO.getInstance().get(buildingInterface.getId(), hibSession);
            }
            if (building == null) {
                building = new Building();
                building.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
            }
            building.setName(buildingInterface.getName());
            building.setAbbreviation(buildingInterface.getAbbreviation());
            building.setExternalUniqueId((String)(buildingInterface.getExternalId() != null && buildingInterface.getExternalId().isEmpty() ? null : buildingInterface.getExternalId()));
            building.setCoordinateX(buildingInterface.getX());
            building.setCoordinateY(buildingInterface.getY());
            if (building.getUniqueId() == null) {
                buildingInterface.setId((Long)hibSession.save((Object)building));
            } else {
                hibSession.update((Object)building);
            }
            ChangeLog.addChange(hibSession, context, building, ChangeLog.Source.BUILDING_EDIT, building.getUniqueId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, null);
            if (updateRoomCoordinates) {
                for (Room room : hibSession.createQuery("from Room r where r.building.uniqueId = :buildingId").setLong("buildingId", building.getUniqueId().longValue()).list()) {
                    if (ToolBox.equals((Object)room.getCoordinateX(), (Object)building.getCoordinateX()) && ToolBox.equals((Object)room.getCoordinateY(), (Object)building.getCoordinateY())) continue;
                    room.setCoordinateX(building.getCoordinateX());
                    room.setCoordinateY(building.getCoordinateY());
                    hibSession.update((Object)room);
                    ChangeLog.addChange(hibSession, context, room, room.getLabel() + " moved to " + room.getCoordinateX() + "," + room.getCoordinateY(), ChangeLog.Source.BUILDING_EDIT, ChangeLog.Operation.UPDATE, null, null);
                }
            }
            tx.commit();
            HibernateUtil.clearCache();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    protected void delete(RoomInterface.BuildingInterface buildingInterface, SessionContext context) throws GwtRpcException {
        Transaction tx = null;
        try {
            Building building;
            org.hibernate.Session hibSession = BuildingDAO.getInstance().getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            if ((building = (Building)BuildingDAO.getInstance().get(buildingInterface.getId())) != null) {
                Iterator i = hibSession.createQuery("select r from Room r where r.building.uniqueId=:buildingId").setLong("buildingId", building.getUniqueId().longValue()).iterate();
                while (i.hasNext()) {
                    Room r = (Room)i.next();
                    hibSession.createQuery("delete RoomPref p where p.room.uniqueId=:roomId").setLong("roomId", r.getUniqueId().longValue()).executeUpdate();
                    Iterator<Assignment> j = r.getAssignments().iterator();
                    while (j.hasNext()) {
                        Assignment a = j.next();
                        a.getRooms().remove(r);
                        hibSession.saveOrUpdate((Object)a);
                        j.remove();
                    }
                    hibSession.delete((Object)r);
                }
                ChangeLog.addChange(hibSession, context, building, ChangeLog.Source.BUILDING_EDIT, ChangeLog.Operation.DELETE, null, null);
                hibSession.delete((Object)building);
            }
            tx.commit();
            HibernateUtil.clearCache();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    protected void updateRooms(SessionContext context) throws GwtRpcException {
        Transaction tx = null;
        try {
            org.hibernate.Session hibSession = BuildingDAO.getInstance().getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            Room.addNewExternalRoomsToSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()));
            tx.commit();
            HibernateUtil.clearCache();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }
}

