/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.menu;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.MenuInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=MenuInterface.SessionInfoRpcRequest.class)
public class SessionInfoBackend
implements GwtRpcImplementation<MenuInterface.SessionInfoRpcRequest, MenuInterface.SessionInfoInterface> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    private SessionContext sessionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MenuInterface.SessionInfoInterface execute(MenuInterface.SessionInfoRpcRequest request, SessionContext context) {
        MenuInterface.SessionInfoInterface ret = new MenuInterface.SessionInfoInterface();
        try (org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();){
            UserContext user = this.sessionContext.getUser();
            if (user == null) {
                MenuInterface.SessionInfoInterface sessionInfoInterface = null;
                return sessionInfoInterface;
            }
            if (user.getCurrentAcademicSessionId() == null) {
                if (this.sessionContext.hasPermissionAnyAuthority(Right.HasRole, new Qualifiable[0])) {
                    ret.addPair(MESSAGES.fieldSession(), MESSAGES.notSelected());
                    ret.addPair(MESSAGES.fieldDatabase(), HibernateUtil.getDatabaseName());
                    ret.setSession(MESSAGES.notSelected());
                    MenuInterface.SessionInfoInterface sessionInfoInterface = ret;
                    return sessionInfoInterface;
                }
                MenuInterface.SessionInfoInterface sessionInfoInterface = null;
                return sessionInfoInterface;
            }
            Session session = (Session)SessionDAO.getInstance().get(user.getCurrentAcademicSessionId(), hibSession);
            ret.addPair(MESSAGES.fieldSession(), session.getLabel());
            ret.addPair(MESSAGES.fieldStatus(), session.getStatusType().getLabel());
            ret.setSession(session.getLabel());
            ret.addPair(MESSAGES.fieldDatabase(), HibernateUtil.getDatabaseName());
        }
        return ret;
    }
}

