/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.server.ReservationServlet;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.gwt.shared.TeachingRequestInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.util.NameFormat;

@GwtRpcImplements(value=TeachingRequestInterface.GetRequestsRpcRequest.class)
public class GetTeachingRequestBackend
implements GwtRpcImplementation<TeachingRequestInterface.GetRequestsRpcRequest, TeachingRequestInterface.GetRequestsRpcResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;

    /*
     * WARNING - void declaration
     */
    @Override
    public TeachingRequestInterface.GetRequestsRpcResponse execute(TeachingRequestInterface.GetRequestsRpcRequest request, SessionContext context) {
        InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(request.getOfferingId());
        if (offering == null) {
            throw new GwtRpcException(MESSAGES.errorOfferingDoesNotExist(request.getOfferingId().toString()));
        }
        context.checkPermission(offering.getDepartment(), Right.InstructorAssignmentPreferences);
        TeachingRequestInterface.GetRequestsRpcResponse response = new TeachingRequestInterface.GetRequestsRpcResponse();
        response.setOffering(ReservationServlet.convert(offering, null, InstructionalOfferingDAO.getInstance().getSession(), null, context, this.classAssignmentService.getAssignment()));
        for (InstructorAttribute attribute : InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute a where a.session.uniqueId = :sessionId and (a.department is null or a.department.uniqueId = :departmentId) order by a.name").setLong("sessionId", context.getUser().getCurrentAcademicSessionId().longValue()).setLong("departmentId", offering.getDepartment().getUniqueId().longValue()).setCacheable(true).list()) {
            Iterator<PreferenceLevel> a = new InstructorInterface.AttributeInterface();
            ((InstructorInterface.AttributeInterface)((Object)a)).setId(attribute.getUniqueId());
            ((InstructorInterface.AttributeInterface)((Object)a)).setParentId(attribute.getParentAttribute() == null ? null : attribute.getParentAttribute().getUniqueId());
            ((InstructorInterface.AttributeInterface)((Object)a)).setParentName(attribute.getParentAttribute() == null ? null : attribute.getParentAttribute().getName());
            ((InstructorInterface.AttributeInterface)((Object)a)).setCode(attribute.getCode());
            ((InstructorInterface.AttributeInterface)((Object)a)).setName(attribute.getName());
            ((InstructorInterface.AttributeInterface)((Object)a)).setCanDelete(context.hasPermission(attribute, Right.InstructorAttributeDelete));
            ((InstructorInterface.AttributeInterface)((Object)a)).setCanEdit(context.hasPermission(attribute, Right.InstructorAttributeEdit));
            ((InstructorInterface.AttributeInterface)((Object)a)).setCanAssign(context.hasPermission(attribute, Right.InstructorAttributeAssign));
            ((InstructorInterface.AttributeInterface)((Object)a)).setCanChangeType(attribute.getChildAttributes().isEmpty());
            if (attribute.getType() != null) {
                InstructorInterface.AttributeTypeInterface attributeTypeInterface = new InstructorInterface.AttributeTypeInterface();
                attributeTypeInterface.setId(attribute.getType().getUniqueId());
                attributeTypeInterface.setAbbreviation(attribute.getType().getReference());
                attributeTypeInterface.setLabel(attribute.getType().getLabel());
                attributeTypeInterface.setConjunctive(attribute.getType().isConjunctive());
                attributeTypeInterface.setRequired(attribute.getType().isRequired());
                ((InstructorInterface.AttributeInterface)((Object)a)).setType(attributeTypeInterface);
            }
            if (attribute.getDepartment() != null) {
                InstructorInterface.DepartmentInterface departmentInterface = new InstructorInterface.DepartmentInterface();
                departmentInterface.setId(attribute.getDepartment().getUniqueId());
                departmentInterface.setAbbreviation(attribute.getDepartment().getAbbreviation());
                departmentInterface.setDeptCode(attribute.getDepartment().getDeptCode());
                departmentInterface.setLabel(attribute.getDepartment().getName());
                departmentInterface.setTitle(attribute.getDepartment().getLabel());
                ((InstructorInterface.AttributeInterface)((Object)a)).setDepartment(departmentInterface);
            }
            response.addAttribute((InstructorInterface.AttributeInterface)((Object)a));
        }
        NameFormat instructorNameFormat = NameFormat.fromReference(UserProperty.NameFormat.get(context.getUser()));
        boolean sortByLastName = CommonValues.SortByLastName.eq(UserProperty.SortNames.get(context.getUser()));
        for (DepartmentalInstructor departmentalInstructor : DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor i where i.department.uniqueId = :departmentId").setLong("departmentId", offering.getDepartment().getUniqueId().longValue()).setCacheable(true).list()) {
            void var10_19;
            PreferenceLevel preferenceLevel;
            InstructorInterface i = new InstructorInterface();
            i.setId(departmentalInstructor.getUniqueId());
            i.setFirstName(departmentalInstructor.getFirstName());
            i.setMiddleName(departmentalInstructor.getMiddleName());
            i.setLastName(departmentalInstructor.getLastName());
            i.setFormattedName(instructorNameFormat.format(departmentalInstructor));
            if (sortByLastName) {
                i.setOrderName(departmentalInstructor.nameLastNameFirst());
            }
            i.setExternalId(departmentalInstructor.getExternalUniqueId());
            if (departmentalInstructor.getPositionType() != null) {
                InstructorInterface.PositionInterface positionInterface = new InstructorInterface.PositionInterface();
                positionInterface.setId(departmentalInstructor.getPositionType().getUniqueId());
                positionInterface.setAbbreviation(departmentalInstructor.getPositionType().getReference());
                positionInterface.setLabel(departmentalInstructor.getPositionType().getLabel());
                positionInterface.setSortOrder(departmentalInstructor.getPositionType().getSortOrder());
                i.setPosition(positionInterface);
            }
            if ((preferenceLevel = departmentalInstructor.getTeachingPreference()) == null) {
                PreferenceLevel preferenceLevel2 = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sProhibited);
            }
            i.setTeachingPreference(new InstructorInterface.PreferenceInterface(var10_19.getUniqueId(), PreferenceLevel.prolog2color(var10_19.getPrefProlog()), var10_19.getPrefProlog(), var10_19.getPrefName(), var10_19.getAbbreviation(), true));
            i.setMaxLoad(departmentalInstructor.getMaxLoad());
            response.addInstructor(i);
        }
        for (PreferenceLevel preferenceLevel : PreferenceLevel.getPreferenceLevelList()) {
            response.addPreference(new InstructorInterface.PreferenceInterface(preferenceLevel.getUniqueId(), PreferenceLevel.prolog2bgColor(preferenceLevel.getPrefProlog()), preferenceLevel.getPrefProlog(), preferenceLevel.getPrefName(), preferenceLevel.getAbbreviation(), true));
        }
        HashMap<Long, TeachingRequestInterface.Responsibility> responsibilities = new HashMap<Long, TeachingRequestInterface.Responsibility>();
        for (TeachingResponsibility responsibility : TeachingResponsibilityDAO.getInstance().getSession().createQuery("from TeachingResponsibility order by label").setCacheable(true).list()) {
            TeachingRequestInterface.Responsibility responsibility2 = new TeachingRequestInterface.Responsibility();
            responsibility2.setId(responsibility.getUniqueId());
            responsibility2.setAbbv(responsibility.getAbbreviation());
            responsibility2.setName(responsibility.getLabel());
            responsibility2.setCoordinator(responsibility.isCoordinator());
            responsibility2.setInstructor(responsibility.isInstructor());
            response.addResponsibility(responsibility2);
            responsibilities.put(responsibility.getUniqueId(), responsibility2);
        }
        HashMap<TeachingRequest, TeachingRequestInterface.Request> hashMap = new HashMap<TeachingRequest, TeachingRequestInterface.Request>();
        for (TeachingRequest teachingRequest : offering.getTeachingRequests()) {
            TeachingRequestInterface.Request req;
            TeachingClassRequest master;
            if (teachingRequest.isStandard(master = teachingRequest.getMasterRequest(true)) && !teachingRequest.isAssignCoordinator().booleanValue()) {
                req = null;
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (!((TeachingRequest)entry.getKey()).canCombine(teachingRequest)) continue;
                    req = (TeachingRequestInterface.MultiRequest)entry.getValue();
                    break;
                }
                if (req == null) {
                    req = new TeachingRequestInterface.MultiRequest();
                    req.setAssignCoordinator(false);
                    req.setPercentShare(0);
                    req.setSameCommonPreference(teachingRequest.getSameCommonPart() == null ? null : teachingRequest.getSameCommonPart().getUniqueId());
                    req.setSameCoursePreference(teachingRequest.getSameCoursePreference() == null ? null : teachingRequest.getSameCoursePreference().getUniqueId());
                    req.setTeachingLoad(teachingRequest.getTeachingLoad().floatValue());
                    req.setTeachingResponsibility(teachingRequest.getResponsibility() == null ? null : (TeachingRequestInterface.Responsibility)responsibilities.get(teachingRequest.getResponsibility().getUniqueId()));
                    response.addRequest(req);
                    HashSet<SchedulingSubpart> subparts = new HashSet<SchedulingSubpart>();
                    for (TeachingClassRequest cr : teachingRequest.getClassRequests()) {
                        if (!subparts.add(cr.getTeachingClass().getSchedulingSubpart())) continue;
                        TeachingRequestInterface.IncludeLine include = new TeachingRequestInterface.IncludeLine();
                        include.setAssign(cr.isAssignInstructor());
                        include.setCommon(cr.isCommon());
                        include.setCanOverlap(cr.isCanOverlap());
                        include.setLead(cr.isLead());
                        include.setShare(cr.getPercentShare() == null ? 0 : cr.getPercentShare());
                        include.setOwnerId(cr.getTeachingClass().getSchedulingSubpart().getUniqueId());
                        ((TeachingRequestInterface.MultiRequest)req).addSubpart(include);
                    }
                    for (Preference pref : new TreeSet<Preference>(teachingRequest.getPreferences())) {
                        TeachingRequestInterface.Preference p;
                        if (pref instanceof InstructorPref) {
                            p = new TeachingRequestInterface.Preference();
                            p.setPreferenceId(pref.getPrefLevel().getUniqueId());
                            p.setOwnerId(((InstructorPref)pref).getInstructor().getUniqueId());
                            req.addInstructorPreference(p);
                            continue;
                        }
                        if (!(pref instanceof InstructorAttributePref)) continue;
                        p = new TeachingRequestInterface.Preference();
                        p.setPreferenceId(pref.getPrefLevel().getUniqueId());
                        p.setOwnerId(((InstructorAttributePref)pref).getAttribute().getUniqueId());
                        req.addAttributePreference(p);
                    }
                    hashMap.put(teachingRequest, req);
                }
                TeachingRequestInterface.RequestedClass rc = new TeachingRequestInterface.RequestedClass();
                rc.setNbrInstructors(teachingRequest.getNbrInstructors());
                rc.setClassId(master.getTeachingClass().getUniqueId());
                rc.setInstructorIds(GetTeachingRequestBackend.toInstructorIds(teachingRequest));
                rc.setRequestId(teachingRequest.getUniqueId());
                ((TeachingRequestInterface.MultiRequest)req).addClass(rc);
                continue;
            }
            req = new TeachingRequestInterface.SingleRequest();
            ((TeachingRequestInterface.SingleRequest)req).setRequestId(teachingRequest.getUniqueId());
            ((TeachingRequestInterface.SingleRequest)req).setInstructorIds(GetTeachingRequestBackend.toInstructorIds(teachingRequest));
            ((TeachingRequestInterface.SingleRequest)req).setNbrInstructors(teachingRequest.getNbrInstructors());
            req.setAssignCoordinator(teachingRequest.isAssignCoordinator());
            req.setPercentShare(teachingRequest.getPercentShare());
            req.setSameCommonPreference(teachingRequest.getSameCommonPart() == null ? null : teachingRequest.getSameCommonPart().getUniqueId());
            req.setSameCoursePreference(teachingRequest.getSameCoursePreference() == null ? null : teachingRequest.getSameCoursePreference().getUniqueId());
            req.setTeachingLoad(teachingRequest.getTeachingLoad().floatValue());
            req.setTeachingResponsibility(teachingRequest.getResponsibility() == null ? null : (TeachingRequestInterface.Responsibility)responsibilities.get(teachingRequest.getResponsibility().getUniqueId()));
            for (TeachingClassRequest teachingClassRequest : teachingRequest.getClassRequests()) {
                TeachingRequestInterface.IncludeLine include = new TeachingRequestInterface.IncludeLine();
                include.setAssign(teachingClassRequest.isAssignInstructor());
                include.setCommon(teachingClassRequest.isCommon());
                include.setCanOverlap(teachingClassRequest.isCanOverlap());
                include.setLead(teachingClassRequest.isLead());
                include.setShare(teachingClassRequest.getPercentShare() == null ? 0 : teachingClassRequest.getPercentShare());
                include.setOwnerId(teachingClassRequest.getTeachingClass().getUniqueId());
                ((TeachingRequestInterface.SingleRequest)req).addClass(include);
            }
            for (Preference preference : new TreeSet<Preference>(teachingRequest.getPreferences())) {
                TeachingRequestInterface.Preference p;
                if (preference instanceof InstructorPref) {
                    p = new TeachingRequestInterface.Preference();
                    p.setPreferenceId(preference.getPrefLevel().getUniqueId());
                    p.setOwnerId(((InstructorPref)preference).getInstructor().getUniqueId());
                    req.addInstructorPreference(p);
                    continue;
                }
                if (!(preference instanceof InstructorAttributePref)) continue;
                p = new TeachingRequestInterface.Preference();
                p.setPreferenceId(preference.getPrefLevel().getUniqueId());
                p.setOwnerId(((InstructorAttributePref)preference).getAttribute().getUniqueId());
                req.addAttributePreference(p);
            }
            response.addRequest(req);
        }
        return response;
    }

    public static List<Long> toInstructorIds(TeachingRequest request) {
        if (request.getAssignedInstructors() == null || request.getAssignedInstructors().isEmpty()) {
            return null;
        }
        ArrayList<DepartmentalInstructor> instructors = new ArrayList<DepartmentalInstructor>(request.getAssignedInstructors());
        Collections.sort(instructors);
        ArrayList<Long> ret = new ArrayList<Long>(instructors.size());
        for (DepartmentalInstructor instructor : instructors) {
            ret.add(instructor.getUniqueId());
        }
        return ret;
    }
}

