/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.NameFormat;

@GwtRpcImplements(value=InstructorInterface.GetInstructorAttributesRequest.class)
public class GetInstructorAttributesBackend
implements GwtRpcImplementation<InstructorInterface.GetInstructorAttributesRequest, GwtRpcResponseList<InstructorInterface.AttributeInterface>> {
    @Override
    public GwtRpcResponseList<InstructorInterface.AttributeInterface> execute(InstructorInterface.GetInstructorAttributesRequest request, SessionContext context) {
        context.checkPermission(request.getDepartmentId(), "Department", Right.InstructorAttributes);
        NameFormat instructorNameFormat = NameFormat.fromReference(UserProperty.NameFormat.get(context.getUser()));
        boolean sortByLastName = CommonValues.SortByLastName.eq(UserProperty.SortNames.get(context.getUser()));
        GwtRpcResponseList<InstructorInterface.AttributeInterface> response = new GwtRpcResponseList<InstructorInterface.AttributeInterface>();
        for (InstructorAttribute attribute : InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute a where a.session.uniqueId = :sessionId and (a.department is null or a.department.uniqueId = :departmentId) order by a.name").setLong("sessionId", context.getUser().getCurrentAcademicSessionId().longValue()).setLong("departmentId", request.getDepartmentId().longValue()).setCacheable(true).list()) {
            InstructorInterface.AttributeInterface a = new InstructorInterface.AttributeInterface();
            a.setId(attribute.getUniqueId());
            a.setParentId(attribute.getParentAttribute() == null ? null : attribute.getParentAttribute().getUniqueId());
            a.setParentName(attribute.getParentAttribute() == null ? null : attribute.getParentAttribute().getName());
            a.setCode(attribute.getCode());
            a.setName(attribute.getName());
            a.setCanDelete(context.hasPermission(attribute, Right.InstructorAttributeDelete));
            a.setCanEdit(context.hasPermission(attribute, Right.InstructorAttributeEdit));
            a.setCanAssign(context.hasPermission(attribute, Right.InstructorAttributeAssign));
            a.setCanChangeType(attribute.getChildAttributes().isEmpty());
            if (attribute.getType() != null) {
                InstructorInterface.AttributeTypeInterface t = new InstructorInterface.AttributeTypeInterface();
                t.setId(attribute.getType().getUniqueId());
                t.setAbbreviation(attribute.getType().getReference());
                t.setLabel(attribute.getType().getLabel());
                t.setConjunctive(attribute.getType().isConjunctive());
                t.setRequired(attribute.getType().isRequired());
                a.setType(t);
            }
            if (attribute.getDepartment() != null) {
                InstructorInterface.DepartmentInterface d = new InstructorInterface.DepartmentInterface();
                d.setId(attribute.getDepartment().getUniqueId());
                d.setAbbreviation(attribute.getDepartment().getAbbreviation());
                d.setDeptCode(attribute.getDepartment().getDeptCode());
                d.setLabel(attribute.getDepartment().getName());
                d.setTitle(attribute.getDepartment().getLabel());
                a.setDepartment(d);
            }
            for (DepartmentalInstructor instructor : attribute.getInstructors()) {
                PreferenceLevel pref;
                if (!instructor.getDepartment().getUniqueId().equals(request.getDepartmentId())) continue;
                InstructorInterface i = new InstructorInterface();
                i.setId(instructor.getUniqueId());
                i.setFirstName(instructor.getFirstName());
                i.setMiddleName(instructor.getMiddleName());
                i.setLastName(instructor.getLastName());
                i.setFormattedName(instructorNameFormat.format(instructor));
                if (sortByLastName) {
                    i.setOrderName(instructor.nameLastNameFirst());
                }
                i.setExternalId(instructor.getExternalUniqueId());
                if (instructor.getPositionType() != null) {
                    InstructorInterface.PositionInterface p = new InstructorInterface.PositionInterface();
                    p.setId(instructor.getPositionType().getUniqueId());
                    p.setAbbreviation(instructor.getPositionType().getReference());
                    p.setLabel(instructor.getPositionType().getLabel());
                    p.setSortOrder(instructor.getPositionType().getSortOrder());
                    i.setPosition(p);
                }
                if ((pref = instructor.getTeachingPreference()) == null) {
                    pref = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sProhibited);
                }
                i.setTeachingPreference(new InstructorInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2bgColor(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), true));
                i.setMaxLoad(instructor.getMaxLoad());
                a.addInstructor(i);
            }
            response.add(a);
        }
        return response;
    }
}

