/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.departments;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.gwt.client.departments.DepartmentsEdit;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.DepartmentInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExternalDepartmentStatusType;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseExternalDepartmentStatusType;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=DepartmentsEdit.UpdateDepartmentRequest.class)
public class UpdateDepartmentBackend
implements GwtRpcImplementation<DepartmentsEdit.UpdateDepartmentRequest, DepartmentInterface> {
    @Override
    public DepartmentInterface execute(DepartmentsEdit.UpdateDepartmentRequest request, SessionContext context) {
        org.hibernate.Session hibSession = DepartmentDAO.getInstance().getSession();
        Department department = null;
        switch (request.getAction()) {
            case CREATE: {
                context.checkPermission(Right.DepartmentAdd);
                department = this.saveOrUpdate(request.getDepartment(), context);
                ChangeLog.addChange(hibSession, context, department, ChangeLog.Source.DEPARTMENT_EDIT, ChangeLog.Operation.CREATE, null, department);
                break;
            }
            case UPDATE: {
                context.checkPermission(request.getDepartment().getId(), "Department", Right.DepartmentEdit);
                department = this.saveOrUpdate(request.getDepartment(), context);
                ChangeLog.addChange(hibSession, context, department, ChangeLog.Source.DEPARTMENT_EDIT, ChangeLog.Operation.UPDATE, null, department);
                break;
            }
            case DELETE: {
                context.checkPermission(request.getDepartment().getId(), "Department", Right.DepartmentDelete);
                department = (Department)DepartmentDAO.getInstance().get(request.getDepartment().getId(), hibSession);
                ChangeLog.addChange(hibSession, context, department, ChangeLog.Source.DEPARTMENT_EDIT, ChangeLog.Operation.DELETE, null, null);
                this.delete(request.getDepartment(), context);
            }
        }
        hibSession.flush();
        return request.getDepartment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Department saveOrUpdate(DepartmentInterface departmentInterface, SessionContext context) throws GwtRpcException {
        Department department = null;
        try {
            Session acadSession = null;
            org.hibernate.Session hibSession = DepartmentDAO.getInstance().getSession();
            try {
                if (departmentInterface.getId() != null) {
                    department = (Department)DepartmentDAO.getInstance().get(departmentInterface.getId(), hibSession);
                }
                if (department == null) {
                    department = new Department();
                    acadSession = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
                    department.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
                    department.setDistributionPrefPriority(0);
                    acadSession.addTodepartments(department);
                    department.setExternalStatusTypes(new HashSet<ExternalDepartmentStatusType>());
                }
                department.setDeptCode(departmentInterface.getDeptCode());
                department.setAllowReqTime(departmentInterface.getAllowReqTime());
                department.setAbbreviation(departmentInterface.getAbbreviation());
                department.setName(departmentInterface.getName());
                department.setExternalUniqueId((String)(departmentInterface.getExternalId() != null && departmentInterface.getExternalId().isEmpty() ? null : departmentInterface.getExternalId()));
                department.setDistributionPrefPriority(departmentInterface.getDistributionPrefPriority());
                department.setExternalManager(departmentInterface.getExternalManager());
                department.setExternalMgrAbbv(departmentInterface.getExternalMgrAbbv());
                department.setAllowReqDistribution(departmentInterface.getAllowReqDistribution());
                department.setExternalFundingDept(departmentInterface.getExternalFundingDept());
                department.setExternalMgrLabel(departmentInterface.getExternalMgrLabel());
                department.setAllowReqRoom(departmentInterface.getAllowReqRoom());
                department.setAllowEvents(departmentInterface.getAllowEvents());
                department.setAllowStudentScheduling(departmentInterface.getAllowStudentScheduling());
                department.setInheritInstructorPreferences(departmentInterface.getInheritInstructorPreferences());
                department.setStatusType(DepartmentStatusType.findByRef(departmentInterface.getStatusTypeStr()));
                ArrayList<ExternalDepartmentStatusType> statuses = new ArrayList<ExternalDepartmentStatusType>(department.getExternalStatusTypes());
                if (department.isExternalManager().booleanValue()) {
                    for (int i = 0; i < Math.min(departmentInterface.iDependentDepartments.size(), departmentInterface.iDependentStatuses.size()); ++i) {
                        Long deptId = Long.valueOf(departmentInterface.iDependentDepartments.get(i));
                        String status = departmentInterface.iDependentStatuses.get(i);
                        DepartmentStatusType d = DepartmentStatusType.findByRef(status);
                        if (deptId < 0L || status.isEmpty()) continue;
                        BaseExternalDepartmentStatusType t = null;
                        Iterator j = statuses.iterator();
                        while (j.hasNext()) {
                            ExternalDepartmentStatusType x = (ExternalDepartmentStatusType)j.next();
                            if (!deptId.equals(x.getDepartment().getUniqueId())) continue;
                            j.remove();
                            t = x;
                            break;
                        }
                        if (t == null) {
                            t = new ExternalDepartmentStatusType();
                            t.setExternalDepartment(department);
                            t.setDepartment((Department)DepartmentDAO.getInstance().get(deptId));
                            department.getExternalStatusTypes().add((ExternalDepartmentStatusType)t);
                        }
                        t.setStatusType(d);
                    }
                }
                for (ExternalDepartmentStatusType t : statuses) {
                    department.getExternalStatusTypes().remove(t);
                    hibSession.delete((Object)t);
                }
                if (department.getUniqueId() == null) {
                    departmentInterface.setId((Long)hibSession.save((Object)department));
                } else {
                    hibSession.update((Object)department);
                }
            }
            finally {
                hibSession.flush();
            }
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GwtRpcException(e.getMessage(), e);
        }
        return department;
    }

    protected void delete(DepartmentInterface DepartmentInterface2, SessionContext context) throws GwtRpcException {
        context.checkPermission(DepartmentInterface2.getId(), "Department", Right.DepartmentDelete);
        org.hibernate.Session hibSession = DepartmentDAO.getInstance().getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            Department department = (Department)new DepartmentDAO().get(DepartmentInterface2.getId(), hibSession);
            if (department.isExternalManager().booleanValue()) {
                Iterator i = hibSession.createQuery("select c from Class_ c where c.managingDept.uniqueId=:deptId").setLong("deptId", department.getUniqueId().longValue()).iterate();
                while (i.hasNext()) {
                    Preference pref;
                    Iterator<Preference> j;
                    Class_ clazz = (Class_)i.next();
                    if (clazz.getSchedulingSubpart().getManagingDept().equals(department)) {
                        j = clazz.getSchedulingSubpart().getPreferences().iterator();
                        while (j.hasNext()) {
                            pref = j.next();
                            if (pref instanceof TimePref) continue;
                            j.remove();
                        }
                        clazz.getSchedulingSubpart().deleteAllDistributionPreferences(hibSession);
                        hibSession.saveOrUpdate((Object)clazz.getSchedulingSubpart());
                    }
                    clazz.setManagingDept(clazz.getControllingDept(), context.getUser(), hibSession);
                    j = clazz.getPreferences().iterator();
                    while (j.hasNext()) {
                        pref = j.next();
                        if (pref instanceof TimePref) continue;
                        j.remove();
                    }
                    clazz.deleteAllDistributionPreferences(hibSession);
                    hibSession.saveOrUpdate((Object)clazz);
                }
            } else {
                hibSession.createQuery("delete StudentClassEnrollment e where e.clazz.uniqueId in (select c.uniqueId from Class_ c, CourseOffering co where co.isControl=true and c.schedulingSubpart.instrOfferingConfig.instructionalOffering=co.instructionalOffering and co.subjectArea.department.uniqueId=:deptId)").setLong("deptId", department.getUniqueId().longValue()).executeUpdate();
            }
            hibSession.delete((Object)department);
            tx.commit();
            HibernateUtil.clearCache();
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }
}

