/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.curricula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.CurriculumInterface;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.FilterBoxBackend;
import org.unitime.timetable.util.Constants;

@GwtRpcImplements(value=CurriculumInterface.CurriculumFilterRpcRequest.class)
public class CurriculumFilterBackend
extends FilterBoxBackend<CurriculumInterface.CurriculumFilterRpcRequest> {
    @Override
    public EventInterface.FilterRpcResponse execute(CurriculumInterface.CurriculumFilterRpcRequest request, SessionContext context) {
        context.checkPermission(Right.CurriculumView);
        return super.execute(request, context);
    }

    @Override
    public void load(CurriculumInterface.CurriculumFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
        TreeSet<Department> userDepts = Department.getUserDepartments(context.getUser());
        HashMap<Long, EventInterface.FilterRpcResponse.Entity> areas = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
        for (Curriculum curriculum : CurriculumFilterBackend.curricula(request.getSessionId(), request.getOptions(), null, -1, "area", userDepts)) {
            EventInterface.FilterRpcResponse.Entity area = (EventInterface.FilterRpcResponse.Entity)areas.get(curriculum.getAcademicArea().getUniqueId());
            if (area == null) {
                area = new EventInterface.FilterRpcResponse.Entity(curriculum.getAcademicArea().getUniqueId(), curriculum.getAcademicArea().getAcademicAreaAbbreviation(), Constants.curriculaToInitialCase(curriculum.getAcademicArea().getTitle()), new String[0]);
                areas.put(area.getUniqueId(), area);
            }
            area.incCount();
        }
        response.add("area", new TreeSet<EventInterface.FilterRpcResponse.Entity>(areas.values()));
        if (request.hasOption("area")) {
            HashMap<Long, EventInterface.FilterRpcResponse.Entity> majors = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
            for (Curriculum curriculum : CurriculumFilterBackend.curricula(request.getSessionId(), request.getOptions(), null, -1, "major", userDepts)) {
                for (PosMajor m : curriculum.getMajors()) {
                    EventInterface.FilterRpcResponse.Entity major = (EventInterface.FilterRpcResponse.Entity)majors.get(m.getUniqueId());
                    if (major != null) continue;
                    major = new EventInterface.FilterRpcResponse.Entity(m.getUniqueId(), m.getCode(), Constants.curriculaToInitialCase(m.getName()), new String[0]);
                    majors.put(major.getUniqueId(), major);
                }
            }
            response.add("major", new TreeSet<EventInterface.FilterRpcResponse.Entity>(majors.values()));
        }
        HashMap<Long, EventInterface.FilterRpcResponse.Entity> classifications = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
        for (Curriculum curriculum : CurriculumFilterBackend.curricula(request.getSessionId(), request.getOptions(), null, -1, "classification", userDepts)) {
            for (CurriculumClassification cc : curriculum.getClassifications()) {
                EventInterface.FilterRpcResponse.Entity classification = (EventInterface.FilterRpcResponse.Entity)classifications.get(cc.getAcademicClassification().getUniqueId());
                if (classification == null) {
                    classification = new EventInterface.FilterRpcResponse.Entity(cc.getAcademicClassification().getUniqueId(), cc.getAcademicClassification().getCode(), Constants.curriculaToInitialCase(cc.getAcademicClassification().getName()), new String[0]);
                    classifications.put(classification.getUniqueId(), classification);
                }
                classification.incCount();
            }
        }
        response.add("classification", new TreeSet<EventInterface.FilterRpcResponse.Entity>(classifications.values()));
        EventInterface.FilterRpcResponse.Entity entity = new EventInterface.FilterRpcResponse.Entity(-1L, "Managed", "Managed Curricula", new String[0]);
        HashMap<Long, EventInterface.FilterRpcResponse.Entity> departments = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
        for (Curriculum curriculum : CurriculumFilterBackend.curricula(request.getSessionId(), request.getOptions(), null, -1, "department", userDepts)) {
            EventInterface.FilterRpcResponse.Entity department = (EventInterface.FilterRpcResponse.Entity)departments.get(curriculum.getDepartment().getUniqueId());
            if (department == null) {
                department = new EventInterface.FilterRpcResponse.Entity(curriculum.getDepartment().getUniqueId(), curriculum.getDepartment().getDeptCode(), curriculum.getDepartment().getDeptCode() + " - " + curriculum.getDepartment().getName() + (curriculum.getDepartment().isExternalManager() != false ? " (" + curriculum.getDepartment().getExternalMgrLabel() + ")" : ""), new String[0]);
                departments.put(department.getUniqueId(), department);
            }
            department.incCount();
            if (!userDepts.contains(curriculum.getDepartment())) continue;
            entity.incCount();
        }
        if (entity.getCount() > 0) {
            response.add("department", entity);
        }
        response.add("department", new TreeSet<EventInterface.FilterRpcResponse.Entity>(departments.values()));
    }

    public static List<Curriculum> curricula(Long sessionId, Map<String, Set<String>> options, Query query, int limit, String ignoreCommand, Set<Department> userDepartments) {
        Session hibSession = CurriculumDAO.getInstance().getSession();
        Set<String> area = options == null || "area".equals(ignoreCommand) ? null : options.get("area");
        Set<String> major = options == null || "major".equals(ignoreCommand) ? null : options.get("major");
        Set<String> department = options == null || "department".equals(ignoreCommand) ? null : options.get("department");
        Set<String> classification = options == null || "classification".equals(ignoreCommand) ? null : options.get("classification");
        Set<String> nameOrAbbv = options == null || "curriculum".equals(ignoreCommand) ? null : options.get("curriculum");
        List curricula = hibSession.createQuery("select distinct c from Curriculum c where c.department.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        ArrayList<Curriculum> ret = new ArrayList<Curriculum>();
        block0: for (Curriculum curriculum : curricula) {
            if (nameOrAbbv != null && !nameOrAbbv.isEmpty()) {
                for (String fragment : nameOrAbbv) {
                    if (fragment.isEmpty() || fragment.equalsIgnoreCase(curriculum.getAbbv()) || fragment.equalsIgnoreCase(curriculum.getName())) continue;
                    block2: for (String word : fragment.split(" ")) {
                        for (String term : curriculum.getName().split(" ")) {
                            if (word.equalsIgnoreCase(term)) continue block2;
                        }
                        continue block0;
                    }
                }
            }
            if (query != null && !query.match(new CurriculumMatcher(curriculum, userDepartments)) || area != null && !area.isEmpty() && !area.contains(curriculum.getAcademicArea().getAcademicAreaAbbreviation()) && !area.contains(Constants.curriculaToInitialCase(curriculum.getAcademicArea().getTitle())) || department != null && !department.isEmpty() && (!department.contains("Managed") ? !department.contains(curriculum.getDepartment().getDeptCode()) : !userDepartments.contains(curriculum.getDepartment()))) continue;
            if (major != null && !major.isEmpty()) {
                boolean found = false;
                for (PosMajor m : curriculum.getMajors()) {
                    if (!major.contains(m.getCode()) && !major.contains(Constants.curriculaToInitialCase(m.getName()))) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (classification != null && !classification.isEmpty()) {
                boolean found = false;
                for (CurriculumClassification cc : curriculum.getClassifications()) {
                    if (!classification.contains(cc.getName()) && !classification.contains(cc.getAcademicClassification().getCode()) && !classification.contains(Constants.curriculaToInitialCase(cc.getAcademicClassification().getName()))) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            ret.add(curriculum);
        }
        return ret;
    }

    private String suggestionQuery(String query) {
        if (query == null || query.isEmpty()) {
            return query;
        }
        if (!query.contains(":") && !query.contains("\"")) {
            return query + " || starts:\"" + query + "\"";
        }
        return query;
    }

    @Override
    public void suggestions(CurriculumInterface.CurriculumFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
        for (Curriculum curriculum : CurriculumFilterBackend.curricula(request.getSessionId(), request.getOptions(), new Query(this.suggestionQuery(request.getText())), 20, null, Department.getUserDepartments(context.getUser()))) {
            response.addSuggestion(curriculum.getAbbv(), curriculum.getAbbv(), "(" + curriculum.getName() + ")");
        }
    }

    @Override
    public void enumarate(CurriculumInterface.CurriculumFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
        for (Curriculum curriculum : CurriculumFilterBackend.curricula(request.getSessionId(), request.getOptions(), new Query(request.getText()), -1, null, Department.getUserDepartments(context.getUser()))) {
            response.addResult(new EventInterface.FilterRpcResponse.Entity(curriculum.getUniqueId(), curriculum.getAbbv(), curriculum.getName(), "department", curriculum.getDepartment().getDeptCode()));
        }
    }

    public static class CurriculumMatcher
    implements Query.TermMatcher {
        private Curriculum iCurriculum;
        private Set<Department> iManaged;

        public CurriculumMatcher(Curriculum c, Set<Department> managed) {
            this.iCurriculum = c;
            this.iManaged = managed;
        }

        @Override
        public boolean match(String attr, String term) {
            if (term.isEmpty()) {
                return true;
            }
            if (attr == null || "dept".equals(attr) || "department".equals(attr)) {
                if (("dept".equals(attr) || "department".equals(attr)) && "managed".equalsIgnoreCase(term)) {
                    return this.iManaged.contains(this.iCurriculum.getDepartment());
                }
                if (this.eq(this.iCurriculum.getDepartment().getDeptCode(), term) || this.eq(this.iCurriculum.getDepartment().getAbbreviation(), term) || this.has(this.iCurriculum.getDepartment().getName(), term)) {
                    return true;
                }
            }
            if ((attr == null || "abbv".equals(attr) || "curriculum".equals(attr) || "abbreviation".equals(attr)) && this.eq(this.iCurriculum.getAbbv(), term)) {
                return true;
            }
            if ((attr == null || "name".equals(attr) || "curriculum".equals(attr)) && this.has(this.iCurriculum.getName(), term)) {
                return true;
            }
            if ("starts".equals(attr)) {
                return this.iCurriculum.getName().startsWith(term) || this.iCurriculum.getAbbv().startsWith(term);
            }
            if ((attr == null || "area".equals(attr)) && (this.eq(this.iCurriculum.getAcademicArea().getAcademicAreaAbbreviation(), term) || this.has(this.iCurriculum.getAcademicArea().getTitle(), term))) {
                return true;
            }
            if (attr == null || "major".equals(attr)) {
                for (PosMajor m : this.iCurriculum.getMajors()) {
                    if (!this.eq(m.getCode(), term) && !this.has(m.getName(), term)) continue;
                    return true;
                }
            }
            if (attr == null || "clasf".equals(attr) || "classification".equals(attr)) {
                for (CurriculumClassification cc : this.iCurriculum.getClassifications()) {
                    if (!this.eq(cc.getName(), term) && !this.eq(cc.getAcademicClassification().getCode(), term) && !this.has(cc.getAcademicClassification().getName(), term)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" ")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }
    }
}

