/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.dao.SolverParameterGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=solverParamGroup]")
public class SolverParameterGroups
implements AdminTable,
AdminTable.HasFilter {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageSolverParamGroup(), MESSAGES.pageSolverParamGroups());
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameterGroups')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        return this.load(null, context, hibSession);
    }

    protected List<SolverParameterGroup> getSolverParameterGroups(String[] filter, SessionContext context) {
        if (filter == null || filter[0] == null || filter[0].isEmpty() || filter[0].equals("null")) {
            context.getUser().setProperty("Admin.SolverParamGroup.FilterType", null);
            return SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterGroup order by order, name").list();
        }
        context.getUser().setProperty("Admin.SolverParamGroup.FilterType", filter[0]);
        return SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterGroup where type = :type order by order, name").setInteger("type", Integer.valueOf(filter[0]).intValue()).list();
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameterGroups')")
    public SimpleEditInterface load(String[] filter, SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> types = new ArrayList<SimpleEditInterface.ListItem>();
        types.add(new SimpleEditInterface.ListItem(String.valueOf(SolverParameterGroup.SolverType.COURSE.ordinal()), MESSAGES.solverCourse()));
        types.add(new SimpleEditInterface.ListItem(String.valueOf(SolverParameterGroup.SolverType.EXAM.ordinal()), MESSAGES.solverExamination()));
        types.add(new SimpleEditInterface.ListItem(String.valueOf(SolverParameterGroup.SolverType.STUDENT.ordinal()), MESSAGES.solverStudent()));
        types.add(new SimpleEditInterface.ListItem(String.valueOf(SolverParameterGroup.SolverType.INSTRUCTOR.ordinal()), MESSAGES.solverInstructor()));
        String defaultType = null;
        if (filter != null && filter[0] != null && !filter[0].isEmpty() && !filter[0].equals("null")) {
            defaultType = filter[0];
        }
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 300, 100, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldType(), SimpleEditInterface.FieldType.list, 200, types, SimpleEditInterface.Flag.NOT_EMPTY).withDefault(defaultType), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 1000, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSaveOrder(false);
        data.setCanMoveUpAndDown(true);
        data.setAllowSort(false);
        for (SolverParameterGroup group : this.getSolverParameterGroups(filter, context)) {
            SimpleEditInterface.Record r = data.addRecord(group.getUniqueId());
            r.setField(0, group.getName());
            r.setField(1, group.getType() == null ? "" : group.getType().toString(), group.getParameters().isEmpty());
            r.setField(2, group.getDescription());
            r.setDeletable(group.getParameters().isEmpty());
        }
        return data;
    }

    protected int nextOrd(Set<Integer> ords) {
        for (int i = 0; i < ords.size() + 1; ++i) {
            if (ords.contains(i)) continue;
            ords.add(i);
            return i;
        }
        return ords.size();
    }

    protected int nextOrd() {
        List groups = SolverParameterGroupDAO.getInstance().findAll();
        int idx = 0;
        block0: while (true) {
            for (SolverParameterGroup t : groups) {
                if (idx != t.getOrder()) continue;
                ++idx;
                continue block0;
            }
            break;
        }
        return idx;
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameterGroups')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        this.save(null, data, context, hibSession);
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameterGroups')")
    public void save(String[] filter, SimpleEditInterface data, SessionContext context, Session hibSession) {
        HashSet<Integer> ords = new HashSet<Integer>();
        if (filter != null && filter[0] != null && !filter[0].isEmpty() && !filter[0].equals("null")) {
            for (SolverParameterGroup group : SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterGroup where type != :type").setInteger("type", Integer.valueOf(filter[0]).intValue()).list()) {
                ords.add(group.getOrder());
            }
        }
        for (SimpleEditInterface.Record r : data.getRecords()) {
            if (r.isEmpty(data)) continue;
            r.setOrder(this.nextOrd(ords));
        }
        for (SolverParameterGroup group : this.getSolverParameterGroups(filter, context)) {
            SimpleEditInterface.Record r = data.getRecord(group.getUniqueId());
            if (r == null) {
                this.delete(group, context, hibSession);
                continue;
            }
            this.update(group, r, r.getOrder(), context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, r.getOrder(), context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameterGroups')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.save(record, null, context, hibSession);
    }

    protected void save(SimpleEditInterface.Record record, Integer order, SessionContext context, Session hibSession) {
        if (order == null) {
            order = this.nextOrd();
        }
        SolverParameterGroup group = new SolverParameterGroup();
        group.setName(record.getField(0));
        group.setType(Integer.valueOf(record.getField(1)));
        group.setDescription(record.getField(2));
        group.setOrder(order);
        record.setUniqueId((Long)hibSession.save((Object)group));
        ChangeLog.addChange(hibSession, context, group, group.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(SolverParameterGroup group, SimpleEditInterface.Record record, Integer order, SessionContext context, Session hibSession) {
        boolean changed;
        if (group == null) {
            return;
        }
        if (order == null) {
            order = group.getOrder();
        }
        boolean bl = changed = !ToolBox.equals((Object)group.getName(), (Object)record.getField(0)) || !ToolBox.equals((Object)group.getType().toString(), (Object)record.getField(1)) || !ToolBox.equals((Object)group.getDescription(), (Object)record.getField(2));
        if (!changed && ToolBox.equals((Object)group.getOrder(), (Object)order)) {
            return;
        }
        group.setName(record.getField(0));
        group.setType(Integer.valueOf(record.getField(1)));
        group.setDescription(record.getField(2));
        group.setOrder(order);
        hibSession.saveOrUpdate((Object)group);
        if (changed) {
            ChangeLog.addChange(hibSession, context, group, group.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameterGroups')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((SolverParameterGroup)SolverParameterGroupDAO.getInstance().get(record.getUniqueId(), hibSession), record, null, context, hibSession);
    }

    protected void delete(SolverParameterGroup group, SessionContext context, Session hibSession) {
        if (group == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, group, group.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)group);
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameterGroups')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((SolverParameterGroup)SolverParameterGroupDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameterGroups')")
    public SimpleEditInterface.Filter getFilter(SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> types = new ArrayList<SimpleEditInterface.ListItem>();
        types.add(new SimpleEditInterface.ListItem("", MESSAGES.itemAll()));
        types.add(new SimpleEditInterface.ListItem(String.valueOf(SolverParameterGroup.SolverType.COURSE.ordinal()), MESSAGES.solverCourse()));
        types.add(new SimpleEditInterface.ListItem(String.valueOf(SolverParameterGroup.SolverType.EXAM.ordinal()), MESSAGES.solverExamination()));
        types.add(new SimpleEditInterface.ListItem(String.valueOf(SolverParameterGroup.SolverType.STUDENT.ordinal()), MESSAGES.solverStudent()));
        types.add(new SimpleEditInterface.ListItem(String.valueOf(SolverParameterGroup.SolverType.INSTRUCTOR.ordinal()), MESSAGES.solverInstructor()));
        SimpleEditInterface.Filter filter = new SimpleEditInterface.Filter(new SimpleEditInterface.Field(MESSAGES.fieldType(), SimpleEditInterface.FieldType.list, 100, types, new SimpleEditInterface.Flag[0]));
        String lastId = context.getUser().getProperty("Admin.SolverParamGroup.FilterType");
        if (lastId != null) {
            filter.getDefaultValue().setField(0, lastId);
        }
        return filter;
    }
}

