/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.LearningManagementSystemInfoDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=lmsInfo]")
public class LearningManagementSystemInfos
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageLearningManagementSystemInfo(), MESSAGES.pageLearningManagementSystemInfos());
    }

    @Override
    @PreAuthorize(value="checkPermission('LearningManagementSystemInfos')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldDefault(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]));
        data.setSortBy(1, 2, 3);
        for (LearningManagementSystemInfo lmsInfo : LearningManagementSystemInfoDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(lmsInfo.getUniqueId());
            r.setField(0, lmsInfo.getReference());
            r.setField(1, lmsInfo.getLabel());
            r.setField(2, lmsInfo.getExternalUniqueId());
            r.setField(3, lmsInfo.isDefaultLms() != false ? "true" : "false");
            r.setDeletable(lmsInfo.isDefaultLms() == false && !lmsInfo.isUsed(hibSession));
        }
        data.setEditable(context.hasPermission(Right.LearningManagementSystemInfoEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('LearningManagementSystemInfoEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (LearningManagementSystemInfo lmsInfo : LearningManagementSystemInfoDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(lmsInfo.getUniqueId());
            if (r == null) {
                this.delete(lmsInfo, context, hibSession);
                continue;
            }
            this.update(lmsInfo, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('LearningManagementSystemInfoEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        LearningManagementSystemInfo lmsInfo = new LearningManagementSystemInfo();
        lmsInfo.setReference(record.getField(0));
        lmsInfo.setLabel(record.getField(1));
        lmsInfo.setExternalUniqueId(record.getField(2));
        lmsInfo.setDefaultLms("true".equalsIgnoreCase(record.getField(3)));
        lmsInfo.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        record.setUniqueId((Long)hibSession.save((Object)lmsInfo));
        ChangeLog.addChange(hibSession, context, lmsInfo, lmsInfo.getReference() + " " + lmsInfo.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(LearningManagementSystemInfo lmsInfo, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (lmsInfo == null) {
            return;
        }
        if (ToolBox.equals((Object)lmsInfo.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)lmsInfo.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)lmsInfo.getExternalUniqueId(), (Object)record.getField(2)) && ToolBox.equals((Object)lmsInfo.getDefaultLms(), (Object)"true".equalsIgnoreCase(record.getField(3)))) {
            return;
        }
        lmsInfo.setReference(record.getField(0));
        lmsInfo.setLabel(record.getField(1));
        lmsInfo.setExternalUniqueId(record.getField(2));
        lmsInfo.setDefaultLms("true".equalsIgnoreCase(record.getField(3)));
        hibSession.saveOrUpdate((Object)lmsInfo);
        ChangeLog.addChange(hibSession, context, lmsInfo, lmsInfo.getReference() + " " + lmsInfo.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('LearningManagementSystemInfoEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((LearningManagementSystemInfo)LearningManagementSystemInfoDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(LearningManagementSystemInfo lmsInfo, SessionContext context, org.hibernate.Session hibSession) {
        if (lmsInfo == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, lmsInfo, lmsInfo.getReference() + " " + lmsInfo.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)lmsInfo);
    }

    @Override
    @PreAuthorize(value="checkPermission('LearningManagementSystemInfoEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((LearningManagementSystemInfo)LearningManagementSystemInfoDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

