/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.dao.PosMajorConcentrationDAO;
import org.unitime.timetable.model.dao.PosMajorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=concentration]")
public class Concentrations
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageConcentration(), MESSAGES.pageConcentrations());
    }

    @Override
    @PreAuthorize(value="checkPermission('Concentrations')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> majors = new ArrayList<SimpleEditInterface.ListItem>();
        for (PosMajor major : PosMajorDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            AcademicArea area = null;
            Iterator<AcademicArea> iterator = major.getAcademicAreas().iterator();
            if (iterator.hasNext()) {
                AcademicArea a;
                area = a = iterator.next();
            }
            majors.add(new SimpleEditInterface.ListItem(major.getUniqueId().toString(), (area != null ? area.getAcademicAreaAbbreviation() + "/" : "") + major.getCode() + " - " + major.getName()));
        }
        Collections.sort(majors);
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldCode(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 100, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldMajor(), SimpleEditInterface.FieldType.list, 300, majors, new SimpleEditInterface.Flag[0]));
        data.setSortBy(3, 1, 2);
        for (PosMajorConcentration conc : PosMajorConcentration.findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(conc.getUniqueId());
            r.setField(0, conc.getExternalUniqueId());
            r.setField(1, conc.getCode());
            r.setField(2, conc.getName());
            r.setDeletable(conc.getExternalUniqueId() == null);
            r.setField(3, conc.getMajor().getUniqueId().toString(), false);
        }
        data.setEditable(context.hasPermission(Right.ConcentrationEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('ConcentrationEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (PosMajorConcentration conc : PosMajorConcentration.findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(conc.getUniqueId());
            if (r == null) {
                this.delete(conc, context, hibSession);
                continue;
            }
            this.update(conc, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('ConcentrationEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        PosMajorConcentration conc = new PosMajorConcentration();
        conc.setExternalUniqueId(record.getField(0));
        conc.setCode(record.getField(1));
        conc.setName(record.getField(2));
        PosMajor major = (PosMajor)PosMajorDAO.getInstance().get(Long.valueOf(record.getField(3)), hibSession);
        conc.setMajor(major);
        major.getConcentrations().add(conc);
        record.setUniqueId((Long)hibSession.save((Object)conc));
        ChangeLog.addChange(hibSession, context, conc, conc.getCode() + " " + conc.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(PosMajorConcentration conc, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (conc == null) {
            return;
        }
        if (!(ToolBox.equals((Object)conc.getExternalUniqueId(), (Object)record.getField(0)) && ToolBox.equals((Object)conc.getCode(), (Object)record.getField(1)) && ToolBox.equals((Object)conc.getName(), (Object)record.getField(2)))) {
            conc.setExternalUniqueId(record.getField(0));
            conc.setCode(record.getField(1));
            conc.setName(record.getField(2));
            hibSession.saveOrUpdate((Object)conc);
            ChangeLog.addChange(hibSession, context, conc, conc.getCode() + " " + conc.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('ConcentrationEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((PosMajorConcentration)PosMajorConcentrationDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(PosMajorConcentration conc, SessionContext context, Session hibSession) {
        if (conc == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, conc, conc.getCode() + " " + conc.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        conc.getMajor().getConcentrations().remove(conc);
        hibSession.delete((Object)conc);
    }

    @Override
    @PreAuthorize(value="checkPermission('ConcentrationEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((PosMajorConcentration)PosMajorConcentrationDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

