/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.Campus;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.CampusDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=campus]")
public class Campuses
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageCampus(), MESSAGES.pageCampuses());
    }

    @Override
    @PreAuthorize(value="checkPermission('Campuses')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 240, 40, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldCode(), SimpleEditInterface.FieldType.text, 120, 20, SimpleEditInterface.Flag.NOT_EMPTY, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 360, 60, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSortBy(1, 2);
        for (Campus campus : Campus.findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(campus.getUniqueId());
            r.setField(0, campus.getExternalUniqueId());
            r.setField(1, campus.getReference());
            r.setField(2, campus.getLabel());
            r.setDeletable(campus.getExternalUniqueId() == null);
        }
        data.setEditable(context.hasPermission(Right.CampusEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('CampusEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (Campus campus : Campus.findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(campus.getUniqueId());
            if (r == null) {
                this.delete(campus, context, hibSession);
                continue;
            }
            this.update(campus, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('CampusEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        Campus campus = new Campus();
        campus.setExternalUniqueId(record.getField(0));
        campus.setReference(record.getField(1));
        campus.setLabel(record.getField(2));
        campus.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        record.setUniqueId((Long)hibSession.save((Object)campus));
        ChangeLog.addChange(hibSession, context, campus, campus.getReference() + " " + campus.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(Campus campus, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (campus == null) {
            return;
        }
        if (!(ToolBox.equals((Object)campus.getExternalUniqueId(), (Object)record.getField(0)) && ToolBox.equals((Object)campus.getReference(), (Object)record.getField(1)) && ToolBox.equals((Object)campus.getLabel(), (Object)record.getField(2)))) {
            campus.setExternalUniqueId(record.getField(0));
            campus.setReference(record.getField(1));
            campus.setLabel(record.getField(2));
            hibSession.saveOrUpdate((Object)campus);
            ChangeLog.addChange(hibSession, context, campus, campus.getReference() + " " + campus.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('CampusEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((Campus)CampusDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(Campus campus, SessionContext context, org.hibernate.Session hibSession) {
        if (campus == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, campus, campus.getReference() + " " + campus.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)campus);
    }

    @Override
    @PreAuthorize(value="checkPermission('CampusEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((Campus)CampusDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

