/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.authority;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.HasRights;
import org.unitime.timetable.security.rights.Right;

public abstract class AbstractAuthority
implements UserAuthority {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iRole;
    private String iLabel;
    private List<UserQualifier> iQualifiers = new ArrayList<UserQualifier>();
    private UserQualifier iSession = null;
    private Set<Right> iRights = new HashSet<Right>();

    public AbstractAuthority(Long uniqueId, String role, String label, HasRights permissions) {
        this.iUniqueId = uniqueId;
        this.iRole = role;
        this.iLabel = label;
        for (Right right : Right.values()) {
            if (!permissions.hasRight(right)) continue;
            this.iRights.add(right);
        }
    }

    @Override
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    @Override
    public UserQualifier getAcademicSession() {
        return this.iSession;
    }

    @Override
    public String getLabel() {
        return this.iLabel;
    }

    @Override
    public String getRole() {
        return this.iRole;
    }

    public String getAuthority() {
        UserQualifier session = this.getAcademicSession();
        return (this.getRole() + (session == null ? "" : "_" + session.getQualifierReference())).toUpperCase().replace(' ', '_');
    }

    @Override
    public boolean hasRight(Right right) {
        return this.iRights.contains((Object)right);
    }

    public String toString() {
        return this.getAuthority() + " " + this.getQualifiers();
    }

    public int hashCode() {
        return this.getAuthority().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof GrantedAuthority)) {
            return false;
        }
        return this.getAuthority().equals(((GrantedAuthority)o).getAuthority());
    }

    @Override
    public List<? extends UserQualifier> getQualifiers() {
        return this.iQualifiers;
    }

    @Override
    public List<? extends UserQualifier> getQualifiers(String type) {
        ArrayList<UserQualifier> ret = new ArrayList<UserQualifier>();
        for (UserQualifier userQualifier : this.getQualifiers()) {
            if (type != null && !type.equals(userQualifier.getQualifierType())) continue;
            ret.add(userQualifier);
        }
        return ret;
    }

    @Override
    public boolean hasQualifier(Qualifiable qualifiable) {
        return this.getQualifier(qualifiable) != null;
    }

    @Override
    public UserQualifier getQualifier(Qualifiable qualifiable) {
        for (UserQualifier userQualifier : this.getQualifiers()) {
            if (!userQualifier.equals(qualifiable)) continue;
            return userQualifier;
        }
        return null;
    }

    @Override
    public void addQualifier(UserQualifier qualifier) {
        if ("Session".equalsIgnoreCase(qualifier.getQualifierType())) {
            this.iSession = qualifier;
        }
        this.iQualifiers.add(qualifier);
    }

    @Override
    public void addQualifier(Qualifiable qualifiable) {
        this.addQualifier(new SimpleQualifier(qualifiable));
    }
}

