/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseExamPeriod;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.reports.exam.ScheduleByCourseReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class ExamPeriodChartReport
extends PdfLegacyExamReport {
    protected static Log sLog = LogFactory.getLog(ScheduleByCourseReport.class);

    public ExamPeriodChartReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, MSG.legacyReportPeriodAssignment(), session, examType, subjectAreas, exams);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void printReport() throws DocumentException {
        if (this.iRC != null && this.iRC.length() > 0) {
            this.setFooter(this.iRC + (this.iLimit >= 0 ? " (" + MSG.lrFooterLimit(this.iLimit) + ")" : ""));
        } else if (this.iLimit >= 0) {
            this.setFooter(MSG.lrFooterLimit(this.iLimit));
        }
        Hashtable<ExamPeriod, TreeSet<ExamAssignmentInfo>> period2exams = new Hashtable<ExamPeriod, TreeSet<ExamAssignmentInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null || !this.hasSubjectArea(exam)) continue;
            TreeSet<ExamAssignmentInfo> exams = (TreeSet<ExamAssignmentInfo>)period2exams.get(exam.getPeriod());
            if (exams == null) {
                exams = new TreeSet<ExamAssignmentInfo>();
                period2exams.put(exam.getPeriod(), exams);
            }
            exams.add(exam);
        }
        HashMap<Integer, String> times = new HashMap<Integer, String>();
        HashMap<Integer, AbstractReport.Cell> fixedTimes = new HashMap<Integer, AbstractReport.Cell>();
        HashMap<Integer, String> days = new HashMap<Integer, String>();
        for (ExamPeriod period : ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType())) {
            times.put(period.getStartSlot(), period.getStartTimeLabel());
            days.put(period.getDateOffset(), period.getStartDateLabel());
            fixedTimes.put(period.getStartSlot(), this.lpad(period.getStartTimeLabel(), '0', 6));
        }
        boolean headerPrinted = false;
        Hashtable<Integer, Integer> totalADay = new Hashtable<Integer, Integer>();
        String timesThisPage = null;
        int nrCols = 0;
        if (!this.iTotals) {
            if (this.iCompact) {
                this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrStartTime(), 10).withSeparator("| "), this.rpad(MSG.lrExam(), 15).withSeparator(""), this.rpad(" ", 1).withSeparator(""), this.rpad(MSG.lrEnrl(), 4).withSeparator("| "), this.rpad(MSG.lrExam(), 15).withSeparator(""), this.rpad(" ", 1).withSeparator(""), this.rpad(MSG.lrEnrl(), 4).withSeparator("| "), this.rpad(MSG.lrExam(), 15).withSeparator(""), this.rpad(" ", 1).withSeparator(""), this.rpad(MSG.lrEnrl(), 4).withSeparator("| "), this.rpad(MSG.lrExam(), 15).withSeparator(""), this.rpad(" ", 1).withSeparator(""), this.rpad(MSG.lrEnrl(), 4).withSeparator("| "), this.rpad(MSG.lrExam(), 15).withSeparator(""), this.rpad(" ", 1).withSeparator(""), this.rpad(MSG.lrEnrl(), 4)), new AbstractReport.Line(this.rpad("", '-', 10).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4)));
            } else {
                this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrStartTime(), 10).withSeparator("|"), this.rpad(MSG.lrExam(), 24).withSeparator(""), this.rpad(" ", 1).withSeparator(""), this.rpad(MSG.lrEnrl(), 4).withSeparator("| "), this.rpad(MSG.lrExam(), 24).withSeparator(""), this.rpad(" ", 1).withSeparator(""), this.rpad(MSG.lrEnrl(), 4).withSeparator("| "), this.rpad(MSG.lrExam(), 24).withSeparator(""), this.rpad(" ", 1).withSeparator(""), this.rpad(MSG.lrEnrl(), 4).withSeparator("| "), this.rpad(MSG.lrExam(), 24).withSeparator(""), this.rpad(" ", 1).withSeparator(""), this.rpad(MSG.lrEnrl(), 4)), new AbstractReport.Line(this.rpad("", '-', 10).withSeparator("|"), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4)));
            }
            this.printHeader();
        }
        int lastDIdx = 0;
        boolean firstLine = true;
        for (int dIdx = 0; dIdx < days.size(); dIdx += nrCols) {
            Iterator iterator = new TreeSet(times.keySet()).iterator();
            while (iterator.hasNext()) {
                Vector linesThisPeriod;
                int time = (Integer)iterator.next();
                int offset = 0;
                String timeStr = (String)times.get(time);
                ArrayList<AbstractReport.Cell> header1 = new ArrayList<AbstractReport.Cell>();
                ArrayList<AbstractReport.Cell> header2 = new ArrayList<AbstractReport.Cell>();
                ArrayList<AbstractReport.Cell> header3 = new ArrayList<AbstractReport.Cell>();
                Vector<Object> periods = new Vector<Object>();
                int idx = 0;
                String firstDay = null;
                int firstDayOffset = 0;
                String lastDay = null;
                nrCols = 0;
                Iterator f = new TreeSet(days.keySet()).iterator();
                while (f.hasNext()) {
                    int day = (Integer)f.next();
                    String dayStr = (String)days.get(day);
                    if (idx >= dIdx) {
                        if (nrCols != (this.iCompact ? (this.iTotals ? 6 : 5) : 4)) {
                            if (firstDay != null && (dayStr.startsWith("Mon") || day >= firstDayOffset + 7)) break;
                            if (firstDay == null) {
                                firstDay = dayStr;
                                firstDayOffset = day;
                                Calendar c = Calendar.getInstance(Locale.US);
                                c.setTime(this.getSession().getExamBeginDate());
                                c.add(6, day);
                                if (!this.iTotals) {
                                    offset = (c.get(7) + 5) % 7;
                                    firstDayOffset -= offset;
                                }
                            }
                            lastDay = dayStr;
                            if (this.iCompact) {
                                header1.add(this.mpad(dayStr, 20).withSeparator("| ").withColSpan(3));
                                header2.add(this.rpad(MSG.lrExam(), 15).withSeparator(""));
                                header2.add(this.rpad(" ", 1).withSeparator(""));
                                header2.add(this.rpad(MSG.lrEnrl(), 4).withSeparator("| "));
                                header3.add(this.lpad("", '=', 15).withColSpan(2));
                                header3.add(this.lpad("", '=', 4).withSeparator("| "));
                            } else {
                                header1.add(this.mpad(dayStr, 29).withSeparator("| ").withColSpan(3));
                                header2.add(this.rpad(MSG.lrExam(), 24).withSeparator(""));
                                header2.add(this.rpad(" ", 1).withSeparator(""));
                                header2.add(this.rpad(MSG.lrEnrl(), 4).withSeparator("| "));
                                header3.add(this.lpad("", '=', 24).withColSpan(2));
                                header3.add(this.lpad("", '=', 4).withSeparator("| "));
                            }
                            Object period = null;
                            ++nrCols;
                            for (Object p : ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType())) {
                                if (time != ((BaseExamPeriod)p).getStartSlot() || day != ((BaseExamPeriod)p).getDateOffset()) continue;
                                period = p;
                                break;
                            }
                            periods.add(period);
                        }
                    }
                    ++idx;
                }
                if (this.iTotals) {
                    this.setHeaderLine(new AbstractReport.Line(new AbstractReport.Cell(timeStr).withColSpan(header2.size())), new AbstractReport.Line(header1.toArray(new AbstractReport.Cell[header1.size()])), new AbstractReport.Line(header2.toArray(new AbstractReport.Cell[header2.size()])), new AbstractReport.Line(header3.toArray(new AbstractReport.Cell[header3.size()])));
                } else if (offset + periods.size() > (this.iCompact ? (this.iTotals ? 6 : 5) : 4)) {
                    offset = Math.max(0, (this.iCompact ? (this.iTotals ? 6 : 5) : 4) - periods.size());
                }
                int nextLines = 0;
                Enumeration f2 = periods.elements();
                while (f2.hasMoreElements()) {
                    TreeSet exams;
                    Object p;
                    ExamPeriod period = (ExamPeriod)f2.nextElement();
                    if (period == null || (exams = (TreeSet)period2exams.get(period)) == null) continue;
                    int linesThisSections = 6;
                    p = exams.iterator();
                    while (p.hasNext()) {
                        ExamAssignmentInfo exam = (ExamAssignmentInfo)p.next();
                        int size = 0;
                        for (Object section : exam.getSectionsIncludeCrosslistedDummies()) {
                            size += ((ExamInfo.ExamSectionInfo)section).getNrStudents();
                        }
                        if (this.iLimit >= 0 && size < this.iLimit) continue;
                        for (Object section : exam.getSectionsIncludeCrosslistedDummies()) {
                            if (!this.hasSubjectArea((ExamInfo.ExamSectionInfo)section)) continue;
                            ++linesThisSections;
                        }
                    }
                    nextLines = Math.max(nextLines, linesThisSections);
                }
                if (this.iTotals) {
                    if (!headerPrinted) {
                        this.printHeader();
                        this.setPageName(timeStr + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                        this.setCont(timeStr + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                        timesThisPage = timeStr;
                    } else if (timesThisPage != null && (this.getNrLinesPerPage() == 0 || this.getLineNumber() + nextLines <= this.getNrLinesPerPage())) {
                        this.println(new AbstractReport.Line());
                        this.printHeader(false);
                        timesThisPage = timesThisPage + ", " + timeStr;
                        this.setPageName(timesThisPage + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                        this.setCont(timesThisPage + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                    } else {
                        this.newPage();
                        timesThisPage = timeStr;
                        this.setPageName(timeStr + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                        this.setCont(timeStr + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                    }
                } else {
                    if (nextLines == 0) continue;
                    if (!this.iNewPage && !firstLine) {
                        if (lastDIdx != dIdx) {
                            if (this.iCompact) {
                                this.printSeparator(this.rpad("", '-', 10).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4));
                            } else {
                                this.printSeparator(this.rpad("", '-', 10), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4));
                            }
                            lastDIdx = dIdx;
                        } else if (this.iCompact) {
                            this.printSeparator(this.lpad("", ' ', 10).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 15).withColSpan(2), this.rpad("", '-', 4));
                        } else {
                            this.printSeparator(this.lpad("", ' ', 10), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4).withSeparator("| "), this.rpad("", '-', 24).withColSpan(2), this.rpad("", '-', 4));
                        }
                    }
                    firstLine = false;
                    this.setCont(firstDay + " - " + lastDay + " " + fixedTimes.get(time));
                    this.setPageName(firstDay + " - " + lastDay + " " + fixedTimes.get(time));
                }
                headerPrinted = true;
                int max = 0;
                Vector<Vector> lines = new Vector<Vector>();
                Enumeration f3 = periods.elements();
                while (f3.hasMoreElements()) {
                    Object section;
                    ExamPeriod period = (ExamPeriod)f3.nextElement();
                    if (period == null) {
                        Vector<AbstractReport.Cell[]> linesThisPeriod2 = new Vector<AbstractReport.Cell[]>();
                        linesThisPeriod2.add(new AbstractReport.Cell[]{this.lpad("", this.iCompact ? 15 : 24).withColSpan(2), this.lpad("0", 5)});
                        lines.add(linesThisPeriod2);
                        continue;
                    }
                    TreeSet exams = (TreeSet)period2exams.get(period);
                    if (exams == null) {
                        exams = new TreeSet();
                    }
                    linesThisPeriod = new Vector();
                    int total = 0;
                    int totalListed = 0;
                    section = exams.iterator();
                    while (section.hasNext()) {
                        ExamAssignmentInfo exam = (ExamAssignmentInfo)section.next();
                        boolean sizePrinted = false;
                        int size = 0;
                        for (ExamInfo.ExamSectionInfo section2 : exam.getSectionsIncludeCrosslistedDummies()) {
                            size += section2.getNrStudents();
                        }
                        for (ExamInfo.ExamSectionInfo section2 : exam.getSectionsIncludeCrosslistedDummies()) {
                            ExamRoomInfo room;
                            String c;
                            Iterator<ExamRoomInfo> iterator2;
                            if (!this.hasSubjectArea(section2)) continue;
                            total += section2.getNrStudents();
                            if (this.iLimit >= 0 && size < this.iLimit) continue;
                            totalListed += section2.getNrStudents();
                            String code = null;
                            if (this.iRoomCodes != null && !this.iRoomCodes.isEmpty() && (iterator2 = section2.getExamAssignment().getRooms().iterator()).hasNext() && (c = (String)this.iRoomCodes.get((room = iterator2.next()).getName())) != null) {
                                code = c;
                            }
                            if (this.iCompact) {
                                linesThisPeriod.add(new AbstractReport.Cell[]{new AbstractReport.Cell(this.rpad(section2.getSubject(), 7).withSeparator(""), this.rpad(section2.getCourseNbr(), 8).withSeparator("")).withSeparator(""), new AbstractReport.Cell(String.valueOf(sizePrinted || code == null || code.length() == 0 ? (char)' ' : code.charAt(0))).withSeparator(""), this.lpad(sizePrinted ? "" : String.valueOf(size), 4)});
                            } else if (this.iItype) {
                                if (this.iExternal) {
                                    linesThisPeriod.add(new AbstractReport.Cell[]{new AbstractReport.Cell(this.rpad(section2.getSubject(), 7).withSeparator(""), this.rpad(section2.getCourseNbr(), 8).withSeparator(""), this.rpad(section2.getItype(), 9).withSeparator("")).withSeparator(""), new AbstractReport.Cell(String.valueOf(sizePrinted || code == null || code.length() == 0 ? (char)' ' : code.charAt(0))).withSeparator(""), this.lpad(sizePrinted ? "" : String.valueOf(size), 4)});
                                } else {
                                    linesThisPeriod.add(new AbstractReport.Cell[]{this.rpad(section2.getName(), 24).withSeparator(""), new AbstractReport.Cell(String.valueOf(sizePrinted || code == null || code.length() == 0 ? (char)' ' : code.charAt(0))).withSeparator(""), this.lpad(sizePrinted ? "" : String.valueOf(size), 4)});
                                }
                            } else {
                                linesThisPeriod.add(new AbstractReport.Cell[]{new AbstractReport.Cell(this.rpad(section2.getSubject(), 7).withSeparator(""), this.rpad(section2.getCourseNbr(), 8).withSeparator(""), this.rpad(section2.getItype(), 9).withSeparator("")).withSeparator(""), new AbstractReport.Cell(String.valueOf(sizePrinted || code == null || code.length() == 0 ? (char)' ' : code.charAt(0))).withSeparator(""), this.lpad(sizePrinted ? "" : String.valueOf(size), 4)});
                            }
                            sizePrinted = true;
                        }
                    }
                    if (this.iCompact) {
                        if (this.iTotals) {
                            if (totalListed != total) {
                                linesThisPeriod.insertElementAt(new AbstractReport.Cell[]{this.mpad("(" + totalListed + ")", 14).withColSpan(2), this.lpad("" + total, 6)}, 0);
                            } else {
                                linesThisPeriod.insertElementAt(new AbstractReport.Cell[]{this.lpad("" + total, 20).withColSpan(3)}, 0);
                            }
                        } else {
                            linesThisPeriod.insertElementAt(new AbstractReport.Cell[]{this.rpad(period.getStartDateLabel(), 14).withColSpan(2), this.lpad(total == 0 ? "" : "" + total, 6)}, 0);
                        }
                    } else if (this.iTotals) {
                        if (totalListed != total) {
                            linesThisPeriod.insertElementAt(new AbstractReport.Cell[]{this.mpad("(" + totalListed + ")", 23).withColSpan(2), this.lpad("" + total, 6)}, 0);
                        } else {
                            linesThisPeriod.insertElementAt(new AbstractReport.Cell[]{this.lpad("" + total, 29).withColSpan(3)}, 0);
                        }
                    } else {
                        linesThisPeriod.insertElementAt(new AbstractReport.Cell[]{this.rpad(period.getStartDateLabel(), 23).withColSpan(2), this.lpad(total == 0 ? "" : "" + total, 6)}, 0);
                    }
                    max = Math.max(max, linesThisPeriod.size());
                    Integer td = (Integer)totalADay.get(period.getDateOffset());
                    totalADay.put(period.getDateOffset(), total + (td == null ? 0 : td));
                    lines.add(linesThisPeriod);
                }
                for (int i = 0; i < max; ++i) {
                    ArrayList<AbstractReport.Cell> line = new ArrayList<AbstractReport.Cell>();
                    if (!this.iTotals) {
                        if (this.iCompact) {
                            if (i == 0 || this.iNewPage) {
                                line.add(this.rpad((AbstractReport.Cell)fixedTimes.get(time), 10).withSeparator("| "));
                                for (int c = 0; c < offset; ++c) {
                                    line.add(this.rpad("", 20).withSeparator("| ").withColSpan(3));
                                }
                            } else {
                                line.add(this.rpad("", 10).withSeparator("| "));
                                for (int c = 0; c < offset; ++c) {
                                    line.add(this.rpad("", 20).withSeparator("| ").withColSpan(3));
                                }
                            }
                        } else if (i == 0 || this.iNewPage) {
                            line.add(this.rpad((AbstractReport.Cell)fixedTimes.get(time), 10).withSeparator("|"));
                            for (int c = 0; c < offset; ++c) {
                                line.add(this.rpad("", 29).withSeparator("| ").withColSpan(3));
                            }
                        } else {
                            line.add(this.rpad("", 10).withSeparator("|"));
                            for (int c = 0; c < offset; ++c) {
                                line.add(this.rpad("", 29).withSeparator("| ").withColSpan(3));
                            }
                        }
                    }
                    Enumeration f4 = lines.elements();
                    while (f4.hasMoreElements()) {
                        linesThisPeriod = (Vector)f4.nextElement();
                        if (i < linesThisPeriod.size()) {
                            AbstractReport.Cell[] c = (AbstractReport.Cell[])linesThisPeriod.elementAt(i);
                            for (int j = 0; j < c.length; ++j) {
                                line.add(c[j].withSeparator(j + 1 == c.length ? "| " : ""));
                            }
                            continue;
                        }
                        line.add(this.rpad("", this.iCompact ? 20 : 29).withColSpan(3).withSeparator("| "));
                    }
                    if (!this.iTotals) {
                        for (int c = offset + lines.size(); c < (this.iCompact ? 5 : 4); ++c) {
                            if (this.iCompact) {
                                line.add(this.rpad("", 20).withSeparator("| ").withColSpan(3));
                                continue;
                            }
                            line.add(this.rpad("", 29).withSeparator("|").withColSpan(3));
                        }
                    }
                    this.println(line.toArray(new AbstractReport.Cell[line.size()]));
                }
                this.setCont(null);
            }
            if (!this.iTotals) continue;
            this.setHeaderLine(new AbstractReport.Line[0]);
            if (this.getLineNumber() + 5 > this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                this.newPage();
                this.setPageName(MSG.lrTotals());
            } else {
                this.println(new AbstractReport.Line());
            }
            ArrayList<AbstractReport.Cell> line1 = new ArrayList<AbstractReport.Cell>();
            ArrayList<AbstractReport.Cell> line2 = new ArrayList<AbstractReport.Cell>();
            ArrayList<AbstractReport.Cell> line3 = new ArrayList<AbstractReport.Cell>();
            int idx = 0;
            Iterator f = new TreeSet(days.keySet()).iterator();
            while (f.hasNext()) {
                int day = (Integer)f.next();
                if (idx >= dIdx && idx < dIdx + nrCols) {
                    if (this.iCompact) {
                        line1.add(this.mpad((String)days.get(day), 20).withSeparator("| ").withColSpan(3));
                        line2.add(this.lpad("", '=', 15).withSeparator(""));
                        line2.add(this.lpad("", ' ', 1).withSeparator(""));
                        line2.add(this.lpad("", '=', 4).withSeparator("| "));
                        line3.add(this.lpad(totalADay.get(day) == null ? "" : totalADay.get(day).toString(), 20).withColSpan(3).withSeparator("| "));
                    } else {
                        line1.add(this.mpad((String)days.get(day), 29).withSeparator("| ").withColSpan(3));
                        line2.add(this.lpad("", '=', 24).withSeparator(""));
                        line2.add(this.lpad("", ' ', 1).withSeparator(""));
                        line2.add(this.lpad("", '=', 4).withSeparator("| "));
                        line3.add(this.lpad(totalADay.get(day) == null ? "" : totalADay.get(day).toString(), 29).withColSpan(3).withSeparator("| "));
                    }
                }
                ++idx;
            }
            this.setHeaderLine(new AbstractReport.Line(new AbstractReport.Cell(MSG.lrTotalStudentExams()).withColSpan(line1.size() * 3)), new AbstractReport.Line(line1.toArray(new AbstractReport.Cell[line1.size()])), new AbstractReport.Line(line2.toArray(new AbstractReport.Cell[line2.size()])));
            this.printHeader(false);
            this.println(line3.toArray(new AbstractReport.Cell[line3.size()]));
            timesThisPage = null;
        }
        this.lastPage();
    }
}

