/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;

public class ConflictsByCourseAndStudentReport
extends PdfLegacyExamReport {
    protected static Log sLog = LogFactory.getLog(ConflictsByCourseAndStudentReport.class);
    Hashtable<Long, String> iStudentNames = new Hashtable();

    public ConflictsByCourseAndStudentReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, MSG.legacyReportConflictsByCourseAndStudent(), session, examType, subjectAreas, exams);
        sLog.debug((Object)MSG.statusLoadingStudents());
        Iterator i = new StudentDAO().getSession().createQuery("select s.uniqueId, s.externalUniqueId, s.lastName, s.firstName, s.middleName from Student s where s.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).iterate();
        while (i.hasNext()) {
            Object[] o = (Object[])i.next();
            if (o[2] != null) {
                this.iStudentNames.put((Long)o[0], (String)o[2] + (o[3] == null ? "" : " " + (String)o[3]) + (o[4] == null ? "" : " " + (String)o[4]));
                continue;
            }
            if (o[1] != null) {
                this.iStudentNames.put((Long)o[0], (String)o[1]);
                continue;
            }
            this.iStudentNames.put((Long)o[0], MSG.lrNA());
        }
    }

    @Override
    public void printReport() throws DocumentException {
        sLog.debug((Object)MSG.statusSortingSections());
        Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>> subject2courseSections = new Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (!this.hasSubjectArea(section)) continue;
                TreeSet<ExamInfo.ExamSectionInfo> sections = (TreeSet<ExamInfo.ExamSectionInfo>)subject2courseSections.get(section.getSubject());
                if (sections == null) {
                    sections = new TreeSet<ExamInfo.ExamSectionInfo>();
                    subject2courseSections.put(section.getSubject(), sections);
                }
                sections.add(section);
            }
        }
        sLog.debug((Object)MSG.statusPrintingReport());
        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnID() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 10), this.rpad(MSG.lrDate(), 7), this.rpad(MSG.lrTime(), 6), this.rpad(MSG.lrName(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnID() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 10), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 10), this.lpad("", '-', 7), this.lpad("", '-', 6), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 10), this.lpad("", '-', 15)));
        this.printHeader();
        boolean dirtyPage = false;
        for (String subject : new TreeSet(subject2courseSections.keySet())) {
            TreeSet sections = (TreeSet)subject2courseSections.get(subject);
            if (this.iSubjectPrinted || dirtyPage) {
                this.newPage();
            }
            this.setPageName(subject);
            this.setCont(subject);
            this.iSubjectPrinted = false;
            for (ExamInfo.ExamSectionInfo section : sections) {
                ExamAssignmentInfo exam = section.getExamAssignmentInfo();
                if (exam == null || exam.getPeriod() == null) continue;
                this.iCoursePrinted = false;
                Vector<Long> students = new Vector<Long>(section.getStudentIds());
                Collections.sort(students, new Comparator<Long>(){

                    @Override
                    public int compare(Long s1, Long s2) {
                        int cmp = ConflictsByCourseAndStudentReport.this.iStudentNames.get(s1).compareTo(ConflictsByCourseAndStudentReport.this.iStudentNames.get(s2));
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.compareTo(s2);
                    }
                });
                for (Long studentId : students) {
                    this.iStudentPrinted = false;
                    if (this.iDirect) {
                        for (ExamAssignmentInfo.DirectConflict directConflict : exam.getDirectConflicts()) {
                            if (!directConflict.getStudents().contains(studentId)) continue;
                            this.iPeriodPrinted = false;
                            if (directConflict.getOtherExam() != null) {
                                for (ExamInfo.ExamSectionInfo other : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                                    if (!other.getStudentIds().contains(studentId)) continue;
                                    this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.iStudentNames.get(studentId), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrDIRECT(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.formatSection10(other.getSection()), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                                    this.iPeriodPrinted = !this.iNewPage;
                                    this.iStudentPrinted = this.iPeriodPrinted;
                                    this.iCoursePrinted = this.iPeriodPrinted;
                                    this.iSubjectPrinted = this.iPeriodPrinted;
                                }
                                continue;
                            }
                            if (directConflict.getOtherEventId() == null) continue;
                            if (directConflict.isOtherClass()) {
                                this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.iStudentNames.get(studentId), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrCLASS(), 6), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv(), 7), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr(), 8), this.iItype ? this.rpad(this.iExternal ? directConflict.getOtherClass().getExternalUniqueId() : directConflict.getOtherClass().getSchedulingSubpart().getItypeDesc(), 6) : NULL, this.formatSection10(this.iUseClassSuffix && directConflict.getOtherClass().getClassSuffix() != null ? directConflict.getOtherClass().getClassSuffix() : directConflict.getOtherClass().getSectionNumberString()), new AbstractReport.Cell(this.getMeetingTime(directConflict.getOtherEventTime())));
                            } else {
                                this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.iStudentNames.get(studentId), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrEVENT(), 6), this.rpad(directConflict.getOtherEventName(), this.iItype ? 34 : 27).withColSpan(this.iItype ? 4 : 3), new AbstractReport.Cell(this.getMeetingTime(directConflict.getOtherEventTime())));
                            }
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                        }
                    }
                    if (this.iM2d) {
                        for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getMoreThanTwoADaysConflicts()) {
                            if (!moreThanTwoADayConflict.getStudents().contains(studentId)) continue;
                            this.iPeriodPrinted = false;
                            for (ExamAssignment otherExam : moreThanTwoADayConflict.getOtherExams()) {
                                for (ExamInfo.ExamSectionInfo examSectionInfo : otherExam.getSectionsIncludeCrosslistedDummies()) {
                                    if (!examSectionInfo.getStudentIds().contains(studentId)) continue;
                                    this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.iStudentNames.get(studentId), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrMore2DAY(), 6), this.rpad(examSectionInfo.getSubject(), 7), this.rpad(examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(examSectionInfo.getItype(), 6) : NULL, this.formatSection10(examSectionInfo.getSection()), new AbstractReport.Cell(examSectionInfo.getExamAssignment().getTimeFixedLength()));
                                    this.iPeriodPrinted = !this.iNewPage;
                                    this.iStudentPrinted = this.iPeriodPrinted;
                                    this.iCoursePrinted = this.iPeriodPrinted;
                                    this.iSubjectPrinted = this.iPeriodPrinted;
                                }
                            }
                        }
                    }
                    if (!this.iBtb) continue;
                    for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getBackToBackConflicts()) {
                        if (!backToBackConflict.getStudents().contains(studentId)) continue;
                        this.iPeriodPrinted = false;
                        for (ExamInfo.ExamSectionInfo other : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                            if (!other.getStudentIds().contains(studentId)) continue;
                            this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.iStudentNames.get(studentId), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrBTB(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.formatSection10(other.getSection()), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                        }
                    }
                }
                boolean needReprintSubject = false;
                if (section.hasDifferentSubjectChildren()) {
                    for (ExamInfo.ExamSectionInfo child : section.getDifferentSubjectChildren()) {
                        boolean bl = false;
                        students = new Vector<Long>(child.getStudentIds());
                        Collections.sort(students, new Comparator<Long>(){

                            @Override
                            public int compare(Long s1, Long s2) {
                                int cmp = ConflictsByCourseAndStudentReport.this.iStudentNames.get(s1).compareTo(ConflictsByCourseAndStudentReport.this.iStudentNames.get(s2));
                                if (cmp != 0) {
                                    return cmp;
                                }
                                return s1.compareTo(s2);
                            }
                        });
                        for (Long studentId : students) {
                            boolean bl2;
                            this.iStudentPrinted = false;
                            if (this.iDirect) {
                                for (ExamAssignmentInfo.DirectConflict directConflict : exam.getDirectConflicts()) {
                                    if (!directConflict.getStudents().contains(studentId)) continue;
                                    this.iPeriodPrinted = false;
                                    if (directConflict.getOtherExam() != null) {
                                        for (ExamInfo.ExamSectionInfo other : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                                            if (!other.getStudentIds().contains(studentId)) continue;
                                            if (!this.iCoursePrinted) {
                                                this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam));
                                                this.iCoursePrinted = !this.iNewPage;
                                                this.iSubjectPrinted = this.iCoursePrinted;
                                            }
                                            this.println(this.rpad(bl2 ? "" : MSG.lrWith() + child.getSubject(), 8).withSeparator(""), this.rpad(child.getCourseNbr(), 8), this.iItype ? this.rpad(child.getItype(), 6) : NULL, this.formatSection10(child.getSection()), this.formatShortPeriodNoEndTimeDate(exam), this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.iStudentNames.get(studentId), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrDIRECT(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.formatSection10(other.getSection()), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                                            needReprintSubject = !this.iNewPage;
                                            bl2 = needReprintSubject;
                                            this.iPeriodPrinted = needReprintSubject;
                                            this.iStudentPrinted = needReprintSubject;
                                            this.iCoursePrinted = needReprintSubject;
                                            this.iSubjectPrinted = needReprintSubject;
                                        }
                                        continue;
                                    }
                                    if (directConflict.getOtherEventId() == null) continue;
                                    if (!this.iCoursePrinted) {
                                        this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam));
                                        this.iCoursePrinted = !this.iNewPage;
                                        this.iSubjectPrinted = this.iCoursePrinted;
                                    }
                                    if (directConflict.isOtherClass()) {
                                        this.println(this.rpad(bl2 ? "" : MSG.lrWith() + child.getSubject(), 8).withSeparator(""), this.rpad(child.getCourseNbr(), 8), this.iItype ? this.rpad(child.getItype(), 6) : NULL, this.formatSection10(child.getSection()), this.formatShortPeriodNoEndTimeDate(exam), this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.iStudentNames.get(studentId), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrCLASS(), 6), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv(), 7), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr(), 8), this.iItype ? this.rpad(this.iExternal ? directConflict.getOtherClass().getExternalUniqueId() : directConflict.getOtherClass().getSchedulingSubpart().getItypeDesc(), 6) : NULL, this.formatSection10(this.iUseClassSuffix && directConflict.getOtherClass().getClassSuffix() != null ? directConflict.getOtherClass().getClassSuffix() : directConflict.getOtherClass().getSectionNumberString()), new AbstractReport.Cell(this.getMeetingTime(directConflict.getOtherEventTime())));
                                    } else {
                                        this.println(this.rpad(bl2 ? "" : MSG.lrWith() + child.getSubject(), 8).withSeparator(""), this.rpad(child.getCourseNbr(), 8), this.iItype ? this.rpad(child.getItype(), 6) : NULL, this.formatSection10(child.getSection()), this.formatShortPeriodNoEndTimeDate(exam), this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.iStudentNames.get(studentId), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrEVENT(), 6), this.rpad(directConflict.getOtherEventName(), this.iItype ? 34 : 27).withColSpan(this.iItype ? 4 : 3), new AbstractReport.Cell(this.getMeetingTime(directConflict.getOtherEventTime())));
                                    }
                                    needReprintSubject = !this.iNewPage;
                                    bl2 = needReprintSubject;
                                    this.iPeriodPrinted = needReprintSubject;
                                    this.iStudentPrinted = needReprintSubject;
                                    this.iCoursePrinted = needReprintSubject;
                                    this.iSubjectPrinted = needReprintSubject;
                                }
                            }
                            if (this.iM2d) {
                                for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getMoreThanTwoADaysConflicts()) {
                                    if (!moreThanTwoADayConflict.getStudents().contains(studentId)) continue;
                                    this.iPeriodPrinted = false;
                                    for (ExamAssignment otherExam : moreThanTwoADayConflict.getOtherExams()) {
                                        for (ExamInfo.ExamSectionInfo other : otherExam.getSectionsIncludeCrosslistedDummies()) {
                                            if (!other.getStudentIds().contains(studentId)) continue;
                                            if (!this.iCoursePrinted) {
                                                this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam));
                                                this.iCoursePrinted = !this.iNewPage;
                                                this.iSubjectPrinted = this.iCoursePrinted;
                                            }
                                            this.println(this.rpad(bl2 ? "" : MSG.lrWith() + child.getSubject(), 8).withSeparator(""), this.rpad(child.getCourseNbr(), 8), this.iItype ? this.rpad(child.getItype(), 6) : NULL, this.formatSection10(child.getSection()), this.formatShortPeriodNoEndTimeDate(exam), this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.iStudentNames.get(studentId), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrMore2DAY(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.formatSection10(other.getSection()), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                                            needReprintSubject = !this.iNewPage;
                                            bl2 = needReprintSubject;
                                            this.iPeriodPrinted = needReprintSubject;
                                            this.iStudentPrinted = needReprintSubject;
                                            this.iCoursePrinted = needReprintSubject;
                                            this.iSubjectPrinted = needReprintSubject;
                                        }
                                    }
                                }
                            }
                            if (!this.iBtb) continue;
                            for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getBackToBackConflicts()) {
                                if (!backToBackConflict.getStudents().contains(studentId)) continue;
                                this.iPeriodPrinted = false;
                                for (ExamInfo.ExamSectionInfo other : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                                    if (!other.getStudentIds().contains(studentId)) continue;
                                    if (!this.iCoursePrinted) {
                                        this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam));
                                        this.iCoursePrinted = !this.iNewPage;
                                        this.iSubjectPrinted = this.iCoursePrinted;
                                    }
                                    this.println(this.rpad(bl2 ? "" : MSG.lrWith() + child.getSubject(), 8).withSeparator(""), this.rpad(child.getCourseNbr(), 8), this.iItype ? this.rpad(child.getItype(), 6) : NULL, this.formatSection10(child.getSection()), this.formatShortPeriodNoEndTimeDate(exam), this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : this.iStudentNames.get(studentId), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrBTB(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.formatSection10(other.getSection()), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                                    needReprintSubject = !this.iNewPage;
                                    bl2 = needReprintSubject;
                                    this.iPeriodPrinted = needReprintSubject;
                                    this.iStudentPrinted = needReprintSubject;
                                    this.iCoursePrinted = needReprintSubject;
                                    this.iSubjectPrinted = needReprintSubject;
                                }
                            }
                        }
                    }
                }
                if (!needReprintSubject) continue;
                this.iSubjectPrinted = false;
                dirtyPage = true;
            }
            this.setCont(null);
        }
        if (this.iSubjectPrinted) {
            this.lastPage();
        }
    }
}

