/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.ReportWriter;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;

public class PdfReportWriter
implements ReportWriter {
    protected static ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private Document iDocument;
    private PdfWriter iWriter;
    private String iTitle;
    private String iTitle2;
    private String iSession;
    private int iPageNo = 0;
    private int iLineNo = 0;
    private boolean iEmpty = true;
    private String iPageId = null;
    private String iCont = null;
    private String iFooter = null;
    private String iSubject = null;
    private AbstractReport.Line[] iHeaderLine = null;
    private PdfPTable iTable = null;
    private Font iFont = null;
    private Font iBoldFont = null;
    private boolean iNewPage = true;
    private ReportWriter.Listener iListener = null;

    public PdfReportWriter(OutputStream out, String title, String title2, String subject, String session) throws DocumentException, IOException {
        this.iTitle = title;
        this.iTitle2 = title2;
        this.iSubject = subject;
        this.iSession = session;
        this.iFont = PdfFont.createFont(ApplicationProperty.PdfFontSizeExams.floatValue().floatValue(), false, false, false);
        this.iBoldFont = PdfFont.createFont(ApplicationProperty.PdfFontSizeExams.floatValue().floatValue(), false, true, false);
        if (out != null) {
            this.open(out);
        }
    }

    @Override
    public void setFooter(String footer) {
        this.iFooter = footer;
    }

    @Override
    public void setHeader(AbstractReport.Line ... line) {
        try {
            if (this.iTable != null) {
                this.finishCurrentTable();
            }
        }
        catch (DocumentException e) {
            Debug.error(e);
        }
        this.iHeaderLine = line;
    }

    @Override
    public AbstractReport.Line[] getHeader() {
        return this.iHeaderLine;
    }

    @Override
    public void printLine(AbstractReport.Line line) throws DocumentException {
        if (this.iTable == null) {
            String text = line == null ? " " : line.render().trim();
            Paragraph p = new Paragraph(text.isEmpty() ? " " : text, this.iFont);
            switch (line.getAlignment()) {
                case Center: {
                    p.setAlignment(1);
                    break;
                }
                case Left: {
                    p.setAlignment(0);
                    break;
                }
                case Right: {
                    p.setAlignment(2);
                }
            }
            this.iDocument.add((Element)p);
            ++this.iLineNo;
        } else {
            if (line == null) {
                return;
            }
            List<PdfPCell> cells = this.render(line, this.iFont);
            int colspan = 0;
            Iterator<PdfPCell> i = cells.iterator();
            while (i.hasNext()) {
                PdfPCell cell = i.next();
                if (!i.hasNext() && (colspan += cell.getColspan()) < this.iTable.getNumberOfColumns()) {
                    cell.setColspan(this.iTable.getNumberOfColumns() - colspan + cell.getColspan());
                }
                this.iTable.addCell(cell);
            }
            this.iTable.completeRow();
            ++this.iLineNo;
        }
        this.iNewPage = false;
        this.iEmpty = false;
        if (this.iLineNo >= this.getNrLinesPerPage()) {
            this.newPage();
        }
    }

    @Override
    public void close() throws IOException, DocumentException {
        if (this.iEmpty) {
            Paragraph p = new Paragraph(MSG.lrNothingToReport(), this.iFont);
            p.setAlignment(0);
            this.iDocument.add((Element)p);
        }
        this.lastPage();
        this.iDocument.close();
        this.iWriter.close();
    }

    @Override
    public void open(OutputStream out) throws DocumentException, IOException {
        this.iDocument = new Document(PageSize.LETTER.rotate(), 36.0f, 36.0f, 60.0f, 48.0f);
        this.iWriter = PdfWriter.getInstance((Document)this.iDocument, (OutputStream)out);
        this.iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler(){

            @Override
            public void onEndPage(PdfWriter writer, Document document) {
                try {
                    PdfReportWriter.this.printFooter(writer, document);
                }
                catch (DocumentException e) {
                    Debug.error("Failed to print footer: " + e.getMessage(), e);
                }
            }

            public void onStartPage(PdfWriter writer, Document document) {
                try {
                    PdfReportWriter.this.printHeader(writer, document);
                }
                catch (DocumentException e) {
                    Debug.error("Failed to print header: " + e.getMessage(), e);
                }
            }
        });
        this.iDocument.addTitle(this.iTitle);
        this.iDocument.addAuthor("UniTime " + Constants.getVersion() + ", www.unitime.org");
        if (this.iSubject != null) {
            this.iDocument.addSubject(this.iSubject);
        }
        this.iDocument.addCreator("UniTime " + Constants.getVersion() + ", www.unitime.org");
        this.iDocument.open();
    }

    protected void printFooter(PdfWriter writer, Document document) throws DocumentException {
        PdfContentByte cb = writer.getDirectContent();
        cb.beginText();
        cb.setFontAndSize(this.iFont.getBaseFont(), this.iFont.getSize());
        cb.showTextAligned(0, this.iFooter == null ? "" : this.iFooter, document.left(), document.bottom() - 12.0f, 0.0f);
        cb.showTextAligned(2, this.iPageId == null || this.iPageId.isEmpty() ? "" : this.iPageId, document.right(), document.bottom() - 12.0f, 0.0f);
        cb.showTextAligned(1, MSG.lrPage(this.iPageNo + 1), (document.left() + document.right()) / 2.0f, document.bottom() - 12.0f, 0.0f);
        cb.endText();
        ++this.iPageNo;
    }

    protected void printHeader(PdfWriter writer, Document document) throws DocumentException {
        PdfContentByte cb = writer.getDirectContent();
        if (this.iCont != null && !this.iCont.isEmpty()) {
            cb.beginText();
            cb.setFontAndSize(this.iFont.getBaseFont(), this.iFont.getSize());
            cb.showTextAligned(0, "UniTime " + Constants.getVersion(), document.left(), document.top() + 24.0f, 0.0f);
            cb.showTextAligned(2, this.iTitle, document.right(), document.top() + 24.0f, 0.0f);
            cb.showTextAligned(1, this.iTitle2, (document.left() + document.right()) / 2.0f, document.top() + 24.0f, 0.0f);
            cb.showTextAligned(0, Formats.getDateFormat(Formats.Pattern.DATE_MEETING).format(new Date()), document.left(), document.top() + 16.0f, 0.0f);
            cb.showTextAligned(2, this.iSession, document.right(), document.top() + 16.0f, 0.0f);
            cb.showTextAligned(2, "(" + this.iCont + " Continued)", document.right(), document.top() + 4.0f, 0.0f);
            cb.endText();
            cb.setColorStroke(Color.BLACK);
            cb.moveTo(document.left(), document.top() + 12.0f);
            cb.lineTo(document.right(), document.top() + 12.0f);
            cb.closePathStroke();
        } else {
            cb.beginText();
            cb.setFontAndSize(this.iFont.getBaseFont(), this.iFont.getSize());
            cb.showTextAligned(0, "UniTime " + Constants.getVersion(), document.left(), document.top() + 14.0f, 0.0f);
            cb.showTextAligned(2, this.iTitle, document.right(), document.top() + 14.0f, 0.0f);
            cb.showTextAligned(1, this.iTitle2, (document.left() + document.right()) / 2.0f, document.top() + 14.0f, 0.0f);
            cb.showTextAligned(0, Formats.getDateFormat(Formats.Pattern.DATE_MEETING).format(new Date()), document.left(), document.top() + 4.0f, 0.0f);
            cb.showTextAligned(2, this.iSession, document.right(), document.top() + 4.0f, 0.0f);
            cb.endText();
            cb.setColorStroke(Color.BLACK);
            cb.moveTo(document.left(), document.top());
            cb.lineTo(document.right(), document.top());
            cb.closePathStroke();
        }
        this.iLineNo = 0;
        this.iNewPage = true;
        if (this.iListener != null) {
            this.iListener.headerPrinted();
        }
    }

    @Override
    public void setPageName(String pageName) {
        this.iPageId = pageName;
    }

    @Override
    public void setCont(String cont) {
        this.iCont = cont;
    }

    protected void computeColumnWidths(AbstractReport.Cell cell, List<Float> widths) {
        if (cell.getColSpan() == 0) {
            return;
        }
        float width = cell.getLength();
        if (width == 0.0f) {
            width = 1.0f;
        }
        widths.add(Float.valueOf(width / (float)cell.getColSpan()));
    }

    protected void computeColumnWidths(AbstractReport.Line line, List<Float> widths) {
        if (line.getCells() != null) {
            int length = 0;
            for (AbstractReport.Cell c : line.getCells()) {
                length += c.getLength();
                if (c.getColSpan() == 0) continue;
                for (int i = 0; i < c.getColSpan(); ++i) {
                    widths.add(Float.valueOf(1.0f + (length == 0 ? 1.0f : (float)length) / (float)c.getColSpan()));
                }
                length = 0;
            }
        }
        if (line.getLines() != null) {
            for (int i = 0; i < line.getLines().length; ++i) {
                this.computeColumnWidths(line.getLines()[i], widths);
            }
        }
    }

    protected float[] getColumnWidth(AbstractReport.Line line) {
        ArrayList<Float> cols = new ArrayList<Float>();
        this.computeColumnWidths(this.iHeaderLine[Math.max(0, this.iHeaderLine.length - 2)], cols);
        float[] ret = new float[cols.size()];
        for (int i = 0; i < cols.size(); ++i) {
            ret[i] = ((Float)cols.get(i)).floatValue();
        }
        return ret;
    }

    @Override
    public void printHeader(boolean newPage) throws DocumentException {
        this.finishCurrentTable();
        this.createNewTable();
    }

    protected void finishCurrentTable() throws DocumentException {
        if (this.iTable != null) {
            if (!this.iTable.getRows().isEmpty()) {
                PdfPRow row = this.iTable.getRow(this.iTable.getRows().size() - 1);
                for (PdfPCell c : row.getCells()) {
                    if (c == null) continue;
                    c.setBorder(c.getBorder() | 2);
                }
            }
            this.iDocument.add((Element)this.iTable);
            this.iTable = null;
        }
    }

    protected void createNewTable() throws DocumentException {
        if (this.iTable != null) {
            this.finishCurrentTable();
        }
        if (this.iHeaderLine != null && this.iHeaderLine.length > 0) {
            this.iTable = new PdfPTable(this.getColumnWidth(this.iHeaderLine[0]));
            this.iTable.getDefaultCell().setBorder(0);
            this.iTable.setWidthPercentage(100.0f);
            this.iTable.setSpacingBefore(4.0f);
            for (AbstractReport.Line line : this.iHeaderLine) {
                if (line.isEmpty()) continue;
                for (PdfPCell cell : this.render(line, this.iBoldFont)) {
                    cell.setBackgroundColor(Color.LIGHT_GRAY);
                    this.iTable.addCell(cell);
                }
                this.iTable.completeRow();
                ++this.iLineNo;
            }
            this.iTable.setHeaderRows(this.iTable.getRows().size());
            if (!this.iTable.getRows().isEmpty()) {
                PdfPRow row = this.iTable.getRow(this.iTable.getRows().size() - 1);
                for (PdfPCell c : row.getCells()) {
                    if (c == null) continue;
                    c.setBorder(c.getBorder() | 2);
                }
                row = this.iTable.getRow(0);
                for (PdfPCell c : row.getCells()) {
                    if (c == null) continue;
                    c.setBorder(c.getBorder() | 1);
                }
            }
        }
    }

    @Override
    public void newPage() throws DocumentException {
        if (this.iTable != null) {
            this.finishCurrentTable();
        }
        if (!this.iNewPage) {
            this.iDocument.newPage();
        }
        this.createNewTable();
    }

    @Override
    public void lastPage() throws DocumentException {
        this.finishCurrentTable();
    }

    @Override
    public int getLineNumber() {
        return this.iLineNo;
    }

    @Override
    public int getNrLinesPerPage() {
        return (int)((double)(this.iDocument.top() - this.iDocument.bottom()) / (1.5 * (double)this.iFont.getSize())) - 1;
    }

    @Override
    public int getNrCharsPerLine() {
        return 1000;
    }

    private String render(AbstractReport.Cell cell) {
        StringBuffer ret = new StringBuffer();
        if (cell.getText() != null) {
            if (cell.getPadding() != ' ' && cell.getText().length() < cell.getLength()) {
                ret.append(cell.render());
            } else {
                ret.append(cell.getText());
            }
        }
        if (cell.getCells() != null) {
            if (cell.getText() != null) {
                if (cell.getCellSeparator().isEmpty()) {
                    ret.append(" ");
                } else {
                    ret.append(cell.getCellSeparator());
                }
            }
            for (int i = 0; i < cell.getCells().length; ++i) {
                if (i > 0) {
                    if (cell.getCells()[i - 1].getCellSeparator().isEmpty()) {
                        ret.append(" ");
                    } else {
                        ret.append(cell.getCells()[i - 1].getCellSeparator());
                    }
                }
                ret.append(this.render(cell.getCells()[i]));
            }
        }
        return ret.toString();
    }

    private List<PdfPCell> render(AbstractReport.Line line, Font font) {
        if (line == null) {
            return null;
        }
        if (line.getLines() != null) {
            ArrayList<PdfPCell> ret = new ArrayList<PdfPCell>();
            for (int i = 0; i < line.getLines().length; ++i) {
                ret.addAll(this.render(line.getLines()[i], font));
            }
            return ret;
        }
        if (line.getCells() != null) {
            ArrayList<PdfPCell> ret = new ArrayList<PdfPCell>();
            String leftOver = null;
            for (AbstractReport.Cell cell : line.getCells()) {
                if (cell.getColSpan() == 0) {
                    leftOver = ((leftOver == null || leftOver.isEmpty() ? "" : leftOver + " ") + this.render(cell)).trim();
                    continue;
                }
                PdfPCell c = new PdfPCell();
                c.setVerticalAlignment(4);
                Paragraph ch = new Paragraph((leftOver == null || leftOver.isEmpty() ? "" : leftOver + " ") + this.render(cell), font);
                if (cell.getAlignment() != null) {
                    switch (cell.getAlignment()) {
                        case Center: {
                            ch.setAlignment(1);
                            break;
                        }
                        case Left: {
                            ch.setAlignment(0);
                            break;
                        }
                        case Right: {
                            ch.setAlignment(2);
                            c.setPaddingRight(5.0f);
                        }
                    }
                }
                c.setFixedHeight(this.iFont.getSize() * 1.5f);
                ch.setLeading(0.0f, 1.0f);
                c.addElement((Element)ch);
                c.setBorder(0);
                c.setColspan(cell.getColSpan());
                if (cell.getCellSeparator() != null && cell.getCellSeparator().trim().equals("|")) {
                    c.setBorder(8);
                }
                ret.add(c);
                leftOver = null;
            }
            if (ret.isEmpty()) {
                PdfPCell c = new PdfPCell();
                c.setVerticalAlignment(4);
                c.setBorder(0);
                c.setColspan(this.iTable.getNumberOfColumns());
                c.setFixedHeight(this.iFont.getSize() * 1.5f);
                ret.add(c);
            }
            if (ret.size() > 0) {
                ((PdfPCell)ret.get(0)).setBorder(((PdfPCell)ret.get(0)).getBorder() | 4);
                ((PdfPCell)ret.get(ret.size() - 1)).setBorder(((PdfPCell)ret.get(ret.size() - 1)).getBorder() | 8);
            }
            return ret;
        }
        return null;
    }

    @Override
    public void printSeparator(AbstractReport.Line line) throws DocumentException {
        if (this.iTable != null && !this.iTable.getRows().isEmpty()) {
            PdfPRow row = this.iTable.getRow(this.iTable.getRows().size() - 1);
            for (PdfPCell c : row.getCells()) {
                if (c == null) continue;
                c.setBorder(c.getBorder() | 2);
            }
        }
    }

    @Override
    public int getSeparatorNrLines() {
        return 0;
    }

    @Override
    public void setListener(ReportWriter.Listener listener) {
        this.iListener = listener;
    }

    @Override
    public boolean isSkipRepeating() {
        return true;
    }
}

