/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports;

import com.lowagie.text.DocumentException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.ReportWriter;

public class CsvReportWriter
implements ReportWriter {
    private PrintWriter iPrint = null;
    private AbstractReport.Line[] iHeaderLine = null;

    public CsvReportWriter(OutputStream out, String title, String title2, String subject, String session) throws DocumentException, IOException {
        if (out != null) {
            this.open(out);
        }
    }

    @Override
    public void setFooter(String footer) {
    }

    @Override
    public void setHeader(AbstractReport.Line ... line) {
        this.iHeaderLine = line;
    }

    @Override
    public AbstractReport.Line[] getHeader() {
        return this.iHeaderLine;
    }

    protected void println(String text) throws DocumentException {
        if (text == null) {
            this.iPrint.println();
        } else {
            this.iPrint.println(text);
        }
    }

    @Override
    public void close() throws IOException, DocumentException {
        this.iPrint.close();
    }

    @Override
    public void open(OutputStream out) throws DocumentException, IOException {
        this.iPrint = new PrintWriter(out);
    }

    @Override
    public void setPageName(String pageName) {
    }

    @Override
    public void setCont(String cont) {
    }

    @Override
    public void printHeader(boolean newPage) throws DocumentException {
        if (this.iHeaderLine != null) {
            for (int i = 0; i < this.iHeaderLine.length; ++i) {
                if (this.iHeaderLine[i].isEmpty()) continue;
                this.printLine(this.iHeaderLine[i]);
            }
        }
    }

    @Override
    public void newPage() throws DocumentException {
    }

    @Override
    public void lastPage() throws DocumentException {
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public int getNrLinesPerPage() {
        return 0;
    }

    @Override
    public int getNrCharsPerLine() {
        return 1000;
    }

    private String render(AbstractReport.Cell cell) {
        StringBuffer ret = new StringBuffer();
        if (cell.getText() != null) {
            if (cell.getPadding() != ' ' && cell.getText().length() < cell.getLength()) {
                ret.append(cell.render());
            } else {
                ret.append(cell.getText());
            }
        }
        if (cell.getCells() != null) {
            if (cell.getText() != null) {
                if (cell.getCellSeparator().isEmpty()) {
                    ret.append(" ");
                } else {
                    ret.append(cell.getCellSeparator());
                }
            }
            for (int i = 0; i < cell.getCells().length; ++i) {
                if (i > 0) {
                    if (cell.getCells()[i - 1].getCellSeparator().isEmpty()) {
                        ret.append(" ");
                    } else {
                        ret.append(cell.getCells()[i - 1].getCellSeparator());
                    }
                }
                ret.append(this.render(cell.getCells()[i]));
            }
        }
        return ret.toString();
    }

    private String quote(String cell) {
        if (cell == null) {
            return "";
        }
        if (cell.indexOf(34) < 0 && cell.indexOf(10) < 0 && cell.indexOf(44) < 0) {
            return cell;
        }
        return "\"" + cell.replaceAll("\"", "\"\"") + "\"";
    }

    private String render(AbstractReport.Line line) {
        if (line == null) {
            return "";
        }
        if (line.getLines() != null) {
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < line.getLines().length; ++i) {
                if (i > 0) {
                    ret.append(",,");
                }
                ret.append(this.render(line.getLines()[i]));
            }
            return ret.toString();
        }
        if (line.getCells() != null) {
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < line.getCells().length; ++i) {
                if (i > 0) {
                    if (line.getCells()[i - 1].getColSpan() == 0) {
                        ret.append(" ");
                    } else {
                        ret.append(",");
                    }
                }
                ret.append(this.quote(this.render(line.getCells()[i])));
                for (int j = 1; j < line.getCells()[i].getColSpan(); ++j) {
                    ret.append(",");
                }
            }
            return ret.toString();
        }
        return "";
    }

    @Override
    public void printLine(AbstractReport.Line line) throws DocumentException {
        this.println(this.render(line));
    }

    @Override
    public void printSeparator(AbstractReport.Line line) throws DocumentException {
    }

    @Override
    public int getSeparatorNrLines() {
        return 0;
    }

    @Override
    public void setListener(ReportWriter.Listener listener) {
    }

    @Override
    public boolean isSkipRepeating() {
        return false;
    }
}

