/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.Collection;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class ReloadStudent
extends ReloadAllData {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Collection<Long> iStudentIds = null;

    public ReloadStudent forStudents(Long ... studentIds) {
        this.iStudentIds = new ArrayList<Long>();
        for (Long studentId : studentIds) {
            this.iStudentIds.add(studentId);
        }
        return this;
    }

    public ReloadStudent forStudents(Collection<Long> studentIds) {
        this.iStudentIds = studentIds;
        return this;
    }

    public Collection<Long> getStudentIds() {
        return this.iStudentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        helper.info(this.getStudentIds().size() + " students changed.");
        for (Long studentId : this.getStudentIds()) {
            helper.getAction().addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(studentId).setType(OnlineSectioningLog.Entity.EntityType.STUDENT));
            OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(studentId).setType(OnlineSectioningLog.Entity.EntityType.STUDENT));
            OnlineSectioningServer.Lock lock = server.lockStudent(studentId, helper.getHibSession().createQuery("select distinct e.courseOffering.instructionalOffering.uniqueId from StudentClassEnrollment e where e.student.uniqueId = :studentId").setLong("studentId", studentId.longValue()).list(), this.name());
            try {
                helper.beginTransaction();
                try {
                    XStudent oldStudent = server.getStudent(studentId);
                    if (oldStudent != null) {
                        OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                        enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                        for (XRequest oldRequest : oldStudent.getRequests()) {
                            if (!(oldRequest instanceof XCourseRequest) || ((XCourseRequest)oldRequest).getEnrollment() == null) continue;
                            XEnrollment enrl = ((XCourseRequest)oldRequest).getEnrollment();
                            XOffering offering = server.getOffering(enrl.getOfferingId());
                            for (XSection section : offering.getSections(enrl)) {
                                enrollment.addSection(OnlineSectioningHelper.toProto(section, enrl));
                            }
                        }
                        action.addEnrollment(enrollment);
                        server.remove(oldStudent);
                        action.getStudentBuilder().setUniqueId(oldStudent.getStudentId()).setExternalId(oldStudent.getExternalId()).setName(oldStudent.getName());
                    }
                    Student student = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                    XStudent newStudent = null;
                    if (student != null) {
                        newStudent = ReloadStudent.loadStudent(student, null, server, helper, WaitList.WaitListType.RELOAD);
                        if (newStudent != null) {
                            server.update(newStudent, true);
                            OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                            enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                            for (XRequest newRequest : newStudent.getRequests()) {
                                action.addRequest(OnlineSectioningHelper.toProto(newRequest));
                                if (!(newRequest instanceof XCourseRequest) || ((XCourseRequest)newRequest).getEnrollment() == null) continue;
                                XEnrollment enrl = ((XCourseRequest)newRequest).getEnrollment();
                                XOffering offering = server.getOffering(enrl.getOfferingId());
                                for (XSection section : offering.getSections(enrl)) {
                                    enrollment.addSection(OnlineSectioningHelper.toProto(section, enrl));
                                }
                            }
                            action.addEnrollment(enrollment);
                        }
                        action.getStudentBuilder().setUniqueId(newStudent.getStudentId()).setExternalId(newStudent.getExternalId()).setName(newStudent.getName());
                    }
                    server.execute(server.createAction(NotifyStudentAction.class).forStudent(studentId).fromAction(this.name()).oldStudent(oldStudent), helper.getUser());
                    helper.commitTransaction();
                }
                catch (Exception e) {
                    helper.rollbackTransaction();
                    if (e instanceof SectioningException) {
                        throw (SectioningException)e;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                }
            }
            finally {
                lock.release();
            }
            action.setEndTime(System.currentTimeMillis());
        }
        return true;
    }

    @Override
    public String name() {
        return "reload-student";
    }
}

