/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.Collection;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class ChangeStudentGroup
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Collection<Long> iStudentIds = null;
    private Long iGroupId = null;
    private boolean iRemove = true;

    public ChangeStudentGroup forStudents(Collection<Long> studentIds) {
        this.iStudentIds = studentIds;
        return this;
    }

    public ChangeStudentGroup withGroup(Long groupId, boolean remove) {
        this.iGroupId = groupId;
        this.iRemove = remove;
        return this;
    }

    public Collection<Long> getStudentIds() {
        return this.iStudentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        StudentGroup group = (StudentGroup)helper.getHibSession().createQuery("from StudentGroup where uniqueId = :groupId").setLong("groupId", this.iGroupId.longValue()).uniqueResult();
        if (group == null || group.getType() == null || !group.getType().isAdvisorsCanSet().booleanValue()) {
            return false;
        }
        for (Long studentId : this.getStudentIds()) {
            OnlineSectioningServer.Lock lock = server.lockStudent(studentId, null, this.name());
            try {
                XStudent student = server.getStudent(studentId);
                helper.beginTransaction();
                try {
                    Student dbStudent = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                    if (student != null && dbStudent != null) {
                        OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
                        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName()));
                        action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(group.getUniqueId()).setName(group.getGroupAbbreviation()).setExternalId(group.getGroupName()).setType(OnlineSectioningLog.Entity.EntityType.OTHER));
                        action.addOptionBuilder().setKey("action").setValue(this.iRemove ? "remove" : "add");
                        action.addMessageBuilder().setLevel(OnlineSectioningLog.Message.Level.INFO).setText(group.getGroupAbbreviation() + " - " + group.getGroupName() + " (" + (this.iRemove ? "remove" : "add") + ")");
                        boolean changed = false;
                        if (this.iRemove) {
                            changed = group.getStudents().remove(dbStudent);
                            dbStudent.getGroups().remove(group);
                            student.getGroups().remove(new XStudent.XGroup(group));
                        } else {
                            changed = group.getStudents().add(dbStudent);
                            dbStudent.getGroups().add(group);
                            if (changed) {
                                student.getGroups().add(new XStudent.XGroup(group));
                            }
                        }
                        helper.getHibSession().saveOrUpdate((Object)group);
                        server.update(student, false);
                        action.setResult(changed ? OnlineSectioningLog.Action.ResultType.TRUE : OnlineSectioningLog.Action.ResultType.FALSE);
                    }
                    helper.commitTransaction();
                }
                catch (Exception e) {
                    helper.rollbackTransaction();
                    if (e instanceof SectioningException) {
                        throw (SectioningException)e;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                }
            }
            finally {
                lock.release();
            }
        }
        return true;
    }

    @Override
    public String name() {
        return "group-change";
    }
}

