/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.Collection;
import java.util.Date;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XApproval;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class ApproveEnrollmentsAction
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iOfferingId;
    private Collection<Long> iStudentIds;
    private Collection<Long> iCourseIdsCanApprove;
    private String iApproval;

    public ApproveEnrollmentsAction withParams(Long offeringId, Collection<Long> studentIds, Collection<Long> courseIdsCanApprove, String approval) {
        this.iOfferingId = offeringId;
        this.iStudentIds = studentIds;
        this.iCourseIdsCanApprove = courseIdsCanApprove;
        this.iApproval = approval;
        return this;
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public Collection<Long> getStudentIds() {
        return this.iStudentIds;
    }

    public String getApproval() {
        return this.iApproval;
    }

    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock lock = server.lockOffering(this.getOfferingId(), this.getStudentIds(), this.name());
        try {
            helper.getAction().addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getOfferingId()).setType(OnlineSectioningLog.Entity.EntityType.OFFERING));
            String[] approval = this.getApproval().split(":");
            Date approvedDate = new Date(Long.valueOf(approval[0]));
            helper.beginTransaction();
            try {
                XOffering offering = server.getOffering(this.getOfferingId());
                XEnrollments enrollments = server.getEnrollments(this.getOfferingId());
                if (offering == null || enrollments == null) {
                    throw new SectioningException(MSG.exceptionBadOffering());
                }
                for (XCourseRequest request : enrollments.getRequests()) {
                    XStudent student;
                    XEnrollment enrollment = request.getEnrollment();
                    if (enrollment == null || !enrollment.getOfferingId().equals(this.getOfferingId()) || !this.getStudentIds().contains(enrollment.getStudentId()) || !this.iCourseIdsCanApprove.contains(enrollment.getCourseId()) || (student = server.getStudent(enrollment.getStudentId())) == null) continue;
                    OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
                    action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName()));
                    action.addRequest(OnlineSectioningHelper.toProto(request));
                    OnlineSectioningLog.Enrollment.Builder enrl = OnlineSectioningLog.Enrollment.newBuilder();
                    enrl.setType(OnlineSectioningLog.Enrollment.EnrollmentType.APPROVED);
                    for (XSection assignment : offering.getSections(enrollment)) {
                        enrl.addSection(OnlineSectioningHelper.toProto(assignment, enrollment));
                    }
                    action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(offering.getOfferingId()).setName(offering.getName()).setType(OnlineSectioningLog.Entity.EntityType.OFFERING));
                    action.addOther(OnlineSectioningLog.Entity.newBuilder().setName(approval[2]).setExternalId(approval[1]).setType(OnlineSectioningLog.Entity.EntityType.MANAGER));
                    action.addEnrollment(enrl);
                    XEnrollment oldEnrollment = new XEnrollment(enrollment);
                    enrollment.setApproval(new XApproval(approval[1], approvedDate, approval[2]));
                    XCourseRequest r = server.assign(request, enrollment);
                    if (r == null || r.getEnrollment() == null) continue;
                    for (StudentClassEnrollment e : helper.getHibSession().createQuery("from StudentClassEnrollment e where e.student.uniqueId = :studentId and e.courseOffering.instructionalOffering = :offeringId").setLong("studentId", enrollment.getStudentId().longValue()).setLong("offeringId", this.getOfferingId().longValue()).list()) {
                        e.setApprovedBy(approval[1]);
                        e.setApprovedDate(approvedDate);
                        helper.getHibSession().saveOrUpdate((Object)e);
                    }
                    server.execute(server.createAction(NotifyStudentAction.class).forStudent(enrollment.getStudentId()).fromAction(this.name()).oldEnrollment(offering, offering.getCourse(oldEnrollment.getCourseId()), oldEnrollment), helper.getUser());
                }
                helper.commitTransaction();
                Boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                helper.rollbackTransaction();
                if (e instanceof SectioningException) {
                    throw (SectioningException)e;
                }
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "approve-enrollments";
    }
}

