/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.base.BaseStudentAreaClassificationMajor;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.FindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;

public class DbFindEnrollmentInfoAction
extends FindEnrollmentInfoAction {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);

    public boolean isMyStudent(Student student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getUniqueId());
    }

    protected String datePatternName(DatePattern pattern, String datePatternFormat) {
        if ("never".equals(datePatternFormat)) {
            return pattern.getName();
        }
        if ("extended".equals(datePatternFormat) && !pattern.isExtended()) {
            return pattern.getName();
        }
        if ("alternate".equals(datePatternFormat) && pattern.isAlternate()) {
            return pattern.getName();
        }
        Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
        Date first = pattern.getStartDate();
        Date last = pattern.getEndDate();
        return dpf.format(first) + (first.equals(last) ? "" : " - " + dpf.format(last));
    }

    @Override
    public List<ClassAssignmentInterface.EnrollmentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iFilter == null) {
            return super.execute(server, helper);
        }
        ArrayList<ClassAssignmentInterface.EnrollmentInfo> ret = new ArrayList<ClassAssignmentInterface.EnrollmentInfo>();
        AcademicSessionInfo session = server.getAcademicSession();
        StatusPageSuggestionsAction.CourseLookup lookup = new StatusPageSuggestionsAction.CourseLookup(server.getAcademicSession());
        if (this.courseId() == null) {
            HashSet<Long> students = new HashSet<Long>();
            HashSet<Long> matchingStudents = new HashSet<Long>();
            int gEnrl = 0;
            int gWait = 0;
            int gRes = 0;
            int gUnasg = 0;
            int gUnasgPrim = 0;
            int gNoSub = 0;
            int gSwap = 0;
            int gtEnrl = 0;
            int gtWait = 0;
            int gtRes = 0;
            int gtUnasg = 0;
            int gtUnasgPrim = 0;
            int gtNoSub = 0;
            int gtSwap = 0;
            int gConNeed = 0;
            int gtConNeed = 0;
            int gOvrNeed = 0;
            int gtOvrNeed = 0;
            DbFindEnrollmentInfoCourseMatcher m = new DbFindEnrollmentInfoCourseMatcher(this.iCoursesIcoordinate, this.iCoursesIcanApprove, this.iSubjectAreas, this.iQuery, lookup, server);
            HashMap requests = new HashMap();
            block2: for (CourseRequest cr : SectioningStatusFilterAction.getCourseQuery(this.iFilter, server, helper).select("distinct cr").query(helper.getHibSession()).list()) {
                ArrayList<CourseRequest> list;
                if (!m.match(cr.getCourseOffering())) continue;
                if (cr.getClassEnrollments().isEmpty()) {
                    for (CourseRequest x : cr.getCourseDemand().getCourseRequests()) {
                        if (x.equals(cr) || x.getClassEnrollments().isEmpty()) continue;
                        continue block2;
                    }
                }
                if ((list = (ArrayList<CourseRequest>)requests.get(cr.getCourseOffering())) == null) {
                    list = new ArrayList<CourseRequest>();
                    requests.put(cr.getCourseOffering(), list);
                }
                list.add(cr);
            }
            if (this.iShowUnmatchedCourses && SectioningStatusFilterAction.hasNoMatchCourses(this.iFilter, helper)) {
                try {
                    for (Object co : SectioningStatusFilterAction.getCourseQuery(this.iFilter, server, helper).selectCourses("distinct co", this.iFilter).query(helper.getHibSession()).list()) {
                        if (requests.containsKey(co) || !m.match((CourseOffering)co)) continue;
                        requests.put(co, new ArrayList());
                    }
                }
                catch (Exception e) {
                    this.iShowUnmatchedCourses = false;
                }
            } else {
                this.iShowUnmatchedCourses = false;
            }
            boolean checkOverrides = !this.query().hasAttribute("override");
            for (Map.Entry entry : requests.entrySet()) {
                Object request22;
                CourseOffering course = (CourseOffering)entry.getKey();
                InstructionalOffering offering = course.getInstructionalOffering();
                HashSet<Long> allStudents = new HashSet<Long>();
                boolean isConsentToDoCourse = this.isConsentToDoCourse(course);
                ClassAssignmentInterface.EnrollmentInfo e = new ClassAssignmentInterface.EnrollmentInfo();
                e.setCourseId(course.getUniqueId());
                e.setOfferingId(offering.getUniqueId());
                e.setSubject(course.getSubjectAreaAbbv());
                e.setCourseNbr(course.getCourseNbr());
                e.setTitle(course.getTitle());
                e.setConsent(course.getConsentType() == null ? null : course.getConsentType().getAbbv());
                e.setControl(course.isIsControl());
                int match = 0;
                int enrl = 0;
                int n = 0;
                int res = 0;
                int unasg = 0;
                int unasgPrim = 0;
                int noSub = 0;
                int swap = 0;
                int tEnrl = 0;
                int tWait = 0;
                int tRes = 0;
                int tUnasg = 0;
                int tUnasgPrim = 0;
                int tNoSub = 0;
                int tSwap = 0;
                int conNeed = 0;
                int tConNeed = 0;
                int ovrNeed = 0;
                int tOvrNeed = 0;
                block6: for (Object request22 : helper.getHibSession().createQuery("from CourseRequest where courseOffering.uniqueId = :courseId").setLong("courseId", course.getUniqueId().longValue()).setCacheable(true).list()) {
                    if (checkOverrides && !((CourseRequest)request22).isRequestApproved() && !((CourseRequest)request22).isRequestNotNeeded() && ((CourseRequest)request22).getClassEnrollments().isEmpty()) continue;
                    if (((CourseRequest)request22).getClassEnrollments().isEmpty()) {
                        for (CourseRequest x : ((BaseCourseRequest)request22).getCourseDemand().getCourseRequests()) {
                            if (x.equals(request22) || x.getClassEnrollments().isEmpty()) continue;
                            continue block6;
                        }
                    }
                    DbCourseRequestMatcher crm = new DbCourseRequestMatcher(session, (CourseRequest)request22, isConsentToDoCourse, this.isMyStudent(((BaseCourseRequest)request22).getCourseDemand().getStudent()), helper.getStudentNameFormat(), lookup);
                    if (this.query().match(crm)) continue;
                    allStudents.add(crm.student().getUniqueId());
                    if (!crm.enrollment().isEmpty()) {
                        ++tEnrl;
                        if (crm.reservation() != null) {
                            ++tRes;
                        }
                        if (((BaseCourseRequest)request22).getCourseOffering().getConsentType() != null && crm.approval() == null) {
                            ++tConNeed;
                        }
                        if (!crm.request().getCourseDemand().effectiveWaitList() || crm.request().getCourseDemand().isEnrolledExceptForWaitListSwap()) continue;
                        ++tSwap;
                        continue;
                    }
                    if (!crm.canAssign()) continue;
                    ++tUnasg;
                    if (((BaseCourseRequest)request22).getCourseDemand().isAlternative().booleanValue() || ((BaseCourseRequest)request22).getOrder() != 0) continue;
                    ++tUnasgPrim;
                    if (((BaseCourseRequest)request22).getCourseDemand().effectiveWaitList()) {
                        ++tWait;
                    }
                    if (!((BaseCourseRequest)request22).getCourseDemand().effectiveNoSub()) continue;
                    ++tNoSub;
                }
                HashSet<Long> addedStudents = new HashSet<Long>();
                request22 = ((List)entry.getValue()).iterator();
                while (request22.hasNext()) {
                    CourseRequest request3 = (CourseRequest)request22.next();
                    if (checkOverrides && !request3.isRequestApproved() && !request3.isRequestNotNeeded() && request3.getClassEnrollments().isEmpty()) continue;
                    Student student = request3.getCourseDemand().getStudent();
                    if (students.add(student.getUniqueId())) {
                        addedStudents.add(student.getUniqueId());
                    }
                    DbCourseRequestMatcher crm = new DbCourseRequestMatcher(session, request3, isConsentToDoCourse, this.isMyStudent(student), helper.getStudentNameFormat(), lookup);
                    if (this.query().match(crm)) {
                        matchingStudents.add(student.getUniqueId());
                        ++match;
                        if (!crm.enrollment().isEmpty()) {
                            ++enrl;
                            if (crm.reservation() != null) {
                                ++res;
                            }
                            if (request3.getCourseOffering().getConsentType() != null && crm.approval() == null) {
                                ++conNeed;
                            }
                            if (crm.request().getCourseDemand().effectiveWaitList() && !crm.request().getCourseDemand().isEnrolledExceptForWaitListSwap()) {
                                ++swap;
                            }
                        } else if (crm.canAssign()) {
                            ++unasg;
                            if (!request3.getCourseDemand().isAlternative().booleanValue() && request3.getOrder() == 0) {
                                ++unasgPrim;
                                if (request3.getCourseDemand().effectiveWaitList()) {
                                    ++n;
                                }
                                if (request3.getCourseDemand().effectiveNoSub()) {
                                    ++noSub;
                                }
                            }
                        }
                        if (request3.isRequestPending()) {
                            ++ovrNeed;
                        }
                    }
                    if (allStudents.add(crm.student().getUniqueId())) {
                        if (!crm.enrollment().isEmpty()) {
                            ++tEnrl;
                            if (crm.reservation() != null) {
                                ++tRes;
                            }
                            if (request3.getCourseOffering().getConsentType() != null && crm.approval() == null) {
                                ++tConNeed;
                            }
                            if (crm.request().getCourseDemand().effectiveWaitList() && !crm.request().getCourseDemand().isEnrolledExceptForWaitListSwap()) {
                                ++tSwap;
                            }
                        } else if (crm.canAssign()) {
                            ++tUnasg;
                            if (!request3.getCourseDemand().isAlternative().booleanValue() && request3.getOrder() == 0) {
                                ++tUnasgPrim;
                                if (request3.getCourseDemand().effectiveWaitList()) {
                                    ++tWait;
                                }
                                if (request3.getCourseDemand().effectiveNoSub()) {
                                    ++tNoSub;
                                }
                            }
                        }
                    }
                    if (!request3.isRequestPending()) continue;
                    ++tOvrNeed;
                }
                if (match == 0 && !this.iShowUnmatchedCourses) {
                    students.removeAll(addedStudents);
                    continue;
                }
                e.setNoMatch(match == 0);
                gEnrl += enrl;
                gWait += n;
                gNoSub += noSub;
                gSwap += swap;
                gUnasg += unasg;
                gUnasgPrim += unasgPrim;
                gRes += res;
                gConNeed += conNeed;
                gOvrNeed += ovrNeed;
                gtEnrl += tEnrl;
                gtWait += tWait;
                gtNoSub += tNoSub;
                gtSwap += tSwap;
                gtUnasg += tUnasg;
                gtUnasgPrim += tUnasgPrim;
                gtRes += tRes;
                gtConNeed += tConNeed;
                gtOvrNeed += tOvrNeed;
                int limit = 0;
                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                    if (config.isUnlimitedEnrollment().booleanValue()) {
                        limit = -1;
                        break;
                    }
                    limit += config.getLimit().intValue();
                }
                e.setLimit(course.getReservation() != null ? course.getReservation() : limit);
                e.setSnapshot(course.getInstructionalOffering().getSnapshotLimit());
                e.setProjection(course.getProjectedDemand() != null ? course.getProjectedDemand() : (course.getDemand() != null ? course.getDemand() : 0));
                int av = Math.max(0, offering.getUnreservedSpace());
                if (e.getLimit() >= 0 && av > e.getLimit() - course.getEnrollment()) {
                    av = e.getLimit() - course.getEnrollment();
                }
                if (av == Integer.MAX_VALUE) {
                    av = -1;
                }
                e.setAvailable(av);
                if (av >= 0) {
                    int other = 0;
                    for (CourseOffering c : offering.getCourseOfferings()) {
                        if (c.equals(course)) continue;
                        other += c.getEnrollment().intValue();
                    }
                    e.setOther(Math.min(e.getLimit() - course.getEnrollment() - av, other));
                    int lim = 0;
                    for (InstrOfferingConfig f : offering.getInstrOfferingConfigs()) {
                        if (lim < 0 || f.isUnlimitedEnrollment().booleanValue()) {
                            lim = -1;
                            continue;
                        }
                        lim += f.getLimit().intValue();
                    }
                    if (lim >= 0 && lim < e.getLimit()) {
                        e.setOther(e.getOther() + e.getLimit() - limit);
                    }
                }
                e.setEnrollment(enrl);
                e.setReservation(res);
                e.setWaitlist(n);
                e.setNoSub(noSub);
                e.setSwap(swap);
                e.setUnassigned(unasg);
                e.setUnassignedPrimary(unasgPrim);
                e.setTotalEnrollment(tEnrl);
                e.setTotalReservation(tRes);
                e.setTotalWaitlist(tWait);
                e.setTotalNoSub(tNoSub);
                e.setTotalSwap(tSwap);
                e.setTotalUnassigned(tUnasg);
                e.setTotalUnassignedPrimary(tUnasgPrim);
                e.setConsentNeeded(conNeed);
                e.setTotalConsentNeeded(tConNeed);
                e.setOverrideNeeded(ovrNeed);
                e.setTotalOverrideNeeded(tOvrNeed);
                ret.add(e);
                if (this.limit() == null || ret.size() < this.limit()) continue;
                break;
            }
            final NaturalOrderComparator noc = new NaturalOrderComparator();
            Collections.sort(ret, new Comparator<ClassAssignmentInterface.EnrollmentInfo>(){

                @Override
                public int compare(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
                    int cmp = noc.compare(e1.getSubject(), e2.getSubject());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return 0;
                }
            });
            ClassAssignmentInterface.EnrollmentInfo t = new ClassAssignmentInterface.EnrollmentInfo();
            t.setSubject(MSG.total());
            t.setCourseNbr("");
            t.setLimit(students.size());
            t.setAvailable(matchingStudents.size());
            t.setEnrollment(gEnrl);
            t.setReservation(gRes);
            t.setWaitlist(gWait);
            t.setNoSub(gNoSub);
            t.setSwap(gSwap);
            t.setUnassigned(gUnasg);
            t.setUnassignedPrimary(gUnasgPrim);
            t.setTotalEnrollment(gtEnrl);
            t.setTotalReservation(gtRes);
            t.setTotalWaitlist(gtWait);
            t.setTotalNoSub(gtNoSub);
            t.setTotalSwap(gtSwap);
            t.setTotalUnassigned(gtUnasg);
            t.setTotalUnassignedPrimary(gtUnasgPrim);
            t.setConsentNeeded(gConNeed);
            t.setTotalConsentNeeded(gtConNeed);
            t.setOverrideNeeded(gOvrNeed);
            t.setTotalOverrideNeeded(gtOvrNeed);
            ret.add(t);
        } else {
            Object e;
            boolean checkOverrides;
            final CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(this.courseId(), helper.getHibSession());
            if (course == null) {
                return ret;
            }
            InstructionalOffering offering = course.getInstructionalOffering();
            if (offering == null) {
                return ret;
            }
            List requests = helper.getHibSession().createQuery("from CourseRequest where courseOffering.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", offering.getUniqueId().longValue()).setCacheable(true).list();
            OverExpectedCriterion overExp = server.getOverExpectedCriterion();
            boolean bl = checkOverrides = !this.query().hasAttribute("override");
            if (offering.getCourseOfferings().size() > 1) {
                HashSet<Long> allStudents = new HashSet<Long>();
                for (CourseOffering other : offering.getCourseOfferings()) {
                    if (course.equals(other)) continue;
                    boolean isConsentToDoCourse = this.isConsentToDoCourse(other);
                    e = new ClassAssignmentInterface.EnrollmentInfo();
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setCourseId(other.getUniqueId());
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setOfferingId(offering.getUniqueId());
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setSubject(other.getSubjectAreaAbbv());
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setCourseNbr(other.getCourseNbr());
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setTitle(other.getTitle());
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setConsent(other.getConsentType() == null ? null : other.getConsentType().getAbbv());
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setControl(other.isIsControl());
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setMasterCourseId(course.getUniqueId());
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setMasterSubject(course.getSubjectAreaAbbv());
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setMasterCourseNbr(course.getCourseNbr());
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setConfigId(-1L);
                    int enrl = 0;
                    int wait = 0;
                    int res = 0;
                    int unasg = 0;
                    int unasgPrim = 0;
                    int noSub = 0;
                    int swap = 0;
                    int tEnrl = 0;
                    int tWait = 0;
                    int tRes = 0;
                    int tUnasg = 0;
                    int tUnasgPrim = 0;
                    int tNoSub = 0;
                    int tSwap = 0;
                    int conNeed = 0;
                    int tConNeed = 0;
                    int ovrNeed = 0;
                    int tOvrNeed = 0;
                    for (CourseRequest request : requests) {
                        if (!request.getCourseOffering().equals(other) || checkOverrides && !request.isRequestApproved() && !request.isRequestNotNeeded() && request.getClassEnrollments().isEmpty()) continue;
                        DbCourseRequestMatcher crm = new DbCourseRequestMatcher(session, request, isConsentToDoCourse, this.isMyStudent(request.getCourseDemand().getStudent()), helper.getStudentNameFormat(), lookup);
                        if (this.query().match(crm)) {
                            if (!crm.enrollment().isEmpty()) {
                                ++enrl;
                                if (crm.reservation() != null) {
                                    ++res;
                                }
                                if (request.getCourseOffering().getConsentType() != null && crm.approval() == null) {
                                    ++conNeed;
                                }
                                if (crm.request().getCourseDemand().effectiveWaitList() && !crm.request().getCourseDemand().isEnrolledExceptForWaitListSwap()) {
                                    ++swap;
                                }
                            } else if (crm.canAssign()) {
                                ++unasg;
                                if (!request.getCourseDemand().isAlternative().booleanValue() && request.getOrder() == 0) {
                                    ++unasgPrim;
                                    if (request.getCourseDemand().effectiveWaitList()) {
                                        ++wait;
                                    }
                                    if (request.getCourseDemand().effectiveNoSub()) {
                                        ++noSub;
                                    }
                                }
                            }
                            if (request.isRequestPending()) {
                                ++ovrNeed;
                            }
                        }
                        if (!allStudents.add(crm.student().getUniqueId())) continue;
                        if (!crm.enrollment().isEmpty()) {
                            ++tEnrl;
                            if (crm.reservation() != null) {
                                ++tRes;
                            }
                            if (request.getCourseOffering().getConsentType() != null && crm.approval() == null) {
                                ++tConNeed;
                            }
                            if (crm.request().getCourseDemand().effectiveWaitList() && !crm.request().getCourseDemand().isEnrolledExceptForWaitListSwap()) {
                                ++tSwap;
                            }
                        } else if (crm.canAssign()) {
                            ++tUnasg;
                            if (!request.getCourseDemand().isAlternative().booleanValue() && request.getOrder() == 0) {
                                ++tUnasgPrim;
                                if (request.getCourseDemand().effectiveWaitList()) {
                                    ++tWait;
                                }
                                if (request.getCourseDemand().effectiveNoSub()) {
                                    ++tNoSub;
                                }
                            }
                        }
                        if (!request.isRequestPending()) continue;
                        ++tOvrNeed;
                    }
                    int limit = 0;
                    for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                        if (config.isUnlimitedEnrollment().booleanValue()) {
                            limit = -1;
                            break;
                        }
                        limit += config.getLimit().intValue();
                    }
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setLimit(other.getReservation() != null ? other.getReservation() : limit);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setProjection(other.getProjectedDemand() != null ? other.getProjectedDemand() : (other.getDemand() != null ? other.getDemand() : 0));
                    int av = Math.max(0, offering.getUnreservedSpace());
                    if (((ClassAssignmentInterface.EnrollmentInfo)e).getLimit() >= 0 && av > ((ClassAssignmentInterface.EnrollmentInfo)e).getLimit() - other.getEnrollment()) {
                        av = ((ClassAssignmentInterface.EnrollmentInfo)e).getLimit() - other.getEnrollment();
                    }
                    if (av == Integer.MAX_VALUE) {
                        av = -1;
                    }
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setAvailable(av);
                    if (av >= 0) {
                        int otherEnrl = 0;
                        for (CourseOffering courseOffering : offering.getCourseOfferings()) {
                            if (courseOffering.equals(other)) continue;
                            otherEnrl += courseOffering.getEnrollment().intValue();
                        }
                        ((ClassAssignmentInterface.EnrollmentInfo)e).setOther(Math.min(((ClassAssignmentInterface.EnrollmentInfo)e).getLimit() - other.getEnrollment() - av, otherEnrl));
                        int lim = 0;
                        for (InstrOfferingConfig f : offering.getInstrOfferingConfigs()) {
                            if (lim < 0 || f.isUnlimitedEnrollment().booleanValue()) {
                                lim = -1;
                                continue;
                            }
                            lim += f.getLimit().intValue();
                        }
                        if (lim >= 0 && lim < ((ClassAssignmentInterface.EnrollmentInfo)e).getLimit()) {
                            ((ClassAssignmentInterface.EnrollmentInfo)e).setOther(((ClassAssignmentInterface.EnrollmentInfo)e).getOther() + ((ClassAssignmentInterface.EnrollmentInfo)e).getLimit() - limit);
                        }
                    }
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setEnrollment(enrl);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setReservation(res);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setWaitlist(wait);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setNoSub(noSub);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setSwap(swap);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setUnassigned(unasg);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setUnassignedPrimary(unasgPrim);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalEnrollment(tEnrl);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalReservation(tRes);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalWaitlist(tWait);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalNoSub(tNoSub);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalSwap(tSwap);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalUnassigned(tUnasg);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalUnassignedPrimary(tUnasgPrim);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setConsentNeeded(conNeed);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalConsentNeeded(tConNeed);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setOverrideNeeded(ovrNeed);
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalOverrideNeeded(tOvrNeed);
                    ret.add((ClassAssignmentInterface.EnrollmentInfo)e);
                    if (this.limit() == null || ret.size() < this.limit()) continue;
                    break;
                }
                final NaturalOrderComparator noc = new NaturalOrderComparator();
                Collections.sort(ret, new Comparator<ClassAssignmentInterface.EnrollmentInfo>(){

                    @Override
                    public int compare(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
                        int cmp = noc.compare(e1.getSubject(), e2.getSubject());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return 0;
                    }
                });
            }
            boolean isConsentToDoCourse = this.isConsentToDoCourse(course);
            ArrayList<Class_> sections = new ArrayList<Class_>();
            for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    sections.addAll(subpart.getClasses());
                }
            }
            Collections.sort(sections, new Comparator<Class_>(){

                @Override
                public int compare(InstrOfferingConfig c1, InstrOfferingConfig c2) {
                    int cmp = c1.getName().compareToIgnoreCase(c2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return c1.getUniqueId().compareTo(c2.getUniqueId());
                }

                public boolean isParent(SchedulingSubpart s1, SchedulingSubpart s2) {
                    SchedulingSubpart p1 = s1.getParentSubpart();
                    if (p1 == null) {
                        return false;
                    }
                    if (p1.equals(s2)) {
                        return true;
                    }
                    return this.isParent(p1, s2);
                }

                @Override
                public int compare(SchedulingSubpart s1, SchedulingSubpart s2) {
                    int cmp = this.compare(s1.getInstrOfferingConfig(), s2.getInstrOfferingConfig());
                    if (cmp != 0) {
                        return cmp;
                    }
                    if (this.isParent(s1, s2)) {
                        return 1;
                    }
                    if (this.isParent(s2, s1)) {
                        return -1;
                    }
                    cmp = s1.getItype().compareTo(s2.getItype());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getUniqueId().compareTo(s2.getUniqueId());
                }

                @Override
                public int compare(Class_ s1, Class_ s2) {
                    Class_ x;
                    if (s1.getSchedulingSubpart().equals(s2.getSchedulingSubpart())) {
                        int cmp;
                        if (s1.getParentClass() != null && (cmp = this.compare(s1.getParentClass(), s2.getParentClass())) != 0) {
                            return cmp;
                        }
                        try {
                            cmp = Integer.valueOf(s1.getClassSuffix(course) == null ? "0" : s1.getClassSuffix(course)).compareTo(Integer.valueOf(s2.getClassSuffix(course) == null ? "0" : s2.getClassSuffix(course)));
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        catch (NumberFormatException cmp2) {
                            // empty catch block
                        }
                        cmp = (s1.getClassSuffix(course) == null ? "" : s1.getClassSuffix(course)).compareTo(s2.getClassSuffix(course) == null ? "" : s2.getClassSuffix(course));
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getUniqueId().compareTo(s2.getUniqueId());
                    }
                    for (x = s1; x != null; x = x.getParentClass()) {
                        if (!this.isParent(s2.getSchedulingSubpart(), x.getSchedulingSubpart())) continue;
                        Class_ s = s2.getParentClass();
                        while (!s.getSchedulingSubpart().equals(x.getSchedulingSubpart())) {
                            s = s.getParentClass();
                        }
                        int cmp = this.compare(x, s);
                        return cmp == 0 ? (x.equals(s1) ? -1 : this.compare(x.getSchedulingSubpart(), s.getSchedulingSubpart())) : cmp;
                    }
                    for (x = s2; x != null; x = x.getParentClass()) {
                        if (!this.isParent(s1.getSchedulingSubpart(), x.getSchedulingSubpart())) continue;
                        Class_ s = s1.getParentClass();
                        while (!s.getSchedulingSubpart().equals(x.getSchedulingSubpart())) {
                            s = s.getParentClass();
                        }
                        int cmp = this.compare(s, x);
                        return cmp == 0 ? (x.equals(s2) ? 1 : this.compare(x.getSchedulingSubpart(), x.getSchedulingSubpart())) : cmp;
                    }
                    int cmp = this.compare(s1.getSchedulingSubpart(), s2.getSchedulingSubpart());
                    if (cmp != 0) {
                        return cmp;
                    }
                    try {
                        cmp = Integer.valueOf(s1.getClassSuffix(course) == null ? "0" : s1.getClassSuffix(course)).compareTo(Integer.valueOf(s2.getClassSuffix(course) == null ? "0" : s2.getClassSuffix(course)));
                        if (cmp != 0) {
                            return cmp;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    cmp = (s1.getClassSuffix(course) == null ? "" : s1.getClassSuffix(course)).compareTo(s2.getClassSuffix(course) == null ? "" : s2.getClassSuffix(course));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getUniqueId().compareTo(s2.getUniqueId());
                }
            });
            for (Class_ section : sections) {
                Object m;
                e = new ClassAssignmentInterface.EnrollmentInfo();
                ((ClassAssignmentInterface.EnrollmentInfo)e).setCourseId(course.getUniqueId());
                ((ClassAssignmentInterface.EnrollmentInfo)e).setOfferingId(offering.getUniqueId());
                ((ClassAssignmentInterface.EnrollmentInfo)e).setSubject(course.getSubjectAreaAbbv());
                ((ClassAssignmentInterface.EnrollmentInfo)e).setCourseNbr(course.getCourseNbr());
                ((ClassAssignmentInterface.EnrollmentInfo)e).setTitle(course.getTitle());
                ((ClassAssignmentInterface.EnrollmentInfo)e).setConsent(course.getConsentType() == null ? null : course.getConsentType().getAbbv());
                SchedulingSubpart subpart = section.getSchedulingSubpart();
                InstrOfferingConfig config = subpart.getInstrOfferingConfig();
                ((ClassAssignmentInterface.EnrollmentInfo)e).setConfig(config.getName());
                ((ClassAssignmentInterface.EnrollmentInfo)e).setConfigId(config.getUniqueId());
                ((ClassAssignmentInterface.EnrollmentInfo)e).setSubpart(subpart.getItype().getAbbv().trim());
                if (subpart.getInstrOfferingConfig().getInstructionalMethod() != null) {
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setSubpart(((ClassAssignmentInterface.EnrollmentInfo)e).getSubpart() + " (" + subpart.getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                }
                ((ClassAssignmentInterface.EnrollmentInfo)e).setSubpartId(subpart.getUniqueId());
                ((ClassAssignmentInterface.EnrollmentInfo)e).setClazz(section.getClassSuffix(course));
                if (((ClassAssignmentInterface.EnrollmentInfo)e).getClazz() == null) {
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setClazz(section.getSectionNumberString());
                }
                ((ClassAssignmentInterface.EnrollmentInfo)e).setClazzId(section.getUniqueId());
                for (Class_ parent = section.getParentClass(); parent != null; parent = parent.getParentClass()) {
                    ((ClassAssignmentInterface.EnrollmentInfo)e).incLevel();
                }
                int match = 0;
                int enrl = 0;
                int wait = 0;
                int res = 0;
                int unasg = 0;
                int unasgPrim = 0;
                int noSub = 0;
                int swap = 0;
                int tEnrl = 0;
                int tWait = 0;
                int tRes = 0;
                int tUnasg = 0;
                int tUnasgPrim = 0;
                int tNoSub = 0;
                int tSwap = 0;
                int conNeed = 0;
                int tConNeed = 0;
                int other = 0;
                for (CourseRequest courseRequest : requests) {
                    m = new DbCourseRequestMatcher(session, courseRequest, isConsentToDoCourse, this.isMyStudent(courseRequest.getCourseDemand().getStudent()), helper.getStudentNameFormat(), lookup, section);
                    boolean contains = false;
                    for (StudentClassEnrollment x : ((DbCourseRequestMatcher)m).enrollment()) {
                        if (!x.getClazz().equals(section)) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) continue;
                    if (!courseRequest.getCourseOffering().equals(course)) {
                        ++other;
                        continue;
                    }
                    if (this.query().match((Query.AmbigousTermMatcher)m)) {
                        ++match;
                        ++enrl;
                        if (((DbCourseRequestMatcher)m).reservation() != null) {
                            ++res;
                        }
                        if (course.getConsentType() != null && ((DbCourseRequestMatcher)m).approval() == null) {
                            ++conNeed;
                        }
                        if (((DbCourseRequestMatcher)m).request().getCourseDemand().effectiveWaitList() && !((DbCourseRequestMatcher)m).request().getCourseDemand().isEnrolledExceptForWaitListSwap()) {
                            ++swap;
                        }
                    }
                    ++tEnrl;
                    if (((DbCourseRequestMatcher)m).reservation() != null) {
                        ++tRes;
                    }
                    if (course.getConsentType() != null && ((DbCourseRequestMatcher)m).approval() == null) {
                        ++tConNeed;
                    }
                    if (!((DbCourseRequestMatcher)m).request().getCourseDemand().effectiveWaitList() || ((DbCourseRequestMatcher)m).request().getCourseDemand().isEnrolledExceptForWaitListSwap()) continue;
                    ++tSwap;
                }
                for (CourseRequest courseRequest : requests) {
                    m = new DbCourseRequestMatcher(session, courseRequest, isConsentToDoCourse, this.isMyStudent(courseRequest.getCourseDemand().getStudent()), helper.getStudentNameFormat(), lookup, section);
                    if (!((DbCourseRequestMatcher)m).enrollment().isEmpty() || !courseRequest.getCourseOffering().equals(course) || !((DbCourseRequestMatcher)m).canAssign() || checkOverrides && !courseRequest.isRequestApproved() && !courseRequest.isRequestNotNeeded()) continue;
                    if (this.query().match((Query.AmbigousTermMatcher)m)) {
                        ++match;
                        ++unasg;
                        if (!courseRequest.getCourseDemand().isAlternative().booleanValue() && courseRequest.getOrder() == 0) {
                            ++unasgPrim;
                            if (courseRequest.getCourseDemand().effectiveWaitList()) {
                                ++wait;
                            }
                            if (courseRequest.getCourseDemand().effectiveNoSub()) {
                                ++noSub;
                            }
                        }
                    }
                    ++tUnasg;
                    if (courseRequest.getCourseDemand().isAlternative().booleanValue() || courseRequest.getOrder() != 0) continue;
                    ++tUnasgPrim;
                    if (courseRequest.getCourseDemand().effectiveWaitList()) {
                        ++tWait;
                    }
                    if (!courseRequest.getCourseDemand().effectiveNoSub()) continue;
                    ++tNoSub;
                }
                if (match == 0 && !this.iShowUnmatchedClasses) continue;
                ((ClassAssignmentInterface.EnrollmentInfo)e).setNoMatch(match == 0);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setLimit(section.getSectioningLimit());
                ((ClassAssignmentInterface.EnrollmentInfo)e).setOther(other);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setAvailable(section.isCancelled() != false || section.isEnabledForStudentScheduling() == false ? 0 : Math.max(0, section.getUnreservedSectionSpace()));
                if (((ClassAssignmentInterface.EnrollmentInfo)e).getAvailable() == Integer.MAX_VALUE) {
                    ((ClassAssignmentInterface.EnrollmentInfo)e).setAvailable(-1);
                }
                ((ClassAssignmentInterface.EnrollmentInfo)e).setProjection(tEnrl + Math.max(0, (int)Math.round(section.getSectioningInfo() == null ? 0.0 : section.getSectioningInfo().getNbrExpectedStudents())));
                ((ClassAssignmentInterface.EnrollmentInfo)e).setSnapshot(section.getSnapshotLimit());
                ((ClassAssignmentInterface.EnrollmentInfo)e).setEnrollment(enrl);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setReservation(res);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setWaitlist(wait);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setSwap(swap);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setNoSub(noSub);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setUnassigned(unasg);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setUnassignedPrimary(unasgPrim);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalEnrollment(tEnrl);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalReservation(tRes);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalWaitlist(tWait);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalSwap(tSwap);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalNoSub(tNoSub);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalUnassigned(tUnasg);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalUnassignedPrimary(tUnasgPrim);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setConsentNeeded(conNeed);
                ((ClassAssignmentInterface.EnrollmentInfo)e).setTotalConsentNeeded(tConNeed);
                ClassAssignmentInterface.ClassAssignment a = new ClassAssignmentInterface.ClassAssignment();
                a.setClassId(section.getUniqueId());
                a.setSubpart(subpart.getItype().getAbbv().trim());
                if (subpart.getInstrOfferingConfig().getInstructionalMethod() != null) {
                    a.setSubpart(a.getSubpart() + " (" + subpart.getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                }
                a.setClassNumber(section.getClassSuffix() == null ? section.getSectionNumber(helper.getHibSession()) + section.getSchedulingSubpart().getSchedulingSubpartSuffix(helper.getHibSession()) : section.getClassSuffix());
                a.setSection(section.getClassSuffix(course));
                a.setExternalId(section.getExternalId(course));
                a.setCancelled(section.isCancelled());
                a.setLimit(new int[]{section.getEnrollment(), section.getSectioningLimit()});
                Assignment assignment = section.getCommittedAssignment();
                if (assignment != null) {
                    for (DayCode d : DayCode.toDayCodes(assignment.getDays())) {
                        a.addDay(d.getIndex());
                    }
                    a.setStart(assignment.getStartSlot());
                    a.setLength(assignment.getSlotPerMtg());
                    a.setBreakTime(assignment.getBreakTime());
                    a.setDatePattern(assignment.getDatePattern().getName());
                    for (Location rm : assignment.getRooms()) {
                        a.addRoom(rm.getUniqueId(), rm.getLabelWithDisplayName());
                    }
                } else {
                    for (RoomPref p : section.effectivePreferences(RoomPref.class)) {
                        if (!PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog())) continue;
                        a.addRoom(p.getRoom().getUniqueId(), p.getRoom().getLabel());
                    }
                    DatePattern dp = section.effectiveDatePattern();
                    if (dp != null) {
                        a.setDatePattern(this.datePatternName(dp, helper.getDatePatternFormat()));
                    }
                }
                if (section.isDisplayInstructor().booleanValue() && !section.getClassInstructors().isEmpty()) {
                    for (ClassInstructor instructor : section.getClassInstructors()) {
                        a.addInstructor(helper.getInstructorNameFormat().format(instructor.getInstructor()));
                        a.addInstructoEmail(instructor.getInstructor().getEmail());
                    }
                }
                if (section.getParentClass() != null) {
                    a.setParentSection(section.getParentClass().getClassSuffix(course));
                }
                a.setSubpartId(section.getSchedulingSubpart().getUniqueId());
                a.addNote(course.getScheduleBookNote());
                a.addNote(section.getSchedulePrintNote());
                if (section.getSchedulingSubpart().getCredit() != null) {
                    a.setCredit(section.getSchedulingSubpart().getCredit().creditAbbv() + "|" + section.getSchedulingSubpart().getCredit().creditText());
                } else if (section.getParentClass() != null && course.getCredit() != null) {
                    a.setCredit(course.getCredit().creditAbbv() + "|" + course.getCredit().creditText());
                }
                Float creditOverride = section.getCredit(course);
                if (creditOverride != null) {
                    a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                }
                if (a.getParentSection() == null) {
                    String consent;
                    String string = consent = course.getConsentType() == null ? null : course.getConsentType().getLabel();
                    if (consent != null) {
                        a.setParentSection(consent);
                    }
                }
                a.setExpected(overExp.getExpected(section.getSectioningLimit(), section.getSectioningInfo() == null ? 0.0 : section.getSectioningInfo().getNbrExpectedStudents()));
                ((ClassAssignmentInterface.EnrollmentInfo)e).setAssignment(a);
                ret.add((ClassAssignmentInterface.EnrollmentInfo)e);
            }
        }
        return ret;
    }

    public boolean isConsentToDoCourse(CourseOffering course) {
        return this.iCoursesIcanApprove != null && course.getConsentType() != null && this.iCoursesIcanApprove.contains(course.getUniqueId());
    }

    public static class DbFindStudentInfoMatcher
    extends FindStudentInfoAction.FindStudentInfoMatcher {
        private static final long serialVersionUID = 1L;
        protected NameFormat iFormat;

        public DbFindStudentInfoMatcher(AcademicSessionInfo session, Query query, NameFormat format, Set<Long> myStudents) {
            super(session, query, myStudents);
            this.iFormat = format;
        }

        public boolean isMyStudent(Student student) {
            return this.iMyStudents != null && this.iMyStudents.contains(student.getUniqueId());
        }

        public boolean match(Student student) {
            return student != null && this.iQuery.match(new DbStudentMatcher(student, this.iDefaultSectioningStatus, this.iFormat, this.isMyStudent(student)));
        }
    }

    public static class DbStudentMatcher
    implements Query.TermMatcher {
        private Student iStudent;
        private String iDefaultStatus;
        private NameFormat iFormat = null;
        private boolean iMyStudent = false;

        public DbStudentMatcher(Student student, String defaultStatus, NameFormat format, boolean myStudent) {
            this.iStudent = student;
            this.iDefaultStatus = defaultStatus;
            this.iFormat = format;
            this.iMyStudent = myStudent;
        }

        public DbStudentMatcher(Student student) {
            this.iStudent = student;
            this.iDefaultStatus = student.getSession().getDefaultSectioningStatus() == null ? null : student.getSession().getDefaultSectioningStatus().getReference();
            this.iFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingStudentNameFormat.value());
        }

        public Student student() {
            return this.iStudent;
        }

        public String status() {
            return this.iStudent.getSectioningStatus() == null ? this.iDefaultStatus : this.iStudent.getSectioningStatus().getReference();
        }

        @Override
        public boolean match(String attr, String term) {
            block106: {
                block123: {
                    block122: {
                        block121: {
                            block120: {
                                block119: {
                                    block118: {
                                        block117: {
                                            block116: {
                                                block115: {
                                                    block114: {
                                                        block113: {
                                                            block112: {
                                                                block111: {
                                                                    block110: {
                                                                        block109: {
                                                                            block108: {
                                                                                block107: {
                                                                                    block105: {
                                                                                        if (attr == null && term.isEmpty()) {
                                                                                            return true;
                                                                                        }
                                                                                        if ("limit".equals(attr)) {
                                                                                            return true;
                                                                                        }
                                                                                        if (!"area".equals(attr)) break block105;
                                                                                        for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                                                                                            if (!this.eq(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), term)) continue;
                                                                                            return true;
                                                                                        }
                                                                                        for (StudentAreaClassificationMinor studentAreaClassificationMinor : this.student().getAreaClasfMinors()) {
                                                                                            if (!this.eq(studentAreaClassificationMinor.getAcademicArea().getAcademicAreaAbbreviation(), term)) continue;
                                                                                            return true;
                                                                                        }
                                                                                        break block106;
                                                                                    }
                                                                                    if (!"clasf".equals(attr) && !"classification".equals(attr)) break block107;
                                                                                    for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                                                                                        if (!this.eq(studentAreaClassificationMajor.getAcademicClassification().getCode(), term)) continue;
                                                                                        return true;
                                                                                    }
                                                                                    break block106;
                                                                                }
                                                                                if (!"major".equals(attr)) break block108;
                                                                                for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                                                                                    if (!this.eq(studentAreaClassificationMajor.getMajor().getCode(), term)) continue;
                                                                                    return true;
                                                                                }
                                                                                break block106;
                                                                            }
                                                                            if (!"concentration".equals(attr)) break block109;
                                                                            for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                                                                                if (studentAreaClassificationMajor.getConcentration() == null || !this.eq(studentAreaClassificationMajor.getConcentration().getCode(), term)) continue;
                                                                                return true;
                                                                            }
                                                                            break block106;
                                                                        }
                                                                        if (!"degree".equals(attr)) break block110;
                                                                        for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                                                                            if (studentAreaClassificationMajor.getDegree() == null || !this.eq(studentAreaClassificationMajor.getDegree().getReference(), term)) continue;
                                                                            return true;
                                                                        }
                                                                        break block106;
                                                                    }
                                                                    if (!"program".equals(attr)) break block111;
                                                                    for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                                                                        if (studentAreaClassificationMajor.getProgram() == null || !this.like(studentAreaClassificationMajor.getProgram().getReference(), term)) continue;
                                                                        return true;
                                                                    }
                                                                    break block106;
                                                                }
                                                                if (!"campus".equals(attr)) break block112;
                                                                for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                                                                    if (studentAreaClassificationMajor.getCampus() == null || !this.like(studentAreaClassificationMajor.getCampus().getReference(), term)) continue;
                                                                    return true;
                                                                }
                                                                break block106;
                                                            }
                                                            if (!"primary-area".equals(attr)) break block113;
                                                            StudentAreaClassificationMajor acm = this.student().getPrimaryAreaClasfMajor();
                                                            if (acm != null && this.eq(acm.getAcademicArea().getAcademicAreaAbbreviation(), term)) {
                                                                return true;
                                                            }
                                                            break block106;
                                                        }
                                                        if (!"primary-clasf".equals(attr) && !"primary-classification".equals(attr)) break block114;
                                                        StudentAreaClassificationMajor acm = this.student().getPrimaryAreaClasfMajor();
                                                        if (acm != null && this.eq(acm.getAcademicClassification().getCode(), term)) {
                                                            return true;
                                                        }
                                                        break block106;
                                                    }
                                                    if (!"primary-major".equals(attr)) break block115;
                                                    StudentAreaClassificationMajor acm = this.student().getPrimaryAreaClasfMajor();
                                                    if (acm != null && this.eq(acm.getMajor().getCode(), term)) {
                                                        return true;
                                                    }
                                                    break block106;
                                                }
                                                if (!"primary-concentration".equals(attr)) break block116;
                                                StudentAreaClassificationMajor acm = this.student().getPrimaryAreaClasfMajor();
                                                if (acm != null && acm.getConcentration() != null && this.eq(acm.getConcentration().getCode(), term)) {
                                                    return true;
                                                }
                                                break block106;
                                            }
                                            if (!"primary-degree".equals(attr)) break block117;
                                            StudentAreaClassificationMajor acm = this.student().getPrimaryAreaClasfMajor();
                                            if (acm != null && acm.getDegree() != null && this.eq(acm.getDegree().getReference(), term)) {
                                                return true;
                                            }
                                            break block106;
                                        }
                                        if (!"primary-program".equals(attr)) break block118;
                                        StudentAreaClassificationMajor acm = this.student().getPrimaryAreaClasfMajor();
                                        if (acm != null && acm.getProgram() != null && this.like(acm.getProgram().getReference(), term)) {
                                            return true;
                                        }
                                        break block106;
                                    }
                                    if (!"primary-campus".equals(attr)) break block119;
                                    StudentAreaClassificationMajor acm = this.student().getPrimaryAreaClasfMajor();
                                    if (acm != null && acm.getCampus() != null && this.like(acm.getCampus().getReference(), term)) {
                                        return true;
                                    }
                                    break block106;
                                }
                                if (!"minor".equals(attr)) break block120;
                                for (StudentAreaClassificationMinor studentAreaClassificationMinor : this.student().getAreaClasfMinors()) {
                                    if (!this.eq(studentAreaClassificationMinor.getMinor().getCode(), term)) continue;
                                    return true;
                                }
                                break block106;
                            }
                            if (!"group".equals(attr)) break block121;
                            for (StudentGroup studentGroup : this.student().getGroups()) {
                                if (!this.eq(studentGroup.getGroupAbbreviation(), term)) continue;
                                return true;
                            }
                            break block106;
                        }
                        if (!"accommodation".equals(attr)) break block122;
                        for (StudentAccomodation studentAccomodation : this.student().getAccomodations()) {
                            if (!this.eq(studentAccomodation.getAbbreviation(), term)) continue;
                            return true;
                        }
                        break block106;
                    }
                    if ("student".equals(attr)) {
                        return this.has(this.iFormat.format(this.student()), term) || this.eq(this.student().getExternalUniqueId(), term) || this.eq(this.iFormat.format(this.student()), term);
                    }
                    if ("advisor".equals(attr)) {
                        for (Advisor advisor : this.student().getAdvisors()) {
                            if (!this.eq(advisor.getExternalUniqueId(), term)) continue;
                            return true;
                        }
                        return false;
                    }
                    if ("registered".equals(attr)) {
                        return !this.eq("true", term) && !this.eq("1", term);
                    }
                    if ("status".equals(attr)) {
                        if ("default".equalsIgnoreCase(term) || "Not Set".equalsIgnoreCase(term)) {
                            return this.iStudent.getSectioningStatus() == null;
                        }
                        return term.equalsIgnoreCase(this.status());
                    }
                    if ("credit".equals(attr)) {
                        String im;
                        float f;
                        float min;
                        block104: {
                            Matcher m;
                            block103: {
                                min = 0.0f;
                                f = Float.MAX_VALUE;
                                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                                String number = term;
                                if (number.startsWith("<=")) {
                                    prefix = SectioningStatusFilterAction.Credit.le;
                                    number = number.substring(2);
                                } else if (number.startsWith(">=")) {
                                    prefix = SectioningStatusFilterAction.Credit.ge;
                                    number = number.substring(2);
                                } else if (number.startsWith("<")) {
                                    prefix = SectioningStatusFilterAction.Credit.lt;
                                    number = number.substring(1);
                                } else if (number.startsWith(">")) {
                                    prefix = SectioningStatusFilterAction.Credit.gt;
                                    number = number.substring(1);
                                } else if (number.startsWith("=")) {
                                    prefix = SectioningStatusFilterAction.Credit.eq;
                                    number = number.substring(1);
                                }
                                im = null;
                                try {
                                    float a = Float.parseFloat(number);
                                    switch (prefix) {
                                        case eq: {
                                            min = f = a;
                                            break;
                                        }
                                        case le: {
                                            f = a;
                                            break;
                                        }
                                        case ge: {
                                            min = a;
                                            break;
                                        }
                                        case lt: {
                                            f = a - 1.0f;
                                            break;
                                        }
                                        case gt: {
                                            min = a + 1.0f;
                                        }
                                    }
                                }
                                catch (NumberFormatException e) {
                                    m = Pattern.compile("([0-9]+\\.?[0-9]*)([^0-9\\.].*)").matcher(number);
                                    if (!m.matches()) break block103;
                                    float a = Float.parseFloat(m.group(1));
                                    im = m.group(2).trim();
                                    switch (prefix) {
                                        case eq: {
                                            min = f = a;
                                            break;
                                        }
                                        case le: {
                                            f = a;
                                            break;
                                        }
                                        case ge: {
                                            min = a;
                                            break;
                                        }
                                        case lt: {
                                            f = a - 1.0f;
                                            break;
                                        }
                                        case gt: {
                                            min = a + 1.0f;
                                        }
                                    }
                                }
                            }
                            if (term.contains("..")) {
                                try {
                                    String a = term.substring(0, term.indexOf(46));
                                    String b = term.substring(term.indexOf("..") + 2);
                                    min = Float.parseFloat(a);
                                    f = Float.parseFloat(b);
                                }
                                catch (NumberFormatException e) {
                                    m = Pattern.compile("([0-9]+\\.?[0-9]*)\\.\\.([0-9]+\\.?[0-9]*)([^0-9].*)").matcher(term);
                                    if (!m.matches()) break block104;
                                    min = Float.parseFloat(m.group(1));
                                    f = Float.parseFloat(m.group(2));
                                    im = m.group(3).trim();
                                }
                            }
                        }
                        float credit = 0.0f;
                        HashSet<Long> courseIds = new HashSet<Long>();
                        for (StudentClassEnrollment e : this.student().getClassEnrollments()) {
                            if (!courseIds.add(e.getCourseOffering().getUniqueId())) continue;
                            CourseCreditUnitConfig config = e.getCourseOffering().getCredit();
                            if ("!".equals(im) && e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null || im != null && !"!".equals(im) && (e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod() == null || !im.equalsIgnoreCase(e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod().getReference())) || config == null) continue;
                            credit += config.getMinCredit();
                        }
                        return min <= credit && credit <= f;
                    }
                    if ("overlap".equals(attr)) {
                        int n;
                        int min = 0;
                        int n2 = Integer.MAX_VALUE;
                        SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                        String number = term;
                        if (number.startsWith("<=")) {
                            prefix = SectioningStatusFilterAction.Credit.le;
                            number = number.substring(2);
                        } else if (number.startsWith(">=")) {
                            prefix = SectioningStatusFilterAction.Credit.ge;
                            number = number.substring(2);
                        } else if (number.startsWith("<")) {
                            prefix = SectioningStatusFilterAction.Credit.lt;
                            number = number.substring(1);
                        } else if (number.startsWith(">")) {
                            prefix = SectioningStatusFilterAction.Credit.gt;
                            number = number.substring(1);
                        } else if (number.startsWith("=")) {
                            prefix = SectioningStatusFilterAction.Credit.eq;
                            number = number.substring(1);
                        }
                        try {
                            int a = Integer.parseInt(number);
                            switch (prefix) {
                                case eq: {
                                    int n3;
                                    min = n3 = a;
                                    break;
                                }
                                case le: {
                                    int n4 = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    int n5 = a - 1;
                                    break;
                                }
                                case gt: {
                                    min = a + 1;
                                }
                            }
                        }
                        catch (NumberFormatException a) {
                            // empty catch block
                        }
                        if (term.contains("..")) {
                            try {
                                String a = term.substring(0, term.indexOf(46));
                                String b = term.substring(term.indexOf("..") + 2);
                                min = Integer.parseInt(a);
                                n = Integer.parseInt(b);
                            }
                            catch (NumberFormatException a) {
                                // empty catch block
                            }
                        }
                        int share = 0;
                        for (StudentClassEnrollment section : this.student().getClassEnrollments()) {
                            Assignment assignment = section.getClazz().getCommittedAssignment();
                            if (assignment == null) continue;
                            for (StudentClassEnrollment otherSection : this.student().getClassEnrollments()) {
                                Assignment otherAssignment;
                                if (section.equals(otherSection) || (otherAssignment = otherSection.getClazz().getCommittedAssignment()) == null || !assignment.getTimeLocation().hasIntersection(otherAssignment.getTimeLocation()) || section.getClazz().isToIgnoreStudentConflictsWith(otherSection.getClazz()) || section.getClazz().getUniqueId() >= otherSection.getClazz().getUniqueId()) continue;
                                int sh = assignment.getTimeLocation().nrSharedDays(otherAssignment.getTimeLocation()) * assignment.getTimeLocation().nrSharedHours(otherAssignment.getTimeLocation()) * Constants.SLOT_LENGTH_MIN;
                                share += sh;
                            }
                        }
                        return min <= share && share <= n;
                    }
                    if ("override".equals(attr)) {
                        if ("null".equalsIgnoreCase(term) || "None".equalsIgnoreCase(term)) {
                            for (CourseDemand courseDemand : this.student().getCourseDemands()) {
                                for (CourseRequest cr : courseDemand.getCourseRequests()) {
                                    if (cr.getOverrideStatus() != null) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                        CourseRequest.CourseRequestOverrideStatus status = null;
                        for (CourseRequest.CourseRequestOverrideStatus s : CourseRequest.CourseRequestOverrideStatus.values()) {
                            if (!s.name().equalsIgnoreCase(term)) continue;
                            status = s;
                            break;
                        }
                        if (status == null) {
                            return false;
                        }
                        if (this.student().getOverrideStatus() != null && this.student().getOverrideStatus().intValue() == status.ordinal()) {
                            return true;
                        }
                        for (CourseDemand cd : this.student().getCourseDemands()) {
                            for (CourseRequest cr : cd.getCourseRequests()) {
                                if (cr.getOverrideStatus() == null || cr.getOverrideStatus().intValue() != status.ordinal()) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    if ("mode".equals(attr)) {
                        if (this.eq("My Students", term)) {
                            return this.iMyStudent;
                        }
                        if (this.eq("My Advised", term)) {
                            return this.iMyStudent && !this.student().getAdvisorCourseRequests().isEmpty();
                        }
                        if (this.eq("My Not Advised", term)) {
                            return this.iMyStudent && this.student().getAdvisorCourseRequests().isEmpty();
                        }
                        if (this.eq("Advised", term)) {
                            return !this.student().getAdvisorCourseRequests().isEmpty();
                        }
                        if (this.eq("Not Advised", term)) {
                            return this.student().getAdvisorCourseRequests().isEmpty();
                        }
                        return true;
                    }
                    if ("btb".equals(attr)) {
                        if ("prefer".equalsIgnoreCase(term) || "preferred".equalsIgnoreCase(term)) {
                            return this.student().getBackToBackPreference() == Student.BackToBackPreference.BTB_PREFERRED;
                        }
                        if ("disc".equalsIgnoreCase(term) || "discourage".equalsIgnoreCase(term) || "discouraged".equalsIgnoreCase(term)) {
                            return this.student().getBackToBackPreference() == Student.BackToBackPreference.BTB_DISCOURAGED;
                        }
                        return this.student().getBackToBackPreference() == Student.BackToBackPreference.NO_PREFERENCE;
                    }
                    if (!"online".equals(attr)) break block123;
                    if ("prefer".equalsIgnoreCase(term) || "preferred".equalsIgnoreCase(term)) {
                        return this.student().getModalityPreference() == Student.ModalityPreference.ONLINE_PREFERRED;
                    }
                    if ("require".equalsIgnoreCase(term) || "required".equalsIgnoreCase(term)) {
                        return this.student().getModalityPreference() == Student.ModalityPreference.ONLINE_REQUIRED;
                    }
                    if ("disc".equalsIgnoreCase(term) || "discourage".equalsIgnoreCase(term) || "discouraged".equalsIgnoreCase(term)) {
                        return this.student().getModalityPreference() == Student.ModalityPreference.ONILNE_DISCOURAGED;
                    }
                    if ("no".equalsIgnoreCase(term) || "no-preference".equalsIgnoreCase(term)) {
                        return this.student().getModalityPreference() == Student.ModalityPreference.NO_PREFERENCE;
                    }
                    break block106;
                }
                if (attr == null) break block106;
                for (StudentGroup studentGroup : this.student().getGroups()) {
                    if (studentGroup.getType() == null || !this.eq(studentGroup.getType().getReference(), attr.replace('_', ' ')) || !this.eq(studentGroup.getGroupAbbreviation(), term)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean like(String name, String term) {
            if (name == null) {
                return false;
            }
            if (term.indexOf(37) >= 0) {
                return name.matches("(?i)" + term.replaceAll("%", ".*"));
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" |,")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }
    }

    public static class DbCourseRequestMatcher
    extends DbCourseInfoMatcher {
        private static final long serialVersionUID = 1L;
        private AcademicSessionInfo iSession;
        private Student iStudent;
        private CourseRequest iRequest;
        private InstructionalOffering iOffering;
        private String iDefaultStatus;
        private List<StudentClassEnrollment> iEnrollment = null;
        private NameFormat iFormat = null;
        private Reservation iReservation = null;
        private boolean iReservationGuessed = false;
        private boolean iMyStudent = false;
        private Class_ iClazz = null;

        public DbCourseRequestMatcher(AcademicSessionInfo session, CourseRequest request, boolean isConsentToDoCourse, boolean myStudent, NameFormat format, StatusPageSuggestionsAction.CourseLookup lookup) {
            this(session, request, isConsentToDoCourse, myStudent, format, lookup, null);
        }

        public DbCourseRequestMatcher(AcademicSessionInfo session, CourseRequest request, boolean isConsentToDoCourse, boolean myStudent, NameFormat format, StatusPageSuggestionsAction.CourseLookup lookup, Class_ clazz) {
            super(request.getCourseOffering(), isConsentToDoCourse, lookup);
            this.iSession = session;
            this.iStudent = request.getCourseDemand().getStudent();
            this.iRequest = request;
            this.iDefaultStatus = session.getDefaultSectioningStatus();
            this.iOffering = request.getCourseOffering().getInstructionalOffering();
            this.iFormat = format;
            this.iMyStudent = myStudent;
            this.iClazz = clazz;
        }

        public AcademicSessionInfo session() {
            return this.iSession;
        }

        public CourseRequest request() {
            return this.iRequest;
        }

        public List<StudentClassEnrollment> enrollment() {
            if (this.iEnrollment == null) {
                this.iEnrollment = new ArrayList<StudentClassEnrollment>();
                for (StudentClassEnrollment e : this.student().getClassEnrollments()) {
                    for (CourseRequest cr : this.request().getCourseDemand().getCourseRequests()) {
                        if (!cr.getCourseOffering().equals(e.getCourseOffering())) continue;
                        this.iEnrollment.add(e);
                    }
                }
            }
            return this.iEnrollment;
        }

        public Student student() {
            return this.iStudent;
        }

        public String status() {
            return this.student().getSectioningStatus() == null ? this.iDefaultStatus : this.student().getSectioningStatus().getReference();
        }

        public InstructionalOffering offering() {
            return this.iOffering;
        }

        public String approval() {
            if (this.enrollment().isEmpty()) {
                return null;
            }
            HashSet<String> approval = new HashSet<String>();
            String ret = "";
            for (StudentClassEnrollment e : this.enrollment()) {
                if (e.getApprovedBy() == null || e.getApprovedDate() == null) {
                    return null;
                }
                if (!approval.add(e.getApprovedBy())) continue;
                ret = ret + (ret.isEmpty() ? "" : "|") + e.getApprovedBy();
            }
            return ret;
        }

        public Reservation reservation() {
            if (!this.iReservationGuessed) {
                this.iReservation = this.guessReservation();
                this.iReservationGuessed = true;
            }
            return this.iReservation;
        }

        public InstrOfferingConfig config() {
            Iterator<StudentClassEnrollment> iterator = this.enrollment().iterator();
            if (iterator.hasNext()) {
                StudentClassEnrollment e = iterator.next();
                return e.getClazz().getSchedulingSubpart().getInstrOfferingConfig();
            }
            if (this.iClazz != null) {
                return this.iClazz.getSchedulingSubpart().getInstrOfferingConfig();
            }
            return null;
        }

        protected Reservation guessReservation() {
            List<StudentClassEnrollment> enrollment = this.enrollment();
            if (enrollment.isEmpty()) {
                return null;
            }
            Reservation best = null;
            boolean mustBeUsed = false;
            for (Reservation reservation : this.iOffering.getReservations()) {
                if (!reservation.isApplicable(this.iStudent, this.iRequest) || !reservation.isMatching(enrollment)) continue;
                if (!mustBeUsed && reservation.isMustBeUsed()) {
                    best = null;
                    mustBeUsed = true;
                }
                if (mustBeUsed && !reservation.isMustBeUsed() || best != null && !((double)reservation.compareTo(best) < 0.0)) continue;
                best = reservation;
            }
            return best;
        }

        public boolean canAssign() {
            if (!this.enrollment().isEmpty()) {
                return true;
            }
            if (!this.request().getCourseDemand().isAlternative().booleanValue() && this.request().getCourseDemand().effectiveWaitList()) {
                return true;
            }
            int alt = 0;
            for (CourseDemand demand : this.student().getCourseDemands()) {
                boolean waitlist;
                boolean assigned;
                boolean course = !demand.getCourseRequests().isEmpty();
                boolean bl = assigned = !course;
                if (course) {
                    for (CourseRequest request : demand.getCourseRequests()) {
                        if (request.getClassEnrollments().isEmpty()) continue;
                        assigned = true;
                        break;
                    }
                }
                if (demand.equals(this.request().getCourseDemand())) {
                    if (assigned) {
                        return false;
                    }
                    assigned = true;
                }
                boolean bl2 = waitlist = course && (demand.effectiveWaitList() || demand.effectiveNoSub());
                if (demand.isAlternative().booleanValue()) {
                    if (!assigned) continue;
                    --alt;
                    continue;
                }
                if (!course || waitlist || assigned) continue;
                ++alt;
            }
            return alt >= 0;
        }

        @Override
        public Boolean match(String attr, String term) {
            Iterator<Serializable> acm;
            if (attr == null || "name".equals(attr) || "title".equals(attr) || "subject".equals(attr) || "number".equals(attr) || "course".equals(attr) || "lookup".equals(attr) || "department".equals(attr) || "registered".equals(attr)) {
                return super.match(attr, term);
            }
            if ("limit".equals(attr)) {
                return true;
            }
            if ("area".equals(attr)) {
                for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                    if (!this.eq(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), term)) continue;
                    return true;
                }
                for (StudentAreaClassificationMinor studentAreaClassificationMinor : this.student().getAreaClasfMinors()) {
                    if (!this.eq(studentAreaClassificationMinor.getAcademicArea().getAcademicAreaAbbreviation(), term)) continue;
                    return true;
                }
            }
            if ("clasf".equals(attr) || "classification".equals(attr)) {
                for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                    if (!this.eq(studentAreaClassificationMajor.getAcademicClassification().getCode(), term)) continue;
                    return true;
                }
            }
            if ("major".equals(attr)) {
                for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                    if (!this.eq(studentAreaClassificationMajor.getMajor().getCode(), term)) continue;
                    return true;
                }
            }
            if ("concentration".equals(attr)) {
                for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                    if (studentAreaClassificationMajor.getConcentration() == null || !this.eq(studentAreaClassificationMajor.getConcentration().getCode(), term)) continue;
                    return true;
                }
            }
            if ("degree".equals(attr)) {
                for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                    if (studentAreaClassificationMajor.getDegree() == null || !this.eq(studentAreaClassificationMajor.getDegree().getReference(), term)) continue;
                    return true;
                }
            }
            if ("program".equals(attr)) {
                for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                    if (studentAreaClassificationMajor.getProgram() == null || !this.like(studentAreaClassificationMajor.getProgram().getReference(), term)) continue;
                    return true;
                }
            }
            if ("campus".equals(attr)) {
                for (StudentAreaClassificationMajor studentAreaClassificationMajor : this.student().getAreaClasfMajors()) {
                    if (studentAreaClassificationMajor.getCampus() == null || !this.like(studentAreaClassificationMajor.getCampus().getReference(), term)) continue;
                    return true;
                }
            }
            if ("primary-area".equals(attr) && (acm = this.student().getPrimaryAreaClasfMajor()) != null && this.eq(((BaseStudentAreaClassificationMajor)((Object)acm)).getAcademicArea().getAcademicAreaAbbreviation(), term)) {
                return true;
            }
            if (("primary-clasf".equals(attr) || "primary-classification".equals(attr)) && (acm = this.student().getPrimaryAreaClasfMajor()) != null && this.eq(((BaseStudentAreaClassificationMajor)((Object)acm)).getAcademicClassification().getCode(), term)) {
                return true;
            }
            if ("primary-major".equals(attr) && (acm = this.student().getPrimaryAreaClasfMajor()) != null && this.eq(((BaseStudentAreaClassificationMajor)((Object)acm)).getMajor().getCode(), term)) {
                return true;
            }
            if ("primary-concentration".equals(attr) && (acm = this.student().getPrimaryAreaClasfMajor()) != null && ((BaseStudentAreaClassificationMajor)((Object)acm)).getConcentration() != null && this.eq(((BaseStudentAreaClassificationMajor)((Object)acm)).getConcentration().getCode(), term)) {
                return true;
            }
            if ("primary-degree".equals(attr) && (acm = this.student().getPrimaryAreaClasfMajor()) != null && ((BaseStudentAreaClassificationMajor)((Object)acm)).getDegree() != null && this.eq(((BaseStudentAreaClassificationMajor)((Object)acm)).getDegree().getReference(), term)) {
                return true;
            }
            if ("primary-program".equals(attr) && (acm = this.student().getPrimaryAreaClasfMajor()) != null && ((BaseStudentAreaClassificationMajor)((Object)acm)).getProgram() != null && this.like(((BaseStudentAreaClassificationMajor)((Object)acm)).getProgram().getReference(), term)) {
                return true;
            }
            if ("primary-campus".equals(attr) && (acm = this.student().getPrimaryAreaClasfMajor()) != null && ((BaseStudentAreaClassificationMajor)((Object)acm)).getCampus() != null && this.like(((BaseStudentAreaClassificationMajor)((Object)acm)).getCampus().getReference(), term)) {
                return true;
            }
            if ("minor".equals(attr)) {
                for (StudentAreaClassificationMinor studentAreaClassificationMinor : this.student().getAreaClasfMinors()) {
                    if (!this.eq(studentAreaClassificationMinor.getMinor().getCode(), term)) continue;
                    return true;
                }
            }
            if ("group".equals(attr)) {
                for (StudentGroup studentGroup : this.student().getGroups()) {
                    if (!this.eq(studentGroup.getGroupAbbreviation(), term)) continue;
                    return true;
                }
            } else {
                for (StudentGroup studentGroup : this.student().getGroups()) {
                    if (studentGroup.getType() == null || attr == null || !this.eq(studentGroup.getType().getReference(), attr.replace('_', ' ')) || !this.eq(studentGroup.getGroupAbbreviation(), term)) continue;
                    return true;
                }
            }
            if ("accommodation".equals(attr)) {
                for (StudentAccomodation studentAccomodation : this.student().getAccomodations()) {
                    if (!this.eq(studentAccomodation.getAbbreviation(), term)) continue;
                    return true;
                }
            }
            if ("student".equals(attr)) {
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue() && term.startsWith("0")) {
                    return this.has(this.iFormat.format(this.student()), term) || this.eq(this.student().getExternalUniqueId(), term.replaceFirst("^0+(?!$)", "")) || this.eq(this.iFormat.format(this.student()), term);
                }
                return this.has(this.iFormat.format(this.student()), term) || this.eq(this.student().getExternalUniqueId(), term) || this.eq(this.iFormat.format(this.student()), term);
            }
            if ("advisor".equals(attr)) {
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue() && term.startsWith("0")) {
                    for (Advisor advisor : this.student().getAdvisors()) {
                        if (!this.eq(advisor.getExternalUniqueId(), term.replaceFirst("^0+(?!$)", ""))) continue;
                        return true;
                    }
                } else {
                    for (Advisor advisor : this.student().getAdvisors()) {
                        if (!this.eq(advisor.getExternalUniqueId(), term)) continue;
                        return true;
                    }
                }
                return false;
            }
            if ("assignment".equals(attr)) {
                if (this.eq("Assigned", term)) {
                    return !this.enrollment().isEmpty();
                }
                if (this.eq("Reserved", term)) {
                    return !this.enrollment().isEmpty() && this.reservation() != null;
                }
                if (this.eq("Not Assigned", term)) {
                    if (this.enrollment().isEmpty() && !this.request().getCourseDemand().isAlternative().booleanValue()) {
                        for (StudentClassEnrollment studentClassEnrollment : this.student().getClassEnrollments()) {
                            if (studentClassEnrollment.getCourseRequest() == null || !studentClassEnrollment.getCourseRequest().getCourseDemand().equals(this.request().getCourseDemand())) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                if (this.eq("Wait-Listed", term)) {
                    if (!this.enrollment().isEmpty() && this.request().getCourseDemand().effectiveWaitList() && this.enrollment().get(0).getCourseOffering().equals(this.request().getCourseDemand().getWaitListSwapWithCourseOffering())) {
                        return true;
                    }
                    return this.enrollment().isEmpty() && this.request().getCourseDemand().effectiveWaitList();
                }
                if (this.eq("Critical", term)) {
                    return this.request().getCourseDemand().getEffectiveCritical() == CourseDemand.Critical.CRITICAL;
                }
                if (this.eq("Assigned Critical", term)) {
                    if (this.enrollment().isEmpty()) {
                        return false;
                    }
                    return this.request().getCourseDemand().getEffectiveCritical() == CourseDemand.Critical.CRITICAL;
                }
                if (this.eq("Not Assigned Critical", term)) {
                    if (this.enrollment().isEmpty() && this.request().getCourseDemand().getEffectiveCritical() == CourseDemand.Critical.CRITICAL && !this.request().getCourseDemand().isAlternative().booleanValue()) {
                        for (StudentClassEnrollment studentClassEnrollment : this.student().getClassEnrollments()) {
                            if (studentClassEnrollment.getCourseRequest() == null || !studentClassEnrollment.getCourseRequest().getCourseDemand().equals(this.request().getCourseDemand())) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                if (this.eq("Important", term)) {
                    return this.request().getCourseDemand().getEffectiveCritical() == CourseDemand.Critical.IMPORTANT;
                }
                if (this.eq("Assigned Important", term)) {
                    if (this.enrollment().isEmpty()) {
                        return false;
                    }
                    return this.request().getCourseDemand().getEffectiveCritical() == CourseDemand.Critical.IMPORTANT;
                }
                if (this.eq("Not Assigned Important", term)) {
                    if (this.enrollment().isEmpty() && this.request().getCourseDemand().getEffectiveCritical() == CourseDemand.Critical.IMPORTANT && !this.request().getCourseDemand().isAlternative().booleanValue()) {
                        for (StudentClassEnrollment studentClassEnrollment : this.student().getClassEnrollments()) {
                            if (studentClassEnrollment.getCourseRequest() == null || !studentClassEnrollment.getCourseRequest().getCourseDemand().equals(this.request().getCourseDemand())) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                if (this.eq("Vital", term)) {
                    return this.request().getCourseDemand().getEffectiveCritical() == CourseDemand.Critical.VITAL;
                }
                if (this.eq("Assigned Vital", term)) {
                    if (this.enrollment().isEmpty()) {
                        return false;
                    }
                    return this.request().getCourseDemand().getEffectiveCritical() == CourseDemand.Critical.VITAL;
                }
                if (this.eq("Not Assigned Vital", term)) {
                    if (this.enrollment().isEmpty() && this.request().getCourseDemand().getEffectiveCritical() == CourseDemand.Critical.VITAL && !this.request().getCourseDemand().isAlternative().booleanValue()) {
                        for (StudentClassEnrollment studentClassEnrollment : this.student().getClassEnrollments()) {
                            if (studentClassEnrollment.getCourseRequest() == null || !studentClassEnrollment.getCourseRequest().getCourseDemand().equals(this.request().getCourseDemand())) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                if (this.eq("No-Subs", term) || this.eq("No-Substitutes", term)) {
                    return this.request().getCourseDemand().effectiveNoSub();
                }
                if (this.eq("Assigned No-Subs", term) || this.eq("Assigned  No-Substitutes", term)) {
                    return !this.enrollment().isEmpty() && this.request().getCourseDemand().effectiveNoSub();
                }
                if (this.eq("Not Assigned No-Subs", term) || this.eq("Not Assigned No-Substitutes", term)) {
                    return this.enrollment().isEmpty() && this.request().getCourseDemand().effectiveNoSub();
                }
            }
            if ("assigned".equals(attr) || "scheduled".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return !this.enrollment().isEmpty();
                }
                return this.enrollment().isEmpty();
            }
            if ("waitlisted".equals(attr) || "waitlist".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return this.enrollment().isEmpty() && this.request().getCourseDemand().effectiveWaitList();
                }
                return !this.enrollment().isEmpty();
            }
            if ("no-sub".equals(attr) || "no-substitution".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return this.enrollment().isEmpty() && this.request().getCourseDemand().effectiveNoSub();
                }
                return !this.enrollment().isEmpty();
            }
            if ("reservation".equals(attr) || "reserved".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return !this.enrollment().isEmpty() && this.reservation() != null;
                }
                return !this.enrollment().isEmpty() && this.reservation() == null;
            }
            if ("consent".equals(attr)) {
                if (this.eq("none", term) || this.eq("No Consent", term)) {
                    return this.course().getConsentType() == null;
                }
                if (this.eq("Required", term) || this.eq("Consent", term)) {
                    return this.course().getConsentType() != null && !this.enrollment().isEmpty();
                }
                if (this.eq("Approved", term)) {
                    return this.course().getConsentType() != null && !this.enrollment().isEmpty() && this.approval() != null;
                }
                if (this.eq("Waiting", term)) {
                    return this.course().getConsentType() != null && !this.enrollment().isEmpty() && this.approval() == null;
                }
                if (this.eq("todo", term) || this.eq("To Do", term)) {
                    return this.isConsentToDoCourse() && this.course().getConsentType() != null && !this.enrollment().isEmpty() && this.approval() == null;
                }
                return this.course().getConsentType() != null && !this.enrollment().isEmpty() && (this.approval() != null && this.has(this.approval(), term) || this.eq(this.course().getConsentType().getAbbv(), term));
            }
            if ("mode".equals(attr)) {
                if (this.eq("My Students", term)) {
                    return this.iMyStudent;
                }
                if (this.eq("My Advised", term)) {
                    return this.iMyStudent && !this.student().getAdvisorCourseRequests().isEmpty();
                }
                if (this.eq("My Not Advised", term)) {
                    return this.iMyStudent && this.student().getAdvisorCourseRequests().isEmpty();
                }
                if (this.eq("Advised", term)) {
                    return !this.student().getAdvisorCourseRequests().isEmpty();
                }
                if (this.eq("Not Advised", term)) {
                    return this.student().getAdvisorCourseRequests().isEmpty();
                }
                return true;
            }
            if ("approver".equals(attr)) {
                return this.course().getConsentType() != null && !this.enrollment().isEmpty() && this.approval() != null && this.has(this.approval(), term);
            }
            if ("status".equals(attr)) {
                if ("default".equalsIgnoreCase(term) || "Not Set".equalsIgnoreCase(term)) {
                    return this.student().getSectioningStatus() == null;
                }
                return term.equalsIgnoreCase(this.status());
            }
            if ("credit".equals(attr)) {
                String im;
                float f;
                float min;
                block354: {
                    Matcher m;
                    block353: {
                        min = 0.0f;
                        f = Float.MAX_VALUE;
                        SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                        String number = term;
                        if (number.startsWith("<=")) {
                            prefix = SectioningStatusFilterAction.Credit.le;
                            number = number.substring(2);
                        } else if (number.startsWith(">=")) {
                            prefix = SectioningStatusFilterAction.Credit.ge;
                            number = number.substring(2);
                        } else if (number.startsWith("<")) {
                            prefix = SectioningStatusFilterAction.Credit.lt;
                            number = number.substring(1);
                        } else if (number.startsWith(">")) {
                            prefix = SectioningStatusFilterAction.Credit.gt;
                            number = number.substring(1);
                        } else if (number.startsWith("=")) {
                            prefix = SectioningStatusFilterAction.Credit.eq;
                            number = number.substring(1);
                        }
                        im = null;
                        try {
                            float a = Float.parseFloat(number);
                            switch (prefix) {
                                case eq: {
                                    min = f = a;
                                    break;
                                }
                                case le: {
                                    f = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    f = a - 1.0f;
                                    break;
                                }
                                case gt: {
                                    min = a + 1.0f;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            m = Pattern.compile("([0-9]+\\.?[0-9]*)([^0-9\\.].*)").matcher(number);
                            if (!m.matches()) break block353;
                            float a = Float.parseFloat(m.group(1));
                            im = m.group(2).trim();
                            switch (prefix) {
                                case eq: {
                                    min = f = a;
                                    break;
                                }
                                case le: {
                                    f = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    f = a - 1.0f;
                                    break;
                                }
                                case gt: {
                                    min = a + 1.0f;
                                }
                            }
                        }
                    }
                    if (term.contains("..")) {
                        try {
                            String a = term.substring(0, term.indexOf(46));
                            String b = term.substring(term.indexOf("..") + 2);
                            min = Float.parseFloat(a);
                            f = Float.parseFloat(b);
                        }
                        catch (NumberFormatException e) {
                            m = Pattern.compile("([0-9]+\\.?[0-9]*)\\.\\.([0-9]+\\.?[0-9]*)([^0-9].*)").matcher(term);
                            if (!m.matches()) break block354;
                            min = Float.parseFloat(m.group(1));
                            f = Float.parseFloat(m.group(2));
                            im = m.group(3).trim();
                        }
                    }
                }
                float credit = 0.0f;
                HashSet<Long> courseIds = new HashSet<Long>();
                for (StudentClassEnrollment e : this.student().getClassEnrollments()) {
                    if (!courseIds.add(e.getCourseOffering().getUniqueId())) continue;
                    CourseCreditUnitConfig config = e.getCourseOffering().getCredit();
                    if ("!".equals(im) && e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null || im != null && !"!".equals(im) && (e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod() == null || !im.equalsIgnoreCase(e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod().getReference())) || config == null) continue;
                    credit += config.getMinCredit();
                }
                return min <= credit && credit <= f;
            }
            if ("rc".equals(attr) || "requested-credit".equals(attr)) {
                int n;
                int min = 0;
                int n2 = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            int n3;
                            min = n3 = a;
                            break;
                        }
                        case le: {
                            int n4 = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            int n5 = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        n = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && n == Integer.MAX_VALUE) {
                    return true;
                }
                float studentMinTot = 0.0f;
                float studentMaxTot = 0.0f;
                int nrCoursesTot = 0;
                ArrayList<Float> minsTot = new ArrayList<Float>();
                ArrayList<Float> maxsTot = new ArrayList<Float>();
                Set<Long> advisorWaitListedCourseIds = this.student().getAdvisorWaitListedCourseIds(null);
                for (CourseDemand demand : this.student().getCourseDemands()) {
                    if (demand.getCourseRequests().isEmpty()) continue;
                    Float minTot = null;
                    Float maxTot = null;
                    for (CourseRequest r : demand.getCourseRequests()) {
                        CourseCreditUnitConfig c = r.getCourseOffering().getCredit();
                        if (c == null) continue;
                        if (minTot == null || minTot.floatValue() > c.getMinCredit()) {
                            minTot = Float.valueOf(c.getMinCredit());
                        }
                        if (maxTot != null && !(maxTot.floatValue() < c.getMaxCredit())) continue;
                        maxTot = Float.valueOf(c.getMaxCredit());
                    }
                    boolean isWaitList = false;
                    if (!demand.isAlternative().booleanValue()) {
                        if (demand.isWaitListOrNoSub(this.student().getWaitListMode())) {
                            isWaitList = true;
                        } else if (advisorWaitListedCourseIds != null && !advisorWaitListedCourseIds.isEmpty()) {
                            for (CourseRequest r : demand.getCourseRequests()) {
                                if (!advisorWaitListedCourseIds.contains(r.getCourseOffering().getUniqueId())) continue;
                                isWaitList = true;
                                break;
                            }
                        }
                    }
                    if (isWaitList) {
                        if (minTot == null) continue;
                        studentMinTot += minTot.floatValue();
                        studentMaxTot += maxTot.floatValue();
                        continue;
                    }
                    if (minTot == null) continue;
                    minsTot.add(minTot);
                    maxsTot.add(maxTot);
                    if (demand.isAlternative().booleanValue()) continue;
                    ++nrCoursesTot;
                }
                Collections.sort(minsTot);
                Collections.sort(maxsTot);
                for (int i = 0; i < nrCoursesTot; ++i) {
                    studentMinTot += ((Float)minsTot.get(i)).floatValue();
                    studentMaxTot += ((Float)maxsTot.get(maxsTot.size() - i - 1)).floatValue();
                }
                return (float)min <= studentMaxTot && studentMinTot <= (float)n;
            }
            if ("fc".equals(attr) || "first-choice-credit".equals(attr)) {
                int n;
                int min = 0;
                int n6 = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            int n7;
                            min = n7 = a;
                            break;
                        }
                        case le: {
                            int n8 = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            int n9 = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        n = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && n == Integer.MAX_VALUE) {
                    return true;
                }
                float credit = 0.0f;
                block107: for (CourseDemand demand : this.student().getCourseDemands()) {
                    if (demand.getCourseRequests().isEmpty() || demand.isAlternative().booleanValue()) continue;
                    for (CourseRequest r : new TreeSet<CourseRequest>(demand.getCourseRequests())) {
                        CourseCreditUnitConfig c = r.getCourseOffering().getCredit();
                        if (c == null) continue;
                        credit += c.getMinCredit();
                        continue block107;
                    }
                }
                return (float)min <= credit && credit <= (float)n;
            }
            if ("rp".equals(attr)) {
                int n;
                if ("subst".equalsIgnoreCase(term)) {
                    return this.request().getCourseDemand().isAlternative();
                }
                int min = 0;
                int n10 = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            int n11;
                            min = n11 = a;
                            break;
                        }
                        case le: {
                            int n12 = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            int n13 = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        n = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && n == Integer.MAX_VALUE) {
                    return true;
                }
                return this.request().getCourseDemand().isAlternative() == false && min <= this.request().getCourseDemand().getPriority() + 1 && this.request().getCourseDemand().getPriority() + 1 <= n;
            }
            if ("choice".equals(attr) || "ch".equals(attr)) {
                int n;
                int min = 0;
                int n14 = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            int n15;
                            min = n15 = a;
                            break;
                        }
                        case le: {
                            int n16 = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            int n17 = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        n = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && n == Integer.MAX_VALUE) {
                    return true;
                }
                if (this.enrollment() != null) {
                    int choice = this.request().getOrder() + 1;
                    return min <= choice && choice <= n;
                }
                if (!this.request().getCourseDemand().isAlternative().booleanValue()) {
                    int choice = this.request().getCourseDemand().getCourseRequests().size();
                    return min <= choice && choice <= n;
                }
                return false;
            }
            if ("btb".equals(attr)) {
                if ("prefer".equalsIgnoreCase(term) || "preferred".equalsIgnoreCase(term)) {
                    return this.student().getBackToBackPreference() == Student.BackToBackPreference.BTB_PREFERRED;
                }
                if ("disc".equalsIgnoreCase(term) || "discourage".equalsIgnoreCase(term) || "discouraged".equalsIgnoreCase(term)) {
                    return this.student().getBackToBackPreference() == Student.BackToBackPreference.BTB_DISCOURAGED;
                }
                return this.student().getBackToBackPreference() == Student.BackToBackPreference.NO_PREFERENCE;
            }
            if ("online".equals(attr)) {
                if ("prefer".equalsIgnoreCase(term) || "preferred".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.ONLINE_PREFERRED;
                }
                if ("require".equalsIgnoreCase(term) || "required".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.ONLINE_REQUIRED;
                }
                if ("disc".equalsIgnoreCase(term) || "discourage".equalsIgnoreCase(term) || "discouraged".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.ONILNE_DISCOURAGED;
                }
                if ("no".equalsIgnoreCase(term) || "no-preference".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.NO_PREFERENCE;
                }
            }
            if ("online".equals(attr) || "face-to-face".equals(attr) || "f2f".equals(attr) || "no-time".equals(attr) || "has-time".equals(attr)) {
                int n;
                int min = 0;
                int n18 = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                boolean perc = false;
                if (number.endsWith("%")) {
                    perc = true;
                    number = number.substring(0, number.length() - 1).trim();
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            int n19;
                            min = n19 = a;
                            break;
                        }
                        case le: {
                            int n20 = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            int n21 = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        n = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && n == Integer.MAX_VALUE) {
                    return true;
                }
                int match = 0;
                int total = 0;
                for (StudentClassEnrollment section : this.student().getClassEnrollments()) {
                    Assignment assignment = section.getClazz().getCommittedAssignment();
                    boolean online = true;
                    if (assignment != null) {
                        for (Location loc : assignment.getRooms()) {
                            if (loc.isIgnoreRoomCheck().booleanValue()) continue;
                            online = false;
                            break;
                        }
                    }
                    if ("online".equals(attr) && online) {
                        ++match;
                    } else if (("face-to-face".equals(attr) || "f2f".equals(attr)) && !online) {
                        ++match;
                    } else if ("no-time".equals(attr) && assignment == null) {
                        ++match;
                    } else if ("has-time".equals(attr) && assignment != null) {
                        ++match;
                    }
                    ++total;
                }
                if (total == 0) {
                    return false;
                }
                if (perc) {
                    double percentage = 100.0 * (double)match / (double)total;
                    return (double)min <= percentage && percentage <= (double)n;
                }
                return min <= match && match <= n;
            }
            if ("overlap".equals(attr)) {
                int n;
                int min = 0;
                int n22 = Integer.MAX_VALUE;
                SectioningStatusFilterAction.Credit prefix = SectioningStatusFilterAction.Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = SectioningStatusFilterAction.Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = SectioningStatusFilterAction.Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = SectioningStatusFilterAction.Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = SectioningStatusFilterAction.Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = SectioningStatusFilterAction.Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            int n23;
                            min = n23 = a;
                            break;
                        }
                        case le: {
                            int n24 = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            int n25 = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        n = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                int share = 0;
                for (StudentClassEnrollment section : this.student().getClassEnrollments()) {
                    Assignment assignment = section.getClazz().getCommittedAssignment();
                    if (assignment == null) continue;
                    for (StudentClassEnrollment otherSection : this.student().getClassEnrollments()) {
                        Assignment otherAssignment;
                        if (section.equals(otherSection) || (otherAssignment = otherSection.getClazz().getCommittedAssignment()) == null || !assignment.getTimeLocation().hasIntersection(otherAssignment.getTimeLocation()) || section.getClazz().isToIgnoreStudentConflictsWith(otherSection.getClazz()) || section.getClazz().getUniqueId() >= otherSection.getClazz().getUniqueId()) continue;
                        int sh = assignment.getTimeLocation().nrSharedDays(otherAssignment.getTimeLocation()) * assignment.getTimeLocation().nrSharedHours(otherAssignment.getTimeLocation()) * Constants.SLOT_LENGTH_MIN;
                        share += sh;
                    }
                }
                return min <= share && share <= n;
            }
            if ("override".equals(attr)) {
                if ("null".equalsIgnoreCase(term) || "None".equalsIgnoreCase(term)) {
                    return this.request().getOverrideStatus() == null;
                }
                CourseRequest.CourseRequestOverrideStatus status = null;
                for (CourseRequest.CourseRequestOverrideStatus s : CourseRequest.CourseRequestOverrideStatus.values()) {
                    if (!s.name().equalsIgnoreCase(term)) continue;
                    status = s;
                    break;
                }
                if (status == null) {
                    return false;
                }
                if (this.request().getOverrideStatus() != null && this.request().getOverrideStatus().intValue() == status.ordinal()) {
                    return true;
                }
                return false;
            }
            if ("prefer".equals(attr)) {
                if (this.eq("Any Preference", term)) {
                    return !this.request().getPreferences().isEmpty();
                }
                if (this.eq("Met Preference", term) || this.eq("Unmet Preference", term)) {
                    boolean bl;
                    if (this.enrollment() == null || this.enrollment().isEmpty()) {
                        if (this.eq("Unmet Preference", term)) {
                            return !this.request().getPreferences().isEmpty();
                        }
                        return false;
                    }
                    boolean hasPref = false;
                    boolean bl2 = false;
                    boolean im = false;
                    HashSet<String> allSubpart = new HashSet<String>();
                    HashSet<String> selectedSubparts = new HashSet<String>();
                    for (StudentSectioningPref p : this.request().getPreferences()) {
                        hasPref = true;
                        if (p instanceof StudentInstrMthPref) {
                            bl = true;
                            StudentInstrMthPref imp = (StudentInstrMthPref)p;
                            InstructionalMethod method = this.enrollment().get(0).getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod();
                            if (method != null && method.equals(imp.getInstructionalMethod())) {
                                im = true;
                            }
                        }
                        if (!(p instanceof StudentClassPref)) continue;
                        StudentClassPref scp = (StudentClassPref)p;
                        allSubpart.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                        for (StudentClassEnrollment section : this.enrollment()) {
                            if (!scp.getClazz().equals(section.getClazz())) continue;
                            selectedSubparts.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                        }
                    }
                    if (this.eq("Met Preference", term)) {
                        return hasPref && bl == im && selectedSubparts.size() == allSubpart.size();
                    }
                    return hasPref && (bl != im || selectedSubparts.size() != allSubpart.size());
                }
                for (StudentSectioningPref studentSectioningPref : this.request().getPreferences()) {
                    if (!this.eq(studentSectioningPref.getLabel(), term)) continue;
                    return true;
                }
                return false;
            }
            if ("require".equals(attr)) {
                if (this.eq("Any Requirement", term)) {
                    for (StudentSectioningPref studentSectioningPref : this.request().getPreferences()) {
                        if (!studentSectioningPref.isRequired().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }
                if (this.eq("Met Requirement", term)) {
                    boolean bl;
                    if (this.enrollment() == null || this.enrollment().isEmpty()) {
                        return false;
                    }
                    boolean hasPref = false;
                    boolean bl3 = false;
                    boolean im = false;
                    HashSet<String> allSubpart = new HashSet<String>();
                    HashSet<String> selectedSubparts = new HashSet<String>();
                    for (StudentSectioningPref p : this.request().getPreferences()) {
                        if (!p.isRequired().booleanValue()) continue;
                        hasPref = true;
                        if (p instanceof StudentInstrMthPref) {
                            bl = true;
                            StudentInstrMthPref imp = (StudentInstrMthPref)p;
                            InstructionalMethod method = this.enrollment().get(0).getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod();
                            if (method != null && method.equals(imp.getInstructionalMethod())) {
                                im = true;
                            }
                        }
                        if (!(p instanceof StudentClassPref)) continue;
                        StudentClassPref scp = (StudentClassPref)p;
                        allSubpart.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                        for (StudentClassEnrollment section : this.enrollment()) {
                            if (!scp.getClazz().equals(section.getClazz())) continue;
                            selectedSubparts.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                        }
                    }
                    return hasPref && bl == im && selectedSubparts.size() == allSubpart.size();
                }
                if (this.eq("Unmet Requirement", term)) {
                    if (this.enrollment() != null) {
                        return false;
                    }
                    for (StudentSectioningPref studentSectioningPref : this.request().getPreferences()) {
                        if (!studentSectioningPref.isRequired().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }
                for (StudentSectioningPref studentSectioningPref : this.request().getPreferences()) {
                    if (!studentSectioningPref.isRequired().booleanValue() || !this.eq(studentSectioningPref.getLabel(), term)) continue;
                    return true;
                }
                return false;
            }
            if ("im".equals(attr)) {
                InstrOfferingConfig thisConfig = this.config();
                if (thisConfig != null) {
                    if (thisConfig.getInstructionalMethod() == null) {
                        return term.equals(this.session().getDefaultInstructionalMethod());
                    }
                    return term.equals(thisConfig.getInstructionalMethod().getReference());
                }
                for (InstrOfferingConfig config : this.offering().getInstrOfferingConfigs()) {
                    if (config.getInstructionalMethod() == null && term.equals(this.session().getDefaultInstructionalMethod())) {
                        return true;
                    }
                    if (config.getInstructionalMethod() == null || !term.equals(config.getInstructionalMethod().getReference())) continue;
                    return true;
                }
                return false;
            }
            if (!this.enrollment().isEmpty()) {
                for (StudentClassEnrollment studentClassEnrollment : this.enrollment()) {
                    int start;
                    int end;
                    Assignment assignment;
                    if ((attr == null || attr.equals("crn") || attr.equals("id") || attr.equals("externalId") || attr.equals("exid") || attr.equals("name")) && studentClassEnrollment.getClazz().getClassSuffix(studentClassEnrollment.getCourseOffering()).toLowerCase().startsWith(term.toLowerCase())) {
                        return true;
                    }
                    if (attr == null || attr.equals("day")) {
                        int day;
                        assignment = studentClassEnrollment.getClazz().getCommittedAssignment();
                        if (assignment == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (assignment != null && (day = this.parseDay(term)) > 0 && (assignment.getDays() & day) == day) {
                            return true;
                        }
                    }
                    if (attr == null || attr.equals("time")) {
                        int start2;
                        assignment = studentClassEnrollment.getClazz().getCommittedAssignment();
                        if (assignment == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (assignment != null && (start2 = this.parseStart(term)) >= 0 && assignment.getStartSlot() == start2) {
                            return true;
                        }
                    }
                    if (attr != null && attr.equals("before") && (assignment = studentClassEnrollment.getClazz().getCommittedAssignment()) != null && (end = this.parseStart(term)) >= 0 && assignment.getStartSlot() + assignment.getSlotPerMtg() - assignment.getBreakTime() / 5 <= end) {
                        return true;
                    }
                    if (attr != null && attr.equals("after") && (assignment = studentClassEnrollment.getClazz().getCommittedAssignment()) != null && (start = this.parseStart(term)) >= 0 && assignment.getStartSlot() >= start) {
                        return true;
                    }
                    if (attr == null || attr.equals("date")) {
                        ClassEvent event = studentClassEnrollment.getClazz().getEvent();
                        if (event == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (event != null) {
                            Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
                            for (Meeting m : event.getMeetings()) {
                                if (!this.eq(df.format(m.getMeetingDate()), term)) continue;
                                return true;
                            }
                        }
                    }
                    if (attr == null || attr.equals("room")) {
                        assignment = studentClassEnrollment.getClazz().getCommittedAssignment();
                        if ((assignment == null || assignment.getRooms().isEmpty()) && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (assignment != null) {
                            for (Location room : assignment.getRooms()) {
                                if (!this.has(room.getLabel(), term)) continue;
                                return true;
                            }
                        }
                    }
                    if (attr != null && !attr.equals("instr") && !attr.equals("instructor")) continue;
                    if (attr != null && studentClassEnrollment.getClazz().getClassInstructors().isEmpty() && term.equalsIgnoreCase("none")) {
                        return true;
                    }
                    for (ClassInstructor instuctor : studentClassEnrollment.getClazz().getClassInstructors()) {
                        if (this.has(this.iFormat.format(instuctor.getInstructor()), term) || this.eq(instuctor.getInstructor().getExternalUniqueId(), term)) {
                            return true;
                        }
                        if (instuctor.getInstructor().getEmail() == null) continue;
                        String email = instuctor.getInstructor().getEmail();
                        if (email.indexOf(64) >= 0) {
                            email = email.substring(0, email.indexOf(64));
                        }
                        if (!this.eq(email, term)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean like(String name, String term) {
            if (name == null) {
                return false;
            }
            if (term.indexOf(37) >= 0) {
                return name.matches("(?i)" + term.replaceAll("%", ".*"));
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" |,")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }

        private int parseDay(String token) {
            int days = 0;
            boolean found = false;
            do {
                int i;
                found = false;
                for (i = 0; i < CONSTANTS.longDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.longDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.longDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.days().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.days()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.days()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.days().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.days()[i].substring(0, 2).toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(2);
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.shortDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.shortDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.shortDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < CONSTANTS.freeTimeShortDays().length; ++i) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.freeTimeShortDays()[i].toLowerCase())) continue;
                    days |= DayCode.values()[i].getCode();
                    token = token.substring(CONSTANTS.freeTimeShortDays()[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
            } while (found);
            return token.isEmpty() ? days : 0;
        }

        private int parseStart(String token) {
            int startHour = 0;
            int startMin = 0;
            String number = "";
            while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                number = number + token.substring(0, 1);
                token = token.substring(1);
            }
            if (number.isEmpty()) {
                return -1;
            }
            if (number.length() > 2) {
                startHour = Integer.parseInt(number) / 100;
                startMin = Integer.parseInt(number) % 100;
            } else {
                startHour = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            if (token.startsWith(":")) {
                token = token.substring(1);
                while (token.startsWith(" ")) {
                    token = token.substring(1);
                }
                number = "";
                while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                    number = number + token.substring(0, 1);
                    token = token.substring(1);
                }
                if (number.isEmpty()) {
                    return -1;
                }
                startMin = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            boolean hasAmOrPm = false;
            if (token.toLowerCase().startsWith("am")) {
                token = token.substring(2);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("a")) {
                token = token.substring(1);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("pm")) {
                token = token.substring(2);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (token.toLowerCase().startsWith("p")) {
                token = token.substring(1);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (startHour < 7 && !hasAmOrPm) {
                startHour += 12;
            }
            if (startMin % 5 != 0) {
                startMin = 5 * ((startMin + 2) / 5);
            }
            if (startHour == 7 && startMin == 0 && !hasAmOrPm) {
                startHour += 12;
            }
            return (60 * startHour + startMin) / 5;
        }
    }

    public static class DbCourseInfoMatcher
    implements Query.AmbigousTermMatcher,
    Serializable {
        private static final long serialVersionUID = 1L;
        private CourseOffering iCourse;
        private boolean iConsentToDoCourse;
        private StatusPageSuggestionsAction.CourseLookup iLookup;

        public DbCourseInfoMatcher(CourseOffering course, boolean isConsentToDoCourse, StatusPageSuggestionsAction.CourseLookup lookup) {
            this.iCourse = course;
            this.iConsentToDoCourse = isConsentToDoCourse;
            this.iLookup = lookup;
        }

        public CourseOffering course() {
            return this.iCourse;
        }

        public boolean isConsentToDoCourse() {
            return this.iConsentToDoCourse;
        }

        @Override
        public Boolean match(String attr, String term) {
            if (term.isEmpty()) {
                return true;
            }
            if ("limit".equals(attr)) {
                return true;
            }
            if ("lookup".equals(attr)) {
                Set<Long> courseIds = this.iLookup.getCourses(term);
                return courseIds != null && courseIds.contains(this.course().getUniqueId());
            }
            if (attr == null || "name".equals(attr) || "course".equals(attr)) {
                return this.course().getSubjectAreaAbbv().equalsIgnoreCase(term) || this.course().getCourseNbr().equalsIgnoreCase(term) || (this.course().getSubjectAreaAbbv() + " " + this.course().getCourseNbr()).equalsIgnoreCase(term);
            }
            if (attr == null && term.length() > 2 || "title".equals(attr)) {
                return (this.course().getTitle() == null ? "" : this.course().getTitle()).toLowerCase().contains(term.toLowerCase());
            }
            if (attr == null || "subject".equals(attr)) {
                return this.course().getSubjectAreaAbbv().equalsIgnoreCase(term);
            }
            if (attr == null || "number".equals(attr)) {
                return this.course().getCourseNbr().equalsIgnoreCase(term);
            }
            if ("department".equals(attr)) {
                return (this.course().getSubjectArea().getDepartment().getDeptCode() == null ? this.course().getSubjectArea().getDepartment().getAbbreviation() : this.course().getSubjectArea().getDepartment().getDeptCode()).equalsIgnoreCase(term);
            }
            if ("consent".equals(attr)) {
                if ("none".equalsIgnoreCase(term) || "No Consent".equalsIgnoreCase(term)) {
                    return this.course().getConsentType() == null;
                }
                if ("todo".equalsIgnoreCase(term) || "To Do".equalsIgnoreCase(term)) {
                    return this.isConsentToDoCourse();
                }
                return this.course().getConsentType() != null;
            }
            if ("mode".equals(attr)) {
                return true;
            }
            if ("registered".equals(attr)) {
                if ("true".equalsIgnoreCase(term) || "1".equalsIgnoreCase(term)) {
                    return true;
                }
                return false;
            }
            if ("assignment".equals(attr)) {
                if ("Wait-Listed".equals(term)) {
                    return this.course().getInstructionalOffering().effectiveWaitList();
                }
                return true;
            }
            if ("im".equals(attr)) {
                for (InstrOfferingConfig config : this.course().getInstructionalOffering().getInstrOfferingConfigs()) {
                    InstructionalMethod im = config.getEffectiveInstructionalMethod();
                    if (im == null || !term.equals(im.getReference())) continue;
                    return true;
                }
                return false;
            }
            return null;
        }
    }

    public static class DbFindEnrollmentInfoCourseMatcher
    extends FindEnrollmentInfoAction.FindEnrollmentInfoCourseMatcher {
        private static final long serialVersionUID = 1L;

        public DbFindEnrollmentInfoCourseMatcher(Set<Long> coursesIcoordinate, Set<Long> coursesIcanApprove, Set<String> subjects, Query query, StatusPageSuggestionsAction.CourseLookup lookup, OnlineSectioningServer server) {
            super(coursesIcoordinate, coursesIcanApprove, subjects, query, lookup, server);
        }

        public boolean isConsentToDoCourse(CourseOffering co) {
            return this.iCoursesIcanApprove != null && co.getConsentType() != null && this.iCoursesIcanApprove.contains(co.getUniqueId());
        }

        public boolean match(CourseOffering co) {
            return co != null && this.isCourseVisible(co.getUniqueId()) && this.hasMatchingSubjectArea(co.getSubjectAreaAbbv()) && this.iQuery.match(new DbCourseInfoMatcher(co, this.isConsentToDoCourse(co), this.iLookup));
        }
    }
}

