/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.model.Student;
import org.joda.time.LocalDate;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AbstractStudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XAdvisorRequest;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.solver.studentsct.StudentSolver;
import org.unitime.timetable.util.Formats;

public class FindStudentInfoAction
implements OnlineSectioningAction<List<ClassAssignmentInterface.StudentInfo>> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    protected Query iQuery;
    protected Integer iLimit = null;
    protected Set<Long> iCoursesIcoordinate;
    protected Set<Long> iCoursesIcanApprove;
    protected Set<Long> iMyStudents;
    protected Set<String> iSubjectAreas;
    protected boolean iCanShowExtIds = false;
    protected boolean iCanRegister = false;
    protected boolean iCanUseAssistant = false;
    protected boolean iIsAdmin = false;
    protected boolean iIsAdvisor = false;
    protected boolean iCanEditMyStudents = false;
    protected boolean iCanEditOtherStudents = false;
    protected boolean iCanSelect = false;
    protected SectioningStatusFilterBox.SectioningStatusFilterRpcRequest iFilter = null;

    public FindStudentInfoAction withParams(String query, Set<Long> coursesIcoordinage, Set<Long> coursesIcanApprove, Set<Long> myStudents, Set<String> subjects, boolean canShowExtIds, boolean canRegister, boolean canUseAssistant) {
        this.iQuery = new Query(query);
        this.iCoursesIcanApprove = coursesIcanApprove;
        this.iCoursesIcoordinate = coursesIcoordinage;
        this.iMyStudents = myStudents;
        this.iCanShowExtIds = canShowExtIds;
        this.iCanRegister = canRegister;
        this.iCanUseAssistant = canUseAssistant;
        this.iSubjectAreas = subjects;
        Matcher m = Pattern.compile("limit:[ ]?([0-9]*)", 2).matcher(query);
        if (m.find()) {
            this.iLimit = Integer.parseInt(m.group(1));
        }
        return this;
    }

    public FindStudentInfoAction withPermissions(boolean isAdmin, boolean isAdvisor, boolean canEditMyStudents, boolean canEditOtherStudents, boolean canSelectOtherRole) {
        this.iIsAdmin = isAdmin;
        this.iIsAdvisor = isAdvisor;
        this.iCanEditMyStudents = canEditMyStudents;
        this.iCanEditOtherStudents = canEditOtherStudents;
        this.iCanSelect = canSelectOtherRole;
        return this;
    }

    public FindStudentInfoAction withFilter(SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) {
        this.iFilter = filter;
        return this;
    }

    public Query query() {
        return this.iQuery;
    }

    public Integer limit() {
        return this.iLimit;
    }

    public boolean isConsentToDoCourse(XCourse course) {
        return this.iCoursesIcanApprove != null && course.getConsentLabel() != null && this.iCoursesIcanApprove.contains(course.getCourseId());
    }

    public boolean isCourseVisible(Long courseId) {
        return this.iCoursesIcoordinate == null || this.iCoursesIcoordinate.contains(courseId);
    }

    public boolean hasMatchingSubjectArea(String subject) {
        return this.iSubjectAreas == null || this.iSubjectAreas.contains(subject);
    }

    public boolean isMyStudent(XStudentId student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getStudentId());
    }

    public boolean isCanSelect(XStudentId student) {
        if (this.iIsAdmin) {
            return true;
        }
        return this.iIsAdvisor ? this.iCanEditOtherStudents || this.iCanEditMyStudents && this.isMyStudent(student) : this.iCanSelect;
    }

    @Override
    public List<ClassAssignmentInterface.StudentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        HashMap<Long, ClassAssignmentInterface.StudentInfo> students = new HashMap<Long, ClassAssignmentInterface.StudentInfo>();
        int gEnrl = 0;
        int gWait = 0;
        int gRes = 0;
        int gUnasg = 0;
        int gNoSub = 0;
        int gSwap = 0;
        int gtEnrl = 0;
        int gtWait = 0;
        int gtRes = 0;
        int gtUnasg = 0;
        int gtNoSub = 0;
        int gtSwap = 0;
        int gConNeed = 0;
        int gtConNeed = 0;
        int gOvrNeed = 0;
        int gtOvrNeed = 0;
        int gDist = 0;
        int gtDist = 0;
        int gNrDC = 0;
        int gtNrDC = 0;
        int gShr = 0;
        int gtShr = 0;
        int gFre = 0;
        int gtFre = 0;
        int gPIM = 0;
        int gtPIM = 0;
        int gPSec = 0;
        int gtPSec = 0;
        HashSet<Long> unassigned = new HashSet<Long>();
        HashSet<Long> assigned = new HashSet<Long>();
        AcademicSessionInfo session = server.getAcademicSession();
        StatusPageSuggestionsAction.CourseLookup lookup = new StatusPageSuggestionsAction.CourseLookup(session);
        HashSet<String> regStates = new HashSet<String>();
        HashSet<String> assStates = new HashSet<String>();
        HashSet<String> wlStates = new HashSet<String>();
        HashSet<String> noSubStates = new HashSet<String>();
        Session dbSession = (Session)SessionDAO.getInstance().get(session.getUniqueId());
        for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll(helper.getHibSession())) {
            if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.enabled) || this.iIsAdmin && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.admin) || this.iIsAdvisor && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.advisor)) {
                assStates.add(status.getReference());
            }
            if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regenabled) || this.iIsAdmin && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regadmin) || this.iIsAdvisor && StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regadvisor)) {
                regStates.add(status.getReference());
            }
            if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.waitlist)) {
                wlStates.add(status.getReference());
                continue;
            }
            if (!StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.nosubs)) continue;
            noSubStates.add(status.getReference());
        }
        OnlineSectioningInterface.WaitListMode defaultWL = null;
        if (server instanceof StudentSolver) {
            defaultWL = OnlineSectioningInterface.WaitListMode.NoSubs;
        }
        DistanceMetric dm = server.getDistanceMetric();
        boolean solver = server instanceof StudentSolver;
        Set<Long> studentIds = null;
        Map<Long, List<AdvisorCourseRequest>> acrs = null;
        if (!solver) {
            studentIds = this.iFilter == null ? null : server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getStudentIds(server, helper);
        } else if (this.iFilter != null) {
            acrs = server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getAdvisorCourseRequests(server, helper);
        }
        boolean useAdvisorWaitLists = server.getConfig().getPropertyBoolean("Load.UseAdvisorWaitLists", false);
        boolean useAdvisorNoSubs = server.getConfig().getPropertyBoolean("Load.UseAdvisorNoSubs", false);
        for (XCourseId xCourseId : this.findCourses(server, helper, lookup)) {
            XOffering xOffering = server.getOffering(xCourseId.getOfferingId());
            if (xOffering == null) continue;
            XCourse xCourse = xOffering.getCourse(xCourseId.getCourseId());
            XEnrollments enrollments = server.getEnrollments(xCourseId.getOfferingId());
            if (enrollments == null) continue;
            boolean isConsentToDoCourse = this.isConsentToDoCourse(xCourse);
            for (XCourseRequest request : enrollments.getRequests()) {
                Iterator<Externalizable> student;
                if (!request.hasCourse(xCourseId.getCourseId()) || request.getEnrollment() != null && !request.getEnrollment().getCourseId().equals(xCourseId.getCourseId()) || studentIds != null && !studentIds.contains(request.getStudentId()) || (student = server.getStudent(request.getStudentId())) == null) continue;
                String status = ((XStudent)((Object)student)).getStatus() == null ? session.getDefaultSectioningStatus() : ((XStudent)((Object)student)).getStatus();
                OnlineSectioningInterface.WaitListMode wl = OnlineSectioningInterface.WaitListMode.None;
                if (defaultWL != null) {
                    wl = defaultWL;
                } else if (status == null || wlStates.contains(status)) {
                    wl = OnlineSectioningInterface.WaitListMode.WaitList;
                } else if (noSubStates.contains(status)) {
                    wl = OnlineSectioningInterface.WaitListMode.NoSubs;
                }
                if (acrs != null) {
                    ((XStudent)((Object)student)).setAdvisorRequests(acrs.get(((XStudentId)((Object)student)).getStudentId()), helper, server.getAcademicSession().getFreeTimePattern());
                }
                StatusPageSuggestionsAction.CourseRequestMatcher m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, xCourse, (XStudent)((Object)student), xOffering, request, isConsentToDoCourse, this.isMyStudent((XStudentId)((Object)student)), lookup, server, wl);
                if (!this.query().match(m)) continue;
                ClassAssignmentInterface.StudentInfo s = (ClassAssignmentInterface.StudentInfo)students.get(request.getStudentId());
                if (s == null) {
                    int i;
                    s = new ClassAssignmentInterface.StudentInfo();
                    students.put(request.getStudentId(), s);
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    s.setStudent(st);
                    st.setId(request.getStudentId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(((XStudentId)((Object)student)).getExternalId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    st.setWaitListMode(wl);
                    st.setCanRegister(this.iCanRegister && (status == null || regStates.contains(status)));
                    st.setCanUseAssistant(this.iCanUseAssistant && (status == null || assStates.contains(status)));
                    st.setCanSelect(this.isCanSelect((XStudentId)((Object)student)));
                    st.setName(((XStudentId)((Object)student)).getName());
                    for (XAreaClassificationMajor acm : ((XStudent)((Object)student)).getMajors()) {
                        st.addArea(acm.getArea(), acm.getAreaLabel());
                        st.addClassification(acm.getClassification(), acm.getClassificationLabel());
                        st.addMajor(acm.getMajor(), acm.getMajorLabel());
                        st.addConcentration(acm.getConcentration(), acm.getConcentrationLabel());
                        st.addDegree(acm.getDegree(), acm.getDegreeLabel());
                        st.addProgram(acm.getProgram(), acm.getProgramLabel());
                        st.addCampus(acm.getCampus(), acm.getCampusLabel());
                    }
                    st.setDefaultCampus(server.getAcademicSession().getCampus());
                    for (XAreaClassificationMajor acm : ((XStudent)((Object)student)).getMinors()) {
                        st.addMinor(acm.getMajor(), acm.getMajorLabel());
                    }
                    for (XStudent.XGroup gr : ((XStudent)((Object)student)).getGroups()) {
                        st.addGroup(gr.getType(), gr.getAbbreviation(), gr.getTitle());
                    }
                    for (XStudent.XGroup acc : ((XStudent)((Object)student)).getAccomodations()) {
                        st.addAccommodation(acc.getAbbreviation(), acc.getTitle());
                    }
                    for (XStudent.XAdvisor a : ((XStudent)((Object)student)).getAdvisors()) {
                        if (a.getName() == null) continue;
                        st.addAdvisor(a.getName());
                    }
                    int tEnrl = 0;
                    int tWait = 0;
                    int tRes = 0;
                    int tConNeed = 0;
                    int tReq = 0;
                    int tUnasg = 0;
                    int tOvrNeed = 0;
                    int ovrNeed = 0;
                    int tNoSub = 0;
                    int tSwap = 0;
                    float tCred = 0.0f;
                    int nrDisCnf = 0;
                    int maxDist = 0;
                    int share = 0;
                    int ftShare = 0;
                    ArrayList<Float> minsTot = new ArrayList<Float>();
                    ArrayList<Float> maxsTot = new ArrayList<Float>();
                    ArrayList<Float> mins = new ArrayList<Float>();
                    ArrayList<Float> maxs = new ArrayList<Float>();
                    int nrCoursesTot = 0;
                    int nrCourses = 0;
                    float studentMin = 0.0f;
                    float studentMax = 0.0f;
                    float studentMinTot = 0.0f;
                    float studentMaxTot = 0.0f;
                    Set<Long> advisorWaitListedCourseIds = ((XStudent)((Object)student)).getAdvisorWaitListedCourseIds(useAdvisorWaitLists, useAdvisorNoSubs);
                    for (XRequest r : ((XStudent)((Object)student)).getRequests()) {
                        XOffering o;
                        XConfig g;
                        XCourse i2;
                        if (!(r instanceof XCourseRequest)) continue;
                        XCourseRequest cr = (XCourseRequest)r;
                        Float min = null;
                        Float max = null;
                        Float minTot = null;
                        Float maxTot = null;
                        for (XCourseId courseId : cr.getCourseIds()) {
                            XCourse c = server.getCourse(courseId.getCourseId());
                            if (c != null && c.hasCredit()) {
                                if (minTot == null || minTot.floatValue() > c.getMinCredit().floatValue()) {
                                    minTot = c.getMinCredit();
                                }
                                if (maxTot == null || maxTot.floatValue() < c.getMaxCredit().floatValue()) {
                                    maxTot = c.getMaxCredit();
                                }
                            }
                            if (cr.isOverridePending(c)) {
                                ++gtOvrNeed;
                                ++tOvrNeed;
                            }
                            if (!this.query().match(new StatusPageSuggestionsAction.CourseRequestMatcher(session, c, (XStudent)((Object)student), server.getOffering(c.getOfferingId()), cr, this.isConsentToDoCourse(c), this.isMyStudent((XStudentId)((Object)student)), lookup, server, wl))) continue;
                            if (c != null && c.hasCredit()) {
                                if (min == null || min.floatValue() > c.getMinCredit().floatValue()) {
                                    min = c.getMinCredit();
                                }
                                if (max == null || max.floatValue() < c.getMaxCredit().floatValue()) {
                                    max = c.getMaxCredit();
                                }
                            }
                            if (!cr.isOverridePending(c)) continue;
                            ++gOvrNeed;
                            ++ovrNeed;
                        }
                        if (cr.isWaitListOrNoSub(wl, advisorWaitListedCourseIds)) {
                            if (minTot != null) {
                                studentMinTot += minTot.floatValue();
                                studentMaxTot += maxTot.floatValue();
                            }
                            if (min != null) {
                                studentMin += min.floatValue();
                                studentMax += max.floatValue();
                            }
                        } else {
                            if (minTot != null) {
                                minsTot.add(minTot);
                                maxsTot.add(maxTot);
                                if (!r.isAlternative()) {
                                    ++nrCoursesTot;
                                }
                            }
                            if (min != null) {
                                mins.add(min);
                                maxs.add(max);
                                if (!r.isAlternative()) {
                                    ++nrCourses;
                                }
                            }
                        }
                        if (!r.isAlternative()) {
                            ++tReq;
                        }
                        if (cr.getEnrollment() == null) {
                            if (!((XStudent)((Object)student)).canAssign(cr, st.getWaitListMode())) continue;
                            ++tUnasg;
                            ++gtUnasg;
                            if (cr.isWaitlist(st.getWaitListMode())) {
                                ++tWait;
                                ++gtWait;
                            }
                            if (!cr.isNoSub(st.getWaitListMode())) continue;
                            ++tNoSub;
                            ++gtNoSub;
                            continue;
                        }
                        ++tEnrl;
                        ++gtEnrl;
                        if (cr.getEnrollment().getReservation() != null) {
                            ++tRes;
                            ++gtRes;
                        }
                        if (cr.getEnrollment().getApproval() == null && (i2 = server.getCourse(cr.getEnrollment().getCourseId())) != null && i2.getConsentLabel() != null) {
                            ++tConNeed;
                            ++gtConNeed;
                        }
                        if (cr.isWaitlist(wl) && cr.getEnrollment().equals(cr.getWaitListSwapWithCourseOffering())) {
                            ++tSwap;
                            ++gtSwap;
                        }
                        XConfig xConfig = g = (o = server.getOffering(cr.getEnrollment().getOfferingId())) == null ? null : o.getConfig(cr.getEnrollment().getConfigId());
                        if (g != null) {
                            for (XSubpart xs : g.getSubparts()) {
                                tCred += xs.getCreditValue(cr.getEnrollment().getCourseId());
                                if (g.getInstructionalMethod() == null || g.getInstructionalMethod().getReference().equals(session.getDefaultInstructionalMethod())) continue;
                                s.addIMTotalCredit(g.getInstructionalMethod().getReference(), xs.getCreditValue(cr.getEnrollment().getCourseId()));
                            }
                        }
                        if (o == null) continue;
                        for (XSection section : o.getSections(cr.getEnrollment())) {
                            if (section.getTime() == null) continue;
                            for (XRequest q : ((XStudent)((Object)student)).getRequests()) {
                                if (q instanceof XCourseRequest) {
                                    XEnrollment otherEnrollment = ((XCourseRequest)q).getEnrollment();
                                    if (otherEnrollment == null) continue;
                                    XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                                    for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                        if (otherSection.equals(section) || otherSection.getTime() == null) continue;
                                        if (otherSection.isDistanceConflict((XStudent)((Object)student), section, dm)) {
                                            ++nrDisCnf;
                                            ++gtNrDC;
                                            int d = otherSection.getDistanceInMinutes(section, dm);
                                            if (d > maxDist) {
                                                maxDist = d;
                                            }
                                            if (d > gtDist) {
                                                gtDist = d;
                                            }
                                        }
                                        if (!section.getTime().hasIntersection(otherSection.getTime()) || section.isToIgnoreStudentConflictsWith(o.getDistributions(), otherSection.getSectionId()) || section.getSectionId() >= otherSection.getSectionId()) continue;
                                        share += section.getTime().share(otherSection.getTime());
                                        gtShr += section.getTime().share(otherSection.getTime());
                                    }
                                    continue;
                                }
                                if (!(q instanceof XFreeTimeRequest)) continue;
                                XFreeTimeRequest ft = (XFreeTimeRequest)q;
                                if (!section.getTime().hasIntersection(ft.getTime())) continue;
                                ftShare += section.getTime().share(ft.getTime());
                                gtFre += section.getTime().share(ft.getTime());
                            }
                        }
                    }
                    if (((XStudent)((Object)student)).isMaxCreditOverridePending()) {
                        if (nrCourses == nrCoursesTot) {
                            ++gOvrNeed;
                            ++ovrNeed;
                        }
                        ++gtOvrNeed;
                        ++tOvrNeed;
                    }
                    Collections.sort(mins);
                    Collections.sort(maxs);
                    for (i = 0; i < nrCourses; ++i) {
                        studentMin += ((Float)mins.get(i)).floatValue();
                        studentMax += ((Float)maxs.get(maxs.size() - i - 1)).floatValue();
                    }
                    Collections.sort(minsTot);
                    Collections.sort(maxsTot);
                    for (i = 0; i < nrCoursesTot; ++i) {
                        studentMinTot += ((Float)minsTot.get(i)).floatValue();
                        studentMaxTot += ((Float)maxsTot.get(maxsTot.size() - i - 1)).floatValue();
                    }
                    s.setRequestCredit(studentMin, studentMax);
                    s.setTotalRequestCredit(studentMinTot, studentMaxTot);
                    s.setTotalEnrollment(tEnrl);
                    s.setTotalReservation(tRes);
                    s.setTotalWaitlist(tWait);
                    s.setTotalNoSub(tNoSub);
                    s.setTotalSwap(tSwap);
                    s.setTotalUnassigned(tUnasg);
                    s.setTotalConsentNeeded(tConNeed);
                    s.setTotalOverrideNeeded(tOvrNeed);
                    s.setEnrollment(0);
                    s.setReservation(0);
                    s.setNoSub(0);
                    s.setWaitlist(0);
                    s.setSwap(0);
                    s.setUnassigned(0);
                    s.setConsentNeeded(0);
                    s.setOverrideNeeded(ovrNeed);
                    s.setRequested(tReq);
                    s.setStatus(((XStudent)((Object)student)).getStatus() == null ? session.getDefaultSectioningStatus() : ((XStudent)((Object)student)).getStatus());
                    s.setEmailDate(((XStudent)((Object)student)).getEmailTimeStamp() == null ? null : ((XStudent)((Object)student)).getEmailTimeStamp());
                    s.setCredit(Float.valueOf(0.0f));
                    s.setTotalCredit(Float.valueOf(tCred));
                    s.setNote(((XStudent)((Object)student)).hasLastNote() ? ((XStudent)((Object)student)).getLastNote().getNote() : null);
                    s.setNrDistanceConflicts(0);
                    s.setLongestDistanceMinutes(0);
                    s.setOverlappingMinutes(0);
                    s.setTotalNrDistanceConflicts(nrDisCnf);
                    s.setTotalLongestDistanceMinutes(maxDist);
                    s.setTotalOverlappingMinutes(share);
                    s.setFreeTimeOverlappingMins(0);
                    s.setTotalFreeTimeOverlappingMins(ftShare);
                    s.setPrefInstrMethConflict(0);
                    s.setTotalPrefInstrMethConflict(0);
                    s.setPrefSectionConflict(0);
                    s.setTotalPrefSectionConflict(0);
                    s.setMyStudent(this.isMyStudent((XStudentId)((Object)student)));
                    s.setAdvisedInfo(FindStudentInfoAction.getAdvisedInfo(student, server, helper));
                    s.setPreference(FindStudentInfoAction.getStudentSchedulingPreference(student, server, helper));
                }
                if (m.enrollment() != null) {
                    if (assigned.add(m.request().getRequestId())) {
                        XOffering o;
                        XConfig g;
                        s.setEnrollment(s.getEnrollment() + 1);
                        ++gEnrl;
                        if (m.enrollment().getReservation() != null) {
                            s.setReservation(s.getReservation() + 1);
                            ++gRes;
                        }
                        if (xCourse.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                            s.setConsentNeeded(s.getConsentNeeded() + 1);
                            ++gConNeed;
                        }
                        if (m.request().isWaitlist(wl) && m.request().getEnrollment().equals(m.request().getWaitListSwapWithCourseOffering())) {
                            s.setSwap(s.getSwap() + 1);
                            ++gSwap;
                        }
                        if (m.enrollment().getTimeStamp() != null) {
                            if (s.getEnrolledDate() == null) {
                                s.setEnrolledDate(m.enrollment().getTimeStamp());
                            } else if (m.enrollment().getTimeStamp().after(s.getEnrolledDate())) {
                                s.setEnrolledDate(m.enrollment().getTimeStamp());
                            }
                        }
                        if (m.enrollment().getApproval() != null) {
                            if (s.getApprovedDate() == null) {
                                s.setApprovedDate(m.enrollment().getApproval().getTimeStamp());
                            } else if (m.enrollment().getApproval().getTimeStamp().after(s.getApprovedDate())) {
                                s.setApprovedDate(m.enrollment().getApproval().getTimeStamp());
                            }
                        }
                        XConfig xConfig = g = (o = server.getOffering(m.enrollment().getOfferingId())) == null ? null : o.getConfig(m.enrollment().getConfigId());
                        if (g != null) {
                            for (XSubpart xs : g.getSubparts()) {
                                s.setCredit(Float.valueOf(s.getCredit().floatValue() + xs.getCreditValue(m.enrollment().getCourseId())));
                                if (g.getInstructionalMethod() == null || g.getInstructionalMethod().getReference().equals(session.getDefaultInstructionalMethod())) continue;
                                s.addIMCredit(g.getInstructionalMethod().getReference(), xs.getCreditValue(m.enrollment().getCourseId()));
                            }
                            List<XCourseRequest.XPreference> pref = m.request().getPreferences(m.enrollment());
                            if (pref != null) {
                                boolean hasIm = false;
                                boolean im = false;
                                HashSet<String> allSubparts = new HashSet<String>();
                                HashSet<String> selectedSubparts = new HashSet<String>();
                                for (XCourseRequest.XPreference p : pref) {
                                    switch (p.getType()) {
                                        case INSTR_METHOD: {
                                            hasIm = true;
                                            if (g.getInstructionalMethod() == null || !g.getInstructionalMethod().getUniqueId().equals(p.getUniqueId())) break;
                                            im = true;
                                            break;
                                        }
                                        case SECTION: {
                                            XSection ps = o.getSection(p.getUniqueId());
                                            if (ps == null) break;
                                            allSubparts.add(ps.getSubpartName());
                                            for (XSection section : o.getSections(m.enrollment())) {
                                                if (!section.getSectionId().equals(p.getUniqueId())) continue;
                                                selectedSubparts.add(section.getSubpartName());
                                            }
                                            break;
                                        }
                                    }
                                }
                                if (hasIm) {
                                    s.setTotalPrefInstrMethConflict(s.getTotalPrefInstrMethConflict() + 1);
                                    ++gtPIM;
                                    if (im) {
                                        s.setPrefInstrMethConflict(s.getPrefInstrMethConflict() + 1);
                                        ++gPIM;
                                    }
                                }
                                if (!allSubparts.isEmpty()) {
                                    s.setTotalPrefSectionConflict(s.getTotalPrefSectionConflict() + allSubparts.size());
                                    gtPSec += allSubparts.size();
                                    s.setPrefSectionConflict(s.getPrefSectionConflict() + selectedSubparts.size());
                                    gPSec += selectedSubparts.size();
                                }
                            }
                        }
                        if (o != null) {
                            for (XSection section : o.getSections(m.enrollment())) {
                                if (section.getTime() == null) continue;
                                for (XRequest q : ((XStudent)((Object)student)).getRequests()) {
                                    if (q instanceof XCourseRequest) {
                                        XEnrollment otherEnrollment = ((XCourseRequest)q).getEnrollment();
                                        if (otherEnrollment == null) continue;
                                        XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                                        XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                                        for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                            if (otherSection.equals(section) || otherSection.getTime() == null) continue;
                                            if (otherSection.isDistanceConflict((XStudent)((Object)student), section, dm)) {
                                                s.setNrDistanceConflicts(s.getNrDistanceConflicts() + 1);
                                                ++gNrDC;
                                                int d = otherSection.getDistanceInMinutes(section, dm);
                                                if (d > s.getLongestDistanceMinutes()) {
                                                    s.setLongestDistanceMinutes(d);
                                                }
                                                if (d > gDist) {
                                                    gDist = d;
                                                }
                                            }
                                            if (!section.getTime().hasIntersection(otherSection.getTime()) || section.isToIgnoreStudentConflictsWith(o.getDistributions(), otherSection.getSectionId()) || section.getSectionId() >= otherSection.getSectionId() && this.query().match(new StatusPageSuggestionsAction.CourseRequestMatcher(session, otherCourse, (XStudent)((Object)student), otherOffering, (XCourseRequest)q, this.isConsentToDoCourse(otherCourse), this.isMyStudent((XStudentId)((Object)student)), lookup, server, wl))) continue;
                                            s.setOverlappingMinutes(s.getOverlappingMinutes() + section.getTime().share(otherSection.getTime()));
                                            gShr += section.getTime().share(otherSection.getTime());
                                        }
                                        continue;
                                    }
                                    if (!(q instanceof XFreeTimeRequest)) continue;
                                    XFreeTimeRequest ft = (XFreeTimeRequest)q;
                                    if (!section.getTime().hasIntersection(ft.getTime())) continue;
                                    s.setFreeTimeOverlappingMins(s.getFreeTimeOverlappingMins() + section.getTime().share(ft.getTime()));
                                    gFre += section.getTime().share(ft.getTime());
                                }
                            }
                        }
                    }
                } else if (unassigned.add(m.request().getRequestId())) {
                    if (m.student().canAssign(m.request(), s.getStudent().getWaitListMode())) {
                        if (m.request().isWaitlist(s.getStudent().getWaitListMode())) {
                            s.setWaitlist(s.getWaitlist() + 1);
                            ++gWait;
                            if (s.getTopWaitingPriority() == null) {
                                s.setTopWaitingPriority(1 + m.request().getPriority());
                            } else {
                                s.setTopWaitingPriority(Math.min(1 + m.request().getPriority(), s.getTopWaitingPriority()));
                            }
                        }
                        if (m.request().isNoSub(s.getStudent().getWaitListMode())) {
                            s.setNoSub(s.getNoSub() + 1);
                            ++gNoSub;
                        }
                        s.setUnassigned(s.getUnassigned() + 1);
                        ++gUnasg;
                    }
                    for (XCourseId c : m.request().getCourseIds()) {
                        List<XCourseRequest.XPreference> pref = m.request().getPreferences(c);
                        if (pref == null) continue;
                        XOffering o = server.getOffering(c.getOfferingId());
                        boolean reqIm = false;
                        HashSet<String> allSubparts = new HashSet<String>();
                        for (XCourseRequest.XPreference p : pref) {
                            if (!p.isRequired()) continue;
                            switch (p.getType()) {
                                case INSTR_METHOD: {
                                    reqIm = true;
                                    break;
                                }
                                case SECTION: {
                                    XSection ps;
                                    XSection xSection = ps = o == null ? null : o.getSection(p.getUniqueId());
                                    if (ps == null) break;
                                    allSubparts.add(ps.getSubpartName());
                                }
                            }
                        }
                        if (reqIm) {
                            s.setTotalPrefInstrMethConflict(s.getTotalPrefInstrMethConflict() + 1);
                            ++gtPIM;
                        }
                        if (allSubparts.isEmpty()) continue;
                        s.setTotalPrefSectionConflict(s.getTotalPrefSectionConflict() + allSubparts.size());
                        gtPSec += allSubparts.size();
                    }
                }
                if (m.request().getTimeStamp() != null) {
                    if (s.getRequestedDate() == null) {
                        s.setRequestedDate(m.request().getTimeStamp());
                    } else if (m.request().getTimeStamp().after(s.getRequestedDate())) {
                        s.setRequestedDate(m.request().getTimeStamp());
                    }
                }
                if (m.request().getWaitListedTimeStamp() == null) continue;
                if (s.getWaitListedDate() == null) {
                    s.setWaitListedDate(m.request().getWaitListedTimeStamp());
                    continue;
                }
                if (!m.request().getWaitListedTimeStamp().after(s.getWaitListedDate())) continue;
                s.setWaitListedDate(m.request().getWaitListedTimeStamp());
            }
        }
        ArrayList<Object> ret = new ArrayList(students.values());
        if (this.iSubjectAreas == null && this.iCoursesIcoordinate == null) {
            if (studentIds != null && (studentIds.size() < 1000 || server instanceof DatabaseServer)) {
                FindStudentInfoMatcher findStudentInfoMatcher = new FindStudentInfoMatcher(session, this.query(), this.iMyStudents);
                findStudentInfoMatcher.setServer(server);
                for (Long l : studentIds) {
                    String status;
                    XStudent student;
                    if (students.containsKey(l) || (student = server.getStudent(l)) == null || !findStudentInfoMatcher.match(student)) continue;
                    ClassAssignmentInterface.StudentInfo s = new ClassAssignmentInterface.StudentInfo();
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    s.setStudent(st);
                    st.setId(student.getStudentId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(student.getExternalId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    String string = status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
                    if (defaultWL != null) {
                        st.setWaitListMode(defaultWL);
                    } else if (status == null || wlStates.contains(status)) {
                        st.setWaitListMode(OnlineSectioningInterface.WaitListMode.WaitList);
                    } else if (noSubStates.contains(status)) {
                        st.setWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs);
                    } else {
                        st.setWaitListMode(OnlineSectioningInterface.WaitListMode.None);
                    }
                    st.setCanRegister(this.iCanRegister && (status == null || regStates.contains(status)));
                    st.setCanUseAssistant(this.iCanUseAssistant && (status == null || assStates.contains(status)));
                    st.setCanSelect(this.isCanSelect(student));
                    st.setName(student.getName());
                    for (XAreaClassificationMajor acm : student.getMajors()) {
                        st.addArea(acm.getArea(), acm.getAreaLabel());
                        st.addClassification(acm.getClassification(), acm.getClassificationLabel());
                        st.addMajor(acm.getMajor(), acm.getMajorLabel());
                        st.addConcentration(acm.getConcentration(), acm.getConcentrationLabel());
                        st.addDegree(acm.getDegree(), acm.getDegreeLabel());
                        st.addProgram(acm.getProgram(), acm.getProgramLabel());
                        st.addCampus(acm.getCampus(), acm.getCampusLabel());
                    }
                    st.setDefaultCampus(server.getAcademicSession().getCampus());
                    for (XAreaClassificationMajor acm : student.getMinors()) {
                        st.addMinor(acm.getMajor(), acm.getMajorLabel());
                    }
                    for (XStudent.XGroup gr : student.getGroups()) {
                        st.addGroup(gr.getType(), gr.getAbbreviation(), gr.getTitle());
                    }
                    for (XStudent.XGroup acc : student.getAccomodations()) {
                        st.addAccommodation(acc.getAbbreviation(), acc.getTitle());
                    }
                    for (XStudent.XAdvisor a : student.getAdvisors()) {
                        if (a.getName() == null) continue;
                        st.addAdvisor(a.getName());
                    }
                    s.setStatus(student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus());
                    s.setEmailDate(student.getEmailTimeStamp() == null ? null : student.getEmailTimeStamp());
                    s.setNote(student.hasLastNote() ? student.getLastNote().getNote() : null);
                    s.setMyStudent(this.isMyStudent(student));
                    s.setAdvisedInfo(FindStudentInfoAction.getAdvisedInfo(student, server, helper));
                    s.setPreference(FindStudentInfoAction.getStudentSchedulingPreference(student, server, helper));
                    ret.add(s);
                }
            } else {
                for (XStudentId xStudentId : server.findStudents(new FindStudentInfoMatcher(session, this.query(), this.iMyStudents))) {
                    String status;
                    XStudent xStudent;
                    XStudent xStudent2 = xStudent = xStudentId instanceof XStudent ? (XStudent)xStudentId : server.getStudent(xStudentId.getStudentId());
                    if (students.containsKey(xStudentId.getStudentId())) continue;
                    ClassAssignmentInterface.StudentInfo s = new ClassAssignmentInterface.StudentInfo();
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    s.setStudent(st);
                    st.setId(xStudent.getStudentId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(xStudent.getExternalId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    String string = status = xStudent.getStatus() == null ? session.getDefaultSectioningStatus() : xStudent.getStatus();
                    if (defaultWL != null) {
                        st.setWaitListMode(defaultWL);
                    } else if (status == null || wlStates.contains(status)) {
                        st.setWaitListMode(OnlineSectioningInterface.WaitListMode.WaitList);
                    } else if (noSubStates.contains(status)) {
                        st.setWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs);
                    } else {
                        st.setWaitListMode(OnlineSectioningInterface.WaitListMode.None);
                    }
                    st.setCanRegister(this.iCanRegister && (status == null || regStates.contains(status)));
                    st.setCanUseAssistant(this.iCanUseAssistant && (status == null || assStates.contains(status)));
                    st.setCanSelect(this.isCanSelect(xStudent));
                    st.setName(xStudent.getName());
                    for (XAreaClassificationMajor acm : xStudent.getMajors()) {
                        st.addArea(acm.getArea(), acm.getAreaLabel());
                        st.addClassification(acm.getClassification(), acm.getClassificationLabel());
                        st.addMajor(acm.getMajor(), acm.getMajorLabel());
                        st.addConcentration(acm.getConcentration(), acm.getConcentrationLabel());
                        st.addDegree(acm.getDegree(), acm.getDegreeLabel());
                        st.addProgram(acm.getProgram(), acm.getProgramLabel());
                        st.addCampus(acm.getCampus(), acm.getCampusLabel());
                    }
                    st.setDefaultCampus(server.getAcademicSession().getCampus());
                    for (XAreaClassificationMajor acm : xStudent.getMinors()) {
                        st.addMinor(acm.getMajor(), acm.getMajorLabel());
                    }
                    for (XStudent.XGroup gr : xStudent.getGroups()) {
                        st.addGroup(gr.getType(), gr.getAbbreviation(), gr.getTitle());
                    }
                    for (XStudent.XGroup acc : xStudent.getAccomodations()) {
                        st.addAccommodation(acc.getAbbreviation(), acc.getTitle());
                    }
                    for (XStudent.XAdvisor a : xStudent.getAdvisors()) {
                        if (a.getName() == null) continue;
                        st.addAdvisor(a.getName());
                    }
                    s.setStatus(xStudent.getStatus() == null ? session.getDefaultSectioningStatus() : xStudent.getStatus());
                    s.setEmailDate(xStudent.getEmailTimeStamp() == null ? null : xStudent.getEmailTimeStamp());
                    s.setNote(xStudent.hasLastNote() ? xStudent.getLastNote().getNote() : null);
                    s.setMyStudent(this.isMyStudent(xStudent));
                    s.setAdvisedInfo(FindStudentInfoAction.getAdvisedInfo(xStudent, server, helper));
                    s.setPreference(FindStudentInfoAction.getStudentSchedulingPreference(xStudent, server, helper));
                    ret.add(s);
                }
            }
        }
        Collections.sort(ret, new Comparator<ClassAssignmentInterface.StudentInfo>(){

            @Override
            public int compare(ClassAssignmentInterface.StudentInfo s1, ClassAssignmentInterface.StudentInfo s2) {
                int cmp = s1.getStudent().getName().compareTo(s2.getStudent().getName());
                if (cmp != 0) {
                    return cmp;
                }
                return Long.valueOf(s1.getStudent().getId()).compareTo(s2.getStudent().getId());
            }
        });
        if (this.limit() != null && ret.size() >= this.limit()) {
            ArrayList<ClassAssignmentInterface.StudentInfo> arrayList = new ArrayList<ClassAssignmentInterface.StudentInfo>(this.limit());
            for (ClassAssignmentInterface.StudentInfo studentInfo : ret) {
                arrayList.add(studentInfo);
                if (arrayList.size() != this.limit().intValue()) continue;
                break;
            }
            ret = arrayList;
        }
        ClassAssignmentInterface.StudentInfo studentInfo = new ClassAssignmentInterface.StudentInfo();
        studentInfo.setEnrollment(gEnrl);
        studentInfo.setReservation(gRes);
        studentInfo.setWaitlist(gWait);
        studentInfo.setNoSub(gNoSub);
        studentInfo.setSwap(gSwap);
        studentInfo.setUnassigned(gUnasg);
        studentInfo.setTotalEnrollment(gtEnrl);
        studentInfo.setTotalReservation(gtRes);
        studentInfo.setTotalWaitlist(gtWait);
        studentInfo.setTotalNoSub(gtNoSub);
        studentInfo.setTotalSwap(gtSwap);
        studentInfo.setTotalUnassigned(gtUnasg);
        studentInfo.setConsentNeeded(gConNeed);
        studentInfo.setTotalConsentNeeded(gtConNeed);
        studentInfo.setOverrideNeeded(gOvrNeed);
        studentInfo.setTotalOverrideNeeded(gtOvrNeed);
        studentInfo.setNrDistanceConflicts(gNrDC);
        studentInfo.setTotalNrDistanceConflicts(gtNrDC);
        studentInfo.setLongestDistanceMinutes(gDist);
        studentInfo.setTotalLongestDistanceMinutes(gtDist);
        studentInfo.setOverlappingMinutes(gShr);
        studentInfo.setTotalOverlappingMinutes(gtShr);
        studentInfo.setFreeTimeOverlappingMins(gFre);
        studentInfo.setTotalFreeTimeOverlappingMins(gtFre);
        studentInfo.setPrefInstrMethConflict(gPIM);
        studentInfo.setTotalPrefInstrMethConflict(gtPIM);
        studentInfo.setPrefSectionConflict(gPSec);
        studentInfo.setTotalPrefSectionConflict(gtPSec);
        ret.add(studentInfo);
        return ret;
    }

    protected Collection<? extends XCourseId> findCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, StatusPageSuggestionsAction.CourseLookup lookup) {
        if (this.iFilter != null && server instanceof DatabaseServer) {
            ArrayList<XCourse> courses = new ArrayList<XCourse>();
            FindEnrollmentInfoAction.FindEnrollmentInfoCourseMatcher m = new FindEnrollmentInfoAction.FindEnrollmentInfoCourseMatcher(this.iCoursesIcoordinate, this.iCoursesIcanApprove, this.iSubjectAreas, this.iQuery, lookup, server);
            for (XCourse course : server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getCourses(server, helper)) {
                if (!m.match(course)) continue;
                courses.add(course);
            }
            return courses;
        }
        return server.findCourses(new FindEnrollmentInfoAction.FindEnrollmentInfoCourseMatcher(this.iCoursesIcoordinate, this.iCoursesIcanApprove, this.iSubjectAreas, this.iQuery, lookup, server));
    }

    @Override
    public String name() {
        return "find-student-infos";
    }

    public static String getStudentSchedulingPreference(XStudent student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        String pref = null;
        if (student.getModalityPreference() != null && student.getModalityPreference() != Student.ModalityPreference.NO_PREFERENCE) {
            switch (student.getModalityPreference()) {
                case ONILNE_DISCOURAGED: {
                    pref = (pref == null ? "" : pref + "\n") + MSG.itemSchedulingModalityPreferFaceToFace();
                    break;
                }
                case ONLINE_PREFERRED: {
                    pref = (pref == null ? "" : pref + "\n") + MSG.itemSchedulingModalityPreferOnline();
                    break;
                }
                case ONLINE_REQUIRED: {
                    pref = (pref == null ? "" : pref + "\n") + MSG.itemSchedulingModalityRequireOnline();
                }
            }
        }
        if (student.getBackToBackPreference() != null && student.getBackToBackPreference() != Student.BackToBackPreference.NO_PREFERENCE) {
            switch (student.getBackToBackPreference()) {
                case BTB_DISCOURAGED: {
                    pref = (pref == null ? "" : pref + "\n") + MSG.itemSchedulingBackToBackDiscourage();
                    break;
                }
                case BTB_PREFERRED: {
                    pref = (pref == null ? "" : pref + "\n") + MSG.itemSchedulingBackToBackPrefer();
                }
            }
        }
        if (student.getClassStartDate() != null || student.getClassEndDate() != null) {
            pref = student.getClassStartDate() == null ? (pref == null ? "" : pref + "\n") + MSG.schedulingPrefClassesTo(Formats.getDateFormat(CONST.patternDateFormat()).format(new LocalDate((Object)server.getAcademicSession().getDatePatternFirstDate()).plusDays(student.getClassEndDate().intValue()).toDate())) : (student.getClassEndDate() == null ? (pref == null ? "" : pref + "\n") + MSG.schedulingPrefClassesFrom(Formats.getDateFormat(CONST.patternDateFormat()).format(new LocalDate((Object)server.getAcademicSession().getDatePatternFirstDate()).plusDays(student.getClassStartDate().intValue()).toDate())) : (pref == null ? "" : pref + "\n") + MSG.schedulingPrefClassesBetween(Formats.getDateFormat(CONST.patternDateFormat()).format(new LocalDate((Object)server.getAcademicSession().getDatePatternFirstDate()).plusDays(student.getClassStartDate().intValue()).toDate()), Formats.getDateFormat(CONST.patternDateFormat()).format(new LocalDate((Object)server.getAcademicSession().getDatePatternFirstDate()).plusDays(student.getClassEndDate().intValue()).toDate())));
        }
        return pref;
    }

    public static ClassAssignmentInterface.AdvisedInfoInterface getAdvisedInfo(XStudent student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!student.hasAdvisorRequests()) {
            return null;
        }
        ClassAssignmentInterface.AdvisedInfoInterface info = new ClassAssignmentInterface.AdvisedInfoInterface();
        XAdvisorRequest last = null;
        XCourseId advFirstChoice = null;
        XCourseId firstEnrolled = null;
        XCourseRequest firstChoice = null;
        CourseDemand.Critical advCritical = CourseDemand.Critical.fromText(ApplicationProperty.AdvisorCourseRequestsAllowCritical.valueOfSession(server.getAcademicSession().getUniqueId()));
        boolean firstChoiceCritical = false;
        float minCred = 0.0f;
        float maxCred = 0.0f;
        float cm = 0.0f;
        float cx = 0.0f;
        int nrCourses = 0;
        int nrCriticalCourses = 0;
        int nrCoursesFound = 0;
        int nrCriticalCoursesFound = 0;
        int nrSubstMisMatch = 0;
        int nrCoursesAssigned = 0;
        int foundPrioMin = 0;
        int foundPrioMax = 0;
        int points = 0;
        int maxPoints = 0;
        int missingCrit = 0;
        int missingPrim = 0;
        int notAssignedCrit = 0;
        int notAssignedPrim = 0;
        for (XAdvisorRequest acr : student.getAdvisorRequests()) {
            if (acr.getPriority() == -1) continue;
            if (last != null && last.getPriority() != acr.getPriority()) {
                minCred += cm;
                maxCred += cx;
                cm = 0.0f;
                cx = 0.0f;
                if (advFirstChoice != null) {
                    if (firstChoiceCritical && nrCoursesFound == 0) {
                        ++missingCrit;
                        ++missingPrim;
                        if (nrCourses > 1) {
                            info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourseWithAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourseWithAlts(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourseWithAlts(advFirstChoice.getCourseName())));
                        } else {
                            info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourse(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourse(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourse(advFirstChoice.getCourseName())));
                        }
                    } else if (!last.isSubstitute() && nrCoursesFound - nrSubstMisMatch == 0) {
                        ++missingPrim;
                        if (nrCourses > 1) {
                            info.addMessage(MSG.advMessageMissingCourseWithAlts(advFirstChoice.getCourseName()));
                        } else {
                            info.addMessage(MSG.advMessageMissingCourse(advFirstChoice.getCourseName()));
                        }
                    } else if (last.isSubstitute() && nrCoursesFound == 0) {
                        if (nrCourses > 1) {
                            info.addMessage(MSG.advMessageMissingSubstituteCourseWithAlts(advFirstChoice.getCourseName()));
                        } else {
                            info.addMessage(MSG.advMessageMissingSubstituteCourse(advFirstChoice.getCourseName()));
                        }
                    } else if (firstChoice == null && firstChoiceCritical) {
                        info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourseHasAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourseHasAlts(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourseHasAlts(advFirstChoice.getCourseName())));
                    } else if (firstChoice == null) {
                        info.addMessage(MSG.advMessageMissingCourseHasAlts(advFirstChoice.getCourseName()));
                    } else if (nrCoursesFound < nrCourses) {
                        info.addMessage(MSG.advMessageMissingAlternatives(advFirstChoice.getCourseName()));
                    }
                    if (nrCoursesFound > 0 && nrCoursesAssigned == 0 && !last.isSubstitute()) {
                        ++notAssignedPrim;
                        if (firstChoiceCritical) {
                            ++notAssignedCrit;
                            if (nrCourses > 1) {
                                info.addNotAssignedMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageNotEnrolledImportantCourseWithAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageNotEnrolledVitalCourseWithAlts(advFirstChoice.getCourseName()) : MSG.advMessageNotEnrolledCriticalCourseWithAlts(advFirstChoice.getCourseName())));
                            } else {
                                info.addNotAssignedMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageNotEnrolledImportantCourse(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageNotEnrolledVitalCourse(advFirstChoice.getCourseName()) : MSG.advMessageNotEnrolledCriticalCourse(advFirstChoice.getCourseName())));
                            }
                        } else if (nrCourses > 1) {
                            info.addNotAssignedMessage(MSG.advMessageNotEnrolledCourseWithAlts(advFirstChoice.getCourseName()));
                        } else {
                            info.addNotAssignedMessage(MSG.advMessageNotEnrolledCourse(advFirstChoice.getCourseName()));
                        }
                    } else if (last.isSubstitute() && nrCoursesAssigned > 0) {
                        --notAssignedPrim;
                        info.addNotAssignedMessage(MSG.advMessageHasEnrolledSubstituteCourse(firstEnrolled.getCourseName()));
                    }
                    maxPoints += 4 + (firstChoiceCritical ? 2 : 0);
                    if (firstChoice != null) {
                        points += 2;
                        if (firstChoiceCritical && firstChoice.isCritical()) {
                            points += 2;
                        }
                        if (firstChoice.isAlternative() == last.isSubstitute()) {
                            ++points;
                        }
                        if (firstChoice.getCourseIds().get(0).equals(advFirstChoice)) {
                            ++points;
                        }
                    }
                    maxPoints += 2;
                    if (nrCourses == nrCoursesFound) {
                        points += 2;
                    }
                    if (nrCourses > 1) {
                        ++maxPoints;
                    }
                    if (nrCourses > 1 && nrCoursesFound >= 1) {
                        ++points;
                    }
                    if (nrCourses > 0 && !last.isSubstitute()) {
                        maxPoints += 2;
                    }
                    if (nrCourses > 0 && !last.isSubstitute() && nrCoursesFound >= 1 && nrCoursesFound - nrSubstMisMatch > 0) {
                        points += 2;
                    }
                    if (nrCourses > 1) {
                        ++maxPoints;
                    }
                    if (nrCourses > 1 && nrCoursesFound > 1) {
                        ++points;
                    }
                    if (nrCourses > 2) {
                        ++maxPoints;
                    }
                    if (nrCourses > 2 && nrCoursesFound > 2) {
                        ++points;
                    }
                    if (nrCoursesFound > 1) {
                        ++maxPoints;
                    }
                    if (nrCoursesFound > 1 && foundPrioMin == foundPrioMax) {
                        ++points;
                    }
                    ++maxPoints;
                    if (nrSubstMisMatch == 0 && nrCoursesFound > 0) {
                        ++points;
                    }
                    if (nrCriticalCourses > 1) {
                        maxPoints += 3;
                    }
                    if (nrCriticalCourses > 1 && nrCriticalCoursesFound > 1) {
                        points += 3;
                    }
                }
                nrCourses = 0;
                nrCriticalCourses = 0;
                nrCoursesFound = 0;
                nrCriticalCoursesFound = 0;
                nrSubstMisMatch = 0;
                advFirstChoice = null;
                firstChoice = null;
                firstChoiceCritical = false;
                foundPrioMin = 0;
                foundPrioMax = 0;
                firstEnrolled = null;
                nrCoursesAssigned = 0;
            }
            if (!acr.isSubstitute()) {
                XCourse course;
                XCourse xCourse = course = acr.getCourseId() == null ? null : server.getCourse(acr.getCourseId().getCourseId());
                if (course != null && course.hasCredit()) {
                    if (acr.getAlternative() == 0 || course.getMinCredit().floatValue() < cm) {
                        cm = course.getMinCredit().floatValue();
                    }
                    if (acr.getAlternative() == 0 || course.getMaxCredit().floatValue() > cx) {
                        cx = course.getMaxCredit().floatValue();
                    }
                } else if (acr.getAlternative() == 0) {
                    cm = acr.getCreditMin();
                    cx = acr.getCreditMax();
                }
            }
            if (acr.getCourseId() != null) {
                ++nrCourses;
                if (acr.isCritical() && !acr.isSubstitute()) {
                    ++nrCriticalCourses;
                }
                XCourseRequest request = null;
                for (XRequest r : student.getRequests()) {
                    XCourseRequest cr;
                    if (!(r instanceof XCourseRequest) || !(cr = (XCourseRequest)r).hasCourse(acr.getCourseId().getCourseId())) continue;
                    request = cr;
                    break;
                }
                if (advFirstChoice == null) {
                    advFirstChoice = acr.getCourseId();
                    firstChoiceCritical = acr.isCritical();
                    firstChoice = request;
                }
                if (request != null) {
                    if (request.getEnrollment() != null && request.getEnrollment().getCourseId().equals(acr.getCourseId().getCourseId())) {
                        ++nrCoursesAssigned;
                        if (firstEnrolled == null) {
                            firstEnrolled = acr.getCourseId();
                        }
                    }
                    if (++nrCoursesFound == 1) {
                        foundPrioMin = request.getPriority();
                        foundPrioMax = request.getPriority();
                    } else {
                        if (request.getPriority() < foundPrioMin) {
                            foundPrioMin = request.getPriority();
                        }
                        if (request.getPriority() > foundPrioMax) {
                            foundPrioMax = request.getPriority();
                        }
                    }
                    if (acr.isSubstitute() != request.isAlternative()) {
                        ++nrSubstMisMatch;
                    }
                    if (acr.isCritical() && request.isCritical() && !request.isAlternative()) {
                        ++nrCriticalCoursesFound;
                    }
                }
            }
            last = acr;
        }
        info.setMinCredit(Float.valueOf(minCred += cm));
        info.setMaxCredit(Float.valueOf(maxCred += cx));
        if (advFirstChoice != null) {
            if (firstChoiceCritical && nrCoursesFound == 0) {
                ++missingCrit;
                ++missingPrim;
                if (nrCourses > 1) {
                    info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourseWithAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourseWithAlts(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourseWithAlts(advFirstChoice.getCourseName())));
                } else {
                    info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourse(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourse(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourse(advFirstChoice.getCourseName())));
                }
            } else if (!last.isSubstitute() && nrCoursesFound - nrSubstMisMatch == 0) {
                ++missingPrim;
                if (nrCourses > 1) {
                    info.addMessage(MSG.advMessageMissingCourseWithAlts(advFirstChoice.getCourseName()));
                } else {
                    info.addMessage(MSG.advMessageMissingCourse(advFirstChoice.getCourseName()));
                }
            } else if (last.isSubstitute() && nrCoursesFound == 0) {
                if (nrCourses > 1) {
                    info.addMessage(MSG.advMessageMissingSubstituteCourseWithAlts(advFirstChoice.getCourseName()));
                } else {
                    info.addMessage(MSG.advMessageMissingSubstituteCourse(advFirstChoice.getCourseName()));
                }
            } else if (firstChoice == null && firstChoiceCritical) {
                info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourseHasAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourseHasAlts(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourseHasAlts(advFirstChoice.getCourseName())));
            } else if (firstChoice == null) {
                info.addMessage(MSG.advMessageMissingCourseHasAlts(advFirstChoice.getCourseName()));
            } else if (nrCoursesFound < nrCourses) {
                info.addMessage(MSG.advMessageMissingAlternatives(advFirstChoice.getCourseName()));
            }
            if (nrCoursesFound > 0 && nrCoursesAssigned == 0 && !last.isSubstitute()) {
                ++notAssignedPrim;
                if (firstChoiceCritical) {
                    ++notAssignedCrit;
                    if (nrCourses > 1) {
                        info.addNotAssignedMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageNotEnrolledImportantCourseWithAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageNotEnrolledVitalCourseWithAlts(advFirstChoice.getCourseName()) : MSG.advMessageNotEnrolledCriticalCourseWithAlts(advFirstChoice.getCourseName())));
                    } else {
                        info.addNotAssignedMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageNotEnrolledImportantCourse(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageNotEnrolledVitalCourse(advFirstChoice.getCourseName()) : MSG.advMessageNotEnrolledCriticalCourse(advFirstChoice.getCourseName())));
                    }
                } else if (nrCourses > 1) {
                    info.addNotAssignedMessage(MSG.advMessageNotEnrolledCourseWithAlts(advFirstChoice.getCourseName()));
                } else {
                    info.addNotAssignedMessage(MSG.advMessageNotEnrolledCourse(advFirstChoice.getCourseName()));
                }
            } else if (last.isSubstitute() && nrCoursesAssigned > 0) {
                --notAssignedPrim;
                info.addNotAssignedMessage(MSG.advMessageHasEnrolledSubstituteCourse(firstEnrolled.getCourseName()));
            }
            maxPoints += 4 + (firstChoiceCritical ? 2 : 0);
            if (firstChoice != null) {
                points += 2;
                if (firstChoiceCritical && firstChoice.isCritical()) {
                    points += 2;
                }
                if (firstChoice.isAlternative() == last.isSubstitute()) {
                    ++points;
                }
                if (firstChoice.getCourseIds().get(0).equals(advFirstChoice)) {
                    ++points;
                }
            }
            maxPoints += 2;
            if (nrCourses == nrCoursesFound) {
                points += 2;
            }
            if (nrCourses > 1) {
                ++maxPoints;
            }
            if (nrCourses > 1 && nrCoursesFound >= 1) {
                ++points;
            }
            if (nrCourses > 0 && !last.isSubstitute()) {
                maxPoints += 2;
            }
            if (nrCourses > 0 && !last.isSubstitute() && nrCoursesFound >= 1 && nrCoursesFound - nrSubstMisMatch > 0) {
                points += 2;
            }
            if (nrCourses > 1) {
                ++maxPoints;
            }
            if (nrCourses > 1 && nrCoursesFound > 1) {
                ++points;
            }
            if (nrCourses > 2) {
                ++maxPoints;
            }
            if (nrCourses > 2 && nrCoursesFound > 2) {
                ++points;
            }
            if (nrCoursesFound > 1) {
                ++maxPoints;
            }
            if (nrCoursesFound > 1 && foundPrioMin == foundPrioMax) {
                ++points;
            }
            ++maxPoints;
            if (nrSubstMisMatch == 0 && nrCoursesFound > 0) {
                ++points;
            }
            if (nrCriticalCourses > 1) {
                maxPoints += 3;
            }
            if (nrCriticalCourses > 1 && nrCriticalCoursesFound > 1) {
                points += 3;
            }
        }
        if (maxPoints == 0) {
            info.setPercentage(Float.valueOf(0.0f));
        } else {
            info.setPercentage(Float.valueOf((float)points / (float)maxPoints));
        }
        info.setMissingCritical(missingCrit);
        info.setMissingPrimary(missingPrim);
        info.setNotAssignedCritical(notAssignedCrit);
        info.setNotAssignedPrimary(notAssignedPrim);
        info.setAdvisorCritical(advCritical.ordinal());
        return info;
    }

    public static class FindStudentInfoMatcher
    extends AbstractStudentMatcher {
        private static final long serialVersionUID = 1L;
        protected Query iQuery;
        protected String iDefaultSectioningStatus;
        protected Set<Long> iMyStudents;

        public FindStudentInfoMatcher(AcademicSessionInfo session, Query query, Set<Long> myStudents) {
            this.iQuery = query;
            this.iDefaultSectioningStatus = session.getDefaultSectioningStatus();
            this.iMyStudents = myStudents;
        }

        public boolean isMyStudent(XStudentId student) {
            return this.iMyStudents != null && this.iMyStudents.contains(student.getStudentId());
        }

        @Override
        public boolean match(XStudentId id) {
            XStudent student = id instanceof XStudent ? (XStudent)id : this.getServer().getStudent(id.getStudentId());
            return student != null && this.iQuery.match(new StatusPageSuggestionsAction.StudentMatcher(student, this.iDefaultSectioningStatus, this.getServer(), this.isMyStudent(student)));
        }
    }
}

