/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.selection.ResectioningWeights;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XIndividualReservation;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XTime;

public class SectioningRequest
implements ResectioningWeights.LastSectionProvider {
    private XCourseRequest iOldRequest;
    private XCourseRequest iRequest;
    private XStudent iOldStudent;
    private XStudent iStudent;
    private XEnrollment iLastEnrollment;
    private XEnrollment iNewEnrollment;
    private XOffering iOldOffering;
    private XOffering iOffering;
    private boolean iHasIndividualReservation;
    private OnlineSectioningLog.Action.Builder iAction;
    private List<Section> iLastSections = new ArrayList<Section>();
    private Request.RequestPriority iRequestPriority = Request.RequestPriority.Normal;
    private Student.StudentPriority iStudentPriority = Student.StudentPriority.Normal;
    private int iAlternativity = 0;
    private XCourseId iCourseId = null;
    private XCourseId iDropCourseId = null;
    private ReschedulingReason iRescheduling;

    public SectioningRequest(XOffering offering, XCourseRequest request, XCourseId courseId, XStudent student, ReschedulingReason rescheduling, Student.StudentPriority priority, OnlineSectioningLog.Action.Builder action) {
        this.iRequest = request;
        this.iStudent = student;
        this.iOffering = offering;
        this.iCourseId = courseId;
        this.iRescheduling = rescheduling;
        if (courseId != null) {
            this.iAlternativity = request.getCourseIds().indexOf(courseId);
        } else {
            for (int i = 0; i < request.getCourseIds().size(); ++i) {
                if (!request.getCourseIds().get(i).getOfferingId().equals(offering.getOfferingId())) continue;
                this.iAlternativity = i;
                break;
            }
        }
        this.iDropCourseId = request.getWaitListSwapWithCourseOffering();
        this.iStudentPriority = priority;
        if (action != null) {
            action.addOptionBuilder().setKey("Student Priority").setValue(this.iStudentPriority.name());
        }
        if (request.isCritical()) {
            if (request.getCritical() == CourseDemand.Critical.CRITICAL.ordinal()) {
                this.iRequestPriority = Request.RequestPriority.Critical;
            } else if (request.getCritical() == CourseDemand.Critical.IMPORTANT.ordinal()) {
                this.iRequestPriority = Request.RequestPriority.Important;
            } else if (request.getCritical() == CourseDemand.Critical.VITAL.ordinal()) {
                this.iRequestPriority = Request.RequestPriority.Vital;
            } else if (request.getCritical() == CourseDemand.Critical.LC.ordinal()) {
                this.iRequestPriority = Request.RequestPriority.LC;
            }
        }
        if (action != null) {
            action.addOptionBuilder().setKey("Request Priority").setValue(this.iRequestPriority.name());
        }
        this.iHasIndividualReservation = false;
        for (XReservation reservation : this.iOffering.getReservations()) {
            if (!reservation.mustBeUsed() || reservation.isExpired() || !(reservation instanceof XIndividualReservation) || !((XIndividualReservation)reservation).getStudentIds().contains(request.getStudentId())) continue;
            this.iHasIndividualReservation = true;
            break;
        }
        this.iAction = action;
    }

    public XCourseId getCourseId() {
        if (this.iCourseId != null) {
            return this.iCourseId;
        }
        return this.getRequest().getCourseIdByOfferingId(this.getOffering().getOfferingId());
    }

    public boolean isRescheduling() {
        return this.iRescheduling != null;
    }

    public ReschedulingReason getReschedulingReason() {
        return this.iRescheduling;
    }

    public XOffering getOffering() {
        return this.iOffering == null ? this.iOldOffering : this.iOffering;
    }

    public SectioningRequest setOldOffering(XOffering offering) {
        this.iOldOffering = offering;
        return this;
    }

    public XOffering getOldOffering() {
        return this.iOldOffering != null ? this.iOldOffering : this.iOffering;
    }

    public XStudent getStudent() {
        return this.iStudent == null ? this.iOldStudent : this.iStudent;
    }

    public SectioningRequest setOldStudent(XStudent student) {
        this.iOldStudent = student;
        return this;
    }

    public XStudent getOldStudent() {
        return this.iOldStudent == null ? this.iStudent : this.iOldStudent;
    }

    public SectioningRequest setLastEnrollment(XEnrollment enrollment) {
        this.iLastEnrollment = enrollment;
        return this;
    }

    public XEnrollment getLastEnrollment() {
        return this.iLastEnrollment == null ? this.iNewEnrollment : this.iLastEnrollment;
    }

    public SectioningRequest setNewEnrollment(XEnrollment enrollment) {
        this.iNewEnrollment = enrollment;
        return this;
    }

    public XEnrollment getNewEnrollment() {
        return this.iNewEnrollment == null ? this.iLastEnrollment : this.iNewEnrollment;
    }

    public XCourseRequest getRequest() {
        return this.iRequest == null ? this.iOldRequest : this.iRequest;
    }

    public SectioningRequest setOldRequest(XCourseRequest request) {
        this.iOldRequest = request;
        return this;
    }

    public XCourseRequest getOldRequest() {
        return this.iOldRequest == null ? this.iRequest : this.iOldRequest;
    }

    public void setRequest(XCourseRequest request) {
        this.iRequest = request;
    }

    public boolean hasIndividualReservation() {
        return this.iHasIndividualReservation;
    }

    public OnlineSectioningLog.Action.Builder getAction() {
        return this.iAction;
    }

    public XCourseId getDropCourseId() {
        if (this.iLastEnrollment != null) {
            return null;
        }
        return this.iDropCourseId;
    }

    public XEnrollment getDropEnrollment() {
        if (this.iLastEnrollment != null) {
            return null;
        }
        if (this.iDropCourseId == null) {
            return null;
        }
        XCourseRequest request = this.getOldStudent().getRequestForCourse(this.iDropCourseId.getCourseId());
        if (request == null) {
            return null;
        }
        XEnrollment enrollment = request.getEnrollment();
        if (enrollment != null && !enrollment.getCourseId().equals(this.iDropCourseId.getCourseId())) {
            return null;
        }
        return enrollment;
    }

    public XCourseRequest getDropRequest() {
        if (this.iLastEnrollment != null) {
            return null;
        }
        if (this.iDropCourseId == null) {
            return null;
        }
        XCourseRequest request = this.getStudent().getRequestForCourse(this.iDropCourseId.getCourseId());
        if (request == null) {
            request = this.getOldStudent().getRequestForCourse(this.iDropCourseId.getCourseId());
        }
        return request;
    }

    public OnlineSectioningLog.CourseRequestOption getOriginalEnrollment() {
        return this.getOldRequest().getOptions(this.getOldOffering().getOfferingId());
    }

    public int hashCode() {
        return Long.valueOf(this.getRequest().getStudentId()).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SectioningRequest)) {
            return false;
        }
        return this.getRequest().getStudentId().equals(((SectioningRequest)o).getRequest().getStudentId());
    }

    public Request.RequestPriority getRequestPriority() {
        return this.iRequestPriority;
    }

    public Student.StudentPriority getStudentPriority() {
        return this.iStudentPriority;
    }

    public int getAlternativity() {
        return this.iAlternativity;
    }

    public boolean isOverlappingFreeTime(FreeTimeRequest request, Enrollment e) {
        if (request.getTime() == null || e.isAllowOverlap()) {
            return false;
        }
        for (SctAssignment assignment : e.getAssignments()) {
            if (assignment.isAllowOverlap() || assignment.getTime() == null || !request.getTime().hasIntersection(assignment.getTime())) continue;
            return true;
        }
        return false;
    }

    public XEnrollment resection(OnlineSectioningServer server, ResectioningWeights w, StudentQuality sq) {
        w.setLastSectionProvider((ResectioningWeights.LastSectionProvider)this);
        ArrayList<Enrollment> enrollments = new ArrayList<Enrollment>();
        double bestValue = 0.0;
        AssignmentMap assignment = new AssignmentMap();
        CourseRequest request = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, this.getRequest(), this.getDropCourseId(), server, OnlineSectioningInterface.WaitListMode.WaitList);
        if (request == null) {
            return null;
        }
        Integer currentDateIndex = null;
        int dayOfWeekOffset = server.getAcademicSession().getDayOfWeekOffset();
        if (server.getConfig().getPropertyBoolean("ReScheduling.AvoidPastSections", false)) {
            currentDateIndex = Days.daysBetween((ReadablePartial)new LocalDate((Object)server.getAcademicSession().getDatePatternFirstDate()), (ReadablePartial)new LocalDate()).getDays() + server.getConfig().getPropertyInt("ReScheduling.AvoidPastOffset", 0);
        }
        if (this.getLastEnrollment() != null) {
            for (Long sectionId : this.getLastEnrollment().getSectionIds()) {
                for (Course course : request.getCourses()) {
                    Section section = course.getOffering().getSection(sectionId.longValue());
                    if (section == null) continue;
                    this.iLastSections.add(section);
                }
            }
        }
        block2: for (Enrollment e : request.getAvaiableEnrollments((Assignment)assignment)) {
            if (e.getOffering().getId() != this.getOffering().getOfferingId().longValue()) continue;
            if (currentDateIndex != null) {
                for (Section s : e.getSections()) {
                    if (this.iLastSections.contains(s) || s.getTime() == null || (s.getTime().getDayCode() == 0 || s.getTime().getFirstMeeting(dayOfWeekOffset) >= currentDateIndex) && (s.getTime().getDayCode() != 0 || s.getTime().getWeekCode().isEmpty() || s.getTime().getWeekCode().nextSetBit(0) >= currentDateIndex)) continue;
                    continue block2;
                }
            }
            for (Request other : request.getStudent().getRequests()) {
                Enrollment x;
                if (other.equals((Object)request) || !e.isOverlapping(x = (Enrollment)assignment.getValue((Variable)other)) && (w.isFreeTimeAllowOverlaps() || !(other instanceof FreeTimeRequest) || other.getPriority() >= request.getPriority() || !this.isOverlappingFreeTime((FreeTimeRequest)other, e))) continue;
                continue block2;
            }
            for (Section s : e.getSections()) {
                if (!(this.getLastEnrollment() == null ? !server.checkDeadline(e.getCourse().getId(), s.getTime() == null ? null : new XTime(s.getTime()), OnlineSectioningServer.Deadline.NEW) : !this.getLastEnrollment().getSectionIds().contains(s.getId()) && !server.checkDeadline(e.getCourse().getId(), s.getTime() == null ? null : new XTime(s.getTime()), OnlineSectioningServer.Deadline.CHANGE))) continue;
                continue block2;
            }
            double value = w.getWeight((Assignment)assignment, e, sq.allConflicts((Assignment)assignment, e));
            if (enrollments.isEmpty() || value > bestValue) {
                enrollments.clear();
                enrollments.add(e);
                bestValue = value;
                continue;
            }
            if (value != bestValue) continue;
            enrollments.add(e);
        }
        return enrollments.isEmpty() ? null : new XEnrollment((Enrollment)ToolBox.random(enrollments));
    }

    public boolean sameLastChoice(Section current) {
        if (this.getLastEnrollment() != null) {
            for (Section section : this.iLastSections) {
                if (!current.sameChoice(section)) continue;
                return true;
            }
        }
        if (this.getOriginalEnrollment() != null) {
            block1: for (OnlineSectioningLog.Section section : this.getOriginalEnrollment().getSectionList()) {
                if (!section.hasSubpart()) continue;
                if (section.getSubpart().hasExternalId()) {
                    if (!section.getSubpart().getExternalId().equals(current.getSubpart().getInstructionalType())) {
                        continue;
                    }
                } else if (!section.getSubpart().hasName() ? section.getSubpart().hasUniqueId() && section.getSubpart().getUniqueId() != current.getSubpart().getId() : !section.getSubpart().getName().equals(current.getSubpart().getName())) continue;
                if (!section.hasTime() ? current.getTime() != null : current.getTime() == null || section.getTime().getDays() != current.getTime().getDayCode() || section.getTime().getStart() != current.getTime().getStartSlot() || section.getTime().getLength() != current.getTime().getLength() || section.getTime().hasPattern() && !ToolBox.equals((Object)section.getTime().getPattern(), (Object)current.getTime().getDatePatternName())) continue;
                if (current.nrInstructors() != section.getInstructorCount()) continue;
                for (OnlineSectioningLog.Entity instructor : section.getInstructorList()) {
                    if (instructor.hasUniqueId() && current.getInstructors().contains(new Instructor(instructor.getUniqueId()))) continue;
                    continue block1;
                }
                return true;
            }
        }
        return false;
    }

    public boolean sameLastTime(Section current) {
        if (this.getLastEnrollment() != null) {
            for (Section section : this.iLastSections) {
                if (!section.getSubpart().getInstructionalType().equals(current.getSubpart().getInstructionalType()) || !ResectioningWeights.sameTime((Section)current, (TimeLocation)section.getTime())) continue;
                return true;
            }
        }
        if (this.getOriginalEnrollment() != null) {
            for (OnlineSectioningLog.Section section : this.getOriginalEnrollment().getSectionList()) {
                if (!section.hasSubpart()) continue;
                if (section.getSubpart().hasExternalId()) {
                    if (!section.getSubpart().getExternalId().equals(current.getSubpart().getInstructionalType())) {
                        continue;
                    }
                } else if (!section.getSubpart().hasName() ? section.getSubpart().hasUniqueId() && section.getSubpart().getUniqueId() != current.getSubpart().getId() : !section.getSubpart().getName().equals(current.getSubpart().getName())) continue;
                if (section.hasTime() ? current.getTime() == null || section.getTime().getDays() != current.getTime().getDayCode() || section.getTime().getStart() != current.getTime().getStartSlot() || section.getTime().getLength() != current.getTime().getLength() || section.getTime().hasPattern() && !ToolBox.equals((Object)section.getTime().getPattern(), (Object)current.getTime().getDatePatternName()) : current.getTime() != null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean sameLastRoom(Section current) {
        if (this.getLastEnrollment() != null) {
            for (Section section : this.iLastSections) {
                if (!section.getSubpart().getInstructionalType().equals(current.getSubpart().getInstructionalType()) || !ResectioningWeights.sameRooms((Section)current, (List)section.getRooms())) continue;
                return true;
            }
        }
        if (this.getOriginalEnrollment() != null) {
            block1: for (OnlineSectioningLog.Section section : this.getOriginalEnrollment().getSectionList()) {
                if (!section.hasSubpart()) continue;
                if (section.getSubpart().hasExternalId()) {
                    if (!section.getSubpart().getExternalId().equals(current.getSubpart().getInstructionalType())) {
                        continue;
                    }
                } else if (!section.getSubpart().hasName() ? section.getSubpart().hasUniqueId() && section.getSubpart().getUniqueId() != current.getSubpart().getId() : !section.getSubpart().getName().equals(current.getSubpart().getName())) continue;
                if (section.getLocationCount() > 0) {
                    if (current.getRooms() == null || current.getRooms().isEmpty()) continue;
                    block2: for (OnlineSectioningLog.Entity room : section.getLocationList()) {
                        for (RoomLocation loc : current.getRooms()) {
                            if ((!room.hasUniqueId() || room.getUniqueId() != loc.getId().longValue()) && (!room.hasName() || !room.getName().equals(loc.getName()))) continue;
                            continue block2;
                        }
                        continue block1;
                    }
                } else if (current.getRooms() != null && !current.getRooms().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean sameLastName(Section current, Course course) {
        if (this.getLastEnrollment() != null) {
            for (Section section : this.iLastSections) {
                if (section.getSubpart().getId() != current.getSubpart().getId()) continue;
                return ResectioningWeights.sameName((Long)course.getId(), (Section)current, (Section)section);
            }
        }
        if (this.getOriginalEnrollment() != null) {
            for (OnlineSectioningLog.Section section : this.getOriginalEnrollment().getSectionList()) {
                if (!section.hasSubpart()) continue;
                if (section.getSubpart().hasExternalId()) {
                    if (!section.getSubpart().getExternalId().equals(current.getSubpart().getInstructionalType())) {
                        continue;
                    }
                } else if (!section.getSubpart().hasName() ? section.getSubpart().hasUniqueId() && section.getSubpart().getUniqueId() != current.getSubpart().getId() : !section.getSubpart().getName().equals(current.getSubpart().getName())) continue;
                if (!section.hasClazz() || section.getClazz().hasName() && !section.getClazz().getName().equals(current.getName(-1L)) || section.getClazz().hasExternalId() && !section.getClazz().getExternalId().equals(current.getName(course.getId()))) continue;
                return false;
            }
        }
        return false;
    }

    public static CourseRequest convert(Assignment<Request, Enrollment> assignment, XCourseRequest request, OnlineSectioningServer server, OnlineSectioningInterface.WaitListMode wlMode) {
        XCourseId dropCourse = request.isWaitlist(wlMode) ? request.getWaitListSwapWithCourseOffering() : null;
        return SectioningRequest.convert(assignment, request, dropCourse, server, wlMode);
    }

    public static CourseRequest convert(Assignment<Request, Enrollment> assignment, XCourseRequest request, XCourseId dropCourse, OnlineSectioningServer server, OnlineSectioningInterface.WaitListMode wlMode) {
        return SectioningRequest.convert(assignment, server.getStudent(request.getStudentId()), request, server, null, null, dropCourse, wlMode);
    }

    public static Enrollment convert(XCourseRequest request, OnlineSectioningServer server, OnlineSectioningInterface.WaitListMode wlMode) {
        DefaultSingleAssignment assignment = new DefaultSingleAssignment();
        CourseRequest cr = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, server.getStudent(request.getStudentId()), request, server, null, null, null, wlMode);
        return (Enrollment)assignment.getValue((Variable)cr);
    }

    public static boolean hasRequirements(CourseRequest cr) {
        if (cr.getStudent().getClassFirstDate() != null) {
            return true;
        }
        if (cr.getStudent().getClassLastDate() != null) {
            return true;
        }
        if (cr.getStudent().getModalityPreference() == Student.ModalityPreference.ONLINE_REQUIRED) {
            return true;
        }
        return !cr.getRequiredChoices().isEmpty();
    }

    private static boolean check(CourseRequest cr, Course course, Config config, HashSet<Section> sections, int idx) {
        if (idx == 0 && cr.isNotAllowed(course, config)) {
            return false;
        }
        if (config.getSubparts().size() == idx) {
            Enrollment e = new Enrollment((Request)cr, 0, course, config, new HashSet<Section>(sections), null);
            return !cr.isNotAllowed(e);
        }
        Subpart subpart = (Subpart)config.getSubparts().get(idx);
        for (Section section : subpart.getSections()) {
            if (section.isCancelled() || !cr.isRequired(section) || section.getParent() != null && !sections.contains(section.getParent()) || section.isOverlapping(sections) || cr.isNotAllowed(course, section) || !cr.getStudent().isAllowDisabled() && !section.isEnabled(cr.getStudent())) continue;
            sections.add(section);
            if (SectioningRequest.check(cr, course, config, sections, idx + 1)) {
                return true;
            }
            sections.remove(section);
        }
        return false;
    }

    public static boolean hasInconsistentRequirements(CourseRequest cr, Long courseId) {
        if (!SectioningRequest.hasRequirements(cr)) {
            return false;
        }
        for (Course course : cr.getCourses()) {
            if (courseId != null && course.getId() != courseId.longValue()) continue;
            for (Config config : course.getOffering().getConfigs()) {
                if (!SectioningRequest.check(cr, course, config, new HashSet<Section>(), 0)) continue;
                return false;
            }
        }
        return true;
    }

    public static CourseRequest convert(Assignment<Request, Enrollment> assignment, XStudent student, XCourseRequest request, OnlineSectioningServer server, XOffering oldOffering, XEnrollment oldEnrollment, XCourseId dropCourse, OnlineSectioningInterface.WaitListMode wlMode) {
        Collection<Long> offerings;
        XOffering offering;
        Student clonnedStudent = new Student(request.getStudentId().longValue());
        clonnedStudent.setExternalId(student.getExternalId());
        clonnedStudent.setName(student.getName());
        clonnedStudent.setNeedShortDistances(student.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
        clonnedStudent.setAllowDisabled(student.isAllowDisabled());
        clonnedStudent.setClassFirstDate(student.getClassStartDate());
        clonnedStudent.setClassLastDate(student.getClassEndDate());
        clonnedStudent.setBackToBackPreference(student.getBackToBackPreference());
        clonnedStudent.setModalityPreference(student.getModalityPreference());
        CourseRequest ret = null;
        for (XRequest r : student.getRequests()) {
            if (r instanceof XFreeTimeRequest) {
                XFreeTimeRequest ft = (XFreeTimeRequest)r;
                new FreeTimeRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), clonnedStudent, new TimeLocation(ft.getTime().getDays(), ft.getTime().getSlot(), ft.getTime().getLength(), 0, 0.0, Long.valueOf(-1L), "Free Time", server.getAcademicSession().getFreeTimePattern(), 0));
                continue;
            }
            XCourseRequest cr = (XCourseRequest)r;
            ArrayList<Course> courses = new ArrayList<Course>();
            for (XCourseId c : cr.getCourseIds()) {
                XOffering offering2 = server.getOffering(c.getOfferingId());
                if (oldOffering != null && oldOffering.getOfferingId().equals(c.getOfferingId())) {
                    offering2 = oldOffering;
                }
                courses.add(offering2.toCourse(c.getCourseId(), student, server));
            }
            CourseRequest clonnedRequest = new CourseRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), clonnedStudent, courses, cr.isWaitListOrNoSub(wlMode), cr.getTimeStamp() == null ? null : Long.valueOf(cr.getTimeStamp().getTime()));
            cr.fillChoicesIn(clonnedRequest);
            XEnrollment enrollment = cr.getEnrollment();
            if (oldEnrollment != null && cr.getCourseIdByOfferingId(oldOffering.getOfferingId()) != null) {
                enrollment = oldEnrollment;
            }
            if (!(enrollment == null || dropCourse != null && dropCourse.getCourseId().equals(enrollment.getCourseId()))) {
                Config config = null;
                HashSet<Section> assignments = new HashSet<Section>();
                for (Course c : clonnedRequest.getCourses()) {
                    if (!enrollment.getCourseId().equals(c.getId())) continue;
                    for (Config g : c.getOffering().getConfigs()) {
                        if (!enrollment.getConfigId().equals(g.getId())) continue;
                        config = g;
                        for (Subpart s : g.getSubparts()) {
                            for (Section x : s.getSections()) {
                                if (!enrollment.getSectionIds().contains(x.getId())) continue;
                                assignments.add(x);
                            }
                        }
                    }
                }
                if (config != null) {
                    assignment.assign(0L, (Value)new Enrollment((Request)clonnedRequest, 0, config, assignments, assignment));
                }
            }
            if (!request.equals(r)) continue;
            ret = clonnedRequest;
        }
        if (ret == null) {
            ArrayList<Course> courses = new ArrayList<Course>();
            for (XCourseId c : request.getCourseIds()) {
                offering = server.getOffering(c.getOfferingId());
                if (oldOffering != null && oldOffering.getOfferingId().equals(c.getOfferingId())) {
                    offering = oldOffering;
                }
                courses.add(offering.toCourse(c.getCourseId(), student, server));
            }
            ret = new CourseRequest(request.getRequestId().longValue(), request.getPriority(), request.isAlternative(), clonnedStudent, courses, request.isWaitListOrNoSub(wlMode), request.getTimeStamp() == null ? null : Long.valueOf(request.getTimeStamp().getTime()));
            request.fillChoicesIn(ret);
        }
        if (clonnedStudent.getExternalId() != null && !clonnedStudent.getExternalId().isEmpty() && (offerings = server.getInstructedOfferings(clonnedStudent.getExternalId())) != null) {
            for (Long offeringId : offerings) {
                offering = server.getOffering(offeringId);
                if (offering == null) continue;
                offering.fillInUnavailabilities(clonnedStudent);
            }
        }
        return ret;
    }

    public static Enrollment convert(XStudent student, XCourseRequest request, OnlineSectioningServer server, XOffering oldOffering, XEnrollment oldEnrollment, OnlineSectioningInterface.WaitListMode wlMode) {
        DefaultSingleAssignment assignment = new DefaultSingleAssignment();
        CourseRequest cr = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, student, request, server, oldOffering, oldEnrollment, null, wlMode);
        return (Enrollment)assignment.getValue((Variable)cr);
    }

    public static enum ReschedulingReason {
        CLASS_CANCELLED,
        TIME_CONFLICT,
        MISSING_CLASS,
        MULTIPLE_ENRLS,
        CLASS_LINK,
        MULTIPLE_CONFIGS,
        NO_REQUEST;

    }
}

