/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.reservation.IndividualRestriction;
import org.cpsolver.studentsct.reservation.Restriction;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XRestriction;
import org.unitime.timetable.onlinesectioning.model.XRestrictionType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

@SerializeWith(value=XIndividualRestrictionSerializer.class)
public class XIndividualRestriction
extends XRestriction {
    private static final long serialVersionUID = 1L;
    private Set<Long> iStudentIds = new HashSet<Long>();

    public XIndividualRestriction() {
    }

    public XIndividualRestriction(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XIndividualRestriction(IndividualRestriction reservation) {
        super(XRestrictionType.Individual, (Restriction)reservation);
        this.iStudentIds.addAll(reservation.getStudentIds());
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        return this.iStudentIds.contains(student.getStudentId());
    }

    public Set<Long> getStudentIds() {
        return this.iStudentIds;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrStudents = in.readInt();
        this.iStudentIds.clear();
        for (int i = 0; i < nrStudents; ++i) {
            this.iStudentIds.add(in.readLong());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.iStudentIds.size());
        for (Long studentId : this.iStudentIds) {
            out.writeLong(studentId);
        }
    }

    public static class XIndividualRestrictionSerializer
    implements Externalizer<XIndividualRestriction> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XIndividualRestriction object) throws IOException {
            object.writeExternal(output);
        }

        public XIndividualRestriction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XIndividualRestriction(input);
        }
    }
}

