/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;

@SerializeWith(value=XExpectationsSerializer.class)
public class XExpectations
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iOfferingId = null;
    private Map<Long, Double> iExpectations = null;

    public XExpectations() {
    }

    public XExpectations(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XExpectations(Long offeringId) {
        this(offeringId, null);
    }

    public XExpectations(Long offeringId, Map<Long, Double> expectations) {
        this.iOfferingId = offeringId;
        this.iExpectations = expectations;
    }

    public XExpectations(Offering offering) {
        this.iOfferingId = offering.getId();
        this.iExpectations = new HashMap<Long, Double>();
        for (Config config : offering.getConfigs()) {
            for (Subpart subpart : config.getSubparts()) {
                for (Section section : subpart.getSections()) {
                    this.iExpectations.put(section.getId(), section.getSpaceExpected());
                }
            }
        }
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public Double getExpectedSpace(Long sectionId) {
        if (this.iExpectations == null) {
            return 0.0;
        }
        Double expected = this.iExpectations.get(sectionId);
        return expected == null ? 0.0 : expected;
    }

    public void setExpectedSpace(Long sectionId, double expectedSpace) {
        if (this.iExpectations == null) {
            this.iExpectations = new HashMap<Long, Double>();
        }
        this.iExpectations.put(sectionId, expectedSpace);
    }

    public void incExpectedSpace(Long sectionId, double inc) {
        Double expected;
        if (this.iExpectations == null) {
            this.iExpectations = new HashMap<Long, Double>();
        }
        this.iExpectations.put(sectionId, ((expected = this.iExpectations.get(sectionId)) == null ? 0.0 : expected) + inc);
    }

    public Map<Long, Double> toMap() {
        return this.iExpectations == null ? new HashMap<Long, Double>() : new HashMap<Long, Double>(this.iExpectations);
    }

    public boolean hasExpectations() {
        if (this.iExpectations == null) {
            return false;
        }
        for (Double exp : this.iExpectations.values()) {
            if (!(exp > 0.0)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XExpectations)) {
            return false;
        }
        return this.getOfferingId().equals(((XExpectations)o).getOfferingId());
    }

    public int hashCode() {
        return (int)(this.getOfferingId() ^ this.getOfferingId() >>> 32);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iOfferingId = in.readLong();
        int nrExpectations = in.readInt();
        if (nrExpectations == 0) {
            this.iExpectations = null;
        } else {
            this.iExpectations = new HashMap<Long, Double>();
            for (int i = 0; i < nrExpectations; ++i) {
                this.iExpectations.put(in.readLong(), in.readDouble());
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iOfferingId);
        out.writeInt(this.iExpectations == null ? 0 : this.iExpectations.size());
        if (this.iExpectations != null) {
            for (Map.Entry<Long, Double> entry : this.iExpectations.entrySet()) {
                out.writeLong(entry.getKey());
                out.writeDouble(entry.getValue());
            }
        }
    }

    public static class XExpectationsSerializer
    implements Externalizer<XExpectations> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XExpectations object) throws IOException {
            object.writeExternal(output);
        }

        public XExpectations readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XExpectations(input);
        }
    }
}

