/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.VariableTitleCourseProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.util.NameFormat;

public class PurdueVariableTitleCourseProvider
implements VariableTitleCourseProvider {
    private static Log sLog = LogFactory.getLog(PurdueVariableTitleCourseProvider.class);
    private ExternalTermProvider iExternalTermProvider;

    public PurdueVariableTitleCourseProvider() {
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getVariableTitleCourseSQL(AcademicSessionInfo session) {
        return ApplicationProperties.getProperty("purdue.vt.variableTitleCourseSQL." + session.getCampus(), ApplicationProperties.getProperty("purdue.vt.variableTitleCourseSQL", "select c.subj_code, c.crse_numb, c.crse_title, c.credit_hr_ind, c.credit_hr_low, c.credit_hr_high, c.gmod_code, c.gmod_desc, c.gmod_default_ind from timetable.szgv_reg_vartl_course c, timetable.subject_area sa where (concat(concat(c.subj_code, ' '), c.crse_numb) like :query or concat(concat(c.subj_code, ' '), concat(c.crse_numb, concat(' - ', c.crse_title))) like :query) and c.attr_code = 'VART' and c.course_effective_term <= :term and :term < c.course_end_term and c.attr_effective_term <= :term and :term < c.attr_end_term and c.gmod_effective_term <= :term and :term < c.gmod_end_term and c.subj_code = sa.subject_area_abbreviation and sa.session_id = :sessionId and :studentId is not null order by c.subj_code, c.crse_numb, c.gmod_code"));
    }

    protected String getInstructorNameFormat() {
        return ApplicationProperties.getProperty("purdue.vt.instructorNameFormat", "last-first-middle");
    }

    protected String getDisclaimer() {
        return ApplicationProperties.getProperty("purdue.vt.disclaimer", null);
    }

    @Override
    public Collection<SpecialRegistrationInterface.VariableTitleCourseInfo> getVariableTitleCourses(String query, int limit, Long studentId, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        SQLQuery q = helper.getHibSession().createSQLQuery(this.getVariableTitleCourseSQL(server.getAcademicSession()));
        q.setText("query", query == null ? "%" : query.toUpperCase() + "%");
        q.setText("term", this.iExternalTermProvider.getExternalTerm(server.getAcademicSession()));
        q.setLong("sessionId", server.getAcademicSession().getUniqueId().longValue());
        q.setLong("studentId", studentId.longValue());
        if (limit > 0) {
            q.setMaxResults(5 * limit);
        }
        HashMap<String, SpecialRegistrationInterface.VariableTitleCourseInfo> courses = new HashMap<String, SpecialRegistrationInterface.VariableTitleCourseInfo>();
        for (Object[] line : q.list()) {
            String subject = (String)line[0];
            String courseNbr = (String)line[1];
            String title = (String)line[2];
            String credInd = (String)line[3];
            Number credLo = (Number)line[4];
            Number credHi = (Number)line[5];
            String gmCode = (String)line[6];
            String gmDesc = (String)line[7];
            String gmInd = (String)line[8];
            SpecialRegistrationInterface.VariableTitleCourseInfo info = (SpecialRegistrationInterface.VariableTitleCourseInfo)courses.get(subject + " " + courseNbr);
            if (info == null) {
                if (limit > 0 && courses.size() >= limit) break;
                info = new SpecialRegistrationInterface.VariableTitleCourseInfo();
                info.setSubject(subject);
                info.setCourseNbr(courseNbr);
                info.setTitle(title);
                info.setStartDate(server.getAcademicSession().getDefaultStartDate());
                info.setEndDate(server.getAcademicSession().getDefaultEndDate());
                if ("TO".equals(credInd)) {
                    float credit;
                    float min = credLo.floatValue();
                    float max = credHi.floatValue();
                    if ((double)min - Math.floor(min) == 0.5 || (double)max - Math.floor(max) == 0.5) {
                        for (credit = min; credit <= max + 0.001f; credit += 0.5f) {
                            info.addAvailableCredit(Float.valueOf(credit));
                        }
                    } else {
                        for (credit = min; credit <= max + 0.001f; credit += 1.0f) {
                            info.addAvailableCredit(Float.valueOf(credit));
                        }
                    }
                } else if ("OR".equals(credInd)) {
                    info.addAvailableCredit(Float.valueOf(credLo.floatValue()));
                    info.addAvailableCredit(Float.valueOf(credHi.floatValue()));
                } else {
                    info.addAvailableCredit(Float.valueOf(credLo.floatValue()));
                }
                courses.put(subject + " " + courseNbr, info);
            }
            if (gmCode == null) continue;
            info.addGradeMode(new OnlineSectioningInterface.GradeMode(gmCode, gmDesc, false));
            if (!"D".equals(gmInd)) continue;
            info.setDefaultGradeModeCode(gmCode);
        }
        return new TreeSet<SpecialRegistrationInterface.VariableTitleCourseInfo>(courses.values());
    }

    @Override
    public SpecialRegistrationInterface.VariableTitleCourseInfo getVariableTitleCourse(String query, Long studentId, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        SQLQuery q = helper.getHibSession().createSQLQuery(this.getVariableTitleCourseSQL(server.getAcademicSession()));
        q.setText("query", query.toUpperCase());
        q.setText("term", this.iExternalTermProvider.getExternalTerm(server.getAcademicSession()));
        q.setLong("sessionId", server.getAcademicSession().getUniqueId().longValue());
        q.setLong("studentId", studentId.longValue());
        NameFormat nameFormat = NameFormat.fromReference(this.getInstructorNameFormat());
        SpecialRegistrationInterface.VariableTitleCourseInfo info = null;
        for (Object[] line : q.list()) {
            String subject = (String)line[0];
            String courseNbr = (String)line[1];
            String title = (String)line[2];
            String credInd = (String)line[3];
            Number credLo = (Number)line[4];
            Number credHi = (Number)line[5];
            String gmCode = (String)line[6];
            String gmDesc = (String)line[7];
            String gmInd = (String)line[8];
            if (info == null) {
                info = new SpecialRegistrationInterface.VariableTitleCourseInfo();
                info.setSubject(subject);
                info.setCourseNbr(courseNbr);
                info.setTitle(title);
                info.setStartDate(server.getAcademicSession().getDefaultStartDate());
                info.setEndDate(server.getAcademicSession().getDefaultEndDate());
                if ("TO".equals(credInd)) {
                    float credit;
                    float min = credLo.floatValue();
                    float max = credHi.floatValue();
                    if ((double)min - Math.floor(min) == 0.5 || (double)max - Math.floor(max) == 0.5) {
                        for (credit = min; credit <= max + 0.001f; credit += 0.5f) {
                            info.addAvailableCredit(Float.valueOf(credit));
                        }
                    } else {
                        for (credit = min; credit <= max + 0.001f; credit += 1.0f) {
                            info.addAvailableCredit(Float.valueOf(credit));
                        }
                    }
                } else if ("OR".equals(credInd)) {
                    info.addAvailableCredit(Float.valueOf(credLo.floatValue()));
                    info.addAvailableCredit(Float.valueOf(credHi.floatValue()));
                } else {
                    info.addAvailableCredit(Float.valueOf(credLo.floatValue()));
                }
                for (DepartmentalInstructor di : helper.getHibSession().createQuery("select i from DepartmentalInstructor i inner join i.department.subjectAreas sa where i.department.session = :sessionId and sa.subjectAreaAbbreviation = :subject and i.externalUniqueId is not null").setCacheable(true).setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).setString("subject", subject).list()) {
                    info.addInstructor(di.getUniqueId(), nameFormat.format(di));
                }
                if (Customization.CourseDetailsProvider.hasProvider()) {
                    CourseDetailsProvider dp = (CourseDetailsProvider)Customization.CourseDetailsProvider.getProvider();
                    try {
                        info.setDetails(dp.getDetails(server.getAcademicSession(), subject, courseNbr));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                info.setDisclaimer(this.getDisclaimer());
                for (String suggestion : ApplicationProperties.getProperty("purdue.specreg.vt.requestorNoteSuggestions", "").split("[\r\n]+")) {
                    if (suggestion.isEmpty()) continue;
                    info.addSuggestion(suggestion);
                }
            }
            if (gmCode == null) continue;
            info.addGradeMode(new OnlineSectioningInterface.GradeMode(gmCode, gmDesc, false));
            if (!"D".equals(gmInd)) continue;
            info.setDefaultGradeModeCode(gmCode);
        }
        return info;
    }

    @Override
    public void dispose() {
    }
}

