/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.CSVFile;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;

public class CriticalCoursesFile
implements CriticalCoursesProvider {
    private static Log sLog = LogFactory.getLog(CriticalCoursesFile.class);
    private static Map<String, CriticalCoursesImpl> iCriticalCourses = null;

    public CriticalCoursesFile() throws ServletException, IOException {
        String courses = ApplicationProperties.getProperty("purdue.critical.file", "critical-courses.csv");
        CSVFile file = null;
        if (!new File(courses).exists()) {
            throw new ServletException("Unable to create critical course table, reason: resource " + courses + " not found.");
        }
        sLog.info((Object)("Reading menu from " + courses + " ..."));
        file = new CSVFile(new File(courses));
        iCriticalCourses = new HashMap<String, CriticalCoursesImpl>();
        for (CSVFile.CSVLine line : file.getLines()) {
            CSVFile.CSVField area = line.getField("Area");
            CSVFile.CSVField major = line.getField("Major");
            CSVFile.CSVField subject = line.getField("Subject");
            CSVFile.CSVField course = line.getField("Course");
            if (area == null || major == null || subject == null || course == null) continue;
            CriticalCoursesImpl critical = iCriticalCourses.get(area + "/" + major);
            if (critical == null) {
                critical = new CriticalCoursesImpl();
                iCriticalCourses.put(area + "/" + major, critical);
            }
            critical.add(subject.toString(), course.toString());
        }
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student) {
        return this.getCriticalCourses(server, helper, student, helper.getAction());
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId studentId, OnlineSectioningLog.Action.Builder action) {
        XStudent student;
        if (iCriticalCourses == null || iCriticalCourses.isEmpty()) {
            return null;
        }
        XStudent xStudent = student = studentId instanceof XStudent ? (XStudent)studentId : server.getStudent(studentId.getStudentId());
        if (student == null) {
            return null;
        }
        for (XAreaClassificationMajor acm : student.getMajors()) {
            CriticalCoursesProvider.CriticalCourses cc = iCriticalCourses.get(acm.getArea() + "/" + acm.getMajor());
            if (cc == null) continue;
            if (action != null) {
                action.addOptionBuilder().setKey("critical").setValue(cc.toString());
            }
            return cc;
        }
        return null;
    }

    @Override
    public void dispose() {
    }

    protected static class CriticalCoursesImpl
    implements CriticalCoursesProvider.CriticalCourses {
        private Set<String> iCriticalCourses = new TreeSet<String>();

        protected CriticalCoursesImpl() {
        }

        public boolean add(String subject, String course) {
            return this.iCriticalCourses.add(subject + " " + course);
        }

        @Override
        public boolean isEmpty() {
            return this.iCriticalCourses.isEmpty();
        }

        @Override
        public int isCritical(CourseOffering course) {
            for (String c : this.iCriticalCourses) {
                if (!course.getCourseName().startsWith(c)) continue;
                return CourseDemand.Critical.IMPORTANT.ordinal();
            }
            return CourseDemand.Critical.NORMAL.ordinal();
        }

        @Override
        public int isCritical(XCourseId course) {
            for (String c : this.iCriticalCourses) {
                if (!course.getCourseName().startsWith(c)) continue;
                return CourseDemand.Critical.IMPORTANT.ordinal();
            }
            return CourseDemand.Critical.NORMAL.ordinal();
        }

        public String toString() {
            TreeSet<String> courses = new TreeSet<String>(this.iCriticalCourses);
            return ((Object)courses).toString();
        }
    }
}

