/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.model.XAdvisorRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;

public class DefaultCriticalCourses
implements CriticalCoursesProvider {
    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId studentId) {
        return this.getCriticalCourses(server, helper, studentId, helper.getAction());
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId studentId, OnlineSectioningLog.Action.Builder action) {
        XStudent student;
        XStudent xStudent = student = studentId instanceof XStudent ? (XStudent)studentId : server.getStudent(studentId.getStudentId());
        if (student == null) {
            return null;
        }
        CourseDemand.Critical critical = CourseDemand.Critical.fromText(ApplicationProperty.AdvisorCourseRequestsAllowCritical.valueOfSession(server.getAcademicSession().getUniqueId()));
        CriticalCoursesImpl cc = new CriticalCoursesImpl(critical);
        if (student.hasAdvisorRequests()) {
            for (XAdvisorRequest ar : student.getAdvisorRequests()) {
                if (!ar.isCritical() || ar.isSubstitute() || !ar.hasCourseId() || ar.getAlternative() != 0) continue;
                cc.addCritical(ar.getCourseId());
                for (XAdvisorRequest alt : student.getAdvisorRequests()) {
                    if (alt.getPriority() != ar.getPriority() || alt.getAlternative() <= 0 || alt.isSubstitute() || !alt.hasCourseId()) continue;
                    cc.addCritical(alt.getCourseId());
                }
            }
        }
        return cc;
    }

    @Override
    public void dispose() {
    }

    protected static class CriticalCoursesImpl
    implements CriticalCoursesProvider.CriticalCourses,
    CriticalCoursesProvider.AdvisorCriticalCourses {
        private CourseDemand.Critical iCritical = null;
        private Map<Long, String> iCriticalCourses = new HashMap<Long, String>();

        CriticalCoursesImpl(CourseDemand.Critical critical) {
            this.iCritical = critical;
        }

        public boolean addCritical(XCourseId course) {
            return this.iCriticalCourses.put(course.getCourseId(), course.getCourseName()) != null;
        }

        @Override
        public boolean isEmpty() {
            return this.iCriticalCourses.isEmpty();
        }

        @Override
        public int isCritical(CourseOffering course) {
            if (this.iCriticalCourses.containsKey(course.getUniqueId())) {
                return this.iCritical.ordinal();
            }
            return CourseDemand.Critical.NORMAL.ordinal();
        }

        @Override
        public int isCritical(XCourseId course) {
            if (this.iCriticalCourses.containsKey(course.getCourseId())) {
                return this.iCritical.ordinal();
            }
            return CourseDemand.Critical.NORMAL.ordinal();
        }

        public String toString() {
            TreeSet<String> courses = new TreeSet<String>(this.iCriticalCourses.values());
            return ((Object)courses).toString();
        }

        @Override
        public int isCritical(AdvisorCourseRequest request) {
            return request.getEffectiveCritical().ordinal();
        }

        @Override
        public int isCritical(XAdvisorRequest request) {
            return request.getCritical();
        }
    }
}

