/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorGetCourseRequests;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsValidationHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.WaitListValidationProvider;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.WaitlistedOnlineSectioningAction;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class GetRequest
extends WaitlistedOnlineSectioningAction<CourseRequestInterface> {
    protected static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static final long serialVersionUID = 1L;
    private Long iStudentId;
    private boolean iSectioning;
    private boolean iCustomValidation = false;
    private boolean iWaitListValidation = false;
    private boolean iCustomRequests = true;
    private boolean iAdvisorRequests = true;
    private CourseMatcher iMatcher = null;
    private OnlineSectioningInterface.WaitListMode iWaitListMode = null;

    public GetRequest forStudent(Long studentId, boolean sectioning) {
        this.iStudentId = studentId;
        this.iSectioning = sectioning;
        return this;
    }

    public GetRequest forStudent(Long studentId) {
        return this.forStudent(studentId, true);
    }

    public GetRequest withCustomValidation(boolean validation) {
        this.iCustomValidation = validation;
        return this;
    }

    public GetRequest withWaitListValidation(boolean validation) {
        this.iWaitListValidation = validation;
        return this;
    }

    public GetRequest withCustomRequest(boolean request) {
        this.iCustomRequests = request;
        return this;
    }

    public GetRequest withAdvisorRequests(boolean adv) {
        this.iAdvisorRequests = adv;
        return this;
    }

    public GetRequest withCourseMatcher(CourseMatcher matcher) {
        this.iMatcher = matcher;
        return this;
    }

    public GetRequest withWaitListMode(OnlineSectioningInterface.WaitListMode mode) {
        this.iWaitListMode = mode;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CourseRequestInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iStudentId == null) {
            if (CustomCourseRequestsHolder.hasProvider() && this.iCustomRequests) {
                CourseRequestInterface request;
                if (this.iMatcher != null) {
                    this.iMatcher.setServer(server);
                }
                if ((request = CustomCourseRequestsHolder.getProvider().getCourseRequests(server, helper, new XStudent(null, helper.getStudentExternalId(), helper.getUser().getName()), this.iMatcher)) != null) {
                    return request;
                }
            }
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        CourseRequestInterface request = null;
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
            XStudent student = server.getStudent(this.iStudentId);
            if (student == null) {
                CourseRequestInterface courseRequestInterface = null;
                return courseRequestInterface;
            }
            action.getStudentBuilder().setExternalId(student.getExternalId());
            action.getStudentBuilder().setName(student.getName());
            if (student.getRequests().isEmpty() && CustomCourseRequestsHolder.hasProvider() && this.iCustomRequests) {
                if (this.iMatcher != null) {
                    this.iMatcher.setServer(server);
                }
                if ((request = CustomCourseRequestsHolder.getProvider().getCourseRequests(server, helper, student, this.iMatcher)) != null && !request.isEmpty()) {
                    CourseRequestInterface courseRequestInterface = request;
                    return courseRequestInterface;
                }
            }
            request = new CourseRequestInterface();
            request.setStudentId(this.iStudentId);
            request.setSaved(true);
            request.setAcademicSessionId(server.getAcademicSession().getUniqueId());
            request.setMaxCredit(student.getMaxCredit());
            if (this.iWaitListMode == null) {
                request.setWaitListMode(student.getWaitListMode(helper));
            } else {
                request.setWaitListMode(this.iWaitListMode);
            }
            if (student.getMaxCreditOverride() != null) {
                request.setMaxCreditOverride(student.getMaxCreditOverride().getValue());
                request.setMaxCreditOverrideExternalId(student.getMaxCreditOverride().getExternalId());
                request.setMaxCreditOverrideTimeStamp(student.getMaxCreditOverride().getTimeStamp());
                Integer status = student.getMaxCreditOverride().getStatus();
                if (status == null) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
                } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED);
                } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED);
                } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED);
                } else {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                }
            }
            CourseRequestInterface.Request lastRequest = null;
            int lastRequestPriority = -1;
            boolean hasEnrollments = false;
            for (XRequest cd : student.getRequests()) {
                if (!(cd instanceof XCourseRequest) || ((XCourseRequest)cd).getEnrollment() == null) continue;
                hasEnrollments = true;
                break;
            }
            boolean setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnly.isTrue();
            boolean setReadOnlyWhenReserved = ApplicationProperty.OnlineSchedulingMakeReservedRequestReadOnly.isTrue();
            boolean setInactive = ApplicationProperty.OnlineSchedulingMakeUnassignedRequestsInactive.isTrue();
            if (helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER) {
                setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnlyIfAdmin.isTrue();
                setReadOnlyWhenReserved = ApplicationProperty.OnlineSchedulingMakeReservedRequestReadOnlyIfAdmin.isTrue();
                setInactive = ApplicationProperty.OnlineSchedulingMakeUnassignedRequestsInactiveIfAdmin.isTrue();
            }
            boolean reservedNoPriority = ApplicationProperty.OnlineSchedulingReservedRequestNoPriorityChanges.isTrue();
            boolean reservedNoAlternatives = ApplicationProperty.OnlineSchedulingReservedRequestNoAlternativeChanges.isTrue();
            boolean enrolledNoPriority = ApplicationProperty.OnlineSchedulingAssignedRequestNoPriorityChanges.isTrue();
            boolean enrolledNoAlternatives = ApplicationProperty.OnlineSchedulingAssignedRequestNoAlternativeChanges.isTrue();
            if (setInactive && !hasEnrollments) {
                setInactive = false;
            }
            if (setInactive && server instanceof StudentSolver) {
                setInactive = false;
            }
            boolean showWaitListPosition = ApplicationProperty.OnlineSchedulingShowWaitListPosition.isTrue();
            for (XRequest cd : student.getRequests()) {
                CourseRequestInterface.Request r = null;
                if (cd instanceof XFreeTimeRequest) {
                    XFreeTimeRequest ftr = (XFreeTimeRequest)cd;
                    CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                    ft.setStart(ftr.getTime().getSlot());
                    ft.setLength(ftr.getTime().getLength());
                    for (DayCode day : DayCode.toDayCodes(ftr.getTime().getDays())) {
                        ft.addDay(day.getIndex());
                    }
                    if (lastRequest != null && lastRequestPriority == cd.getPriority() && lastRequest.hasRequestedCourse() && lastRequest.getRequestedCourse(0).isFreeTime()) {
                        lastRequest.getRequestedCourse(0).addFreeTime(ft);
                    } else {
                        r = new CourseRequestInterface.Request();
                        CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                        r.addRequestedCourse(rc);
                        rc.addFreeTime(ft);
                        if (cd.isAlternative()) {
                            request.getAlternatives().add(r);
                        } else {
                            request.getCourses().add(r);
                        }
                        lastRequest = r;
                        lastRequestPriority = cd.getPriority();
                        rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    }
                } else if (cd instanceof XCourseRequest) {
                    XEnrollment enrollment;
                    r = new CourseRequestInterface.Request();
                    for (XCourseId courseId : ((XCourseRequest)cd).getCourseIds()) {
                        boolean isWaitListed;
                        XCourse c = server.getCourse(courseId.getCourseId());
                        if (c == null) continue;
                        XOffering offering = server.getOffering(c.getOfferingId());
                        CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                        rc.setCourseId(c.getCourseId());
                        rc.setCourseName(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                        rc.setCourseTitle(c.getTitle());
                        rc.setCredit(c.getMinCredit(), c.getMaxCredit());
                        boolean isEnrolled = ((XCourseRequest)cd).getEnrollment() != null && c.getCourseId().equals(((XCourseRequest)cd).getEnrollment().getCourseId());
                        boolean bl = isWaitListed = !isEnrolled && offering.isWaitList() && ((XCourseRequest)cd).isWaitlist(request.getWaitListMode());
                        if (setReadOnly && isEnrolled) {
                            rc.setReadOnly(true);
                        }
                        if (this.iSectioning && setInactive && !isEnrolled && !isWaitListed) {
                            rc.setInactive(true);
                        }
                        if (!this.iSectioning && isEnrolled) {
                            rc.setReadOnly(true);
                            rc.setCanDelete(false);
                            if (enrolledNoAlternatives) {
                                rc.setCanChangeAlternatives(false);
                            }
                            if (enrolledNoPriority) {
                                rc.setCanChangePriority(false);
                            }
                        }
                        if (!this.iSectioning && setReadOnlyWhenReserved && offering != null && (offering.hasIndividualReservation(student, c) || offering.hasGroupReservation(student, c))) {
                            rc.setReadOnly(true);
                            rc.setCanDelete(false);
                            if (reservedNoAlternatives) {
                                rc.setCanChangeAlternatives(false);
                            }
                            if (reservedNoPriority) {
                                rc.setCanChangePriority(false);
                            }
                        }
                        rc.setCanWaitList(offering != null && offering.isWaitList());
                        if (isEnrolled) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.ENROLLED);
                        } else {
                            Integer status = ((XCourseRequest)cd).getOverrideStatus(courseId);
                            if (status == null) {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
                            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED);
                            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED.ordinal()) {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED);
                            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED.ordinal()) {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED);
                            } else {
                                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                            }
                        }
                        rc.setOverrideExternalId(((XCourseRequest)cd).getOverrideExternalId(courseId));
                        rc.setOverrideTimeStamp(((XCourseRequest)cd).getOverrideTimeStamp(courseId));
                        ((XCourseRequest)cd).fillPreferencesIn(rc, courseId);
                        r.addRequestedCourse(rc);
                        if (!showWaitListPosition || !rc.isCanWaitList() || !((XCourseRequest)cd).isWaitlist()) continue;
                        rc.setWaitListPosition(this.getWaitListPosition(offering, student, (XCourseRequest)cd, courseId, server, helper));
                    }
                    r.setWaitList(((XCourseRequest)cd).isWaitlist());
                    r.setNoSub(((XCourseRequest)cd).isNoSub());
                    r.setCritical(((XCourseRequest)cd).getCritical());
                    r.setTimeStamp(((XCourseRequest)cd).getTimeStamp());
                    if (r.isWaitList()) {
                        r.setWaitListedTimeStamp(((XCourseRequest)cd).getWaitListedTimeStamp());
                    }
                    r.setWaitListSwapWithCourseOfferingId(((XCourseRequest)cd).getWaitListSwapWithCourseOffering() == null ? null : ((XCourseRequest)cd).getWaitListSwapWithCourseOffering().getCourseId());
                    if (r.hasRequestedCourse()) {
                        if (cd.isAlternative()) {
                            request.getAlternatives().add(r);
                        } else {
                            request.getCourses().add(r);
                        }
                    }
                    if (r.isWaitList() && ((XCourseRequest)cd).getEnrollment() == null) {
                        AssignmentMap assignment = new AssignmentMap();
                        CourseRequest courseRequest = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, (XCourseRequest)cd, server, request.getWaitListMode());
                        List enrls = courseRequest.getEnrollmentsSkipSameTime((Assignment)assignment);
                        block9: for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                            Object enrl2;
                            if (rc.getCourseId() == null) continue;
                            for (XCourseId cid : ((XCourseRequest)cd).getCourseIds()) {
                                XOffering off;
                                if (!cid.getCourseId().equals(rc.getCourseId()) || (off = server.getOffering(cid.getOfferingId())) != null && off.isWaitList()) continue;
                                continue block9;
                            }
                            TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                                @Override
                                public int compare(Enrollment o1, Enrollment o2) {
                                    return o1.getRequest().compareTo(o2.getRequest());
                                }
                            });
                            Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                            Object noConfEnrl = null;
                            int nbrEnrl = 0;
                            for (Object enrl2 : enrls) {
                                if (!rc.getCourseId().equals(enrl2.getCourse().getId())) continue;
                                ++nbrEnrl;
                                boolean overlaps = false;
                                for (Request q : enrl2.getStudent().getRequests()) {
                                    if (q.equals((Object)request)) continue;
                                    Enrollment x = (Enrollment)assignment.getValue((Variable)q);
                                    if (q instanceof FreeTimeRequest) {
                                        if (!GetAssignment.isFreeTimeOverlapping((FreeTimeRequest)q, (Enrollment)enrl2)) continue;
                                        overlaps = true;
                                        overlap.add(((FreeTimeRequest)q).createEnrollment());
                                        continue;
                                    }
                                    if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                                    for (SctAssignment a : x.getAssignments()) {
                                        if (!a.isOverlapping(enrl2.getAssignments())) continue;
                                        overlaps = true;
                                        overlap.add(x);
                                        if (!(x.getRequest() instanceof CourseRequest)) continue;
                                        CourseRequest cr = (CourseRequest)x.getRequest();
                                        TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                        if (ss == null) {
                                            ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator((Assignment)assignment));
                                            overlapingSections.put(cr, ss);
                                        }
                                        ss.add((Section)a);
                                    }
                                }
                                if (overlaps || noConfEnrl != null) continue;
                                noConfEnrl = enrl2;
                            }
                            if (noConfEnrl != null) continue;
                            TreeSet<String> overlaps = new TreeSet<String>();
                            enrl2 = overlap.iterator();
                            while (enrl2.hasNext()) {
                                Enrollment q = (Enrollment)enrl2.next();
                                if (q.getRequest() instanceof FreeTimeRequest) {
                                    overlaps.add(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                    continue;
                                }
                                CourseRequest cr = (CourseRequest)q.getRequest();
                                Course o = q.getCourse();
                                String ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                                if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                    Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                    while (i.hasNext()) {
                                        Section s = (Section)i.next();
                                        ov = ov + " " + s.getSubpart().getName();
                                        if (!i.hasNext()) continue;
                                        ov = ov + ",";
                                    }
                                }
                                overlaps.add(ov);
                            }
                            if (nbrEnrl == 0) {
                                enrl2 = courseRequest.getStudent().getUnavailabilities().iterator();
                                block16: while (enrl2.hasNext()) {
                                    Unavailability unavailability = (Unavailability)enrl2.next();
                                    for (Config config : courseRequest.getCourse(rc.getCourseId().longValue()).getOffering().getConfigs()) {
                                        for (Subpart subpart : config.getSubparts()) {
                                            for (Section section : subpart.getSections()) {
                                                if (!unavailability.isOverlapping((SctAssignment)section)) continue;
                                                overlaps.add(MSG.teachingAssignment(unavailability.getSection().getName()));
                                                continue block16;
                                            }
                                        }
                                    }
                                }
                            }
                            if (overlaps == null || overlaps.isEmpty()) continue;
                            String message = null;
                            Iterator i = overlaps.iterator();
                            while (i.hasNext()) {
                                String ov = (String)i.next();
                                if (message == null) {
                                    message = MSG.conflictWithFirst(ov);
                                    continue;
                                }
                                if (i.hasNext()) {
                                    message = message + MSG.conflictWithMiddle(ov);
                                    continue;
                                }
                                message = message + MSG.conflictWithLast(ov);
                            }
                            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "WL-OVERLAP", message + ".", 0);
                        }
                    }
                    if (r.isWaitList() && r.getWaitListSwapWithCourseOfferingId() != null && r.hasRequestedCourse() && (enrollment = ((XCourseRequest)cd).getEnrollment()) != null && enrollment.getCourseId().equals(r.getWaitListSwapWithCourseOfferingId())) {
                        boolean before = true;
                        for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                            if (r.getWaitListSwapWithCourseOfferingId().equals(rc.getCourseId())) {
                                if (((XCourseRequest)cd).isRequired(enrollment, server.getOffering(enrollment.getOfferingId()))) {
                                    rc.setStatus(CourseRequestInterface.RequestedCourseStatus.WAITLIST_INACTIVE);
                                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "WL-INACTIVE", MSG.waitListRequirementsMet(), 0);
                                }
                                before = false;
                                continue;
                            }
                            if (before) continue;
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.WAITLIST_INACTIVE);
                            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "WL-INACTIVE", MSG.waitListLowPriority(), 0);
                        }
                    }
                    lastRequest = r;
                    lastRequestPriority = cd.getPriority();
                }
                action.addRequest(OnlineSectioningHelper.toProto(cd));
            }
            if (!(student.getLastStudentChange() != null || server instanceof StudentSolver || !this.iAdvisorRequests || this.iSectioning && hasEnrollments || !request.applyAdvisorRequests(AdvisorGetCourseRequests.getRequest(student, server, helper)))) {
                request.setPopupMessage(ApplicationProperty.PopupMessageCourseRequestsPrepopulatedWithAdvisorRecommendations.value());
            }
        }
        finally {
            lock.release();
        }
        if (this.iCustomValidation && CustomCourseRequestsValidationHolder.hasProvider()) {
            CustomCourseRequestsValidationHolder.getProvider().check(server, helper, request);
        }
        if (this.iWaitListValidation && request.getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList && Customization.WaitListValidationProvider.hasProvider()) {
            WaitListValidationProvider wp = (WaitListValidationProvider)Customization.WaitListValidationProvider.getProvider();
            wp.check(server, helper, request);
        }
        return request;
    }

    @Override
    public String name() {
        return "get-request";
    }
}

