/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.advisors;

import com.lowagie.text.DocumentException;
import java.io.IOException;
import org.hibernate.CacheMode;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseAdvisor;
import org.unitime.timetable.model.base.BaseAdvisorCourseRequest;
import org.unitime.timetable.model.dao.AdvisorCourseRequestDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorConfirmationPDF;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorGetCourseRequests;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.NameFormat;

@Service(value="org.unitime.timetable.export.Exporter:acrf.pdf")
public class AdvisorConfirmationExporter
implements Exporter {
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    @Override
    public String reference() {
        return "acrf.pdf";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        OnlineSectioningInterface.StudentStatusInfo info;
        TimetableManager manager;
        Advisor advisor;
        boolean isAdvisor = false;
        String externalId = helper.getParameter("id");
        if (externalId == null) {
            if (!helper.getSessionContext().isAuthenticated()) {
                throw new IllegalArgumentException(MSG.exceptionUserNotLoggedIn());
            }
            externalId = helper.getSessionContext().getUser().getExternalUserId();
        } else {
            helper.getSessionContext().checkPermissionAnyAuthority((Object)helper.getAcademicSessionId(), Right.AdvisorCourseRequests, new Qualifiable[0]);
            isAdvisor = true;
        }
        if (externalId == null) {
            throw new IllegalArgumentException(MSG.exceptionBadStudentId());
        }
        if (externalId.isEmpty()) {
            throw new IllegalArgumentException(MSG.exceptionUserNotLoggedIn());
        }
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Student student = Student.findByExternalId(helper.getAcademicSessionId(), externalId);
        if (student == null) {
            throw new IllegalArgumentException(MSG.exceptionNoStudent());
        }
        SessionDAO.getInstance().getSession().setCacheMode(CacheMode.REFRESH);
        OnlineSectioningInterface.AdvisingStudentDetails details = new OnlineSectioningInterface.AdvisingStudentDetails();
        details.setSessionId(sessionId);
        details.setStudentId(student.getUniqueId());
        details.setStudentName(student.getName(NameFormat.LAST_FIRST_MIDDLE.reference()));
        details.setStudentExternalId(student.getExternalUniqueId());
        details.setSessionName(student.getSession().getLabel());
        details.setStudentEmail(student.getEmail());
        if (isAdvisor && (advisor = Advisor.findByExternalId(helper.getSessionContext().getUser().getExternalUserId(), sessionId)) != null) {
            details.setAdvisorEmail(advisor.getEmail());
        }
        if (!details.hasAdvisorEmail()) {
            Object advisor2;
            BaseAdvisorCourseRequest lastAcr = null;
            for (AdvisorCourseRequest acr : student.getAdvisorCourseRequests()) {
                if (lastAcr != null && !lastAcr.getTimestamp().before(acr.getTimestamp())) continue;
                lastAcr = acr;
            }
            if (lastAcr != null && (advisor2 = Advisor.findByExternalId(lastAcr.getChangedBy(), sessionId)) != null) {
                details.setAdvisorEmail(((BaseAdvisor)advisor2).getEmail());
            }
        }
        if (!details.hasAdvisorEmail()) {
            String email = null;
            for (Advisor a : student.getAdvisors()) {
                if (a.getEmail() == null || a.getEmail().isEmpty()) continue;
                email = (email == null ? "" : email + "\n") + a.getEmail();
            }
            details.setAdvisorEmail(email);
        }
        if (!details.hasAdvisorEmail() && isAdvisor && (manager = TimetableManager.findByExternalId(helper.getSessionContext().getUser().getExternalUserId())) != null) {
            details.setAdvisorEmail(manager.getEmailAddress());
        }
        if (student.getSectioningStatus() != null) {
            OnlineSectioningInterface.StudentStatusInfo status = new OnlineSectioningInterface.StudentStatusInfo();
            status.setUniqueId(student.getSectioningStatus().getUniqueId());
            status.setReference(student.getSectioningStatus().getReference());
            status.setLabel(student.getSectioningStatus().getLabel());
            details.setStatus(status);
        } else if (student.getSession().getDefaultSectioningStatus() != null) {
            info = new OnlineSectioningInterface.StudentStatusInfo();
            info.setUniqueId(null);
            info.setReference("");
            info.setLabel(MSG.studentStatusSessionDefault(student.getSession().getDefaultSectioningStatus().getLabel()));
            info.setEffectiveStart(null);
            info.setEffectiveStop(null);
            details.setStatus(info);
        } else {
            info = new OnlineSectioningInterface.StudentStatusInfo();
            info.setReference("");
            info.setLabel(MSG.studentStatusSystemDefault());
            info.setAllEnabled();
            details.setStatus(info);
        }
        details.setRequest(AdvisorGetCourseRequests.getRequest(student, AdvisorCourseRequestDAO.getInstance().getSession()));
        String advWlMode = ApplicationProperty.AdvisorRecommendationsWaitListMode.value(student.getSession());
        if ("Student".equalsIgnoreCase(advWlMode)) {
            details.setWaitListMode(student.getWaitListMode());
        } else {
            details.setWaitListMode(OnlineSectioningInterface.WaitListMode.valueOf(advWlMode));
        }
        helper.setup("application/pdf", "crf-" + student.getSession().getAcademicTerm() + student.getSession().getAcademicYear() + (isAdvisor ? "-" + student.getName(NameFormat.LAST_FIRST_MIDDLE.reference()).replaceAll("[&$\\+,/:;=\\?@<>\\[\\]\\{\\}\\|\\^\\~%#`\\t\\s\\n\\r \\\\]", "") + "-" + student.getExternalUniqueId() : "") + ".pdf", false);
        try {
            new AdvisorConfirmationPDF(details).generatePdfConfirmation(helper.getOutputStream());
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

