/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;

public class MultiReadWriteLock {
    protected Lock iLock = new ReentrantLock();
    protected Condition iLockNotAvailable = this.iLock.newCondition();
    protected Condition iGlobalLockNotAvailable = this.iLock.newCondition();
    protected Map<Long, ReadWriteLock> iIndividualLocks = new HashMap<Long, ReadWriteLock>();
    protected ReadWriteLock iGlobalLock = new ReentrantReadWriteLock(true);
    protected int iGlobalLockRequests = 0;

    public Unlock lock(boolean write, Long ... ids) {
        ArrayList<Long> list = new ArrayList<Long>(ids.length);
        for (Long id : ids) {
            list.add(id);
        }
        return this.lock(write, list);
    }

    public Unlock tryLock(boolean write, Long ... ids) {
        ArrayList<Long> list = new ArrayList<Long>(ids.length);
        for (Long id : ids) {
            list.add(id);
        }
        return this.tryLock(write, list);
    }

    public Unlock lock(boolean write, Collection<Long> ids) {
        this.iLock.lock();
        try {
            if (ids == null || ids.isEmpty()) {
                Unlock unlock = new Unlock(new Lock[0]);
                return unlock;
            }
            while (true) {
                Unlock unlock;
                if ((unlock = this.tryLock(write, ids)) != null) {
                    Unlock unlock2 = unlock;
                    return unlock2;
                }
                this.iLockNotAvailable.awaitUninterruptibly();
            }
        }
        finally {
            this.iLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unlock tryLock(boolean write, Collection<Long> ids) {
        this.iLock.lock();
        try {
            if (ids == null || ids.isEmpty()) {
                Unlock unlock = null;
                return unlock;
            }
            ArrayList<Lock> acquiredLocks = new ArrayList<Lock>();
            if (!this.iGlobalLock.readLock().tryLock()) {
                Unlock unlock = null;
                return unlock;
            }
            acquiredLocks.add(this.iGlobalLock.readLock());
            for (Long courseId : ids) {
                Lock lock;
                ReadWriteLock courseLock = this.iIndividualLocks.get(courseId);
                if (courseLock == null) {
                    courseLock = new ReentrantReadWriteLock(false);
                    this.iIndividualLocks.put(courseId, courseLock);
                }
                Lock lock2 = lock = write ? courseLock.writeLock() : courseLock.readLock();
                if (!lock.tryLock()) {
                    for (Lock undo : acquiredLocks) {
                        undo.unlock();
                    }
                    Iterator iterator = null;
                    return iterator;
                }
                acquiredLocks.add(lock);
            }
            Unlock unlock = new Unlock(acquiredLocks);
            return unlock;
        }
        finally {
            this.iLock.unlock();
        }
    }

    public Unlock lockAll() {
        this.iLock.lock();
        try {
            while (true) {
                if (this.iGlobalLock.writeLock().tryLock()) {
                    Unlock unlock = new Unlock(new Lock[]{this.iGlobalLock.writeLock()});
                    return unlock;
                }
                ++this.iGlobalLockRequests;
                this.iGlobalLockNotAvailable.awaitUninterruptibly();
                --this.iGlobalLockRequests;
            }
        }
        finally {
            this.iLock.unlock();
        }
    }

    public Unlock empty() {
        return new Unlock(new Lock[0]);
    }

    public void remove(Long id) {
        this.iLock.lock();
        try {
            this.iIndividualLocks.remove(id);
        }
        finally {
            this.iLock.unlock();
        }
    }

    public void removeAll() {
        this.iLock.lock();
        try {
            this.iIndividualLocks.clear();
        }
        finally {
            this.iLock.unlock();
        }
    }

    public static void main(String[] args) {
        try {
            Thread t;
            int i;
            final MultiReadWriteLock lock = new MultiReadWriteLock();
            for (i = 1; i <= 1000; ++i) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (int x = 1; x <= 10; ++x) {
                                int nrCourses = 2 + ToolBox.random((int)9);
                                HashSet<Long> courses = new HashSet<Long>();
                                String s = "";
                                for (int i = 0; i < nrCourses; ++i) {
                                    long courseId;
                                    while (!courses.add(courseId = (long)ToolBox.random((int)10000))) {
                                    }
                                    s = s + (i > 0 ? ", " : "") + courseId;
                                }
                                boolean write = ToolBox.random((int)10) == 0;
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") " + (write ? "Write " : "Read ") + "locking: [" + s + "]");
                                Unlock unlock = lock.lock(write, courses);
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") " + (write ? "Write " : "Read ") + "locked: [" + s + "]");
                                try {
                                    Thread.sleep(ToolBox.random((int)1000));
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") " + (write ? "Write " : "Read ") + "unlocking: [" + s + "]");
                                unlock.release();
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") " + (write ? "Write " : "Read ") + "unlocked: [" + s + "]");
                            }
                        }
                        catch (Exception e) {
                            System.err.println(Thread.currentThread().getName() + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
                t.setName("[T" + i + "]: ");
                t.start();
            }
            for (i = 1; i <= 3; ++i) {
                t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (int x = 1; x <= 10; ++x) {
                                try {
                                    Thread.sleep(ToolBox.random((int)5000));
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") Locking all...");
                                Unlock unlock = lock.lockAll();
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") All locked.");
                                try {
                                    Thread.sleep(ToolBox.random((int)1000));
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") Unlocking all.");
                                unlock.release();
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") All unlocked.");
                            }
                        }
                        catch (Exception e) {
                            System.err.println(Thread.currentThread().getName() + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
                t.setName("[A" + i + "]: ");
                t.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Unlock
    implements OnlineSectioningServer.Lock {
        private List<Lock> iAcquiredLocks;

        private Unlock(List<Lock> acquiredLocks) {
            this.iAcquiredLocks = acquiredLocks;
        }

        private Unlock(Lock ... acquiredLocks) {
            this.iAcquiredLocks = new ArrayList<Lock>();
            for (Lock lock : acquiredLocks) {
                this.iAcquiredLocks.add(lock);
            }
        }

        @Override
        public void release() {
            MultiReadWriteLock.this.iLock.lock();
            try {
                for (Lock lock : this.iAcquiredLocks) {
                    lock.unlock();
                }
                if (MultiReadWriteLock.this.iGlobalLockRequests > 0) {
                    MultiReadWriteLock.this.iGlobalLockNotAvailable.signal();
                } else {
                    MultiReadWriteLock.this.iLockNotAvailable.signalAll();
                }
            }
            finally {
                MultiReadWriteLock.this.iLock.unlock();
            }
        }
    }
}

