/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TeachingResponsibility;

public abstract class BaseTeachingRequest
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer iNbrInstructors;
    private Float iTeachingLoad;
    private Boolean iAssignCoordinator;
    private Integer iPercentShare;
    private InstructionalOffering iOffering;
    private PreferenceLevel iSameCoursePreference;
    private PreferenceLevel iSameCommonPart;
    private TeachingResponsibility iResponsibility;
    private Set<DepartmentalInstructor> iAssignedInstructors;
    private Set<TeachingClassRequest> iClassRequests;
    public static String PROP_NBR_INSTRUCTORS = "nbrInstructors";
    public static String PROP_TEACHING_LOAD = "teachingLoad";
    public static String PROP_ASSIGN_COORDINATOR = "assignCoordinator";
    public static String PROP_PERCENT_SHARE = "percentShare";

    public BaseTeachingRequest() {
        this.initialize();
    }

    public BaseTeachingRequest(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    @Override
    protected void initialize() {
    }

    public Integer getNbrInstructors() {
        return this.iNbrInstructors;
    }

    public void setNbrInstructors(Integer nbrInstructors) {
        this.iNbrInstructors = nbrInstructors;
    }

    public Float getTeachingLoad() {
        return this.iTeachingLoad;
    }

    public void setTeachingLoad(Float teachingLoad) {
        this.iTeachingLoad = teachingLoad;
    }

    public Boolean isAssignCoordinator() {
        return this.iAssignCoordinator;
    }

    public Boolean getAssignCoordinator() {
        return this.iAssignCoordinator;
    }

    public void setAssignCoordinator(Boolean assignCoordinator) {
        this.iAssignCoordinator = assignCoordinator;
    }

    public Integer getPercentShare() {
        return this.iPercentShare;
    }

    public void setPercentShare(Integer percentShare) {
        this.iPercentShare = percentShare;
    }

    public InstructionalOffering getOffering() {
        return this.iOffering;
    }

    public void setOffering(InstructionalOffering offering) {
        this.iOffering = offering;
    }

    public PreferenceLevel getSameCoursePreference() {
        return this.iSameCoursePreference;
    }

    public void setSameCoursePreference(PreferenceLevel sameCoursePreference) {
        this.iSameCoursePreference = sameCoursePreference;
    }

    public PreferenceLevel getSameCommonPart() {
        return this.iSameCommonPart;
    }

    public void setSameCommonPart(PreferenceLevel sameCommonPart) {
        this.iSameCommonPart = sameCommonPart;
    }

    public TeachingResponsibility getResponsibility() {
        return this.iResponsibility;
    }

    public void setResponsibility(TeachingResponsibility responsibility) {
        this.iResponsibility = responsibility;
    }

    public Set<DepartmentalInstructor> getAssignedInstructors() {
        return this.iAssignedInstructors;
    }

    public void setAssignedInstructors(Set<DepartmentalInstructor> assignedInstructors) {
        this.iAssignedInstructors = assignedInstructors;
    }

    public void addToassignedInstructors(DepartmentalInstructor departmentalInstructor) {
        if (this.iAssignedInstructors == null) {
            this.iAssignedInstructors = new HashSet<DepartmentalInstructor>();
        }
        this.iAssignedInstructors.add(departmentalInstructor);
    }

    public Set<TeachingClassRequest> getClassRequests() {
        return this.iClassRequests;
    }

    public void setClassRequests(Set<TeachingClassRequest> classRequests) {
        this.iClassRequests = classRequests;
    }

    public void addToclassRequests(TeachingClassRequest teachingClassRequest) {
        if (this.iClassRequests == null) {
            this.iClassRequests = new HashSet<TeachingClassRequest>();
        }
        this.iClassRequests.add(teachingClassRequest);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof TeachingRequest)) {
            return false;
        }
        if (this.getUniqueId() == null || ((TeachingRequest)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((TeachingRequest)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "TeachingRequest[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "TeachingRequest[\n\tAssignCoordinator: " + this.getAssignCoordinator() + "\n\tNbrInstructors: " + this.getNbrInstructors() + "\n\tOffering: " + this.getOffering() + "\n\tPercentShare: " + this.getPercentShare() + "\n\tResponsibility: " + this.getResponsibility() + "\n\tSameCommonPart: " + this.getSameCommonPart() + "\n\tSameCoursePreference: " + this.getSameCoursePreference() + "\n\tTeachingLoad: " + this.getTeachingLoad() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

