/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;

public abstract class BaseSubjectArea
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iSubjectAreaAbbreviation;
    private String iTitle;
    private Session iSession;
    private Department iDepartment;
    private Department iFundingDept;
    private Set<CourseOffering> iCourseOfferings;
    private Set<InstructionalOffering> iInstructionalOfferings;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_EXTERNAL_UID = "externalUniqueId";
    public static String PROP_SUBJECT_AREA_ABBREVIATION = "subjectAreaAbbreviation";
    public static String PROP_LONG_TITLE = "title";

    public BaseSubjectArea() {
        this.initialize();
    }

    public BaseSubjectArea(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    public String getSubjectAreaAbbreviation() {
        return this.iSubjectAreaAbbreviation;
    }

    public void setSubjectAreaAbbreviation(String subjectAreaAbbreviation) {
        this.iSubjectAreaAbbreviation = subjectAreaAbbreviation;
    }

    public String getTitle() {
        return this.iTitle;
    }

    public void setTitle(String title) {
        this.iTitle = title;
    }

    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    public Department getFundingDept() {
        return this.iFundingDept;
    }

    public void setFundingDept(Department fundingDept) {
        this.iFundingDept = fundingDept;
    }

    public Set<CourseOffering> getCourseOfferings() {
        return this.iCourseOfferings;
    }

    public void setCourseOfferings(Set<CourseOffering> courseOfferings) {
        this.iCourseOfferings = courseOfferings;
    }

    public void addTocourseOfferings(CourseOffering courseOffering) {
        if (this.iCourseOfferings == null) {
            this.iCourseOfferings = new HashSet<CourseOffering>();
        }
        this.iCourseOfferings.add(courseOffering);
    }

    public Set<InstructionalOffering> getInstructionalOfferings() {
        return this.iInstructionalOfferings;
    }

    public void setInstructionalOfferings(Set<InstructionalOffering> instructionalOfferings) {
        this.iInstructionalOfferings = instructionalOfferings;
    }

    public void addToinstructionalOfferings(InstructionalOffering instructionalOffering) {
        if (this.iInstructionalOfferings == null) {
            this.iInstructionalOfferings = new HashSet<InstructionalOffering>();
        }
        this.iInstructionalOfferings.add(instructionalOffering);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SubjectArea)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SubjectArea)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SubjectArea)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SubjectArea[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "SubjectArea[\n\tDepartment: " + this.getDepartment() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFundingDept: " + this.getFundingDept() + "\n\tSession: " + this.getSession() + "\n\tSubjectAreaAbbreviation: " + this.getSubjectAreaAbbreviation() + "\n\tTitle: " + this.getTitle() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

