/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Roles;

public abstract class BaseDepartmentalInstructor
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iExternalUniqueId;
    private String iCareerAcct;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iAcademicTitle;
    private String iNote;
    private String iEmail;
    private Boolean iIgnoreToFar;
    private Float iMaxLoad;
    private String iUnavailableDays;
    private Integer iUnavailableOffset;
    private PositionType iPositionType;
    private Department iDepartment;
    private Roles iRole;
    private PreferenceLevel iTeachingPreference;
    private Set<ClassInstructor> iClasses;
    private Set<Exam> iExams;
    private Set<Assignment> iAssignments;
    private Set<OfferingCoordinator> iOfferingCoordinators;
    private Set<InstructorAttribute> iAttributes;
    public static String PROP_EXTERNAL_UID = "externalUniqueId";
    public static String PROP_CAREER_ACCT = "careerAcct";
    public static String PROP_FNAME = "firstName";
    public static String PROP_MNAME = "middleName";
    public static String PROP_LNAME = "lastName";
    public static String PROP_ACAD_TITLE = "academicTitle";
    public static String PROP_NOTE = "note";
    public static String PROP_EMAIL = "email";
    public static String PROP_IGNORE_TOO_FAR = "ignoreToFar";
    public static String PROP_MAX_LOAD = "maxLoad";
    public static String PROP_UNAVAILABLE_DAYS = "unavailableDays";
    public static String PROP_UNAVAILABLE_OFFSET = "unavailableOffset";

    public BaseDepartmentalInstructor() {
        this.initialize();
    }

    public BaseDepartmentalInstructor(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    @Override
    protected void initialize() {
    }

    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    public String getCareerAcct() {
        return this.iCareerAcct;
    }

    public void setCareerAcct(String careerAcct) {
        this.iCareerAcct = careerAcct;
    }

    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    public String getAcademicTitle() {
        return this.iAcademicTitle;
    }

    public void setAcademicTitle(String academicTitle) {
        this.iAcademicTitle = academicTitle;
    }

    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    public Boolean isIgnoreToFar() {
        return this.iIgnoreToFar;
    }

    public Boolean getIgnoreToFar() {
        return this.iIgnoreToFar;
    }

    public void setIgnoreToFar(Boolean ignoreToFar) {
        this.iIgnoreToFar = ignoreToFar;
    }

    public Float getMaxLoad() {
        return this.iMaxLoad;
    }

    public void setMaxLoad(Float maxLoad) {
        this.iMaxLoad = maxLoad;
    }

    public String getUnavailableDays() {
        return this.iUnavailableDays;
    }

    public void setUnavailableDays(String unavailableDays) {
        this.iUnavailableDays = unavailableDays;
    }

    public Integer getUnavailableOffset() {
        return this.iUnavailableOffset;
    }

    public void setUnavailableOffset(Integer unavailableOffset) {
        this.iUnavailableOffset = unavailableOffset;
    }

    public PositionType getPositionType() {
        return this.iPositionType;
    }

    public void setPositionType(PositionType positionType) {
        this.iPositionType = positionType;
    }

    @Override
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    public Roles getRole() {
        return this.iRole;
    }

    public void setRole(Roles role) {
        this.iRole = role;
    }

    public PreferenceLevel getTeachingPreference() {
        return this.iTeachingPreference;
    }

    public void setTeachingPreference(PreferenceLevel teachingPreference) {
        this.iTeachingPreference = teachingPreference;
    }

    public Set<ClassInstructor> getClasses() {
        return this.iClasses;
    }

    public void setClasses(Set<ClassInstructor> classes) {
        this.iClasses = classes;
    }

    public void addToclasses(ClassInstructor classInstructor) {
        if (this.iClasses == null) {
            this.iClasses = new HashSet<ClassInstructor>();
        }
        this.iClasses.add(classInstructor);
    }

    public Set<Exam> getExams() {
        return this.iExams;
    }

    public void setExams(Set<Exam> exams) {
        this.iExams = exams;
    }

    public void addToexams(Exam exam) {
        if (this.iExams == null) {
            this.iExams = new HashSet<Exam>();
        }
        this.iExams.add(exam);
    }

    public Set<Assignment> getAssignments() {
        return this.iAssignments;
    }

    public void setAssignments(Set<Assignment> assignments) {
        this.iAssignments = assignments;
    }

    public void addToassignments(Assignment assignment) {
        if (this.iAssignments == null) {
            this.iAssignments = new HashSet<Assignment>();
        }
        this.iAssignments.add(assignment);
    }

    public Set<OfferingCoordinator> getOfferingCoordinators() {
        return this.iOfferingCoordinators;
    }

    public void setOfferingCoordinators(Set<OfferingCoordinator> offeringCoordinators) {
        this.iOfferingCoordinators = offeringCoordinators;
    }

    public void addToofferingCoordinators(OfferingCoordinator offeringCoordinator) {
        if (this.iOfferingCoordinators == null) {
            this.iOfferingCoordinators = new HashSet<OfferingCoordinator>();
        }
        this.iOfferingCoordinators.add(offeringCoordinator);
    }

    public Set<InstructorAttribute> getAttributes() {
        return this.iAttributes;
    }

    public void setAttributes(Set<InstructorAttribute> attributes) {
        this.iAttributes = attributes;
    }

    public void addToattributes(InstructorAttribute instructorAttribute) {
        if (this.iAttributes == null) {
            this.iAttributes = new HashSet<InstructorAttribute>();
        }
        this.iAttributes.add(instructorAttribute);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DepartmentalInstructor)) {
            return false;
        }
        if (this.getUniqueId() == null || ((DepartmentalInstructor)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((DepartmentalInstructor)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "DepartmentalInstructor[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "DepartmentalInstructor[\n\tAcademicTitle: " + this.getAcademicTitle() + "\n\tCareerAcct: " + this.getCareerAcct() + "\n\tDepartment: " + this.getDepartment() + "\n\tEmail: " + this.getEmail() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFirstName: " + this.getFirstName() + "\n\tIgnoreToFar: " + this.getIgnoreToFar() + "\n\tLastName: " + this.getLastName() + "\n\tMaxLoad: " + this.getMaxLoad() + "\n\tMiddleName: " + this.getMiddleName() + "\n\tNote: " + this.getNote() + "\n\tPositionType: " + this.getPositionType() + "\n\tRole: " + this.getRole() + "\n\tTeachingPreference: " + this.getTeachingPreference() + "\n\tUnavailableDays: " + this.getUnavailableDays() + "\n\tUnavailableOffset: " + this.getUnavailableOffset() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

