/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.TreeSet;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.base.BaseWaitList;

public class WaitList
extends BaseWaitList
implements Comparable<WaitList> {
    private static final long serialVersionUID = 1L;

    public WaitList() {
    }

    public WaitList(Long uniqueId) {
        super(uniqueId);
    }

    public WaitListType getWaitListType() {
        if (this.getType() == null) {
            return WaitListType.OTHER;
        }
        return WaitListType.values()[this.getType()];
    }

    public void setWaitListType(WaitListType status) {
        if (status == null) {
            this.setType(null);
        } else {
            this.setType(status.ordinal());
        }
    }

    @Override
    public int compareTo(WaitList wl) {
        int cmp = this.getTimestamp().compareTo(wl.getTimestamp());
        if (cmp != 0) {
            return cmp;
        }
        return this.getUniqueId().compareTo(wl.getUniqueId());
    }

    public boolean hasMatchingCourse(CourseRequest cr) {
        if (cr == null) {
            return false;
        }
        return this.hasMatchingCourse(cr.getCourseDemand());
    }

    public boolean hasMatchingCourse(CourseDemand cd) {
        if (cd == null) {
            return false;
        }
        for (CourseRequest cr : cd.getCourseRequests()) {
            if (!cr.getCourseOffering().equals(this.getCourseOffering())) continue;
            return true;
        }
        return false;
    }

    public static String computeEnrollment(Student student, CourseOffering enrolledCourse) {
        if (student == null || enrolledCourse == null) {
            return "";
        }
        String enrl = null;
        for (StudentClassEnrollment e : student.getClassEnrollments()) {
            if (!enrolledCourse.equals(e.getCourseOffering())) continue;
            enrl = (enrl == null ? "" : enrl + "\n") + e.getClazz().getClassLabel(enrolledCourse, true);
        }
        if (enrl != null && enrl.length() > 255) {
            enrl = enrl.substring(0, 252) + "...";
        }
        return enrl;
    }

    public static String computeRequest(CourseDemand cd) {
        if (cd == null) {
            return null;
        }
        String req = null;
        for (CourseRequest cr : new TreeSet<CourseRequest>(cd.getCourseRequests())) {
            String rp = null;
            if (cr.getPreferences() != null) {
                for (StudentSectioningPref p : cr.getPreferences()) {
                    if (!p.isRequired().booleanValue()) continue;
                    if (p instanceof StudentClassPref) {
                        rp = (rp == null ? "" : rp + ", ") + ((StudentClassPref)p).getClazz().getClassPrefLabel(cr.getCourseOffering());
                        continue;
                    }
                    if (!(p instanceof StudentInstrMthPref)) continue;
                    rp = (rp == null ? "" : rp + ", ") + ((StudentInstrMthPref)p).getInstructionalMethod().getLabel();
                }
            }
            req = (req == null ? "" : req + "\n") + cr.getCourseOffering().getCourseName() + (rp == null ? "" : " [" + rp + "]");
        }
        if (req != null && req.length() > 255) {
            req = req.substring(0, 252) + "...";
        }
        return req;
    }

    public void fillInNotes() {
        this.setEnrollment(WaitList.computeEnrollment(this.getStudent(), this.getEnrolledCourse()));
        this.setRequest(WaitList.computeRequest(this.getCourseDemand()));
    }

    public static enum WaitListType {
        SCHEDULING_ASSISTANT,
        COURSE_REQUESTS,
        XML_IMPORT,
        BATCH_SOLVER,
        WAIT_LIST_PORCESSING,
        MASS_CANCEL,
        EXTERNAL_UPDATE,
        RELOAD,
        OTHER,
        RE_BATCH_ON_RELOAD,
        RE_BATCH_ON_CHECK;

    }
}

